/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.actions;

import de.datomino.peppergis.client.export.AbstractExportFileAction;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.exporter.DefaultExportDto;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.type.PoiType;
import de.datomino.util.message.error.ErrorMessages;
import java.awt.Window;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JOptionPane;
import org.ktde.util.datatypes.Tupel;

public class ExportPoisAction
extends AbstractExportFileAction<Object> {
    private static final long serialVersionUID = 6125471218861045486L;

    public ExportPoisAction(Window parent) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.pois", new Serializable[0]), parent, "csv");
    }

    @Override
    protected Tupel<Map<String, byte[]>, ErrorMessages> getContent(Object t) throws ClientExportException {
        EnumSet<PoiType> types = EnumSet.allOf(PoiType.class);
        types.removeAll(Arrays.asList(PoiType.ORIGIN, PoiType.END_POINT, PoiType.REMOVED, PoiType.LAYOVER));
        final EnumComboBox<PoiType> poiTypeComboBox = new EnumComboBox<PoiType>(PoiType.class, false, (Collection<PoiType>)types);
        int d = JOptionPane.showConfirmDialog(this.getParent(), poiTypeComboBox, "Bitte Typ ausw\u00e4hlen: ", 2);
        switch (d) {
            case 0: {
                if (poiTypeComboBox.getSelectedItem() == null) break;
                ModelEnviroment modelEnviroment = new ModelEnviroment(this.getParent());
                AbstractAsynchronousDialog<DefaultExportDto> asynchronousDialog = new AbstractAsynchronousDialog<DefaultExportDto>(this.getParent(), ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.export", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]), 1, modelEnviroment){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected AsynchronousDto<DefaultExportDto> getAsynchronousDto(String token) {
                        return this.modelEnviroment.getAllCaller().getAsynchronousCaller().getExportPoisByTypeResult(token);
                    }

                    @Override
                    protected String startAsynchronous() {
                        return this.modelEnviroment.getAllCaller().getAsynchronousCaller().exportPoisByType((PoiType)((Object)poiTypeComboBox.getSelectedValue()));
                    }
                };
                LinkedList exportDtos = new LinkedList();
                try {
                    Tupel poiExportDto = asynchronousDialog.run();
                    exportDtos.add(poiExportDto.getElement1());
                }
                catch (Exception ex) {
                    if (ex instanceof ClientExportException) {
                        throw (ClientExportException)ex;
                    }
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
                modelEnviroment.close();
                return new Tupel<Map<String, byte[]>, ErrorMessages>(Collections.singletonMap("Pois", ((DefaultExportDto)exportDtos.get(0)).getContent()), ((DefaultExportDto)exportDtos.get(0)).getErrorMessages());
            }
        }
        return null;
    }
}

