/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.actions;

import de.datomino.peppergis.client.export.AbstractExportFileAction;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.configuration.gui.job.schedule.parameter.special.ExportParcelOfChangedAreasSettingsPane;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.exporter.DefaultExportDto;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.util.message.error.ErrorMessages;
import java.awt.Window;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JOptionPane;
import org.ktde.util.datatypes.Tupel;

public class ExportParcelsOfChangedAreasAction
extends AbstractExportFileAction<Object> {
    private static final long serialVersionUID = -7386768988791061524L;

    public ExportParcelsOfChangedAreasAction(Window parent) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.export.parcels.changedAreas", new Serializable[0]), parent, "csv");
    }

    @Override
    protected Tupel<Map<String, byte[]>, ErrorMessages> getContent(Object o) throws ClientExportException {
        ModelEnviroment modelEnviroment = new ModelEnviroment(this.getParent());
        ExportParcelOfChangedAreasSettingsPane exportParcelOfChangedAreasSettingsPane = new ExportParcelOfChangedAreasSettingsPane(modelEnviroment);
        int d = JOptionPane.showConfirmDialog(this.getParent(), exportParcelOfChangedAreasSettingsPane, ModelEnviroment.getMessageResolver().resolveMessage("messages.export.parcels.changedAreas", new Serializable[0]), 2);
        switch (d) {
            case 0: {
                final AreaLayerModel layer = exportParcelOfChangedAreasSettingsPane.getLayer();
                final Collection<Long> areas = exportParcelOfChangedAreasSettingsPane.getAreas();
                final Date date = exportParcelOfChangedAreasSettingsPane.getDate();
                final AreaLayerModel targetLayer = exportParcelOfChangedAreasSettingsPane.getTargetLayer();
                AbstractAsynchronousDialog<DefaultExportDto> asynchronousDialog = new AbstractAsynchronousDialog<DefaultExportDto>(this.getParent(), ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]), 1, modelEnviroment){
                    private static final long serialVersionUID = -9010756475037313167L;

                    @Override
                    protected AsynchronousDto<DefaultExportDto> getAsynchronousDto(String token) {
                        return this.modelEnviroment.getAllCaller().getAsynchronousCaller().getExportParcelsOfChangedAreasResult(token);
                    }

                    @Override
                    protected String startAsynchronous() {
                        return this.modelEnviroment.getAllCaller().getAsynchronousCaller().exportParcelsOfChangedAreas(layer.getDisplayname(), areas, date, targetLayer);
                    }
                };
                LinkedList exportDtos = new LinkedList();
                try {
                    Tupel parcelExportDto = asynchronousDialog.run();
                    exportDtos.add(parcelExportDto.getElement1());
                }
                catch (Exception ex) {
                    if (ex instanceof ClientExportException) {
                        throw (ClientExportException)ex;
                    }
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
                modelEnviroment.close();
                return new Tupel<Map<String, byte[]>, ErrorMessages>(Collections.singletonMap("Parcels", ((DefaultExportDto)exportDtos.get(0)).getContent()), ((DefaultExportDto)exportDtos.get(0)).getErrorMessages());
            }
        }
        return null;
    }
}

