/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.common.DialogDisposeAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.AttributeGroupModel;
import de.datomino.peppergis.client.model.base.AttributeGroupModelImpl;
import de.datomino.peppergis.client.model.base.PoiAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.type.AttributeGroupType;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AttributeGroupDialog
extends CommonDialog {
    private static final long serialVersionUID = -1076944764891544148L;
    private ModelEnviroment modelEnviroment;
    private JList attributeGroupList;
    private JTextField groupName;
    private JTextArea description;
    private DialogDisposeAction disposeAction = new DialogDisposeAction(this);
    private OkAction okAction = new OkAction();
    private AddAttributeGroupAction addGroupAction = new AddAttributeGroupAction();
    private DeleteAttributeGroupAction deleteGroupAction = new DeleteAttributeGroupAction();
    private Integer lastSelectedIndex;
    private AttributeGroupType type;

    public AttributeGroupDialog(Window owner, ModelEnviroment modelEnviroment, AttributeGroupType type) {
        super((Component)owner, ModelEnviroment.getMessageResolver().resolveMessageForEnum(type) + "-" + ModelEnviroment.getMessageResolver().resolveMessage("gui.configuration.attribute.group", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = modelEnviroment;
        this.type = type;
        this.buildLayout();
        this.pack();
        this.center();
        this.fillList();
        this.modelEnviroment.getUndoManager().startTransaction();
    }

    @Override
    protected Action getCancelAction() {
        return this.disposeAction;
    }

    @Override
    protected Component getMainComponent() {
        JSplitPane panel = new JSplitPane(1);
        JPanel subListPanel = new JPanel(new BorderLayout());
        this.attributeGroupList = new JList();
        JScrollPane scroll = new JScrollPane(this.attributeGroupList);
        scroll.setHorizontalScrollBarPolicy(32);
        subListPanel.add((Component)scroll, "Center");
        this.attributeGroupList.setSelectionMode(0);
        this.attributeGroupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AttributeGroupDialog.this.fillData();
            }
        });
        JPanel listButtonPanel = new JPanel(new BorderLayout());
        JButton addButton = new JButton(this.addGroupAction);
        JButton deleteButton = new JButton(this.deleteGroupAction);
        listButtonPanel.add((Component)addButton, "East");
        listButtonPanel.add((Component)deleteButton, "West");
        subListPanel.add((Component)listButtonPanel, "South");
        subListPanel.setBorder(new TitledBorder(ModelEnviroment.getMessageResolver().resolveMessage("gui.attribute.group", new Serializable[0])));
        panel.setLeftComponent(subListPanel);
        JPanel editPanel = new JPanel(new BorderLayout());
        JPanel subEditPanel = new JPanel(new SpringLayout());
        this.groupName = new JTextField(10);
        this.groupName.getDocument().addDocumentListener(new TextDocumentListener(){

            @Override
            protected void handleChange() {
                AttributeGroupElement element = (AttributeGroupElement)AttributeGroupDialog.this.attributeGroupList.getSelectedValue();
                if (element != null) {
                    element.getAttributeGroup().setName(AttributeGroupDialog.this.groupName.getText());
                    AttributeGroupDialog.this.attributeGroupList.repaint(10L);
                }
            }
        });
        subEditPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0])));
        subEditPanel.add(this.groupName);
        subEditPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.type", new Serializable[0])));
        JTextField typeField = new JTextField(ModelEnviroment.getMessageResolver().resolveMessageForEnum(this.type));
        typeField.setEditable(false);
        subEditPanel.add(typeField);
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.description", new Serializable[0]));
        label.setVerticalAlignment(1);
        subEditPanel.add(label);
        this.description = new JTextArea(10, 50);
        this.description.getDocument().addDocumentListener(new TextDocumentListener(){

            @Override
            protected void handleChange() {
                AttributeGroupElement element = (AttributeGroupElement)AttributeGroupDialog.this.attributeGroupList.getSelectedValue();
                if (element != null) {
                    element.getAttributeGroup().setDescription(AttributeGroupDialog.this.description.getText());
                }
            }
        });
        subEditPanel.add(ClientSwingUtil.scrollTextArea(this.description, null, true));
        SpringUtilities.makeCompactGrid(subEditPanel, 3, 2, 5, 5, 5, 5);
        editPanel.add((Component)subEditPanel, "North");
        panel.setRightComponent(editPanel);
        return panel;
    }

    @Override
    protected Action getOkAction() {
        return this.okAction;
    }

    private void fillList() {
        Collection<AttributeGroupModel> attributeGroups = this.modelEnviroment.getAllCaller().getBaseCaller().getAttributeGroupForType(this.type);
        DefaultListModel<AttributeGroupElement> listModel = new DefaultListModel<AttributeGroupElement>();
        for (AttributeGroupModel attributeGroup : attributeGroups) {
            listModel.addElement(new AttributeGroupElement(attributeGroup));
        }
        this.attributeGroupList.setModel(listModel);
        this.attributeGroupList.setSelectedIndices(new int[0]);
        this.groupName.setEnabled(false);
    }

    private void fillData() {
        if (this.lastSelectedIndex == null || this.lastSelectedIndex != null && !this.lastSelectedIndex.equals(this.attributeGroupList.getSelectedIndex())) {
            AttributeGroupElement element = (AttributeGroupElement)this.attributeGroupList.getSelectedValue();
            if (element == null) {
                this.groupName.setText("");
                this.groupName.setEnabled(false);
                this.description.setText("");
                this.description.setEnabled(false);
                this.lastSelectedIndex = null;
            } else {
                AttributeGroupModel group = element.getAttributeGroup();
                this.groupName.setText(group.getName());
                this.groupName.setEnabled(ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER));
                this.description.setText(group.getDescription());
                this.description.setEnabled(ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER));
                this.lastSelectedIndex = this.attributeGroupList.getSelectedIndex();
            }
        }
    }

    private class DeleteAttributeGroupAction
    extends AbstractAction {
        private static final long serialVersionUID = -1086286998318286451L;

        public DeleteAttributeGroupAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0]));
            this.setEnabled(ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttributeGroupElement selectedGroup = (AttributeGroupElement)AttributeGroupDialog.this.attributeGroupList.getSelectedValue();
            DefaultListModel dlm = (DefaultListModel)AttributeGroupDialog.this.attributeGroupList.getModel();
            dlm.removeElement(selectedGroup);
            switch (AttributeGroupDialog.this.type) {
                case AREA: {
                    Collection<AreaAttributeValueDescriptorModel> attributeValueDescriptors = AttributeGroupDialog.this.modelEnviroment.getAllCaller().getAreaCaller().fetchAllAreaAttributeValueDescriptors();
                    for (AreaAttributeValueDescriptorModel areaAttributeValueDescriptorModel : attributeValueDescriptors) {
                        AttributeGroupModel group = areaAttributeValueDescriptorModel.getGroup();
                        if (group == null || !group.equals(selectedGroup.getAttributeGroup())) continue;
                        areaAttributeValueDescriptorModel.setGroup(null);
                    }
                    break;
                }
                case PARCEL: {
                    Collection<ParcelAttributeValueDescriptorModel> parcelAttributeValueDescriptors = AttributeGroupDialog.this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchAllParcelAttributeValueDescriptors();
                    for (ParcelAttributeValueDescriptorModel parcelAttributeValueDescriptorModel : parcelAttributeValueDescriptors) {
                        AttributeGroupModel group = parcelAttributeValueDescriptorModel.getGroup();
                        if (group == null || !group.equals(selectedGroup.getAttributeGroup())) continue;
                        parcelAttributeValueDescriptorModel.setGroup(null);
                    }
                    break;
                }
                case POI: {
                    Collection<PoiAttributeValueDescriptorModel> poiAttributeValueDescriptors = AttributeGroupDialog.this.modelEnviroment.getAllCaller().getBaseCaller().getAllPoiAttributeValueDescriptors();
                    for (PoiAttributeValueDescriptorModel poiAttributeValueDescriptorModel : poiAttributeValueDescriptors) {
                        AttributeGroupModel group = poiAttributeValueDescriptorModel.getGroup();
                        if (group == null || !group.equals(selectedGroup.getAttributeGroup())) continue;
                        poiAttributeValueDescriptorModel.setGroup(null);
                    }
                    break;
                }
                case SUBSCRIPTION: {
                    Collection<SubscriptionAttributeValueDescriptorModel> subscriptionAttributeValueDescriptors = AttributeGroupDialog.this.modelEnviroment.getAllCaller().getSubscriptionCaller().getAllSubscriptionAttributeValueDescriptors();
                    for (SubscriptionAttributeValueDescriptorModel subscriptionAttributeValueDescriptorModel : subscriptionAttributeValueDescriptors) {
                        AttributeGroupModel group = subscriptionAttributeValueDescriptorModel.getGroup();
                        if (group == null || !group.equals(selectedGroup.getAttributeGroup())) continue;
                        subscriptionAttributeValueDescriptorModel.setGroup(null);
                    }
                    break;
                }
            }
            selectedGroup.getAttributeGroup().delete();
        }
    }

    private class AddAttributeGroupAction
    extends AbstractAction {
        private static final long serialVersionUID = -1086286998318286451L;

        public AddAttributeGroupAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
            this.setEnabled(ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean found;
            DefaultListModel listModel = (DefaultListModel)AttributeGroupDialog.this.attributeGroupList.getModel();
            int size = listModel.getSize();
            String newName = ModelEnviroment.getMessageResolver().resolveMessage("gui.attribute.group", new Serializable[0]);
            int suffixCount = 1;
            block0: do {
                found = true;
                for (int i = 0; i < size; ++i) {
                    AttributeGroupElement areaLayerElement = (AttributeGroupElement)listModel.getElementAt(i);
                    if (!areaLayerElement.getAttributeGroup().getName().equals(newName)) continue;
                    newName = ModelEnviroment.getMessageResolver().resolveMessage("gui.attribute.group", new Serializable[0]) + "_" + suffixCount;
                    ++suffixCount;
                    found = false;
                    continue block0;
                }
            } while (!found);
            AttributeGroupModelImpl attributeGroup = new AttributeGroupModelImpl();
            attributeGroup.setGroupType(AttributeGroupDialog.this.type);
            attributeGroup.setName(newName);
            listModel.addElement(new AttributeGroupElement(attributeGroup));
            AttributeGroupDialog.this.attributeGroupList.setSelectedIndex(size);
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = 3280449595070962158L;

        public OkAction() {
            super("Ok");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttributeGroupDialog.this.modelEnviroment.getUndoManager().finishTransaction("");
            try {
                AttributeGroupDialog.this.modelEnviroment.getUndoManager().storeTransactions();
                AttributeGroupDialog.this.dispose();
            }
            catch (ValidateException e1) {
                AttributeGroupDialog.this.modelEnviroment.getUndoManager().handleValidateException(e1);
            }
            AttributeGroupDialog.this.modelEnviroment.close();
        }
    }

    private class AttributeGroupElement {
        private AttributeGroupModel attributeGroup;

        public AttributeGroupElement(AttributeGroupModel attributeGroup) {
            this.attributeGroup = attributeGroup;
        }

        public AttributeGroupModel getAttributeGroup() {
            return this.attributeGroup;
        }

        public String toString() {
            return this.attributeGroup.getName();
        }
    }

    private abstract class TextDocumentListener
    implements DocumentListener {
        private TextDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }

        protected abstract void handleChange();
    }
}

