/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.common.attribute.descriptor;

import de.datomino.peppergis.client.gui.attribute.AttributeGroupComboBox;
import de.datomino.peppergis.client.gui.common.tree.JTreeUtils;
import de.datomino.peppergis.client.gui.common.tree.MoveInTreeAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.AttributeGroupModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.StaticChoiceValueModel;
import de.datomino.peppergis.configuration.common.attribute.descriptor.AttributePrintOptionPane;
import de.datomino.peppergis.configuration.common.attribute.descriptor.AttributeValueLimitPane;
import de.datomino.peppergis.configuration.common.attribute.descriptor.EmptySubDescriptorPane;
import de.datomino.peppergis.configuration.common.attribute.descriptor.StaticChoiceDescriptorPane;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.type.AttributeGroupType;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.attribute.AttributeValueDescriptor;
import de.datomino.peppergis.type.attribute.StaticChoiceValue;
import de.datomino.util.collection.Transformer;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.WidthUnifier;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpringLayout;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.ktde.util.StringUtil;

public abstract class AbstractAttributeValueDescriptorDialog<T extends Model, U extends Model>
extends JDialog {
    private static final long serialVersionUID = -4045681456121857579L;
    private static final String CARD_SIMPLE = "SIMPLE";
    private static final String CARD_LIMIT = "LIMIT";
    private static final String CARD_STATIC_CHOICE = "STATIC_CHOICE";
    private static final DataFlavor TREE_PATH_FLAVOR = new DataFlavor(Long.class, "Desc");
    private ModelEnviroment modelEnviroment = new ModelEnviroment(this);
    private JTree descriptorList;
    private JComboBox valueType;
    private AttributeGroupComboBox attributeGroup;
    private JTextField name;
    private JTextField key;
    private JTextArea description;
    private JCheckBox editable;
    private AddDescriptorAction addDescriptorAction;
    private RemoveDescriptorAction removeDescriptorAction;
    private AttributeValueDescriptorModel<T, U> selectedValueDescriptorModel;
    private AttributeValueTypeComboBoxActionListener attributeValueTypeComboBoxActionListener;
    private JPanel specialPane;
    private CardLayout specialCardLayout;
    private AttributeDescriptorMoveInListAction moveUpAction;
    private AttributeDescriptorMoveInListAction moveDownAction;
    private AttributeDescriptorMoveInListAction moveHighestAction;
    private AttributeDescriptorMoveInListAction moveLowestAction;
    private AttributePrintOptionPane attributePrintOptionPane;
    private AttributeValueLimitPane attributeValueLimitPane;
    private StaticChoiceDescriptorPane<U, T> staticChoiceDescriptorPane;
    private boolean expansionLocked = true;

    public AbstractAttributeValueDescriptorDialog(Window parent, String title) {
        super(parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment.getUndoManager().startTransaction();
        JSplitPane splitPane = this.buildLayout();
        this.fillValues(this.fetchValues(this.modelEnviroment));
        this.pack();
        Dimension dim = this.getSize();
        Dimension pDim = parent.getSize();
        int maxWidth = (int)(pDim.getWidth() * 0.8);
        int maxHeight = (int)(pDim.getHeight() * 0.8);
        int width = Math.min(dim.width, maxWidth);
        this.setSize(new Dimension(width, Math.min(dim.height, maxHeight)));
        SwingUtils.centerDialog(this, parent);
        splitPane.setDividerLocation(width / 2);
    }

    protected abstract AttributeGroupType getAttributeGroupType();

    private JSplitPane buildLayout() {
        try {
            this.setIconImage(ImageIO.read(AbstractAttributeValueDescriptorDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.getContentPane().setLayout(new BorderLayout());
        JSplitPane mainPanel = new JSplitPane(1);
        JPanel descriptorListPanel = new JPanel(new BorderLayout());
        this.descriptorList = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.descriptorList.setRootVisible(false);
        this.descriptorList.addTreeSelectionListener(new DescriptorListSelectionListener());
        this.descriptorList.getSelectionModel().setSelectionMode(1);
        this.descriptorList.setCellRenderer(new AttributeTreeRenderer(this.descriptorList.getCellRenderer()));
        this.descriptorList.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                if (AbstractAttributeValueDescriptorDialog.this.expansionLocked) {
                    throw new ExpandVetoException(event);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                if (AbstractAttributeValueDescriptorDialog.this.expansionLocked) {
                    throw new ExpandVetoException(event);
                }
            }
        });
        new TreeDragSource(this.descriptorList, 3);
        new TreeDropTarget(this.descriptorList);
        JScrollPane scroll = new JScrollPane(this.descriptorList);
        scroll.setHorizontalScrollBarPolicy(32);
        descriptorListPanel.add((Component)scroll, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.removeDescriptorAction = new RemoveDescriptorAction();
        JButton remove = new JButton(this.removeDescriptorAction);
        this.removeDescriptorAction.setEnabled(false);
        buttonPanel.add((Component)remove, "West");
        this.addDescriptorAction = new AddDescriptorAction();
        JButton add = new JButton(this.addDescriptorAction);
        buttonPanel.add((Component)add, "East");
        descriptorListPanel.add((Component)buttonPanel, "South");
        buttonPanel = new JPanel(new BorderLayout());
        JPanel upperButtonPanel = new JPanel(new SpringLayout());
        this.moveHighestAction = new AttributeDescriptorMoveInListAction("\u21d1", MoveInTreeAction.MoveInListType.HIGHEST);
        upperButtonPanel.add(new JButton(this.moveHighestAction));
        this.moveUpAction = new AttributeDescriptorMoveInListAction("\u2191", MoveInTreeAction.MoveInListType.UP);
        upperButtonPanel.add(new JButton(this.moveUpAction));
        SpringUtilities.makeCompactGrid(upperButtonPanel, 2, 1, 2, 2, 2, 5);
        buttonPanel.add((Component)upperButtonPanel, "North");
        upperButtonPanel = new JPanel(new SpringLayout());
        this.moveDownAction = new AttributeDescriptorMoveInListAction("\u2193", MoveInTreeAction.MoveInListType.DOWN);
        upperButtonPanel.add(new JButton(this.moveDownAction));
        this.moveLowestAction = new AttributeDescriptorMoveInListAction("\u21d3", MoveInTreeAction.MoveInListType.LOWEST);
        upperButtonPanel.add(new JButton(this.moveLowestAction));
        SpringUtilities.makeCompactGrid(upperButtonPanel, 2, 1, 2, 2, 2, 5);
        buttonPanel.add((Component)upperButtonPanel, "South");
        this.moveDownAction.setEnabled(false);
        this.moveUpAction.setEnabled(false);
        this.moveHighestAction.setEnabled(false);
        this.moveLowestAction.setEnabled(false);
        descriptorListPanel.add((Component)buttonPanel, "East");
        mainPanel.setLeftComponent(descriptorListPanel);
        JPanel valuePanel = new JPanel(new BorderLayout());
        WidthUnifier labelWidthUnifier = new WidthUnifier();
        JPanel cPanel = this.buildDescriptorPanel(labelWidthUnifier);
        valuePanel.add((Component)cPanel, "North");
        JPanel sPanel = this.buildSpecialPane(labelWidthUnifier);
        valuePanel.add((Component)sPanel, "Center");
        this.attributePrintOptionPane = this.getAttributePrintOptionPane(labelWidthUnifier);
        if (this.attributePrintOptionPane != null) {
            valuePanel.add((Component)this.attributePrintOptionPane, "South");
        }
        labelWidthUnifier.unifyWidth();
        mainPanel.setRightComponent(valuePanel);
        this.getContentPane().add((Component)mainPanel, "Center");
        buttonPanel = new JPanel(new BorderLayout());
        JPanel subButtonPanel = new JPanel(new FlowLayout());
        subButtonPanel.add(new JButton(new OkAction()));
        subButtonPanel.add(new JButton(new CancelAction()));
        buttonPanel.add((Component)subButtonPanel, "East");
        this.getContentPane().add((Component)buttonPanel, "South");
        return mainPanel;
    }

    protected abstract AttributePrintOptionPane getAttributePrintOptionPane(WidthUnifier var1);

    private JPanel buildSpecialPane(WidthUnifier labelWidthUnifier) {
        JPanel outerPanel = new JPanel(new SpringLayout());
        JLabel label = new JLabel();
        outerPanel.add(label);
        labelWidthUnifier.add(label);
        this.specialCardLayout = new CardLayout();
        this.specialPane = new JPanel(this.specialCardLayout);
        this.specialPane.setEnabled(false);
        this.specialPane.add((Component)new EmptySubDescriptorPane(), CARD_SIMPLE);
        this.attributeValueLimitPane = new AttributeValueLimitPane();
        this.specialPane.add((Component)this.attributeValueLimitPane, CARD_LIMIT);
        this.staticChoiceDescriptorPane = new StaticChoiceDescriptorPane<U, T>(){
            private static final long serialVersionUID = -1436017517152029133L;

            @Override
            protected StaticChoiceValueModel<U, T> createEmptyStaticChoiceValueModel() {
                return AbstractAttributeValueDescriptorDialog.this.createEmptyStaticChoiceValueModel();
            }
        };
        this.specialPane.add((Component)this.staticChoiceDescriptorPane, CARD_STATIC_CHOICE);
        outerPanel.add(this.specialPane);
        SpringUtilities.makeCompactGrid(outerPanel, 1, 2, 0, 10, 5, 0);
        return outerPanel;
    }

    private JPanel buildDescriptorPanel(WidthUnifier labelWidthUnifier) {
        JPanel cPanel = new JPanel(new SpringLayout());
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.attributevaluedescriptor.name", new Serializable[0]));
        cPanel.add(label);
        this.name = new JTextField(30);
        this.name.setEditable(false);
        cPanel.add(this.name);
        labelWidthUnifier.add(label);
        label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.attributevaluedescriptor.key", new Serializable[0]));
        cPanel.add(label);
        this.key = new JTextField(30);
        this.key.setEditable(false);
        cPanel.add(this.key);
        labelWidthUnifier.add(label);
        label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.attributevaluedescriptor.editable", new Serializable[0]));
        cPanel.add(label);
        this.editable = new JCheckBox();
        this.editable.setEnabled(false);
        cPanel.add(this.editable);
        labelWidthUnifier.add(label);
        label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.attributevaluedescriptor.description", new Serializable[0]));
        cPanel.add(label);
        this.description = new JTextArea(5, 30);
        this.description.setEditable(false);
        cPanel.add(new JScrollPane(this.description));
        labelWidthUnifier.add(label);
        label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.attribute.group", new Serializable[0]));
        cPanel.add(label);
        this.attributeGroup = new AttributeGroupComboBox(this.modelEnviroment.getAllCaller().getBaseCaller().getAttributeGroupForType(this.getAttributeGroupType()), true);
        this.attributeGroup.setEnabled(false);
        this.attributeGroup.addActionListener(new GroupActionListener());
        cPanel.add(this.attributeGroup);
        labelWidthUnifier.add(label);
        Vector<AttributeValueTypeItem> attributeValueTypeItems = new Vector<AttributeValueTypeItem>(AttributeValueType.values().length);
        for (AttributeValueType attributeValueType : AttributeValueType.values()) {
            if (attributeValueType == AttributeValueType.MULTIPLE_LIST_CHOICE || attributeValueType == AttributeValueType.PDF_DOWN) continue;
            attributeValueTypeItems.addElement(new AttributeValueTypeItem(attributeValueType));
        }
        Collections.sort(attributeValueTypeItems);
        label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.attributevaluedescriptor.attributeValueType", new Serializable[0]));
        cPanel.add(label);
        this.valueType = new JComboBox(attributeValueTypeItems);
        this.attributeValueTypeComboBoxActionListener = new AttributeValueTypeComboBoxActionListener();
        this.valueType.addActionListener(this.attributeValueTypeComboBoxActionListener);
        this.valueType.setEnabled(false);
        cPanel.add(this.valueType);
        labelWidthUnifier.add(label);
        SpringUtilities.makeCompactGrid(cPanel, 6, 2, 5, 5, 2, 2);
        return cPanel;
    }

    public void fillValues(Collection<AttributeValueDescriptorModel<T, U>> attributeValueDescriptorModels) {
        List list;
        DefaultTreeModel dlm = (DefaultTreeModel)this.descriptorList.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)dlm.getRoot();
        root.removeAllChildren();
        TreeSet<AttributeGroupModel> groupSet = new TreeSet<AttributeGroupModel>(new GroupComparator());
        HashMap<AttributeGroupModel, LinkedList<AttributeValueDescriptorModel<T, U>>> descMap = new HashMap<AttributeGroupModel, LinkedList<AttributeValueDescriptorModel<T, U>>>();
        LinkedList<AttributeValueDescriptorModel<T, U>> nullGroupDescs = new LinkedList<AttributeValueDescriptorModel<T, U>>();
        for (AttributeValueDescriptorModel<T, U> attributeValueDescriptorModel : attributeValueDescriptorModels) {
            AttributeGroupModel attributeGroupModel = attributeValueDescriptorModel.getAttributeGroup();
            if (attributeGroupModel == null) {
                nullGroupDescs.add(attributeValueDescriptorModel);
                continue;
            }
            list = (LinkedList<AttributeValueDescriptorModel<T, U>>)descMap.get(attributeGroupModel);
            if (list == null) {
                list = new LinkedList<AttributeValueDescriptorModel<T, U>>();
                descMap.put(attributeGroupModel, (LinkedList<AttributeValueDescriptorModel<T, U>>)list);
                groupSet.add(attributeGroupModel);
            }
            list.add(attributeValueDescriptorModel);
        }
        for (AttributeGroupModel group : groupSet) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(group);
            root.add(defaultMutableTreeNode);
            list = (List)descMap.get(group);
            for (AttributeValueDescriptorModel desc : list) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(desc));
            }
        }
        DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(ModelEnviroment.getMessageResolver().resolveMessage("messages.attribute.noGroup", new Serializable[0]));
        root.add(groupNode);
        for (AttributeValueDescriptorModel attributeValueDescriptorModel : nullGroupDescs) {
            groupNode.add(new DefaultMutableTreeNode(attributeValueDescriptorModel));
        }
        dlm.nodeChanged(root);
        dlm.reload();
        this.expandAllTreeNodes();
    }

    private void expandAllTreeNodes() {
        this.expansionLocked = false;
        int j = this.descriptorList.getRowCount();
        for (int i = 0; i < j; ++i) {
            this.descriptorList.expandRow(i);
            j = this.descriptorList.getRowCount();
        }
        this.expansionLocked = true;
    }

    private void restoreSelection(TreePath tp) {
        DefaultMutableTreeNode dmt;
        if (tp != null && (dmt = (DefaultMutableTreeNode)tp.getLastPathComponent()) != null) {
            Object userObject = dmt.getUserObject();
            this.selectUserObject(userObject);
        }
    }

    private void selectUserObject(Object userObject) {
        TreePath s;
        if (userObject instanceof AttributeValueDescriptorModel && (s = JTreeUtils.findTreePathWithUserObject(this.descriptorList, userObject)) != null) {
            this.descriptorList.setSelectionPath(s);
        }
    }

    private void clearDescriptorValues() {
        this.description.setText("");
        this.editable.setSelected(false);
        this.key.setText("");
        this.name.setText("");
        this.valueType.setSelectedIndex(0);
        this.setSpecialComponent(null);
        this.attributeGroup.setSelectedIndex(0);
        if (this.attributePrintOptionPane != null) {
            this.attributePrintOptionPane.clear();
        }
    }

    private void setDescriptorValuesEnabled(boolean b) {
        this.description.setEditable(b);
        this.editable.setEnabled(b);
        this.key.setEditable(b);
        this.name.setEditable(b);
        this.valueType.setEnabled(b);
        this.attributeGroup.setEnabled(b);
        if (this.attributePrintOptionPane != null) {
            this.attributePrintOptionPane.setEnabled(b);
        }
    }

    private void setDescriptorValues(AttributeValueDescriptorModel<T, U> attributeValueDescriptorModel) {
        this.description.setText(attributeValueDescriptorModel.getDescription());
        this.editable.setSelected(attributeValueDescriptorModel.getEditable());
        this.key.setText(attributeValueDescriptorModel.getKey());
        this.name.setText(attributeValueDescriptorModel.getName());
        this.attributeValueTypeComboBoxActionListener.setEnabled(false);
        this.valueType.setSelectedItem(new AttributeValueTypeItem(attributeValueDescriptorModel.getAttributeValueType()));
        this.attributeValueTypeComboBoxActionListener.setEnabled(true);
        this.setSpecialComponent(attributeValueDescriptorModel);
        this.attributeGroup.setSelectedItem(attributeValueDescriptorModel.getAttributeGroup());
        if (this.attributePrintOptionPane != null) {
            this.attributePrintOptionPane.setPrintable(attributeValueDescriptorModel.getCanPrint());
            this.attributePrintOptionPane.setPrintLength(attributeValueDescriptorModel.getPrintLength());
            this.attributePrintOptionPane.setPrintSortOrder(attributeValueDescriptorModel.getPrintSortOrder());
        }
    }

    private void setSpecialComponent(AttributeValueDescriptorModel<T, U> attributeValueDescriptorModel) {
        AttributeValueType attributeValueType;
        AttributeValueType attributeValueType2 = attributeValueType = attributeValueDescriptorModel == null ? null : attributeValueDescriptorModel.getAttributeValueType();
        if (attributeValueType == null) {
            this.specialCardLayout.show(this.specialPane, CARD_SIMPLE);
        } else if (attributeValueType == AttributeValueType.FLOAT || attributeValueType == AttributeValueType.INTEGER) {
            this.attributeValueLimitPane.setAttributeValueDescriptorModel(attributeValueDescriptorModel);
            this.specialCardLayout.show(this.specialPane, CARD_LIMIT);
        } else {
            boolean found = false;
            for (int i = 0; i < this.specialPane.getComponentCount(); ++i) {
                if (!this.staticChoiceDescriptorPane.getAttributeValueTypes().contains((Object)attributeValueType)) continue;
                this.staticChoiceDescriptorPane.setAttributeValueDescriptorModel(attributeValueDescriptorModel);
                this.specialCardLayout.show(this.specialPane, CARD_STATIC_CHOICE);
                found = true;
                break;
            }
            if (!found) {
                this.specialCardLayout.show(this.specialPane, CARD_SIMPLE);
            }
        }
    }

    private void adaptValuesToModel(AttributeValueDescriptorModel<T, U> valueDescriptorModel) {
        valueDescriptorModel.setDescription(this.description.getText());
        valueDescriptorModel.setEditable(this.editable.isSelected());
        valueDescriptorModel.setKey(this.key.getText());
        valueDescriptorModel.setName(this.name.getText());
        valueDescriptorModel.setAttributeGroup((AttributeGroupModel)this.attributeGroup.getSelectedItem());
        if (this.attributePrintOptionPane != null) {
            valueDescriptorModel.setCanPrint(this.attributePrintOptionPane.isPrintable());
            valueDescriptorModel.setPrintLength(this.attributePrintOptionPane.getPrintLength());
            valueDescriptorModel.setPrintSortOrder(this.attributePrintOptionPane.getPrintSortOrder());
        }
        AttributeValueType attributeValueType = ((AttributeValueTypeItem)this.valueType.getSelectedItem()).getAttributeValueType();
        valueDescriptorModel.setAttributeValueType(attributeValueType);
        if (attributeValueType == AttributeValueType.FLOAT || attributeValueType == AttributeValueType.INTEGER) {
            this.attributeValueLimitPane.setValuesToModel();
        } else {
            for (int i = 0; i < this.specialPane.getComponentCount(); ++i) {
                if (!this.staticChoiceDescriptorPane.getAttributeValueTypes().contains((Object)attributeValueType)) continue;
                this.staticChoiceDescriptorPane.setValuesToModel();
                break;
            }
        }
    }

    private void reorgSortOrder() {
        DefaultTreeModel dlm = (DefaultTreeModel)this.descriptorList.getModel();
        int i = 0;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)dlm.getRoot();
        for (int j = 0; j < root.getChildCount(); ++j) {
            DefaultMutableTreeNode group = (DefaultMutableTreeNode)root.getChildAt(j);
            for (int k = 0; k < group.getChildCount(); ++k) {
                DefaultMutableTreeNode descNode = (DefaultMutableTreeNode)group.getChildAt(k);
                AttributeValueDescriptorModel desc = (AttributeValueDescriptorModel)descNode.getUserObject();
                desc.setSortOrder(i++);
            }
        }
    }

    protected abstract AttributeValueDescriptorModel<T, U> createEmptyAttributeValueDescriptorModel();

    protected abstract Collection<AttributeValueDescriptorModel<T, U>> fetchValues(ModelEnviroment var1);

    protected abstract StaticChoiceValueModel<U, T> createEmptyStaticChoiceValueModel();

    private void setMovingEnablings() {
        DefaultMutableTreeNode dmt;
        Object userObject;
        boolean moveDown = false;
        boolean moveUp = false;
        boolean moveHighest = false;
        boolean moveLowest = false;
        TreePath treePath = this.descriptorList.getSelectionPath();
        if (treePath != null && (userObject = (dmt = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof AttributeValueDescriptorModel) {
            moveHighest = moveUp = dmt.getPreviousSibling() != null;
            moveLowest = moveDown = dmt.getNextSibling() != null;
        }
        this.moveDownAction.setEnabled(moveDown);
        this.moveUpAction.setEnabled(moveUp);
        this.moveHighestAction.setEnabled(moveHighest);
        this.moveLowestAction.setEnabled(moveLowest);
    }

    private Map<String, List<AttributeValueDescriptorModel<T, U>>> checkDescriptorsForUniqness() {
        HashMap<String, List<AttributeValueDescriptorModel<T, U>>> map = new HashMap<String, List<AttributeValueDescriptorModel<T, U>>>();
        DefaultTreeModel model = (DefaultTreeModel)this.descriptorList.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)root.getChildAt(i);
            for (int j = 0; j < groupNode.getChildCount(); ++j) {
                DefaultMutableTreeNode descriptorNode = (DefaultMutableTreeNode)groupNode.getChildAt(j);
                AttributeValueDescriptorModel descriptor = (AttributeValueDescriptorModel)descriptorNode.getUserObject();
                String key = descriptor.getKey();
                LinkedList<AttributeValueDescriptorModel> list = (LinkedList<AttributeValueDescriptorModel>)map.get(key);
                if (list == null) {
                    list = new LinkedList<AttributeValueDescriptorModel>();
                    map.put(key, list);
                }
                list.add(descriptor);
            }
        }
        LinkedList keysToRemove = new LinkedList();
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            if (list.size() <= 1) {
                keysToRemove.add(entry.getKey());
                continue;
            }
            Collections.sort(list, new Comparator<AttributeValueDescriptorModel<T, U>>(){

                @Override
                public int compare(AttributeValueDescriptorModel<T, U> o1, AttributeValueDescriptorModel<T, U> o2) {
                    String n1 = StringUtil.nullToEmpty(o1.getName());
                    String n2 = StringUtil.nullToEmpty(o2.getName());
                    return n1.compareTo(n2);
                }
            });
        }
        for (String key : keysToRemove) {
            map.remove(key);
        }
        return map;
    }

    private class TreeDropTarget
    implements DropTargetListener {
        private JTree targetTree;

        public TreeDropTarget(JTree tree) {
            this.targetTree = tree;
            new DropTarget(this.targetTree, this);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            dtde.acceptDrag(dtde.getDropAction());
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            dtde.acceptDrag(dtde.getDropAction());
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Point pt = dtde.getLocation();
            DropTargetContext dtc = dtde.getDropTargetContext();
            JTree tree = (JTree)dtc.getComponent();
            TreePath parentpath = tree.getClosestPathForLocation(pt.x, pt.y);
            DefaultMutableTreeNode foundTp = (DefaultMutableTreeNode)parentpath.getLastPathComponent();
            Object userObject = foundTp.getUserObject();
            DefaultMutableTreeNode parent = foundTp;
            boolean descNode = false;
            if (userObject instanceof AttributeValueDescriptorModel) {
                parent = (DefaultMutableTreeNode)foundTp.getParent();
                descNode = true;
            }
            try {
                Transferable tr = dtde.getTransferable();
                DataFlavor[] flavors = tr.getTransferDataFlavors();
                for (int i = 0; i < flavors.length; ++i) {
                    if (!tr.isDataFlavorSupported(flavors[i])) continue;
                    dtde.acceptDrop(dtde.getDropAction());
                    Long descId = (Long)tr.getTransferData(flavors[i]);
                    TreePath treePath = JTreeUtils.findTreePathWithUserObject(AbstractAttributeValueDescriptorDialog.this.descriptorList, descId, new Transformer<Object, Long>(){

                        @Override
                        public Long transform(Object t) {
                            if (t instanceof AttributeValueDescriptorModel) {
                                AttributeValueDescriptorModel desc = (AttributeValueDescriptorModel)t;
                                return ((Model)desc.getAttachedObject()).getId();
                            }
                            return null;
                        }
                    });
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    ((DefaultMutableTreeNode)node.getParent()).remove(node);
                    DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                    int pos = 0;
                    if (descNode) {
                        pos = parent.getIndex(foundTp) + 1;
                    }
                    model.insertNodeInto(node, parent, pos);
                    Object parentUserObject = parent.getUserObject();
                    AttributeGroupModel group = null;
                    if (parentUserObject instanceof AttributeGroupModel) {
                        group = (AttributeGroupModel)parentUserObject;
                    }
                    AttributeValueDescriptorModel attributeValueDescriptor = (AttributeValueDescriptorModel)node.getUserObject();
                    attributeValueDescriptor.setAttributeGroup(group);
                    model.reload();
                    AbstractAttributeValueDescriptorDialog.this.expandAllTreeNodes();
                    AbstractAttributeValueDescriptorDialog.this.selectUserObject(node.getUserObject());
                    dtde.dropComplete(true);
                    return;
                }
                dtde.rejectDrop();
            }
            catch (Exception e) {
                e.printStackTrace();
                dtde.rejectDrop();
            }
        }
    }

    private class TreeDragSource
    implements DragSourceListener,
    DragGestureListener {
        private DragSource dragSource;
        private TransferableAttributeValueDescriptor transferable;
        private JTree sourceTree;

        public TreeDragSource(JTree tree, int actions2) {
            this.sourceTree = tree;
            this.dragSource = new DragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this.sourceTree, actions2, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            TreePath path = this.sourceTree.getSelectionPath();
            if (path == null) {
                return;
            }
            DefaultMutableTreeNode dmt = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (dmt == null || !(dmt.getUserObject() instanceof AttributeValueDescriptorModel)) {
                return;
            }
            AttributeValueDescriptorModel desc = (AttributeValueDescriptorModel)dmt.getUserObject();
            this.transferable = new TransferableAttributeValueDescriptor(((Model)desc.getAttachedObject()).getId());
            this.dragSource.startDrag(dge, DragSource.DefaultMoveDrop, this.transferable, this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }
    }

    private class TransferableAttributeValueDescriptor
    implements Transferable {
        private Long attributeDescriptorId;

        public TransferableAttributeValueDescriptor(Long attributeDescriptorId) {
            this.attributeDescriptorId = attributeDescriptorId;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{TREE_PATH_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.getRepresentationClass() == Long.class;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(flavor)) {
                return this.attributeDescriptorId;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    private class AttributeDescriptorMoveInListAction
    extends MoveInTreeAction<Boolean> {
        private static final long serialVersionUID = -3224664983681233893L;

        public AttributeDescriptorMoveInListAction(String name, MoveInTreeAction.MoveInListType moveInListType) {
            super(name, moveInListType, AbstractAttributeValueDescriptorDialog.this.descriptorList);
        }

        @Override
        protected Boolean doBefore() {
            boolean attributeValueTypeComboBoxActionListenerEnabled = AbstractAttributeValueDescriptorDialog.this.attributeValueTypeComboBoxActionListener.isEnabled();
            AbstractAttributeValueDescriptorDialog.this.attributeValueTypeComboBoxActionListener.setEnabled(false);
            return attributeValueTypeComboBoxActionListenerEnabled;
        }

        @Override
        protected void doAfter(Boolean t) {
            AbstractAttributeValueDescriptorDialog.this.setMovingEnablings();
            AbstractAttributeValueDescriptorDialog.this.attributeValueTypeComboBoxActionListener.setEnabled(t);
            DefaultTreeModel model = (DefaultTreeModel)AbstractAttributeValueDescriptorDialog.this.descriptorList.getModel();
            model.reload();
            AbstractAttributeValueDescriptorDialog.this.expandAllTreeNodes();
        }
    }

    private class AttributeValueTypeComboBoxActionListener
    implements ActionListener {
        private boolean enabled = true;

        private AttributeValueTypeComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.enabled && AbstractAttributeValueDescriptorDialog.this.selectedValueDescriptorModel != null) {
                AbstractAttributeValueDescriptorDialog.this.selectedValueDescriptorModel.setAttributeValueType(((AttributeValueTypeItem)AbstractAttributeValueDescriptorDialog.this.valueType.getSelectedItem()).getAttributeValueType());
                AbstractAttributeValueDescriptorDialog.this.setSpecialComponent(AbstractAttributeValueDescriptorDialog.this.selectedValueDescriptorModel);
            }
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    private class DescriptorListSelectionListener
    implements TreeSelectionListener {
        private DescriptorListSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode dmt;
            Object userObject;
            if (AbstractAttributeValueDescriptorDialog.this.selectedValueDescriptorModel != null) {
                AbstractAttributeValueDescriptorDialog.this.adaptValuesToModel(AbstractAttributeValueDescriptorDialog.this.selectedValueDescriptorModel);
            }
            AbstractAttributeValueDescriptorDialog.this.selectedValueDescriptorModel = null;
            AttributeValueDescriptor attributeValueDescriptorModel = null;
            TreePath treePath = AbstractAttributeValueDescriptorDialog.this.descriptorList.getSelectionPath();
            if (treePath != null && (userObject = (dmt = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof AttributeValueDescriptorModel) {
                attributeValueDescriptorModel = (AttributeValueDescriptorModel)userObject;
            }
            if (attributeValueDescriptorModel == null) {
                AbstractAttributeValueDescriptorDialog.this.clearDescriptorValues();
                AbstractAttributeValueDescriptorDialog.this.setDescriptorValuesEnabled(false);
                AbstractAttributeValueDescriptorDialog.this.selectedValueDescriptorModel = null;
                AbstractAttributeValueDescriptorDialog.this.removeDescriptorAction.setEnabled(false);
                AbstractAttributeValueDescriptorDialog.this.setSpecialComponent(null);
            } else {
                AbstractAttributeValueDescriptorDialog.this.setDescriptorValues(attributeValueDescriptorModel);
                Boolean modifiable = attributeValueDescriptorModel.getModifiable();
                boolean mod = modifiable == null || modifiable != false;
                AbstractAttributeValueDescriptorDialog.this.setDescriptorValuesEnabled(mod);
                AbstractAttributeValueDescriptorDialog.this.selectedValueDescriptorModel = (AttributeValueDescriptorModel)attributeValueDescriptorModel;
                AbstractAttributeValueDescriptorDialog.this.removeDescriptorAction.setEnabled(mod);
            }
            AbstractAttributeValueDescriptorDialog.this.setMovingEnablings();
        }
    }

    private class AddDescriptorAction
    extends AbstractAction {
        private static final long serialVersionUID = 8499378600954852165L;

        private AddDescriptorAction() {
            super("Hinzuf\u00fcgen");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttributeValueDescriptorModel attributeValueDescriptorModel = AbstractAttributeValueDescriptorDialog.this.createEmptyAttributeValueDescriptorModel();
            attributeValueDescriptorModel.setDescription("");
            attributeValueDescriptorModel.setKey("");
            attributeValueDescriptorModel.setEditable(false);
            attributeValueDescriptorModel.setName("Neuer Deskriptor");
            attributeValueDescriptorModel.setAttributeValueType(AttributeValueType.STRING);
            DefaultTreeModel dtm = (DefaultTreeModel)AbstractAttributeValueDescriptorDialog.this.descriptorList.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
            DefaultMutableTreeNode last = (DefaultMutableTreeNode)root.getLastChild();
            last.insert(new DefaultMutableTreeNode(attributeValueDescriptorModel), 0);
            dtm.reload();
            AbstractAttributeValueDescriptorDialog.this.expandAllTreeNodes();
            AbstractAttributeValueDescriptorDialog.this.selectUserObject(attributeValueDescriptorModel);
        }
    }

    private class RemoveDescriptorAction
    extends AbstractAction {
        private static final long serialVersionUID = -4457684156037937804L;

        private RemoveDescriptorAction() {
            super("Entfernen");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath treePath = AbstractAttributeValueDescriptorDialog.this.descriptorList.getSelectionPath();
            DefaultMutableTreeNode dmt = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            AttributeValueDescriptorModel attributeValueDescriptorModel = (AttributeValueDescriptorModel)dmt.getUserObject();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)dmt.getParent();
            parent.remove(dmt);
            List staticChoiceValues = attributeValueDescriptorModel.getStaticChoiceValues();
            for (StaticChoiceValue staticChoiceValue : staticChoiceValues) {
                ((Model)staticChoiceValue.getAttachedObject()).delete();
            }
            ((Model)attributeValueDescriptorModel.getAttachedObject()).delete();
            ((DefaultTreeModel)AbstractAttributeValueDescriptorDialog.this.descriptorList.getModel()).reload();
            AbstractAttributeValueDescriptorDialog.this.expandAllTreeNodes();
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = -3081061551035548573L;

        private OkAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Map multiMap;
            if (AbstractAttributeValueDescriptorDialog.this.selectedValueDescriptorModel != null) {
                AbstractAttributeValueDescriptorDialog.this.adaptValuesToModel(AbstractAttributeValueDescriptorDialog.this.selectedValueDescriptorModel);
            }
            if ((multiMap = AbstractAttributeValueDescriptorDialog.this.checkDescriptorsForUniqness()).isEmpty()) {
                AbstractAttributeValueDescriptorDialog.this.reorgSortOrder();
                try {
                    AbstractAttributeValueDescriptorDialog.this.modelEnviroment.getUndoManager().finishTransaction("");
                    AbstractAttributeValueDescriptorDialog.this.modelEnviroment.getUndoManager().storeTransactions();
                }
                catch (ValidateException e1) {
                    JOptionPane.showMessageDialog(AbstractAttributeValueDescriptorDialog.this, e1.getMessage());
                }
                AbstractAttributeValueDescriptorDialog.this.modelEnviroment.close();
                AbstractAttributeValueDescriptorDialog.this.dispose();
            } else {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.attributes.descriptorEqualKeys", new Serializable[0])), "North");
                ArrayList<String> textElements = new ArrayList<String>(multiMap.size());
                TreeSet keySet = new TreeSet(multiMap.keySet());
                for (String key : keySet) {
                    StringBuilder sb = new StringBuilder(key).append(" - ");
                    Collection col = (Collection)multiMap.get(key);
                    ArrayList<String> nameList = new ArrayList<String>(col.size());
                    for (AttributeValueDescriptorModel attributeValueDescriptorModel : col) {
                        nameList.add(attributeValueDescriptorModel.getName());
                    }
                    sb.append(StringUtil.implode(nameList, ", "));
                    textElements.add(sb.toString());
                }
                JTextArea ta = new JTextArea(StringUtil.implode(textElements, "\n"));
                panel.add((Component)new JScrollPane(ta), "Center");
                JOptionPane.showMessageDialog(AbstractAttributeValueDescriptorDialog.this, panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 3193354565160748706L;

        private CancelAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractAttributeValueDescriptorDialog.this.modelEnviroment.getUndoManager().rollbackTransaction();
            AbstractAttributeValueDescriptorDialog.this.dispose();
        }
    }

    private class AttributeValueTypeItem
    implements Comparable<AttributeValueTypeItem> {
        private AttributeValueType attributeValueType;
        private String representation;

        public AttributeValueTypeItem(AttributeValueType attributeValueType) {
            this.attributeValueType = attributeValueType;
        }

        public AttributeValueType getAttributeValueType() {
            return this.attributeValueType;
        }

        public String toString() {
            if (this.representation == null) {
                this.representation = ModelEnviroment.getMessageResolver().resolveMessage(AttributeValueType.class.getName() + "." + this.getAttributeValueType().name(), new Serializable[0]);
            }
            return this.representation;
        }

        @Override
        public int compareTo(AttributeValueTypeItem o) {
            return this.toString().compareTo(o.toString());
        }

        public boolean equals(Object obj) {
            if (AttributeValueTypeItem.class.isInstance(obj)) {
                AttributeValueTypeItem other = (AttributeValueTypeItem)obj;
                return this.getAttributeValueType() == other.getAttributeValueType();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.getAttributeValueType()).toHashCode();
        }
    }

    private class AttributeTreeRenderer
    implements TreeCellRenderer {
        private TreeCellRenderer parent;

        public AttributeTreeRenderer(TreeCellRenderer parent) {
            this.parent = parent;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object nValue = value;
            if (nValue instanceof DefaultMutableTreeNode) {
                if ((nValue = ((DefaultMutableTreeNode)nValue).getUserObject()) instanceof AttributeGroupModel) {
                    nValue = ((AttributeGroupModel)nValue).getName();
                } else if (nValue instanceof AttributeValueDescriptorModel) {
                    nValue = ((AttributeValueDescriptorModel)nValue).getName();
                }
            }
            return this.parent.getTreeCellRendererComponent(tree, nValue, selected, expanded, leaf, row, hasFocus);
        }
    }

    private class GroupComparator
    implements Comparator<AttributeGroupModel> {
        private GroupComparator() {
        }

        @Override
        public int compare(AttributeGroupModel o1, AttributeGroupModel o2) {
            String desc2;
            String desc1;
            String name2;
            String name1 = StringUtil.nullToEmpty(o1.getName());
            int d = name1.compareTo(name2 = StringUtil.nullToEmpty(o2.getName()));
            if (d == 0 && (d = (desc1 = StringUtil.nullToEmpty(o1.getDescription())).compareTo(desc2 = StringUtil.nullToEmpty(o2.getDescription()))) == 0) {
                Long id1 = o1.getId();
                Long id2 = o2.getId();
                d = id1.compareTo(id2);
            }
            return d;
        }
    }

    private class GroupActionListener
    implements ActionListener {
        private GroupActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttributeValueDescriptorModel attributeValueDescriptorModel;
            DefaultMutableTreeNode dmt;
            Object userObject;
            AttributeGroupModel group = (AttributeGroupModel)AbstractAttributeValueDescriptorDialog.this.attributeGroup.getSelectedItem();
            TreePath treePath = AbstractAttributeValueDescriptorDialog.this.descriptorList.getSelectionPath();
            if (treePath != null && (userObject = (dmt = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof AttributeValueDescriptorModel && !new EqualsBuilder().append(group, (attributeValueDescriptorModel = (AttributeValueDescriptorModel)userObject).getAttributeGroup()).isEquals()) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)dmt.getParent();
                parent.remove(dmt);
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)parent.getParent();
                if (group == null) {
                    DefaultMutableTreeNode last = (DefaultMutableTreeNode)root.getLastChild();
                    last.insert(dmt, 0);
                } else {
                    DefaultMutableTreeNode groupNode;
                    int i;
                    DefaultMutableTreeNode found = null;
                    for (i = 0; i < root.getChildCount(); ++i) {
                        groupNode = (DefaultMutableTreeNode)root.getChildAt(i);
                        if (!groupNode.getUserObject().equals(group)) continue;
                        groupNode.insert(dmt, 0);
                        found = groupNode;
                    }
                    if (found == null) {
                        found = new DefaultMutableTreeNode(group);
                        found.insert(dmt, 0);
                        for (i = 0; i < root.getChildCount(); ++i) {
                            groupNode = (DefaultMutableTreeNode)root.getChildAt(i);
                            Object groupObject = groupNode.getUserObject();
                            GroupComparator groupComparator = new GroupComparator();
                            if (groupObject instanceof AttributeGroupModel) {
                                AttributeGroupModel cGroup = (AttributeGroupModel)groupObject;
                                if (groupComparator.compare(cGroup, group) >= 0) continue;
                                root.insert(found, i);
                                break;
                            }
                            root.insert(found, i);
                            break;
                        }
                        found = root;
                    }
                }
                DefaultTreeModel dtm = (DefaultTreeModel)AbstractAttributeValueDescriptorDialog.this.descriptorList.getModel();
                dtm.reload(parent);
                dtm.reload(root);
                AbstractAttributeValueDescriptorDialog.this.expandAllTreeNodes();
                AbstractAttributeValueDescriptorDialog.this.restoreSelection(treePath);
            }
        }
    }
}

