/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.subscriptioneditor;

import de.datomino.peppergis.client.gui.location.AbstractLocationEditorPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.clienttools.location.AbstractLocationBasedLegendMouseListener;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.JList;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;

public class SubscriptionLegendMouseListener
extends AbstractLocationBasedLegendMouseListener<SubscriptionModel> {
    public SubscriptionLegendMouseListener(JList subscriptionList, ModelEnviroment modelEnviroment, AbstractLocationEditorPane parent) {
        super(subscriptionList, modelEnviroment, parent);
    }

    @Override
    protected String getDeleteActionName(Collection<SubscriptionModel> models) {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.delete", new Serializable[0]);
    }

    @Override
    protected String getEditActionName(Collection<SubscriptionModel> models) {
        return "Abonnenten-Koordinate bearbeiten";
    }

    @Override
    protected void delete(SubscriptionModel model) {
        SubscriptionModelUtil.deleteSubscription(model, this.getModelEnviroment());
    }

    @Override
    protected String getChangedText(SubscriptionModel model) {
        return "Abonnent (" + model.getSubscriptionNumber() + ") wurde verschoben.";
    }

    @Override
    protected LocationModel getLocationFromModel(SubscriptionModel model) {
        return model.getLocation();
    }

    @Override
    protected boolean checkIfOnlyObjectInCollections(SubscriptionModel model, Collection<CustomerModel> customers, Collection<PoiModel> pois, Collection<StopModel> stops, Collection<SubscriptionModel> subscriptions) {
        return subscriptions.contains(model) && subscriptions.size() == 1 && customers.isEmpty() && pois.isEmpty() && stops.isEmpty();
    }

    @Override
    protected String getDeletedMessage(Collection<SubscriptionModel> models) {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.deleted", new Serializable[]{StringUtil.implode(models, ", ", new NameGenerator<SubscriptionModel>(){

            @Override
            public String getName(SubscriptionModel t) {
                return t.getSubscriptionNumber();
            }
        })});
    }
}

