/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.subscriptioneditor;

import de.datomino.peppergis.client.communication.BaseCaller;
import de.datomino.peppergis.client.gui.location.AbstractLocationEditorPane;
import de.datomino.peppergis.client.gui.location.SearchLocationAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.subscription.SubscriptionDialog;
import de.datomino.peppergis.client.gui.subscription.SubscriptionLayerRenderer;
import de.datomino.peppergis.client.gui.subscription.SubscriptionListCellRenderer;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.util.StreetNameComparator;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.clienttools.subscriptioneditor.SubscriptionEditorActions;
import de.datomino.peppergis.clienttools.subscriptioneditor.SubscriptionLegendMouseListener;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeoObjectBucketsChangeListener;
import de.datomino.util.geo.model.GeoObjectBucketsChangedEvent;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class SubscriptionEditorGui
extends AbstractLocationEditorPane {
    private static final long serialVersionUID = -967880666587890520L;
    private SubscriptionEditorActions subscriptionEditorActions;
    private Set<SubscriptionModel> subscriptionSet;
    private SubscriptionLayerRenderer subscriptionLayerRenderer;
    private DefaultGeoObjectBucketsModel<SubscriptionModel, ImmutablePoint> subscriptionBucketsModel;
    private List<SubscriptionModel> nullGeoms;
    private List<SubscriptionModel> badSegments;
    private static boolean NULL_GEOM;
    private static boolean BAD_SEGMENT;

    public SubscriptionEditorGui(ModelEnviroment modelEnviroment, Properties properties) {
        super(modelEnviroment, properties);
    }

    @Override
    protected JPanel createTopPanel(JPanel undoManagerPane) {
        this.subscriptionEditorActions = new SubscriptionEditorActions(this);
        JPanel filterPanel = new JPanel(new FlowLayout());
        filterPanel.add(this.subscriptionEditorActions.getKindFilter());
        filterPanel.add(this.subscriptionEditorActions.getPlzFilter());
        Tupel<SearchLocationAction, Action> tupel = SearchLocationAction.createButtonTupel(this, super.getNavigatorPanel(), super.getModelEnviroment(), true, false);
        filterPanel.add(new JButton(tupel.getElement1()));
        filterPanel.add(new JButton(tupel.getElement2()));
        filterPanel.add(this.subscriptionEditorActions.getShowStreetButton());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)filterPanel, "West");
        topPanel.add(p1);
        JPanel p2 = new JPanel(new BorderLayout());
        p2.add((Component)undoManagerPane, "East");
        topPanel.add(p2);
        return topPanel;
    }

    @Override
    protected JScrollPane createLeftPanel() {
        DefaultListModel subscriptionListModel = new DefaultListModel();
        JList legendList = new JList(subscriptionListModel);
        this.setLegendList(legendList);
        SubscriptionListCellRenderer subscriptionModelListCellRenderer = new SubscriptionListCellRenderer();
        subscriptionModelListCellRenderer.setWithIndex(true);
        legendList.setCellRenderer(subscriptionModelListCellRenderer);
        legendList.addMouseListener(new SubscriptionLegendMouseListener(legendList, this.getModelEnviroment(), this));
        JScrollPane jScrollPane = new JScrollPane(legendList);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Abonnenten-Legende"));
        jScrollPane.setPreferredSize(FormUtil.SIZEOFLISTANDTREE);
        return jScrollPane;
    }

    @Override
    protected SubscriptionLayerRenderer getLayerRenderer() {
        if (this.subscriptionLayerRenderer == null) {
            this.subscriptionLayerRenderer = new SubscriptionLayerRenderer(this, this.getModelEnviroment(), true, true);
        }
        return this.subscriptionLayerRenderer;
    }

    @Override
    public void update() {
        ListValueChangeListener listValueChangeListener;
        NavigatorPanel navigatorPanel = this.getNavigatorPanel();
        final CoordinateFactory coordinateFactory = navigatorPanel.getCoordinateFactory();
        if (this.subscriptionBucketsModel == null) {
            this.subscriptionBucketsModel = new DefaultGeoObjectBucketsModel<SubscriptionModel, ImmutablePoint>(5000.0 * coordinateFactory.getRefScale(), coordinateFactory, this.createSubscriptionGeomExtractor());
            this.subscriptionBucketsModel.setFetchCallback(new BucketsFetchCallback<SubscriptionModel, ImmutablePoint>(){

                @Override
                public Collection<SubscriptionModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                    return SubscriptionEditorGui.this.getModelEnviroment().getAllCaller().getTourCaller().fetchSubscriptions(ImmutableGeoObjectFactory.createImmutablePoint(coordinateFactory.createCoordinate(topLeft)), ImmutableGeoObjectFactory.createImmutablePoint(coordinateFactory.createCoordinate(bottomRight)));
                }
            });
            this.subscriptionBucketsModel.addGeoObjectBucketsChangeListener(new GeoObjectBucketsChangeListener(){

                @Override
                public void geoBucketsChanged(GeoObjectBucketsChangedEvent e) {
                    SubscriptionEditorGui.this.getNavigatorPanel().repaint(10L);
                    SubscriptionEditorGui.this.update();
                }
            });
        }
        this.subscriptionSet = new HashSet<SubscriptionModel>();
        BaseCaller baseCaller = this.getModelEnviroment().getAllCaller().getBaseCaller();
        if (NULL_GEOM) {
            if (this.nullGeoms == null) {
                this.nullGeoms = new ArrayList<SubscriptionModel>(baseCaller.fetchSubscriptionsWithNullGeom());
                listValueChangeListener = new ListValueChangeListener(this.nullGeoms);
                for (SubscriptionModel subscription : this.nullGeoms) {
                    subscription.addValueChangeListener(listValueChangeListener);
                }
            }
            this.subscriptionSet.addAll(this.nullGeoms);
        }
        if (BAD_SEGMENT) {
            if (this.badSegments == null) {
                this.badSegments = new ArrayList<SubscriptionModel>(baseCaller.fetchSubscriptionsWithBadSegment());
                listValueChangeListener = new ListValueChangeListener(this.badSegments);
                for (SubscriptionModel subscription : this.badSegments) {
                    subscription.addValueChangeListener(listValueChangeListener);
                }
            }
            this.subscriptionSet.addAll(this.badSegments);
        }
        DefaultListModel subscriptionListModel = (DefaultListModel)this.getLegendList().getModel();
        subscriptionListModel.clear();
        ArrayList<SubscriptionModel> subscriptions = new ArrayList<SubscriptionModel>(this.subscriptionSet);
        if (this.isWithAllModels()) {
            Point2D.Double bottomLeft = navigatorPanel.getRealBoundaryBottomLeft();
            Point2D.Double topRight = navigatorPanel.getRealBoundaryTopRight();
            Coordinate topLeftCoordinate = coordinateFactory.createCoordinate(bottomLeft.x, topRight.y);
            ImmutablePoint topLeft = ImmutableGeoObjectFactory.createImmutablePoint(topLeftCoordinate);
            Coordinate bottomRightCoordinate = coordinateFactory.createCoordinate(topRight.x, bottomLeft.y);
            ImmutablePoint bottomRight = ImmutableGeoObjectFactory.createImmutablePoint(bottomRightCoordinate);
            subscriptions.addAll(this.subscriptionBucketsModel.findObjects(bottomRight, topLeft));
        }
        Collections.sort(subscriptions, new StreetNameComparator());
        for (SubscriptionModel subscription : subscriptions) {
            subscriptionListModel.addElement(subscription);
        }
        this.subscriptionEditorActions.filterAndSetInList();
    }

    private GeomExtractor<SubscriptionModel, ImmutablePoint> createSubscriptionGeomExtractor() {
        return new GeomExtractor<SubscriptionModel, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(SubscriptionModel object) {
                LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(object.getLocation());
                return locationWrapper.getGeoLocation();
            }
        };
    }

    @Override
    protected void showLegendDialog(Object o) {
        if (o instanceof SubscriptionModel) {
            Window parent = SwingUtils.findWindowParent(this);
            SubscriptionDialog subscriptionDialog = new SubscriptionDialog(parent, Arrays.asList((SubscriptionModel)o), this.getModelEnviroment());
            subscriptionDialog.setVisible(true);
        }
    }

    static {
        String nullGeomString = ModelEnviroment.getProperties().getProperty("subscriptionEditor.nullGeom.active");
        nullGeomString = StringUtil.isBlank(nullGeomString) ? "true" : nullGeomString;
        NULL_GEOM = StringUtil.isTrue(nullGeomString);
        String badSegmentString = ModelEnviroment.getProperties().getProperty("subscriptionEditor.badSegment.active");
        badSegmentString = StringUtil.isBlank(badSegmentString) ? "true" : badSegmentString;
        BAD_SEGMENT = StringUtil.isTrue(badSegmentString);
    }

    private class ListValueChangeListener
    implements ValueChangeListener {
        private List<SubscriptionModel> subscriptions;

        public ListValueChangeListener(List<SubscriptionModel> subscriptions) {
            this.subscriptions = subscriptions;
        }

        @Override
        public void valueChanged(ValueChangeEvent e) {
            SubscriptionModel subscription = (SubscriptionModel)e.getSource();
            switch (e.getType()) {
                case DELETE: {
                    this.subscriptions.remove(subscription);
                    SubscriptionEditorGui.this.update();
                    break;
                }
                case UNDELETE: {
                    this.subscriptions.add(subscription);
                    SubscriptionEditorGui.this.update();
                    break;
                }
            }
        }
    }
}

