/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.subscriptioneditor;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.clienttools.subscriptioneditor.SubscriptionEditorGui;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.swing.SpringUtilities;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.ktde.swing.AbstractToggleAction;
import org.ktde.util.datatypes.Tupel;

public class SubscriptionEditorActions {
    private SubscriptionEditorGui subscriptionEditorGui;
    private JTextField startPostcodeTexField;
    private JTextField endPostcodeTexField;

    public SubscriptionEditorActions(SubscriptionEditorGui subscriptionEditorGui) {
        this.subscriptionEditorGui = subscriptionEditorGui;
    }

    public JToggleButton getShowStreetButton() {
        AbstractToggleAction showStreetAction = new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("gui.route.motorcar", "gui.route.foot", "gui.route.bike"), new String[0]).replace(" ", "/")){
            private static final long serialVersionUID = 9040378009770278832L;

            @Override
            public void turnOn() {
                SubscriptionEditorActions.this.subscriptionEditorGui.getLayerRenderer().setForMotorSegment(true);
                SubscriptionEditorActions.this.subscriptionEditorGui.getLayerRenderer().setForFootSegment(true);
                SubscriptionEditorActions.this.subscriptionEditorGui.getLayerRenderer().setForBikeSegment(true);
                SubscriptionEditorActions.this.subscriptionEditorGui.repaint(10L);
            }

            @Override
            public void turnOff() {
                SubscriptionEditorActions.this.subscriptionEditorGui.getLayerRenderer().setForMotorSegment(false);
                SubscriptionEditorActions.this.subscriptionEditorGui.getLayerRenderer().setForFootSegment(false);
                SubscriptionEditorActions.this.subscriptionEditorGui.getLayerRenderer().setForBikeSegment(false);
                SubscriptionEditorActions.this.subscriptionEditorGui.repaint(10L);
            }
        };
        return new JToggleButton(showStreetAction);
    }

    public synchronized void filterAndSetInList() {
        DefaultListModel dlm = (DefaultListModel)this.subscriptionEditorGui.getLegendList().getModel();
        ArrayList<SubscriptionModel> subscriptions = new ArrayList<SubscriptionModel>(dlm.size());
        for (int i = 0; i < dlm.size(); ++i) {
            subscriptions.add((SubscriptionModel)dlm.getElementAt(i));
        }
        ArrayList<SubscriptionModel> list = new ArrayList<SubscriptionModel>(subscriptions.size());
        for (SubscriptionModel subscription : subscriptions) {
            if (!this.isInFilter(subscription)) continue;
            list.add(subscription);
        }
        dlm.clear();
        for (SubscriptionModel subscription : list) {
            dlm.addElement(subscription);
        }
        ArrayList<Tupel<SubscriptionModel, Integer>> tupel = new ArrayList<Tupel<SubscriptionModel, Integer>>(list.size());
        CollectionUtil.transform(list, tupel, new Transformer<SubscriptionModel, Tupel<SubscriptionModel, Integer>>(){

            @Override
            public Tupel<SubscriptionModel, Integer> transform(SubscriptionModel t) {
                return new Tupel<SubscriptionModel, Object>(t, null);
            }
        });
        this.subscriptionEditorGui.getLayerRenderer().setSubscriptions(tupel);
        this.subscriptionEditorGui.repaint(10L);
    }

    private boolean isInFilter(SubscriptionModel subscription) {
        boolean b = true;
        if (b) {
            String startPostcode = this.startPostcodeTexField.getText();
            String endPostcode = this.endPostcodeTexField.getText();
            if (startPostcode != null && !startPostcode.trim().equals("") || endPostcode != null && !endPostcode.trim().equals("")) {
                String postcodeString = null;
                try {
                    LocationModel location = subscription.getLocation();
                    LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
                    postcodeString = wrapper.getPostcode();
                }
                catch (NullPointerException e) {
                    b = false;
                }
                if (postcodeString != null && (startPostcode != null && startPostcode.compareTo(postcodeString.substring(0, Math.min(postcodeString.length(), startPostcode.length()))) > 0 || endPostcode != null && endPostcode.compareTo(postcodeString.substring(0, Math.min(postcodeString.length(), endPostcode.length()))) < 0)) {
                    b = false;
                }
            }
        }
        return b;
    }

    public Component getKindFilter() {
        JPanel kindFilterPanel = new JPanel(new SpringLayout());
        JCheckBox kindCheckBox = new JCheckBox("Alle Abonnenten auf der Karte");
        kindCheckBox.addItemListener(new KindFilterItemListener());
        kindFilterPanel.add(kindCheckBox);
        SpringUtilities.makeCompactGrid(kindFilterPanel, 1, 1, 2, 2, 2, 2);
        return kindFilterPanel;
    }

    public JPanel getPlzFilter() {
        JPanel plzFilterPanel = new JPanel(new SpringLayout());
        TextFilterChangedListener textFilterChangedListener = new TextFilterChangedListener();
        plzFilterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("address.postcode", "messages.default.from"), new String[0])));
        this.startPostcodeTexField = new JTextField(5);
        this.startPostcodeTexField.getDocument().addDocumentListener(textFilterChangedListener);
        plzFilterPanel.add(this.startPostcodeTexField);
        plzFilterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0])));
        this.endPostcodeTexField = new JTextField(5);
        this.endPostcodeTexField.getDocument().addDocumentListener(textFilterChangedListener);
        plzFilterPanel.add(this.endPostcodeTexField);
        SpringUtilities.makeCompactGrid(plzFilterPanel, 1, 4, 2, 2, 2, 2);
        return plzFilterPanel;
    }

    private class TextFilterChangedListener
    implements DocumentListener {
        private TextFilterChangedListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SubscriptionEditorActions.this.subscriptionEditorGui.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SubscriptionEditorActions.this.subscriptionEditorGui.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SubscriptionEditorActions.this.subscriptionEditorGui.update();
        }
    }

    private class KindFilterItemListener
    implements ItemListener {
        private KindFilterItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                SubscriptionEditorActions.this.subscriptionEditorGui.setWithAllModels(true);
            } else {
                SubscriptionEditorActions.this.subscriptionEditorGui.setWithAllModels(false);
            }
            SubscriptionEditorActions.this.subscriptionEditorGui.update();
        }
    }
}

