/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.stopeditor;

import de.datomino.peppergis.client.communication.BaseCaller;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.location.AbstractLocationEditorPane;
import de.datomino.peppergis.client.gui.location.SearchLocationAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.stop.StopLayerRenderer;
import de.datomino.peppergis.client.gui.stop.StopListCellRenderer;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.StreetNameComparator;
import de.datomino.peppergis.clienttools.stopeditor.PoiLegendMouseListener;
import de.datomino.peppergis.clienttools.stopeditor.StopEditorActions;
import de.datomino.peppergis.clienttools.stopeditor.StopLegendMouseListener;
import de.datomino.peppergis.tourmanager.gui.base.PoiModelListCellRenderer;
import de.datomino.peppergis.tourmanager.gui.stop.AddAndUpdateStopDialog;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class StopEditorGui
extends AbstractLocationEditorPane {
    private static final long serialVersionUID = -967880666587890520L;
    private StopEditorActions stopEditorActions;
    private Set<StopModel> stopSet;
    private StopLayerRenderer stopLayerRenderer;
    private DefaultListModel poiListModel;
    private DefaultGeoObjectBucketsModel<PoiModel, ImmutablePoint> poiBuckets;
    private DefaultGeoObjectBucketsModel<StopModel, ImmutablePoint> stopBuckets;
    private static boolean NULL_GEOM;
    private static boolean BAD_SEGMENT;
    private static boolean REMOVE_SAME_ADDRESS;

    public StopEditorGui(ModelEnviroment modelEnviroment, Properties properties) {
        super(modelEnviroment, properties);
        CoordinateFactory coordinateFactory = super.getNavigatorPanel().getCoordinateFactory();
        this.poiBuckets = new DefaultGeoObjectBucketsModel<PoiModel, ImmutablePoint>(coordinateFactory, new GeomExtractor<PoiModel, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(PoiModel object) {
                return object == null ? null : LocationModelUtil.getGeom(object.getLocation());
            }
        });
        this.poiBuckets.setFetchCallback(new BucketsFetchCallback<PoiModel, ImmutablePoint>(){

            @Override
            public Collection<PoiModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                BaseCaller baseCaller = StopEditorGui.super.getModelEnviroment().getAllCaller().getBaseCaller();
                return baseCaller.fetchPoisInRectangle(topLeft, bottomRight);
            }
        });
        this.stopBuckets = new DefaultGeoObjectBucketsModel<StopModel, ImmutablePoint>(coordinateFactory, new GeomExtractor<StopModel, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(StopModel object) {
                return object == null ? null : StopModelUtil.getGeom(object);
            }
        });
        this.stopBuckets.setFetchCallback(new BucketsFetchCallback<StopModel, ImmutablePoint>(){

            @Override
            public Collection<StopModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                ImmutablePoint topLeftPoint = ImmutableGeoObjectFactory.createImmutablePoint(topLeft);
                ImmutablePoint bottomRightPoint = ImmutableGeoObjectFactory.createImmutablePoint(bottomRight);
                TourCaller tourCaller = StopEditorGui.super.getModelEnviroment().getAllCaller().getTourCaller();
                return tourCaller.fetchStops(topLeftPoint, bottomRightPoint, REMOVE_SAME_ADDRESS);
            }
        });
    }

    @Override
    protected JPanel createTopPanel(JPanel undoManagerPane) {
        this.stopEditorActions = new StopEditorActions(this);
        JPanel filterPanel = new JPanel(new FlowLayout());
        filterPanel.add(this.stopEditorActions.getKindFilter());
        filterPanel.add(this.stopEditorActions.getPlzFilter());
        Tupel<SearchLocationAction, Action> tupel = SearchLocationAction.createButtonTupel(this, super.getNavigatorPanel(), super.getModelEnviroment(), true, false);
        filterPanel.add(new JButton(tupel.getElement1()));
        filterPanel.add(new JButton(tupel.getElement2()));
        filterPanel.add(this.stopEditorActions.getShowStreetButton());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)filterPanel, "West");
        topPanel.add(p1);
        JPanel p2 = new JPanel(new BorderLayout());
        p2.add((Component)undoManagerPane, "East");
        topPanel.add(p2);
        return topPanel;
    }

    @Override
    protected JComponent createLeftPanel() {
        DefaultListModel stopListModel = new DefaultListModel();
        JList legendList = new JList(stopListModel);
        this.setLegendList(legendList);
        StopListCellRenderer stopListCellRenderer = new StopListCellRenderer();
        stopListCellRenderer.setWithIndex(true);
        legendList.setCellRenderer(stopListCellRenderer);
        legendList.addMouseListener(new StopLegendMouseListener(legendList, this.getModelEnviroment(), this));
        JScrollPane stopScrollPane = new JScrollPane(legendList);
        stopScrollPane.setBorder(BorderFactory.createTitledBorder(""));
        stopScrollPane.setPreferredSize(FormUtil.SIZEOFLISTANDTREE);
        this.poiListModel = new DefaultListModel();
        JList poiList = new JList(this.poiListModel);
        PoiModelListCellRenderer poiListCellRenderer = new PoiModelListCellRenderer(true);
        poiListCellRenderer.setWithIndex(true);
        poiList.setCellRenderer(poiListCellRenderer);
        poiList.addMouseListener(new PoiLegendMouseListener(poiList, this.getModelEnviroment(), this));
        this.getLayerRenderer().setPois(Collections.EMPTY_LIST);
        JScrollPane poiScrollPane = new JScrollPane(poiList);
        poiScrollPane.setBorder(BorderFactory.createTitledBorder(""));
        poiScrollPane.setPreferredSize(FormUtil.SIZEOFLISTANDTREE);
        JTabbedPane tabbedPane = new JTabbedPane(1, 0);
        tabbedPane.add("Abladestellen", stopScrollPane);
        tabbedPane.add("Fixpunkte", poiScrollPane);
        return tabbedPane;
    }

    @Override
    protected StopLayerRenderer getLayerRenderer() {
        if (this.stopLayerRenderer == null) {
            this.stopLayerRenderer = new StopLayerRenderer(true, true, super.getModelEnviroment());
        }
        return this.stopLayerRenderer;
    }

    @Override
    public void update() {
        if (this.stopSet == null) {
            this.stopSet = new HashSet<StopModel>();
            TourCaller tourCaller = this.getModelEnviroment().getAllCaller().getTourCaller();
            if (NULL_GEOM) {
                this.stopSet.addAll(tourCaller.fetchStopsWithNullGeom(REMOVE_SAME_ADDRESS));
            }
            if (BAD_SEGMENT) {
                this.stopSet.addAll(tourCaller.fetchStopsWithBadSegment(REMOVE_SAME_ADDRESS));
            }
        }
        DefaultListModel stopListModel = (DefaultListModel)this.getLegendList().getModel();
        stopListModel.clear();
        this.poiListModel.clear();
        ArrayList<StopModel> stops = new ArrayList<StopModel>(this.stopSet);
        ArrayList pois = new ArrayList();
        if (this.isWithAllModels()) {
            NavigatorPanel navigatorPanel = this.getNavigatorPanel();
            CoordinateFactory factory = navigatorPanel.getCoordinateFactory();
            Point2D.Double bottomLeft = navigatorPanel.getRealBoundaryBottomLeft();
            Point2D.Double topRight = navigatorPanel.getRealBoundaryTopRight();
            Coordinate bottomLeftCoordinate = factory.createCoordinate(bottomLeft.x, bottomLeft.y);
            Coordinate topRightCoordinate = factory.createCoordinate(topRight.x, topRight.y);
            stops.addAll(this.stopBuckets.findObjects(bottomLeftCoordinate, topRightCoordinate));
            pois.addAll(this.poiBuckets.findObjects(bottomLeftCoordinate, topRightCoordinate));
        }
        Collections.sort(stops, new StreetNameComparator());
        for (StopModel stop : stops) {
            stopListModel.addElement(stop);
        }
        Collections.sort(pois, new StreetNameComparator());
        for (PoiModel poi : pois) {
            this.poiListModel.addElement(poi);
        }
        this.stopEditorActions.filterAndSetInList();
    }

    @Override
    protected void showLegendDialog(Object o) {
        if (o instanceof StopModel) {
            AddAndUpdateStopDialog addAndUpdateStopDialog = new AddAndUpdateStopDialog(this.getModelEnviroment(), true, null);
            addAndUpdateStopDialog.showDialog((StopModel)o, true, (Component)this);
        }
    }

    public DefaultListModel getPoiListModel() {
        return this.poiListModel;
    }

    static {
        String nullGeomString = ModelEnviroment.getProperties().getProperty("stopEditor.nullGeom.active");
        nullGeomString = StringUtil.isBlank(nullGeomString) ? "true" : nullGeomString;
        NULL_GEOM = StringUtil.isTrue(nullGeomString);
        String badSegmentString = ModelEnviroment.getProperties().getProperty("stopEditor.badSegment.active");
        badSegmentString = StringUtil.isBlank(badSegmentString) ? "true" : badSegmentString;
        BAD_SEGMENT = StringUtil.isTrue(badSegmentString);
        String sameAddressString = ModelEnviroment.getProperties().getProperty("stopEditor.legend.removeSameAddress");
        sameAddressString = StringUtil.isBlank(sameAddressString) ? "true" : sameAddressString;
        REMOVE_SAME_ADDRESS = StringUtil.isTrue(sameAddressString);
    }
}

