/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.parceleditor;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.geometric.GeoClientHelper;
import de.datomino.peppergis.client.gui.location.GeomEditorResult;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.DeleteParcelDialog;
import de.datomino.peppergis.client.gui.parcel.ParcelLayerRenderer;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.clienttools.parceleditor.ParcelEditorGui;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.SwingUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;

public class ParcelLegendMouseListener
extends MouseAdapter {
    private JList parcelJList;
    private ParcelEditorGui parent;
    private ModelEnviroment modelEnviroment;
    private GeoClientHelper geoClientHelper;

    public ParcelLegendMouseListener(JList parcelList, ModelEnviroment modelEnviroment, ParcelEditorGui parent) {
        this.parent = parent;
        this.parcelJList = parcelList;
        this.modelEnviroment = modelEnviroment;
        this.geoClientHelper = new GeoClientHelper(modelEnviroment);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mousePressed(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            this.showRoutingPopupMenu(e);
        }
    }

    private void showRoutingPopupMenu(MouseEvent e) {
        Object[] selObjects = this.parcelJList.getSelectedValues();
        if (selObjects.length == 0) {
            return;
        }
        final HashSet<ParcelModel> tupels = new HashSet<ParcelModel>(selObjects.length);
        for (Object o : selObjects) {
            tupels.add((ParcelModel)o);
        }
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new AbstractAction("Geb\u00e4ude-Koordinate bearbeiten"){
            private static final long serialVersionUID = -8210513826838906210L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    for (ParcelModel tupel : tupels) {
                        ParcelLegendMouseListener.this.createCoordinateMapDialog(tupel);
                    }
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(ParcelLegendMouseListener.this.parcelJList, "properties error");
                }
            }
        });
        if (StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("map.parcel.deleteAllowed"))) {
            popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.deleted", new Serializable[]{""})){
                private static final long serialVersionUID = -1293471591888928863L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ErrorMessages errorMessages = new ErrorMessages();
                    for (ParcelModel tupel : tupels) {
                        ParcelLegendMouseListener.this.deleteParcel(tupel, errorMessages);
                    }
                    if (errorMessages.hasErrors()) {
                        BufferedImage image;
                        try {
                            image = ImageIO.read(ParcelLegendMouseListener.class.getResourceAsStream("/images/pepper.png"));
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                        ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(SwingUtils.findWindowParent(ParcelLegendMouseListener.this.parent), ModelEnviroment.getMessageResolver(), errorMessages, image);
                        errorMessageDialog.setVisible(true);
                    }
                }
            });
        }
        popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.parcel.center", new Serializable[0])){
            private static final long serialVersionUID = -8370990316626174473L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Coordinate coordinate;
                ParcelModel parcel = (ParcelModel)tupels.iterator().next();
                Coordinate coordinate2 = coordinate = parcel == null || parcel.getGeom() == null ? null : parcel.getGeom().getCoordinate();
                if (GeoUtil.isNullCoordinate(coordinate)) {
                    coordinate = Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0);
                }
                ParcelLayerRenderer layerRenderer = ParcelLegendMouseListener.this.parent.getLayerRenderer();
                layerRenderer.center(coordinate);
            }
        });
        popupMenu.show(this.parcelJList, e.getX(), e.getY());
    }

    private void deleteParcel(final ParcelModel parcel, ErrorMessages errorMessages) {
        DeleteParcelDialog dialog = new DeleteParcelDialog(parcel, this.modelEnviroment, this.parent, errorMessages){
            private static final long serialVersionUID = 6872425691291769576L;

            @Override
            public void after() {
                ((DefaultListModel)ParcelLegendMouseListener.this.parcelJList.getModel()).removeElement(parcel);
                ParcelLegendMouseListener.this.parcelJList.repaint(10L);
            }
        };
        dialog.setVisible(true);
    }

    private void createCoordinateMapDialog(ParcelModel parcel) throws IOException {
        Coordinate startCoordinate = null;
        String title = "";
        ImmutablePoint geom = parcel.getGeom();
        startCoordinate = geom == null ? null : Wgs84Factory.INSTANCE.createCoordinate(geom.getCoordinate());
        title = ParcelModelUtil.getAddress(parcel);
        if (startCoordinate == null) {
            JOptionPane.showMessageDialog(this.parcelJList, ModelEnviroment.getMessageResolver().resolveMessage("gui.location.error.noEditable", new Serializable[0]));
            return;
        }
        this.parent.showCoordinateEditorMapPane(title, startCoordinate, ParcelModelUtil.getRouteSegment(parcel, RouteVehicleType.MOTORCAR), ParcelModelUtil.getRouteSegment(parcel, RouteVehicleType.FOOT), ParcelModelUtil.getRouteSegment(parcel, RouteVehicleType.BIKE), true);
        this.parent.getCoordinateEditorMapPane().setStreetName(ParcelModelUtil.getStreetName(parcel));
        GeomEditorResult result = this.parent.getCoordinateEditorMapPane().getResult();
        if (result.isChanged(startCoordinate, parcel.getMotorSegment(), parcel.getFootSegment(), parcel.getBikeSegment())) {
            this.modelEnviroment.getUndoManager().startTransaction();
            ParcelModelUtil.setGeomResult(parcel, result, this.geoClientHelper);
            this.parcelJList.repaint(10L);
            this.parent.getNavigatorPanel().repaint(10L);
            LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(parcel);
            ImmutablePointDto pointDto = ImmutablePointDto.create(wrapper.getGeoLocation());
            LogisticLocationDto<Long> location = new LogisticLocationDto<Long>(wrapper.getId(), pointDto, null, wrapper.getCountry(), wrapper.getPostcode(), wrapper.getCity(), wrapper.getDistrict(), wrapper.getStreet(), wrapper.getHousenumber(), wrapper.getHousenumberExtension());
            TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
            Collection<LocationModel> locations = tourCaller.fetchLocationsWithSameAddress(location);
            for (LocationModel l : locations) {
                LocationModelUtil.setGeomResult(l, result, this.geoClientHelper);
            }
            this.modelEnviroment.getUndoManager().finishTransaction("Geb\u00e4ude (" + title + ") wurde verschoben.");
            this.parent.update();
        }
    }
}

