/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.parceleditor;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.clienttools.parceleditor.ParcelEditorGui;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.SpringUtilities;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.ktde.swing.AbstractToggleAction;

public class ParcelEditorActions {
    private ParcelEditorGui parcelEditorGui;
    private JTextField startPostcodeTexField;
    private JTextField endPostcodeTexField;

    public ParcelEditorActions(ParcelEditorGui parcelEditorGui) {
        this.parcelEditorGui = parcelEditorGui;
    }

    public JToggleButton getShowStreetButton() {
        AbstractToggleAction showStreetAction = new AbstractToggleAction(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("gui.route.motorcar", "gui.route.foot", "gui.route.bike"), new String[0]).replace(" ", "/")){
            private static final long serialVersionUID = -6692152617927939466L;

            @Override
            public void turnOn() {
                ParcelEditorActions.this.parcelEditorGui.getLayerRenderer().setForMotorSegment(true);
                ParcelEditorActions.this.parcelEditorGui.getLayerRenderer().setForFootSegment(true);
                ParcelEditorActions.this.parcelEditorGui.getLayerRenderer().setForBikeSegment(true);
                ParcelEditorActions.this.parcelEditorGui.repaint(10L);
            }

            @Override
            public void turnOff() {
                ParcelEditorActions.this.parcelEditorGui.getLayerRenderer().setForMotorSegment(false);
                ParcelEditorActions.this.parcelEditorGui.getLayerRenderer().setForFootSegment(false);
                ParcelEditorActions.this.parcelEditorGui.getLayerRenderer().setForBikeSegment(false);
                ParcelEditorActions.this.parcelEditorGui.repaint(10L);
            }
        };
        return new JToggleButton(showStreetAction);
    }

    public synchronized void filterAndSetInList() {
        DefaultListModel dlm = (DefaultListModel)this.parcelEditorGui.getLegendList().getModel();
        ArrayList<ParcelModel> tupels = new ArrayList<ParcelModel>(dlm.size());
        for (int i = 0; i < dlm.size(); ++i) {
            tupels.add((ParcelModel)dlm.getElementAt(i));
        }
        dlm.clear();
        ArrayList<ParcelModel> filtered = new ArrayList<ParcelModel>();
        for (ParcelModel tupel : tupels) {
            if (!this.isInFilter(tupel)) continue;
            dlm.addElement(tupel);
            filtered.add(tupel);
        }
        this.parcelEditorGui.getLayerRenderer().setParcels(filtered);
        this.parcelEditorGui.repaint(10L);
    }

    private boolean isInFilter(ParcelModel parcel) {
        boolean b = true;
        if (b) {
            String startPostcode = this.startPostcodeTexField.getText();
            String endPostcode = this.endPostcodeTexField.getText();
            if (startPostcode != null && !startPostcode.trim().equals("") || endPostcode != null && !endPostcode.trim().equals("")) {
                String postcodeString = null;
                try {
                    PostcodeModel postcode = parcel.getStreet().getPostcodeDistrictRelation().getPostcode();
                    postcodeString = postcode.getName();
                }
                catch (NullPointerException e) {
                    b = false;
                }
                if (postcodeString != null && (startPostcode != null && startPostcode.compareTo(postcodeString.substring(0, Math.min(postcodeString.length(), startPostcode.length()))) > 0 || endPostcode != null && endPostcode.compareTo(postcodeString.substring(0, Math.min(postcodeString.length(), endPostcode.length()))) < 0)) {
                    b = false;
                }
            }
        }
        return b;
    }

    public Component getKindFilter() {
        JPanel kindFilterPanel = new JPanel(new SpringLayout());
        JCheckBox kindCheckBox = new JCheckBox("Alle Geb\u00e4ude auf der Karte");
        kindCheckBox.addItemListener(new KindFilterItemListener());
        kindFilterPanel.add(kindCheckBox);
        SpringUtilities.makeCompactGrid(kindFilterPanel, 1, 1, 2, 2, 2, 2);
        return kindFilterPanel;
    }

    public JPanel getPlzFilter() {
        JPanel plzFilterPanel = new JPanel(new SpringLayout());
        TextFilterChangedListener textFilterChangedListener = new TextFilterChangedListener();
        plzFilterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("address.postcode", "messages.default.from"), new String[0])));
        this.startPostcodeTexField = new JTextField(5);
        this.startPostcodeTexField.getDocument().addDocumentListener(textFilterChangedListener);
        plzFilterPanel.add(this.startPostcodeTexField);
        plzFilterPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0])));
        this.endPostcodeTexField = new JTextField(5);
        this.endPostcodeTexField.getDocument().addDocumentListener(textFilterChangedListener);
        plzFilterPanel.add(this.endPostcodeTexField);
        SpringUtilities.makeCompactGrid(plzFilterPanel, 1, 4, 2, 2, 2, 2);
        return plzFilterPanel;
    }

    private class TextFilterChangedListener
    implements DocumentListener {
        private TextFilterChangedListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ParcelEditorActions.this.parcelEditorGui.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ParcelEditorActions.this.parcelEditorGui.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ParcelEditorActions.this.parcelEditorGui.update();
        }
    }

    private class KindFilterItemListener
    implements ItemListener {
        private KindFilterItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                ParcelEditorActions.this.parcelEditorGui.setWithAllModels(true);
            } else {
                ParcelEditorActions.this.parcelEditorGui.setWithAllModels(false);
            }
            ParcelEditorActions.this.parcelEditorGui.update();
        }
    }
}

