/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.location;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.gui.address.AddressPane;
import de.datomino.peppergis.client.gui.location.AbstractLocationEditorPane;
import de.datomino.peppergis.client.gui.location.GeomEditorResult;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.wrapper.LocationableObjectsModelWrapper;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.model.location.ImportedLocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.client.util.model.location.ParcelLocationWrapper;
import de.datomino.peppergis.type.ImportedLocationProcess;
import de.datomino.peppergis.type.ImportedLocationStatus;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.international.country.Country;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;

public abstract class AbstractLocationBasedLegendMouseListener<T extends Model>
extends MouseAdapter {
    private JList modelList;
    private AbstractLocationEditorPane parent;
    private ModelEnviroment modelEnviroment;

    public AbstractLocationBasedLegendMouseListener(JList modelList, ModelEnviroment modelEnviroment, AbstractLocationEditorPane parent) {
        this.parent = parent;
        this.modelList = modelList;
        this.modelEnviroment = modelEnviroment;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mousePressed(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            this.showRoutingPopupMenu(e);
        }
    }

    private void showRoutingPopupMenu(MouseEvent e) {
        Object[] selObjects = this.modelList.getSelectedValues();
        if (selObjects.length == 0) {
            return;
        }
        final HashSet<Model> models = new HashSet<Model>(selObjects.length);
        for (Object o : selObjects) {
            models.add((Model)o);
        }
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new AbstractAction(this.getEditActionName(models)){
            private static final long serialVersionUID = -8210513826838906210L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    for (Model model : models) {
                        AbstractLocationBasedLegendMouseListener.this.createCoordinateMapDialog(model);
                    }
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(AbstractLocationBasedLegendMouseListener.this.modelList, "properties error");
                }
            }
        });
        popupMenu.add(new AbstractAction(this.getDeleteActionName(models)){
            private static final long serialVersionUID = -1293471591888928863L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager undoManager = AbstractLocationBasedLegendMouseListener.this.modelEnviroment.getUndoManager();
                DefaultListModel dlm = (DefaultListModel)AbstractLocationBasedLegendMouseListener.this.modelList.getModel();
                undoManager.startTransaction();
                for (Model model : models) {
                    AbstractLocationBasedLegendMouseListener.this.delete(model);
                    dlm.removeElement(model);
                }
                undoManager.finishTransaction(AbstractLocationBasedLegendMouseListener.this.getDeletedMessage(models));
            }
        });
        popupMenu.show(this.modelList, e.getX(), e.getY());
    }

    protected abstract String getDeleteActionName(Collection<T> var1);

    protected abstract String getEditActionName(Collection<T> var1);

    protected abstract void delete(T var1);

    private void createCoordinateMapDialog(T model) throws IOException {
        LocationModel location = this.getLocationFromModel(model);
        if (location == null) {
            return;
        }
        LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        Coordinate startCoordinate = null;
        startCoordinate = wrapper.getGeoLocation() == null ? Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0) : Wgs84Factory.INSTANCE.createCoordinate(wrapper.getGeoLocation().getCoordinate());
        String title = LocationModelUtil.getAddressString(location);
        SegmentModel motorSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.MOTORCAR, this.modelEnviroment);
        SegmentModel footSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.FOOT, this.modelEnviroment);
        SegmentModel bikeSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.BIKE, this.modelEnviroment);
        JDialog dialog = this.parent.showCoordinateEditorMapPane(title, startCoordinate, motorSegment, footSegment, bikeSegment, true);
        do {
            GeomEditorResult result = this.parent.getCoordinateEditorMapPane().getResult();
            Integer lastExitValue = this.parent.getCoordinateEditorMapPane().getLastExitValue();
            if (lastExitValue == 0 && result.isChanged(startCoordinate, motorSegment, footSegment, bikeSegment)) {
                this.modelEnviroment.getUndoManager().startTransaction();
                Boolean ok = this.syncChange(location, result, model);
                if (ok == null) {
                    dialog.setVisible(true);
                    result = this.parent.getCoordinateEditorMapPane().getResult();
                    continue;
                }
                if (ok.booleanValue()) {
                    this.modelEnviroment.getUndoManager().finishTransaction(this.getChangedText(model));
                } else {
                    this.modelEnviroment.getUndoManager().rollbackTransaction();
                }
                this.modelList.repaint(10L);
                this.parent.getNavigatorPanel().repaint(10L);
                dialog = null;
                continue;
            }
            dialog = null;
        } while (dialog != null);
        this.parent.update();
    }

    protected abstract String getChangedText(T var1);

    protected abstract LocationModel getLocationFromModel(T var1);

    private Boolean syncChange(LocationModel location, GeomEditorResult result, T model) {
        LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        if (wrapper instanceof ParcelLocationWrapper) {
            return this.handleNewImportedLocation(wrapper, location, result);
        }
        if (wrapper instanceof ImportedLocationWrapper) {
            Collection<SubscriptionModel> subscriptions;
            Collection<StopModel> stops;
            Collection<PoiModel> pois;
            LocationableObjectsModelWrapper locationableObjectsDto = this.modelEnviroment.getAllCaller().getBaseCaller().getObjectsAttachedToImportedLocation(location.getImportedLocation());
            Collection<CustomerModel> customers = locationableObjectsDto.getCustomers();
            if (this.checkIfOnlyObjectInCollections(model, customers, pois = locationableObjectsDto.getPois(), stops = locationableObjectsDto.getStops(), subscriptions = locationableObjectsDto.getSubscriptions())) {
                this.moveImportedLocation(location, result);
                return true;
            }
            return this.handleMore(location, locationableObjectsDto, wrapper, result);
        }
        this.parent.repaint(10L);
        return true;
    }

    protected abstract boolean checkIfOnlyObjectInCollections(T var1, Collection<CustomerModel> var2, Collection<PoiModel> var3, Collection<StopModel> var4, Collection<SubscriptionModel> var5);

    private Boolean handleMore(LocationModel location, LocationableObjectsModelWrapper locationableObjectsDto, LocationWrapper locationWrapper, GeomEditorResult result) {
        Collection<PoiModel> pois;
        Collection<StopModel> stops;
        Collection<SubscriptionModel> subscriptions;
        StringBuilder sb = new StringBuilder(ModelEnviroment.getMessageResolver().resolveMessage("messages.importedLocation.moreObjectsAreAttached", new Serializable[0])).append(":");
        Collection<CustomerModel> customers = locationableObjectsDto.getCustomers();
        if (!customers.isEmpty()) {
            sb.append("\n\n").append(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.customers", new Serializable[0])).append(":\n").append(StringUtil.implode(customers, "\n", new NameGenerator<CustomerModel>(){

                @Override
                public String getName(CustomerModel c) {
                    return c.getCustomerNumber();
                }
            }));
        }
        if (!(subscriptions = locationableObjectsDto.getSubscriptions()).isEmpty()) {
            sb.append("\n\n").append(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0])).append(":\n").append(StringUtil.implode(subscriptions, "\n", new NameGenerator<SubscriptionModel>(){

                @Override
                public String getName(SubscriptionModel s) {
                    return s.getSubscriptionNumber();
                }
            }));
        }
        if (!(stops = locationableObjectsDto.getStops()).isEmpty()) {
            sb.append("\n\n").append(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.stops", new Serializable[0])).append(":\n").append(StringUtil.implode(stops, "\n", new NameGenerator<StopModel>(){

                @Override
                public String getName(StopModel s) {
                    return s.getName();
                }
            }));
        }
        if (!(pois = locationableObjectsDto.getPois()).isEmpty()) {
            sb.append("\n\n").append(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.pois", new Serializable[0])).append(":\n").append(StringUtil.implode(pois, "\n", new NameGenerator<PoiModel>(){

                @Override
                public String getName(PoiModel s) {
                    return s.getPoiNumber();
                }
            }));
        }
        JPanel panel = new JPanel(new BorderLayout());
        JTextArea area = new JTextArea(sb.toString(), 50, 0);
        area.setEditable(false);
        panel.add((Component)new JScrollPane(area), "Center");
        Object[] options = new Object[]{ModelEnviroment.getMessageResolver().resolveMessage("messages.importedLocation.moveAll", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.importedLocation.newAdress", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.resetChanges", new Serializable[0])};
        block6: while (true) {
            int option = JOptionPane.showOptionDialog(SwingUtils.findWindowParent(this.parent), panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), -1, 3, null, options, null);
            switch (option) {
                case 0: {
                    this.moveImportedLocation(location, result);
                    return true;
                }
                case 1: {
                    Boolean b = this.handleNewImportedLocation(locationWrapper, location, result);
                    if (b != null && !b.booleanValue()) continue block6;
                    return b;
                }
                case 2: {
                    return false;
                }
                case 3: {
                    return null;
                }
            }
        }
    }

    private void moveImportedLocation(LocationModel location, GeomEditorResult result) {
        ImportedLocationModel ilm = location.getImportedLocation();
        ImmutablePoint newPoint = ImmutableGeoObjectFactory.createImmutablePoint(result.getCoordinate());
        ilm.setGeoLocation(newPoint);
        location.setMotorSegment(result.getMotorSegment());
        location.setFootSegment(result.getFootSegment());
        location.setBikeSegment(result.getBikeSegment());
        location.setImportedLocation(ilm);
    }

    private Boolean handleNewImportedLocation(LocationWrapper wrapper, LocationModel location, GeomEditorResult result) {
        JPanel panel = new JPanel(new BorderLayout());
        AddressPane addressPane = new AddressPane(this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry());
        addressPane.setLocation(wrapper);
        panel.add((Component)addressPane, "Center");
        while (true) {
            int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(this.parent), panel, ModelEnviroment.getMessageResolver().resolveMessage("address.address", new Serializable[0]), 0, 3);
            switch (d) {
                case 0: {
                    boolean b = this.checkImportedLocationOccurance(addressPane.getCountry(), addressPane.getPostcode(), addressPane.getCity(), addressPane.getDistrict(), addressPane.getStreet(), addressPane.getHousenumber(), addressPane.getHousenumberExtension());
                    if (!b) {
                        location.setParcel(null);
                        ImportedLocationModelImpl ilm = new ImportedLocationModelImpl();
                        ilm.setCity(addressPane.getCity());
                        ilm.setCountry(addressPane.getCountry());
                        ilm.setDistrict(addressPane.getDistrict());
                        ilm.setHousenumber(addressPane.getHousenumber());
                        ilm.setHousenumberExtension(addressPane.getHousenumberExtension());
                        ilm.setInformation("");
                        ilm.setLoginUser(ModelEnviroment.getUserInformation().getUserModel());
                        ilm.setPostcode(addressPane.getPostcode());
                        ilm.setProcess(ImportedLocationProcess.OPEN);
                        ilm.setStatus(ImportedLocationStatus.CHECKED);
                        ilm.setStreet(addressPane.getStreet());
                        ImmutablePoint newPoint = ImmutableGeoObjectFactory.createImmutablePoint(result.getCoordinate());
                        ilm.setGeoLocation(newPoint);
                        location.setMotorSegment(result.getMotorSegment());
                        location.setFootSegment(result.getFootSegment());
                        location.setBikeSegment(result.getBikeSegment());
                        location.setImportedLocation(ilm);
                        return true;
                    }
                    JOptionPane.showMessageDialog(SwingUtils.findWindowParent(this.parent), ModelEnviroment.getMessageResolver().resolveMessage("address.warning.addressExists", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
                    break;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return null;
                }
            }
        }
    }

    private boolean checkImportedLocationOccurance(Country country, String postcode, String city, String district, String street, Integer housenumber, String housenumberExtension) {
        Collection<ImportedLocationModel> ils = this.modelEnviroment.getAllCaller().getStreetNetCaller().findImportLocationsExact(country, postcode, city, district, street, housenumber, housenumberExtension, false);
        if (ils.isEmpty()) {
            Collection<ParcelModel> parcels = this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchParcelExact(country, postcode, city, district, street, housenumber == null ? "" : housenumber.toString(), housenumberExtension);
            return !parcels.isEmpty();
        }
        return true;
    }

    protected abstract String getDeletedMessage(Collection<T> var1);

    protected ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }
}

