/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.action.review;

import de.datomino.logistic.dto.OptimizationAlgorithmType;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.logistic.type.RouteBackType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.AsynchronousCaller;
import de.datomino.peppergis.client.export.AbstractExportFileAction;
import de.datomino.peppergis.client.file.FileUtil;
import de.datomino.peppergis.client.gui.areatour.AbstractAreaTourCalculationOrderNotPossibleDialog;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.BlockDescriptor;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.task.ServerTaskChecker;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.client.util.DeliveryRoundModelUtil;
import de.datomino.peppergis.clienttools.action.review.ReviewAreaTourPane;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.exporter.TourExportDto;
import de.datomino.peppergis.dto.exporter.TourExportFormat;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.tour.AreaTourParameter;
import de.datomino.peppergis.tour.CalculationWay;
import de.datomino.peppergis.tour.ParcelParameter;
import de.datomino.peppergis.tour.SubscriptionParameter;
import de.datomino.peppergis.type.LetterDeliveryType;
import de.datomino.peppergis.type.SubscriptionDeliveryType;
import de.datomino.peppergis.type.SubscriptionStatus;
import de.datomino.peppergis.type.areatourtype.AreaCalculationType;
import de.datomino.peppergis.type.areatourtype.AreaObjectType;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class ReviewAreaToursAction
extends AbstractAction {
    private static final long serialVersionUID = 7061283020067177100L;
    private static final String ORIG_PREFIX = "ORIG";
    private static final String PARCEL_PREFIX = "PARCEL";
    private static final String OPTIMIZE_PREFIX = "OPTIMIZE";
    private static final String CSV_PREFIX = "csv";
    private Window parent;
    private ReviewAreaTourPane reviewAreaTourPane;

    public ReviewAreaToursAction(String titel, Window parent) {
        super(titel);
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final ModelEnviroment modelEnviroment = new ModelEnviroment(this.parent);
        ServerTaskChecker checker = new ServerTaskChecker(modelEnviroment);
        if (!checker.isReady(true, this.parent)) {
            return;
        }
        String codexPropertyString = ModelEnviroment.getProperties().getProperty("review.codex.interface.xml.enable");
        final boolean createXmlProp = StringUtil.isTrue(codexPropertyString);
        final JDialog subDialog = new JDialog(this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.routing", new Serializable[0]), Dialog.ModalityType.DOCUMENT_MODAL);
        try {
            subDialog.setIconImage(ImageIO.read(ReviewAreaToursAction.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        subDialog.setResizable(false);
        if (this.reviewAreaTourPane == null) {
            this.reviewAreaTourPane = new ReviewAreaTourPane(modelEnviroment);
        }
        JPanel buttonPane = new JPanel(new FlowLayout());
        final LinkedList toOptimize = new LinkedList();
        final LinkedList toOrderOrig = new LinkedList();
        final LinkedList toOrderParcel = new LinkedList();
        buttonPane.add(new JButton(new AbstractExportFileAction<Object>(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0]), this.parent, CSV_PREFIX){
            private static final long serialVersionUID = 8402693600289836342L;

            @Override
            public void actionPerformed(final ActionEvent e) {
                toOptimize.clear();
                toOrderOrig.clear();
                toOrderParcel.clear();
                Tupel<Collection<Tupel<AreaObjectModel, List<Model>>>, Collection<Tupel<AreaObjectModel, List<Model>>>> tupel = ReviewAreaToursAction.this.reviewAreaTourPane.checkForBrokenOrders();
                final Collection<Tupel<AreaObjectModel, List<Model>>> origOrderBroken = tupel.getElement1();
                final Collection<Tupel<AreaObjectModel, List<Model>>> parcelOrderBroken = tupel.getElement2();
                if (!origOrderBroken.isEmpty() || !parcelOrderBroken.isEmpty()) {
                    AbstractAreaTourCalculationOrderNotPossibleDialog abstractAreaTourCalculationOrderNotPossibleDialog = new AbstractAreaTourCalculationOrderNotPossibleDialog(subDialog, origOrderBroken, parcelOrderBroken){
                        private static final long serialVersionUID = 4317204158686401350L;

                        @Override
                        protected void doOk(Collection<Tupel<AreaObjectModel, List<Model>>> areaObjectsToSkip, Collection<Tupel<AreaObjectModel, List<Model>>> areaObjectsForOptimize, Collection<Tupel<AreaObjectModel, List<Model>>> areaObjectsForOrig, Collection<Tupel<AreaObjectModel, List<Model>>> areaObjectsForParcel) {
                            Collection<Tupel<AreaObjectModel, List<Model>>> areas = ReviewAreaToursAction.this.reviewAreaTourPane.getSelectedAreaObjects(null);
                            ReviewAreaToursAction.this.removeFrom(areas, origOrderBroken);
                            ReviewAreaToursAction.this.removeFrom(areas, parcelOrderBroken);
                            switch (ReviewAreaToursAction.this.reviewAreaTourPane.getSelectedCalculationWay()) {
                                case OPTIMIZE: {
                                    toOptimize.addAll(areas);
                                    break;
                                }
                                case PARCEL_ORDER: {
                                    toOrderParcel.addAll(areas);
                                    break;
                                }
                                case SAVED_ORDER: {
                                    toOrderOrig.addAll(areas);
                                    break;
                                }
                                default: {
                                    throw new RuntimeException();
                                }
                            }
                            toOptimize.addAll(areaObjectsForOptimize);
                            toOrderParcel.addAll(areaObjectsForParcel);
                            toOrderOrig.addAll(areaObjectsForOrig);
                            this.callSuperActionPerformed(e);
                        }
                    };
                    abstractAreaTourCalculationOrderNotPossibleDialog.setVisible(true);
                } else {
                    Collection<Tupel<AreaObjectModel, List<Model>>> areas = ReviewAreaToursAction.this.reviewAreaTourPane.getSelectedAreaObjects(null);
                    switch (ReviewAreaToursAction.this.reviewAreaTourPane.getSelectedCalculationWay()) {
                        case OPTIMIZE: {
                            toOptimize.addAll(areas);
                            break;
                        }
                        case PARCEL_ORDER: {
                            toOrderParcel.addAll(areas);
                            break;
                        }
                        case SAVED_ORDER: {
                            toOrderOrig.addAll(areas);
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    super.actionPerformed(e);
                }
            }

            private void callSuperActionPerformed(ActionEvent e) {
                super.actionPerformed(e);
            }

            @Override
            protected File save(Tupel<Map<String, byte[]>, ErrorMessages> content) throws IOException {
                File lastDir = this.saveSet(content, ReviewAreaToursAction.OPTIMIZE_PREFIX, null, "reviewArea");
                lastDir = this.saveSet(content, ReviewAreaToursAction.ORIG_PREFIX, lastDir, "review_saved");
                lastDir = this.saveSet(content, ReviewAreaToursAction.PARCEL_PREFIX, lastDir, "review_parcel");
                return lastDir;
            }

            private File saveSet(Tupel<Map<String, byte[]>, ErrorMessages> content, String prefix, File lastDir, String fileName) throws IOException {
                Map<String, byte[]> totalMap = content.getElement1();
                HashMap<String, byte[]> filtered = new HashMap<String, byte[]>();
                for (Map.Entry<String, byte[]> entry : totalMap.entrySet()) {
                    String key = entry.getKey();
                    if (!key.startsWith(prefix)) continue;
                    filtered.put(key, entry.getValue());
                }
                if (!filtered.isEmpty()) {
                    String csvFileKey = prefix + "_" + ReviewAreaToursAction.CSV_PREFIX;
                    byte[] bs = (byte[])filtered.get(csvFileKey);
                    lastDir = FileUtil.saveFile(Collections.singletonMap(fileName, bs), this.getParent(), this.getFileExtension(), lastDir);
                    if (filtered.size() > 1) {
                        JFileChooser fileChooser = lastDir == null ? new JFileChooser() : new JFileChooser(lastDir);
                        FileFilter filter = new FileFilter(){

                            @Override
                            public String getDescription() {
                                return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.directory", new Serializable[0]);
                            }

                            @Override
                            public boolean accept(File f) {
                                return f.isDirectory();
                            }
                        };
                        fileChooser.addChoosableFileFilter(filter);
                        fileChooser.setFileFilter(filter);
                        fileChooser.setFileSelectionMode(1);
                        boolean d2 = false;
                        File dir = null;
                        do {
                            int d = fileChooser.showSaveDialog(this.getParent());
                            switch (d) {
                                case 0: {
                                    dir = fileChooser.getSelectedFile();
                                    if (!this.checkForOverwrite(dir, filtered.keySet(), csvFileKey)) break;
                                    d2 = true;
                                    dir = null;
                                }
                            }
                        } while (d2);
                        for (Map.Entry entry : filtered.entrySet()) {
                            String key = (String)entry.getKey();
                            if (key.equals(csvFileKey)) continue;
                            FileUtils.writeByteArrayToFile(new File(dir, key), (byte[])entry.getValue());
                        }
                        lastDir = fileChooser.getSelectedFile();
                    }
                    return lastDir;
                }
                return null;
            }

            private boolean checkForOverwrite(File dir, Collection<String> keySet, String dataFileName) {
                boolean existing = false;
                for (String name : keySet) {
                    if (name.equals(dataFileName) || !new File(dir, name).exists()) continue;
                    existing = true;
                    break;
                }
                if (existing) {
                    int d = JOptionPane.showConfirmDialog(this.getParent(), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question.overwriteFiles", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0);
                    return d != 0;
                }
                return false;
            }

            @Override
            protected Tupel<Map<String, byte[]>, ErrorMessages> getContent(Object o) throws ClientExportException {
                subDialog.dispose();
                DeliveryRoundModel deliveryRoundModel = ReviewAreaToursAction.this.reviewAreaTourPane.getDeliveryRound();
                if (deliveryRoundModel == null) {
                    JOptionPane.showMessageDialog(this.getParent(), ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.error.noDeliveryRoundSelected", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                    return null;
                }
                ErrorMessages errorMessages = new ErrorMessages();
                LinkedHashMap<String, byte[]> content = new LinkedHashMap<String, byte[]>();
                List<TourExportDto> tourExportDtos = Collections.emptyList();
                if (!toOptimize.isEmpty()) {
                    tourExportDtos = this.execute(modelEnviroment, createXmlProp, ReviewAreaToursAction.this.reviewAreaTourPane, deliveryRoundModel, toOptimize, CalculationWay.OPTIMIZE);
                    this.addToResult(errorMessages, content, tourExportDtos, ReviewAreaToursAction.OPTIMIZE_PREFIX);
                }
                if (!toOrderParcel.isEmpty()) {
                    tourExportDtos = this.execute(modelEnviroment, createXmlProp, ReviewAreaToursAction.this.reviewAreaTourPane, deliveryRoundModel, toOrderParcel, CalculationWay.PARCEL_ORDER);
                    this.addToResult(errorMessages, content, tourExportDtos, ReviewAreaToursAction.PARCEL_PREFIX);
                }
                if (!toOrderOrig.isEmpty()) {
                    tourExportDtos = this.execute(modelEnviroment, createXmlProp, ReviewAreaToursAction.this.reviewAreaTourPane, deliveryRoundModel, toOrderOrig, CalculationWay.SAVED_ORDER);
                    this.addToResult(errorMessages, content, tourExportDtos, ReviewAreaToursAction.ORIG_PREFIX);
                }
                modelEnviroment.close();
                return content.isEmpty() ? null : new Tupel(content, errorMessages);
            }

            private void addToResult(ErrorMessages errorMessages, Map<String, byte[]> content, List<TourExportDto> tourExportDtos, String prefix) {
                for (TourExportDto tourExportDto : tourExportDtos) {
                    Map<String, byte[]> sContent;
                    if (tourExportDto == null) continue;
                    ErrorMessages sErrorMessages = tourExportDto.getErrorMessages();
                    if (sErrorMessages != null) {
                        errorMessages.addAllErrorMessages(sErrorMessages);
                    }
                    if ((sContent = tourExportDto.getContent()) == null) continue;
                    for (Map.Entry<String, byte[]> entry : sContent.entrySet()) {
                        String mainKey;
                        String key = mainKey = prefix + "_" + entry.getKey();
                        int index = 1;
                        while (content.containsKey(key)) {
                            key = mainKey + "_" + index;
                            ++index;
                        }
                        content.put(key, entry.getValue());
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private List<TourExportDto> execute(ModelEnviroment modelEnviroment2, final boolean createXmlProp2, final ReviewAreaTourPane reviewAreaTourPane, DeliveryRoundModel deliveryRoundModel, final Collection<Tupel<AreaObjectModel, List<Model>>> areas, final CalculationWay calculationWay) throws ClientExportException {
                String messageKey;
                Collection<BlockDescriptor> blocks = reviewAreaTourPane.getBlockDescriptors();
                boolean poi = reviewAreaTourPane.isPoi();
                OptimizationType routingType = OptimizationType.createOptimizationType(poi, false, false);
                Collection<Tripel<RouteVehicleType, RouteVehicleType, RouteVehicleType>> vehicles = reviewAreaTourPane.getRouteVehicleTypes();
                final HashSet<AreaTourParameter> parameters = new HashSet<AreaTourParameter>();
                ArrayList<TourExportDto> tourExportDtos = new ArrayList<TourExportDto>(vehicles.size());
                for (Tripel<RouteVehicleType, RouteVehicleType, RouteVehicleType> vehicle : vehicles) {
                    Object areaCalculationType = reviewAreaTourPane.getAreaCalculationType();
                    if (calculationWay == CalculationWay.PARCEL_ORDER) {
                        areaCalculationType = AreaCalculationType.PARCEL_SORT_ORDER;
                    }
                    OptimizationAlgorithmType optimizationAlgorithmType = areaCalculationType == AreaCalculationType.SIDE ? OptimizationAlgorithmType.DEFAULT_STREET_SIDE : OptimizationAlgorithmType.DEFAULT_SEGMENT_MIDDLE;
                    ArrayList<AreaTourParameter.BlockDescriptor> blockDescriptorDtos = new ArrayList<AreaTourParameter.BlockDescriptor>(blocks.size());
                    for (BlockDescriptor block : blocks) {
                        blockDescriptorDtos.add(new AreaTourParameter.BlockDescriptor(block.getParcelAttributeValueDescriptorModel().getKey(), block.getValue(), block.getParcelBlockType()));
                    }
                    boolean preferExclusions = reviewAreaTourPane.isPreferExclusions();
                    AreaTourParameter parameter = null;
                    AreaObjectType areaObjectType = DeliveryRoundModelUtil.getAreaObjectTypeForDeliveryRound(deliveryRoundModel);
                    AreaTourType areaTourType = new AreaTourType(areaObjectType, (AreaCalculationType)((Object)areaCalculationType));
                    RouteBackType back = reviewAreaTourPane.getRouteBackType();
                    boolean startPickPoint = reviewAreaTourPane.isStartPickPoint();
                    boolean endPickPoint = reviewAreaTourPane.isEndPickPoint();
                    Date date = reviewAreaTourPane.getDate();
                    Collection<SubscriptionStatus> subscriptionStatus = reviewAreaTourPane.getSubscriptionStatus();
                    Collection<SubscriptionDeliveryType> subscriptionDeliveryTypes = reviewAreaTourPane.getSubscriptionDeliveryTypes();
                    Collection<LetterDeliveryType> letterDeliveryTypes = reviewAreaTourPane.getLetterDeliveryTypes();
                    switch (areaObjectType) {
                        case PARCEL: {
                            parameter = new ParcelParameter(areaTourType, poi, startPickPoint, endPickPoint, back, date);
                            break;
                        }
                        case PARCEL_WITHOUT_SUBSCRIPTION: 
                        case SUBSCRIPTION: 
                        case LETTER: 
                        case PARCEL_WITH_LETTER: 
                        case PARCEL_WITHOUT_SUBSCRIPTION_WITH_LETTER: 
                        case SUBSCRIPTION_WITH_LETTER: 
                        case PARCEL_SUBSCRIPTION: 
                        case PARCEL_SUBSCRIPTION_LETTER: {
                            parameter = new SubscriptionParameter(areaTourType, poi, startPickPoint, endPickPoint, back, date, subscriptionStatus, subscriptionDeliveryTypes, letterDeliveryTypes);
                        }
                    }
                    parameter.setParcelBlock(blockDescriptorDtos);
                    parameter.setPreferExclusion(preferExclusions);
                    parameter.setRouteVehicleTypeInArea(vehicle.getElement1());
                    parameter.setRouteTypeInArea(vehicle.getElement1().getRouteType());
                    parameter.setRouteVehicleTypeFromPoi(vehicle.getElement2());
                    parameter.setRouteTypeFromPoi(vehicle.getElement2().getRouteType());
                    parameter.setRouteVehicleTypeFromPickPoint(vehicle.getElement3());
                    parameter.setRouteTypeFromPickPoint(vehicle.getElement3().getRouteType());
                    parameter.setRoutingType(routingType);
                    parameter.setAlgorithmType(optimizationAlgorithmType);
                    parameter.setRewardEntity(reviewAreaTourPane.getRewardEntity());
                    parameter.setNight(reviewAreaTourPane.getNight());
                    parameter.setDeliveryRoundId(deliveryRoundModel.getId());
                    parameter.setDifficultyLevelDescriptor(reviewAreaTourPane.isWithDifficultyLevel());
                    parameter.setParcelLocationDescriptor(reviewAreaTourPane.isWithParcelLocation());
                    parameters.add(parameter);
                }
                switch (calculationWay) {
                    case OPTIMIZE: {
                        messageKey = "messages.review.origAreaTour";
                        break;
                    }
                    case SAVED_ORDER: {
                        messageKey = "messages.area.tour.review";
                        break;
                    }
                    case PARCEL_ORDER: {
                        messageKey = "messages.area.tour.areaReview";
                        break;
                    }
                    default: {
                        throw new RuntimeException("not supported");
                    }
                }
                if (reviewAreaTourPane.isSelfParameter()) {
                    ArrayList plainAreas = new ArrayList(areas.size());
                    for (Tupel tupel : areas) {
                        plainAreas.add(tupel.getElement1());
                    }
                    Collection<Tupel<AreaObjectModel, List<Model>>> noRounds = AreaObjectModelUtil.checkDeliveryRound(areas, reviewAreaTourPane.getDate());
                    if (!noRounds.isEmpty()) {
                        void var16_23;
                        String string = "";
                        int i = 0;
                        for (Tupel<AreaObjectModel, List<Model>> area : noRounds) {
                            if (i++ > 10) {
                                String string2 = (String)var16_23 + "\n ......";
                                continue;
                            }
                            String string3 = (String)var16_23 + "\n" + AreaObjectModelUtil.getShortcutAndDisplayname(area.getElement1());
                        }
                        int d = JOptionPane.showConfirmDialog(reviewAreaTourPane, ModelEnviroment.getMessageResolver().resolveMessage("gui.area.ignore.noDeliveryRounds", new Serializable[]{Integer.valueOf(noRounds.size()), var16_23}), "", 0);
                        if (d != 0) {
                            return null;
                        }
                        ArrayList<Tupel<AreaObjectModel, List<Model>>> newAreas = new ArrayList<Tupel<AreaObjectModel, List<Model>>>(areas.size() - noRounds.size());
                        noRounds = new HashSet<Tupel<AreaObjectModel, List<Model>>>(noRounds);
                        for (Tupel<AreaObjectModel, List<Model>> area : areas) {
                            if (noRounds.contains(area.getElement1())) continue;
                            newAreas.add(area);
                        }
                        areas.clear();
                        areas.addAll(newAreas);
                    }
                }
                AbstractAsynchronousDialog<TourExportDto> asynchronousDialog = new AbstractAsynchronousDialog<TourExportDto>(this.getParent(), ModelEnviroment.getMessageResolver().resolveMessage(messageKey, new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]), 1, true, modelEnviroment2){
                    private static final long serialVersionUID = -9010756475037313167L;

                    @Override
                    protected AsynchronousDto<TourExportDto> getAsynchronousDto(String token) {
                        AsynchronousCaller asynchronousCaller = this.modelEnviroment.getAllCaller().getAsynchronousCaller();
                        switch (calculationWay) {
                            case OPTIMIZE: 
                            case PARCEL_ORDER: {
                                return asynchronousCaller.getReviewAreaToursResult(token);
                            }
                            case SAVED_ORDER: {
                                return asynchronousCaller.getReviewOrigAreaToursResult(token);
                            }
                        }
                        throw new RuntimeException("not supported");
                    }

                    @Override
                    protected String startAsynchronous() {
                        AsynchronousCaller asynchronousCaller = this.modelEnviroment.getAllCaller().getAsynchronousCaller();
                        TourExportFormat tourExportType = reviewAreaTourPane.getTourExportType();
                        boolean pdf = reviewAreaTourPane.isPdf();
                        switch (calculationWay) {
                            case OPTIMIZE: 
                            case PARCEL_ORDER: {
                                return asynchronousCaller.reviewAreaTours(areas, parameters, tourExportType, pdf, createXmlProp2, reviewAreaTourPane.isSelfParameter());
                            }
                            case SAVED_ORDER: {
                                return asynchronousCaller.reviewOrigAreaTour(areas, parameters, tourExportType, pdf, createXmlProp2, reviewAreaTourPane.isSelfParameter());
                            }
                        }
                        throw new RuntimeException("not supported");
                    }
                };
                try {
                    Tupel tourExportDto = asynchronousDialog.run();
                    tourExportDtos.add((TourExportDto)tourExportDto.getElement1());
                }
                catch (ClientExportException ex) {
                    throw ex;
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                return tourExportDtos;
            }
        }));
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -5138769151459307689L;

            @Override
            public void actionPerformed(ActionEvent e) {
                subDialog.dispose();
            }
        }));
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)this.reviewAreaTourPane, "Center");
        pane.add((Component)buttonPane, "South");
        subDialog.getContentPane().add((Component)pane, "Center");
        subDialog.pack();
        SwingUtils.centerDialog(subDialog, this.parent);
        subDialog.setVisible(true);
        modelEnviroment.close();
    }

    private void removeFrom(Collection<Tupel<AreaObjectModel, List<Model>>> areas, Collection<Tupel<AreaObjectModel, List<Model>>> toRemove) {
        final HashSet<AreaObjectModel> set = new HashSet<AreaObjectModel>();
        for (Tupel<AreaObjectModel, List<Model>> tupel : toRemove) {
            set.add(tupel.getElement1());
        }
        areas.removeIf(new Predicate<Tupel<AreaObjectModel, List<Model>>>(){

            @Override
            public boolean test(Tupel<AreaObjectModel, List<Model>> t) {
                return set.contains(t.getElement1());
            }
        });
    }
}

