/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.action.geosearch;

import de.datomino.peppergis.client.communication.AsynchronousCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.clienttools.action.geosearch.AbstractCsvGeoSearchingAction;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.importer.ParcelImportDto;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.message.MessageResolver;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HousenumberRangeSearchingAction
extends AbstractCsvGeoSearchingAction {
    private static final long serialVersionUID = -2234441481574467651L;

    public HousenumberRangeSearchingAction(Window parent) {
        super(parent, "Abgleich Abschnitt Hausnummer");
    }

    @Override
    protected List<CsvColumnChoiceField> getColumnMapFields() {
        return Arrays.asList(this.countryField, this.postcodeField, this.cityField, this.districtField, this.streetField, this.housenumberField, this.housenumberExtension, this.housenumberToField, this.housenumberToExtField, this.rangeField);
    }

    @Override
    protected boolean showSearchType() {
        return true;
    }

    @Override
    protected boolean showDuplicated() {
        return true;
    }

    @Override
    protected String startAsynchronousSearch(ModelEnviroment modelEnviroment, byte[] content) {
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        ArrayList<String> headerExtension = new ArrayList<String>();
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(ParcelImportDto.Columns.ID));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.COUNTRY));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.POSTCODE));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.CITY));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.DISTRICT));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.STREET));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.HOUSENUMBER));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.HOUSENUMBER_EXTENSION));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.X));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.Y));
        headerExtension.add(PREFIX + messageResolver.resolveMessageForEnum(ParcelImportDto.Columns.MATCHING));
        AsynchronousCaller asynchronousCaller = modelEnviroment.getAllCaller().getAsynchronousCaller();
        GenericCsvDto dto = new GenericCsvDto();
        dto.setColumnMapping(this.getCsvGeocodingMapping());
        dto.setContent(content);
        String value = (String)this.delimiterField.getValue();
        dto.setDelim(value.isEmpty() ? (char)',' : value.charAt(0));
        dto.setEncoding((String)this.encodingField.getValue());
        value = (String)this.textQuoteField.getValue();
        dto.setTextQuote(value.isEmpty() ? (char)'\"' : value.charAt(0));
        return asynchronousCaller.searchParcelRanges(dto, 1, headerExtension, this.getAddressSearchType(), this.isDuplicated(), this.isImportedLocations());
    }

    @Override
    protected boolean showImportedLocations() {
        return false;
    }

    @Override
    protected String getHousenumberTitle() {
        String key = GenericCsvDto.AddressColumns.class.getName().replace('$', '.') + "." + GenericCsvDto.AddressColumns.HOUSENUMBER.name() + "_FROM";
        return messageResolver.resolveMessage(key, new Serializable[0]);
    }

    @Override
    protected String getHousenumberExtensionTitle() {
        String key = GenericCsvDto.AddressColumns.class.getName().replace('$', '.') + "." + GenericCsvDto.AddressColumns.HOUSENUMBER_EXTENSION.name() + "_FROM";
        return messageResolver.resolveMessage(key, new Serializable[0]);
    }
}

