/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.action.geosearch;

import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.message.EnumMessageResolverNameGenerator;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.importer.CsvGeoCodingField;
import de.datomino.peppergis.dto.importer.DefaultCsvResultDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.search.AddressSearchType;
import de.datomino.util.assistant.editor.WizardDialog;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.BooleanField;
import de.datomino.util.assistant.model.ChoiceField;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.CsvColumnManager;
import de.datomino.util.assistant.model.CsvContentGuesser;
import de.datomino.util.assistant.model.Field;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.assistant.model.FileField;
import de.datomino.util.assistant.model.IntegerField;
import de.datomino.util.assistant.model.Page;
import de.datomino.util.assistant.model.StringField;
import de.datomino.util.assistant.model.Wizard;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.message.MessageResolver;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FileUtils;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.NameGenerator;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractCsvGeoSearchingAction
extends AbstractAction {
    private static final long serialVersionUID = 7666759554004622108L;
    protected static String PREFIX = "GCO ";
    protected static MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
    protected CsvColumnChoiceField countryField;
    protected CsvColumnChoiceField postcodeField;
    protected CsvColumnChoiceField cityField;
    protected CsvColumnChoiceField districtField;
    protected CsvColumnChoiceField streetField;
    protected CsvColumnChoiceField housenumberField;
    protected CsvColumnChoiceField housenumberExtension;
    protected CsvColumnChoiceField housenumberToField;
    protected CsvColumnChoiceField housenumberToExtField;
    protected CsvColumnChoiceField rangeField;
    protected CsvColumnChoiceField idField;
    protected CsvColumnChoiceField xField;
    protected CsvColumnChoiceField yField;
    protected Field<CoordinateFactory.Projections> coordinateFactoryField;
    protected IntegerField decimalPlacesField;
    protected FileField fileField = new FileField(messageResolver.resolveMessage("messages.parameter.file", new Serializable[0]), null, (List<? extends FileFilter>)Collections.singletonList(new FileNameExtensionFilter("CSV", "csv", "CSV")));
    protected StringField delimiterField = new StringField(messageResolver.resolveMessage("messages.parameter.delimiter", new Serializable[0]), ";");
    protected StringField textQuoteField = new StringField(messageResolver.resolveMessage("messages.parameter.textquote", new Serializable[0]), "\"");
    protected StringField encodingField = new StringField(messageResolver.resolveMessage("messages.parameter.encoding", new Serializable[0]), "UTF-8");
    protected ChoiceField<AddressSearchType> exactField;
    protected BooleanField duplicatedField = new BooleanField(messageResolver.resolveMessage("messages.parcel.duplicateFilter", new Serializable[0]), false);
    protected BooleanField importedLocationField = new BooleanField(messageResolver.resolveMessage("messages.parcel.search.importedLocations", new Serializable[0]), false, messageResolver.resolveMessage("messages.parcel.search.importedLocations.checkBox", new Serializable[0]));
    private String title;
    private Window parent;

    public AbstractCsvGeoSearchingAction(Window parent, String title) {
        super(title);
        this.title = title;
        this.parent = parent;
        this.countryField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.COUNTRY), (Serializable)((Object)GenericCsvDto.AddressColumns.COUNTRY), "^(?:land|country)$", true);
        this.postcodeField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.POSTCODE), (Serializable)((Object)GenericCsvDto.AddressColumns.POSTCODE), "^(?:postleitzahl|plz|postcode|plz5)$", false);
        this.cityField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.CITY), (Serializable)((Object)GenericCsvDto.AddressColumns.CITY), "^(?:ort|stadt|city|po|ortsname|postort)$", false);
        this.districtField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.DISTRICT), (Serializable)((Object)GenericCsvDto.AddressColumns.DISTRICT), "^(?:stadtteil|ortsteil|pot|ortsteilname|postortsteil|(?:city[ -]?)?district)$", true);
        this.streetField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.STREET), (Serializable)((Object)GenericCsvDto.AddressColumns.STREET), "^(?:Str(a(ss|\u00df)e|\\.?)|street|strassenname|str|str\\.)$", false);
        this.housenumberField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.HOUSENUMBER), (Serializable)((Object)GenericCsvDto.AddressColumns.HOUSENUMBER), CsvColumnChoiceField.createRegex("Hausnummer", "hausnr", "housenumber", "hnr", "haus-nr.", "Hsnr.", "HNR", "Von Haus-Nr.", "Von Hsnr.", "Von HNR"), false);
        this.housenumberExtension = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.HOUSENUMBER_EXTENSION), (Serializable)((Object)GenericCsvDto.AddressColumns.HOUSENUMBER_EXTENSION), CsvColumnChoiceField.createRegex("Hausnummererweiterung", "Hausnummerzusatz", "hausnummern", "zusatz", "Hausnummer erw", "housenumber_ext", "hnr ew", "hnr_ew", "hsnr.-zusatz", "hsnr-.erw.", "hnr ew", "hnr_ew", "Von Hsnr.-Zusatz", "Von Hsnr.-Erw.", "Von HNR EW", "Von HNR_EW"), true);
        this.housenumberToField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.HOUSENUMBER_TO), (Serializable)((Object)GenericCsvDto.AddressColumns.HOUSENUMBER_TO), CsvColumnChoiceField.createRegex("bis hausnummer", "Bis Haus-Nr.", "Bis Hsnr.", "Bis HNR"), false);
        this.housenumberToExtField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.HOUSENUMBER_TO_EXTENSION), (Serializable)((Object)GenericCsvDto.AddressColumns.HOUSENUMBER_TO_EXTENSION), CsvColumnChoiceField.createRegex("hausnummern", "zusatz", "Hausnummer erw", "housenumber_ext", "bis hausnummer", "Bis Hsnr.-Zusatz", "Bis Hsnr.-Erw.", "Bis HNR EW"), true);
        this.rangeField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(CsvGeoCodingField.RANGE_TYPE), (Serializable)((Object)CsvGeoCodingField.RANGE_TYPE), CsvColumnChoiceField.createRegex("Abschnittstyp", "Bereich"), false);
        this.idField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(CsvGeoCodingField.ID), (Serializable)((Object)CsvGeoCodingField.ID), CsvColumnChoiceField.createRegex("id", "Geb\u00e4ude-ID", "Geb\u00e4ude-Nr."), true);
        this.xField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(CsvGeoCodingField.X), (Serializable)((Object)CsvGeoCodingField.X), CsvColumnChoiceField.createRegexForXCoordinate(), true);
        this.yField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(CsvGeoCodingField.Y), (Serializable)((Object)CsvGeoCodingField.Y), CsvColumnChoiceField.createRegexForYCoordinate(), true);
        Collection<CoordinateFactory.Projections> listableProjections = CoordinateFactory.getListableProjections();
        CoordinateFactory.Projections[] values = new CoordinateFactory.Projections[listableProjections.size()];
        values = listableProjections.toArray(values);
        this.coordinateFactoryField = new ChoiceField<CoordinateFactory.Projections>(messageResolver.resolveMessage("messages.default.coordinateFactory", new Serializable[0]), values, new EnumMessageResolverNameGenerator(), values[0]);
        this.decimalPlacesField = new IntegerField(messageResolver.resolveMessage("messages.default.decimalPlaces", new Serializable[0]), 5);
        this.exactField = new ChoiceField<1>(messageResolver.resolveMessage("messages.parcel.addressSearchType", new Serializable[0]), (T[])AddressSearchType.values(), new NameGenerator<AddressSearchType>(){

            @Override
            public String getName(AddressSearchType t) {
                return messageResolver.resolveMessageForEnum(t);
            }
        });
        this.exactField.setValue(AddressSearchType.values()[0]);
    }

    protected String getHousenumberExtensionTitle() {
        return messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.HOUSENUMBER_EXTENSION);
    }

    protected String getHousenumberTitle() {
        return messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.HOUSENUMBER);
    }

    protected Integer getColumn(String columnName, List<String> line) {
        if (columnName == null) {
            return null;
        }
        int counter = 0;
        for (String head : line) {
            if (columnName.equals(head)) {
                return counter;
            }
            ++counter;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BufferedImage image;
        Wizard wizard = this.getWizard();
        try {
            image = ImageIO.read(AbstractCsvGeoSearchingAction.class.getResourceAsStream("/images/pepper.png"));
        }
        catch (IOException ioEx) {
            throw new RuntimeException(ioEx);
        }
        WizardDialog wizardDialog = new WizardDialog(this.parent, wizard, new Worker(){

            @Override
            public void process() {
                Tupel csvResultDto;
                byte[] content;
                File inputFile = (File)AbstractCsvGeoSearchingAction.this.fileField.getValue();
                try {
                    content = FileUtils.readFileToByteArray(inputFile);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                ModelEnviroment modelEnviroment = new ModelEnviroment(AbstractCsvGeoSearchingAction.this.parent);
                AbstractAsynchronousDialog<DefaultCsvResultDto> asynchronousDialog = new AbstractAsynchronousDialog<DefaultCsvResultDto>(AbstractCsvGeoSearchingAction.this.parent, AbstractCsvGeoSearchingAction.this.title, AbstractCsvGeoSearchingAction.this.title, 1, true, modelEnviroment){
                    private static final long serialVersionUID = 7415083880384099000L;

                    @Override
                    protected AsynchronousDto<DefaultCsvResultDto> getAsynchronousDto(String token) {
                        return this.modelEnviroment.getAllCaller().getAsynchronousCaller().getCsvGeoSearchResult(token);
                    }

                    @Override
                    protected String startAsynchronous() {
                        return AbstractCsvGeoSearchingAction.this.startAsynchronousSearch(this.modelEnviroment, content);
                    }
                };
                try {
                    csvResultDto = asynchronousDialog.run();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                if (!csvResultDto.getElement2().booleanValue()) {
                    JFileChooser fileChooser = new JFileChooser();
                    FileNameExtensionFilter fileFilter = new FileNameExtensionFilter("csv", "csv");
                    fileChooser.addChoosableFileFilter(fileFilter);
                    fileChooser.setFileFilter(fileFilter);
                    fileChooser.setMultiSelectionEnabled(false);
                    boolean done = false;
                    do {
                        int d;
                        if ((d = fileChooser.showSaveDialog(AbstractCsvGeoSearchingAction.this.parent)) == 0) {
                            File file = fileChooser.getSelectedFile();
                            d = file.exists() ? JOptionPane.showConfirmDialog(AbstractCsvGeoSearchingAction.this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question.overwriteFile", new Serializable[]{file.getName()}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0) : 0;
                            if (d != 0) continue;
                            try {
                                FileUtils.writeByteArrayToFile(file, ((DefaultCsvResultDto)csvResultDto.getElement1()).getContent());
                                done = true;
                            }
                            catch (Exception e) {
                                JOptionPane.showMessageDialog(AbstractCsvGeoSearchingAction.this.parent, e.getMessage(), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                            }
                            continue;
                        }
                        done = true;
                    } while (!done);
                }
            }

            @Override
            public String getResultString() {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.csvFileCreated", new Serializable[0]);
            }

            @Override
            public Worker.State getResultState() {
                return Worker.State.OK;
            }
        }, image);
        wizardDialog.show();
        wizardDialog.getDialog().dispose();
    }

    private Wizard getWizard() {
        Wizard wizard = new Wizard(this.title);
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        Page file = new Page(messageResolver.resolveMessage("messages.page.file.title", new Serializable[0]));
        Fieldset fileParams = new Fieldset(messageResolver.resolveMessage("messages.parameter.file.title", new Serializable[0]));
        fileParams.addField(this.fileField);
        file.addFieldset(fileParams);
        Fieldset csvParams = new Fieldset(messageResolver.resolveMessage("messages.parameter.csvparams.title", new Serializable[0]));
        csvParams.addField(this.delimiterField);
        csvParams.addField(this.textQuoteField);
        csvParams.addField(this.encodingField);
        CsvContentGuesser contentGuesser = new CsvContentGuesser(this.fileField, this.encodingField, this.delimiterField, this.textQuoteField, messageResolver);
        csvParams.addAction(contentGuesser);
        file.addFieldset(csvParams);
        wizard.addPage(file);
        Page data = new Page(messageResolver.resolveMessage("messages.page.content.title", new Serializable[0]));
        Fieldset columns = new Fieldset(messageResolver.resolveMessage("messages.parameter.column.title", new Serializable[0]));
        data.addFieldset(columns);
        for (CsvColumnChoiceField choiceField : this.getColumnMapFields()) {
            columns.addField(choiceField);
        }
        if (this.showCoordinateFactory()) {
            data.addField(this.coordinateFactoryField);
        }
        if (this.showDuplicated()) {
            data.addField(this.duplicatedField);
        }
        if (this.showSearchType()) {
            data.addField(this.exactField);
        }
        if (this.showImportedLocations()) {
            data.addField(this.importedLocationField);
        }
        file.addLeaveAction(new CsvColumnManager(contentGuesser, this.getColumnMapFields()));
        wizard.addPage(data);
        return wizard;
    }

    protected boolean showCoordinateFactory() {
        return false;
    }

    protected Map<Serializable, String> getCsvGeocodingMapping() {
        HashMap<Serializable, String> map = new HashMap<Serializable, String>();
        map.put((Serializable)((Object)CsvGeoCodingField.COUNTRY), (String)this.countryField.getValue());
        map.put((Serializable)((Object)CsvGeoCodingField.CITY), (String)this.cityField.getValue());
        map.put((Serializable)((Object)CsvGeoCodingField.DISTRICT), (String)this.districtField.getValue());
        map.put((Serializable)((Object)CsvGeoCodingField.HOUSENUMBER), (String)this.housenumberField.getValue());
        map.put((Serializable)((Object)CsvGeoCodingField.HOUSENUMBER_EXTENSION), (String)this.housenumberExtension.getValue());
        map.put((Serializable)((Object)CsvGeoCodingField.HOUSENUMBER_TO), (String)this.housenumberToField.getValue());
        map.put((Serializable)((Object)CsvGeoCodingField.HOUSENUMBER_EXTENSION_TO), (String)this.housenumberToExtField.getValue());
        map.put((Serializable)((Object)CsvGeoCodingField.POSTCODE), (String)this.postcodeField.getValue());
        map.put((Serializable)((Object)CsvGeoCodingField.RANGE_TYPE), (String)this.rangeField.getValue());
        map.put((Serializable)((Object)CsvGeoCodingField.STREET), (String)this.streetField.getValue());
        map.put((Serializable)((Object)CsvGeoCodingField.ID), (String)this.idField.getValue());
        map.put((Serializable)((Object)CsvGeoCodingField.X), (String)this.xField.getValue());
        map.put((Serializable)((Object)CsvGeoCodingField.Y), (String)this.yField.getValue());
        return map;
    }

    protected abstract List<CsvColumnChoiceField> getColumnMapFields();

    protected abstract boolean showSearchType();

    protected abstract boolean showImportedLocations();

    protected abstract boolean showDuplicated();

    protected abstract String startAsynchronousSearch(ModelEnviroment var1, byte[] var2);

    protected AddressSearchType getAddressSearchType() {
        return (AddressSearchType)((Object)this.exactField.getValue());
    }

    protected boolean isDuplicated() {
        return PrimitiveUtil.nullToFalse((Boolean)this.duplicatedField.getValue());
    }

    protected boolean isImportedLocations() {
        return PrimitiveUtil.nullToFalse((Boolean)this.importedLocationField.getValue());
    }
}

