/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.action;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.action.AbstractAreaAction;
import de.datomino.peppergis.client.geometric.GeoClientHelper;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.util.swing.blocking.BusyDialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingSegmentEvaluationAction
extends AbstractAreaAction {
    private static final long serialVersionUID = -8592042691893746041L;
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutingSegmentEvaluationAction.class);
    private int sum;
    private JCheckBox parcelWithoutArea;
    private JCheckBox clearSegments;
    private GeoClientHelper geoClientHelper;

    public RoutingSegmentEvaluationAction(Window parent) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("gui.action.segmentEvaluation", new Serializable[0]), parent, true);
        this.geoClientHelper = new GeoClientHelper(this.modelEnviroment);
    }

    @Override
    protected JComponent createOptionPane() {
        this.parcelWithoutArea = new JCheckBox("Geb\u00e4ude ohne Gebietszugeh\u00f6rigkeit");
        this.clearSegments = new JCheckBox("Leeren der vorhandenen Stra\u00dfenanbindungen");
        JPanel optionPane = new JPanel(new FlowLayout());
        optionPane.add(this.parcelWithoutArea);
        optionPane.add(this.clearSegments);
        return optionPane;
    }

    @Override
    protected void process(Collection<AreaObjectModel> areas, BusyDialog busyDialog) {
        this.sum = 0;
        int index = 0;
        UndoManager undoManager = this.modelEnviroment.getUndoManager();
        for (AreaObjectModel area : areas) {
            undoManager.startTransaction();
            busyDialog.setMessage(AreaObjectModelUtil.getShortcutAndDisplayname(area) + " - " + index++ + " / " + areas.size(), (int)((double)index * 100.0 / (double)areas.size()));
            this.sum += this.mapping(area);
            undoManager.finishTransaction("");
            try {
                undoManager.storeTransactions();
            }
            catch (Exception e) {
                LOGGER.info(e.getMessage());
                undoManager.rollbackTransaction();
            }
        }
        if (this.parcelWithoutArea.isSelected()) {
            undoManager.startTransaction();
            Collection<ParcelModel> parcels = this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchParcelsWithoutAreaObject();
            int counter = 0;
            busyDialog.setMessage("Geb\u00e4ude ohne Gebietszugeh\u00f6rigkeit - " + counter + " / " + parcels.size(), (int)((double)index * 100.0 / (double)parcels.size()));
            for (ParcelModel parcel : parcels) {
                if (this.clearSegments.isSelected()) {
                    parcel.setFootSegment(null);
                    parcel.setMotorSegment(null);
                    parcel.setBikeSegment(null);
                }
                this.geoClientHelper.getAccessGeomForParcel(parcel, RouteVehicleType.FOOT);
                this.geoClientHelper.getAccessGeomForParcel(parcel, RouteVehicleType.MOTORCAR);
                this.geoClientHelper.getAccessGeomForParcel(parcel, RouteVehicleType.BIKE);
                parcel.setManualFootSegmentUpdate(false);
                parcel.setManualMotorSegmentUpdate(false);
                parcel.setManualBikeSegmentUpdate(false);
                if (++counter % 1000 != 0) continue;
                busyDialog.setMessage("Geb\u00e4ude ohne Gebietszugeh\u00f6rigkeit - " + counter + " / " + parcels.size(), (int)((double)index * 100.0 / (double)parcels.size()));
                this.geoClientHelper.clearSegmentBucket();
                undoManager.finishTransaction("");
                try {
                    undoManager.storeTransactions();
                }
                catch (Exception e) {
                    LOGGER.info(e.getMessage());
                    undoManager.rollbackTransaction();
                }
                undoManager.startTransaction();
            }
            this.sum += parcels.size();
        }
        this.modelEnviroment.close();
    }

    @Override
    protected String getWarn(int size) {
        return "Wollen Sie alle Strassenanbindungen in " + size + " Gebieten neu berechen?";
    }

    @Override
    protected String getResult() {
        return this.sum + " Geb\u00e4ude/Abonnenten wurde zugeordnet";
    }

    private int mapping(AreaObjectModel area) {
        int counter = 0;
        for (AreaObjectParcelRelModel rel : area.iterableAreaObjectParcelRel()) {
            ParcelModel parcel = rel.getParcel();
            if (this.clearSegments.isSelected()) {
                parcel.setFootSegment(null);
                parcel.setMotorSegment(null);
                parcel.setBikeSegment(null);
            }
            this.geoClientHelper.getAccessGeomForParcel(parcel, RouteVehicleType.FOOT);
            this.geoClientHelper.getAccessGeomForParcel(parcel, RouteVehicleType.MOTORCAR);
            this.geoClientHelper.getAccessGeomForParcel(parcel, RouteVehicleType.BIKE);
            parcel.setManualFootSegmentUpdate(false);
            parcel.setManualMotorSegmentUpdate(false);
            parcel.setManualBikeSegmentUpdate(false);
            ++counter;
        }
        List<SubscriptionModel> subscriptions = this.modelEnviroment.getAllCaller().getTourCaller().fetchSubscriptionsByAreaObject(area, null);
        for (SubscriptionModel subscription : subscriptions) {
            LocationModel location = subscription.getLocation();
            if (this.clearSegments.isSelected()) {
                location.setFootSegment(null);
                location.setMotorSegment(null);
                location.setBikeSegment(null);
            }
            this.geoClientHelper.getAccessGeomForLocation(location, RouteVehicleType.FOOT);
            this.geoClientHelper.getAccessGeomForLocation(location, RouteVehicleType.MOTORCAR);
            this.geoClientHelper.getAccessGeomForLocation(location, RouteVehicleType.BIKE);
            ++counter;
        }
        return counter;
    }
}

