/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.action;

import de.datomino.peppergis.client.action.AbstractAreaAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.util.swing.blocking.BusyDialog;
import java.awt.Window;
import java.io.Serializable;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParcelAreaMappingAction
extends AbstractAreaAction {
    private static final long serialVersionUID = -2428280738827033921L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ParcelAreaMappingAction.class);
    private int sum;

    public ParcelAreaMappingAction(Window parent) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("gui.action.parcelAreaMapping", new Serializable[0]), parent, true);
    }

    @Override
    protected void process(Collection<AreaObjectModel> areas, BusyDialog busyDialog) {
        this.sum = 0;
        int index = 0;
        UndoManager undoManager = this.modelEnviroment.getUndoManager();
        for (AreaObjectModel area : areas) {
            undoManager.startTransaction();
            busyDialog.setMessage(index++ + " / " + areas.size(), (int)((double)index * 100.0 / (double)areas.size()));
            this.sum += AreaObjectModelUtil.mappingParcelsToArea(area, this.modelEnviroment);
            undoManager.finishTransaction("");
            try {
                undoManager.storeTransactions();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
                undoManager.rollbackTransaction();
            }
        }
    }

    @Override
    protected String getWarn(int size) {
        return "Wollen Sie alle Geb\u00e4ube in " + size + " Gebieten neu zuordnen?";
    }

    @Override
    protected String getResult() {
        return this.sum + " Geb\u00e4ude wurde zugeordnet";
    }
}

