/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.action;

import de.datomino.peppergis.client.action.AbstractAreaAction;
import de.datomino.peppergis.client.export.AbstractExportFileAction;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.exporter.TourExportDto;
import de.datomino.peppergis.dto.exporter.TourExportFormat;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.type.areatourtype.AreaCalculationType;
import de.datomino.peppergis.type.areatourtype.AreaObjectType;
import de.datomino.peppergis.type.areatourtype.AreaTourType;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.blocking.BusyDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.NumberFormatter;
import org.ktde.util.datatypes.Tupel;

public class FindAloneInAreaAction
extends AbstractAreaAction {
    private static final long serialVersionUID = -4430288057211396890L;

    public FindAloneInAreaAction(String titel, Window parent) {
        super(titel, parent, false);
    }

    @Override
    protected void process(final Collection<AreaObjectModel> areas, BusyDialog busyDialog) {
        final JDialog subDialog = new JDialog(this.dialog);
        try {
            subDialog.setIconImage(ImageIO.read(FindAloneInAreaAction.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Box centerBox = Box.createVerticalBox();
        JPanel typePane = new JPanel(new FlowLayout());
        final JCheckBox parcelType = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]));
        typePane.add(parcelType);
        final JCheckBox parcelWithoutSubType = new JCheckBox("Geb\u00e4ude ohne Abo");
        typePane.add(parcelWithoutSubType);
        final JCheckBox subscriptionlType = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]));
        typePane.add(subscriptionlType);
        centerBox.add(typePane);
        JPanel settingPane = new JPanel(new GridLayout(2, 2));
        settingPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        settingPane.add(new JLabel("Min. Entfernung (Meter)"));
        NumberFormatter formatterDistance = new NumberFormatter();
        formatterDistance.setMinimum(Integer.valueOf(1));
        final JFormattedTextField maxDistance = new JFormattedTextField(formatterDistance);
        maxDistance.setValue(500);
        settingPane.add(maxDistance);
        settingPane.add(new JLabel("Max. Anzahl"));
        NumberFormatter formatterPoints = new NumberFormatter();
        formatterPoints.setMinimum(Integer.valueOf(1));
        final JFormattedTextField maxPoints = new JFormattedTextField(formatterPoints);
        maxPoints.setValue(1);
        settingPane.add(maxPoints);
        centerBox.add(settingPane);
        JPanel reviewTypePane = new JPanel(new FlowLayout());
        final EnumComboBox tourExportTypeComboBox = new EnumComboBox(TourExportFormat.class, false, (Enum[])new TourExportFormat[]{TourExportFormat.CSV});
        reviewTypePane.add(tourExportTypeComboBox);
        JPanel buttonPane = new JPanel(new FlowLayout());
        buttonPane.add(new JButton(new AbstractExportFileAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0]), this.parent, "csv"){
            private static final long serialVersionUID = 8402693600289836342L;

            protected Tupel<Map<String, byte[]>, ErrorMessages> getContent(Object o) throws ClientExportException {
                final HashSet<AreaTourType> allowedAreaTourTypes = new HashSet<AreaTourType>();
                if (parcelType.isSelected()) {
                    allowedAreaTourTypes.add(new AreaTourType(AreaObjectType.PARCEL, AreaCalculationType.DEFAULT));
                }
                if (parcelWithoutSubType.isSelected()) {
                    allowedAreaTourTypes.add(new AreaTourType(AreaObjectType.PARCEL_WITHOUT_SUBSCRIPTION, AreaCalculationType.DEFAULT));
                }
                if (subscriptionlType.isSelected()) {
                    allowedAreaTourTypes.add(new AreaTourType(AreaObjectType.SUBSCRIPTION, AreaCalculationType.DEFAULT));
                }
                subDialog.dispose();
                LinkedList tourExportDtos = new LinkedList();
                AbstractAsynchronousDialog<TourExportDto> asynchronousDialog = new AbstractAsynchronousDialog<TourExportDto>(this.getParent(), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.tour.findDistance", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]), 0, FindAloneInAreaAction.this.modelEnviroment){
                    private static final long serialVersionUID = -9010756475037313167L;

                    @Override
                    protected AsynchronousDto<TourExportDto> getAsynchronousDto(String token) {
                        return FindAloneInAreaAction.this.modelEnviroment.getAllCaller().getAsynchronousCaller().getFindAloneInAreaResult(token);
                    }

                    @Override
                    protected String startAsynchronous() {
                        return FindAloneInAreaAction.this.modelEnviroment.getAllCaller().getAsynchronousCaller().findAloneInArea(areas, allowedAreaTourTypes, (TourExportFormat)((Object)tourExportTypeComboBox.getSelectedValue()), null, (Integer)maxDistance.getValue(), (Integer)maxPoints.getValue(), false);
                    }
                };
                try {
                    Tupel tourExportDto = asynchronousDialog.run();
                    tourExportDtos.add(tourExportDto.getElement1());
                }
                catch (Exception ex) {
                    if (ex instanceof ClientExportException) {
                        throw (ClientExportException)ex;
                    }
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
                FindAloneInAreaAction.this.modelEnviroment.close();
                return new Tupel<Map<String, byte[]>, ErrorMessages>(((TourExportDto)tourExportDtos.get(0)).getContent(), ((TourExportDto)tourExportDtos.get(0)).getErrorMessages());
            }
        }));
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -5138769151459307689L;

            @Override
            public void actionPerformed(ActionEvent e) {
                subDialog.dispose();
            }
        }));
        JPanel pane = new JPanel(new BorderLayout());
        pane.add((Component)centerBox, "Center");
        pane.add((Component)buttonPane, "South");
        subDialog.getContentPane().add((Component)pane, "Center");
        subDialog.pack();
        SwingUtils.centerDialog(subDialog, this.dialog);
        subDialog.setVisible(true);
        this.modelEnviroment.close();
    }

    @Override
    protected String getWarn(int size) {
        return "Wollen Sie die Suche in allen Gebieten " + size + " durchf\u00fchren?";
    }

    @Override
    protected String getResult() {
        return "Die Liste wurden gespeichert.";
    }
}

