/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.clienttools.action;

import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.swing.SpringUtilities;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class DeleteEmptyAreaAction
extends AbstractAction {
    private static final long serialVersionUID = 6875069936420890191L;
    private Window parent;

    public DeleteEmptyAreaAction(Window parent) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("gui.action.deleteEmptyAreas", new Serializable[0]));
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ModelEnviroment modelEnviroment = new ModelEnviroment(this.parent);
        AreaLayerComboBox areaLayerComboBox = new AreaLayerComboBox(modelEnviroment, false, new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND});
        JPanel panel1 = new JPanel(new SpringLayout());
        panel1.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.chooseAreaLayer", new Serializable[0])));
        panel1.add(areaLayerComboBox);
        SpringUtilities.makeCompactGrid(panel1, 2, 1, 5, 5, 5, 5);
        int d = JOptionPane.showConfirmDialog(this.parent, panel1, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
        if (d == 0) {
            AreaLayerModel layer = (AreaLayerModel)areaLayerComboBox.getSelectedItem();
            Collection<AreaObjectModel> areas = modelEnviroment.getAllCaller().getAreaCaller().fetchAllAreasWithoutParcelsAndSubscriptions(Collections.singleton(layer));
            AreaTableModel model = new AreaTableModel();
            model.setAreas(new ArrayList<AreaObjectModel>(areas));
            JTable table = new JTable(model);
            table.getTableHeader().setReorderingAllowed(false);
            table.getColumnModel().getColumn(0).setPreferredWidth(10);
            JPanel panel2 = new JPanel(new SpringLayout());
            panel2.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.chooseAreaOnMap", new Serializable[0])));
            panel2.add(new JScrollPane(table));
            SpringUtilities.makeCompactGrid(panel2, 2, 1, 5, 5, 5, 5);
            d = JOptionPane.showConfirmDialog(this.parent, panel2, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
            if (d == 0) {
                Collection<AreaObjectModel> selected = model.getSelectedAreas();
                modelEnviroment.getAllCaller().getAreaCaller().deleteAreaObjects(selected);
            }
        }
        modelEnviroment.close();
    }

    private class AreaTableModel
    implements TableModel {
        private List<AreaObjectModel> areas;
        private boolean[] checked = new boolean[0];
        private List<TableModelListener> listeners = new LinkedList<TableModelListener>();

        private AreaTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.areas == null ? 0 : this.areas.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.area.shortcut", new Serializable[0]);
                }
                case 2: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.area.displayName", new Serializable[0]);
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.checked[rowIndex];
                }
                case 1: {
                    return this.areas.get(rowIndex).getShortcut();
                }
                case 2: {
                    return this.areas.get(rowIndex).getDisplayname();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                this.checked[rowIndex] = (Boolean)aValue;
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        protected void fireTableModelChanged(TableModelEvent e) {
            for (TableModelListener listener : this.listeners) {
                listener.tableChanged(e);
            }
        }

        public void setAreas(List<AreaObjectModel> areas) {
            this.areas = areas;
            this.checked = new boolean[this.areas == null ? 0 : this.areas.size()];
            Arrays.fill(this.checked, true);
            this.fireTableModelChanged(new TableModelEvent(this));
        }

        public Collection<AreaObjectModel> getSelectedAreas() {
            if (this.areas == null) {
                return Collections.emptyList();
            }
            ArrayList<AreaObjectModel> selected = new ArrayList<AreaObjectModel>(this.areas.size());
            int i = 0;
            for (AreaObjectModel area : this.areas) {
                if (this.checked[i]) {
                    selected.add(area);
                }
                ++i;
            }
            return selected;
        }
    }
}

