/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.wage.track;

import com.google.common.collect.Multimap;
import de.datomino.peppergis.client.gui.DefaultPointRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.model.wage.TrackWatchDataModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.wage.track.TrackWatchTourTrackingDialog;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.swing.AbstractEnhancedMouseManipulatorAction;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.imageio.ImageIO;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.MouseButton;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.swing.navigator.listener.NavigatorRendererActivateEvent;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackWatchTrackingsRenderer
extends AbstractEnhancedMouseManipulatorAction
implements NavigatorRenderer {
    private static final long serialVersionUID = 7219028705863898278L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackWatchTrackingsRenderer.class);
    private Multimap<Integer, TrackWatchDataModel> allPoints;
    private HashSet<ImmutablePoint> pausePoints;
    Collection<Tupel<Integer, List<ImmutablePoint>>> extraPauseTimePointsList;
    private NavigatorPanel navigatorPanel;
    private List<NavigatorRendererActiveListener> navigatorRendererActiveListeners;
    private boolean active = true;
    private boolean extraPauseTimeSignActive = true;
    private static final int RED = 1;
    private static final int GREEN = 2;
    private static final int BLACK = 3;
    private static final double R_FOR_START_STOP = 4.0;
    private static final double R_FOR_TRACK_POINT = 2.0;
    private static final int DEFAULT_POINT_SIZE = 15;
    public static final int DEFAULT_FONT_SIZE = 7;
    public static final int DEFAULT_FONT_STYLE = 0;
    public static final String DEFAULT_FONT_NAME = "Courier";
    public static final int DEFAULT_FONT_PADDING = 0;
    private final int ARROW_SIZE = 4;
    private TrackWatchDataModel hover = null;
    private boolean refreshRequired;
    private int sortOrder = Integer.MAX_VALUE;

    public TrackWatchTrackingsRenderer(NavigatorPanel navigatorPanel, Multimap<Integer, TrackWatchDataModel> allPoints) {
        super(navigatorPanel, (Double)Double.MAX_VALUE, "Track Map");
        this.navigatorPanel = navigatorPanel;
        this.allPoints = allPoints;
        this.pausePoints = new HashSet();
        this.extraPauseTimePointsList = this.getExtraPauseTimeTrackPointsList();
    }

    @Override
    public Collection<OnTopRendering> paintOnto(final Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, final double upp) {
        if (this.isActive() && !this.allPoints.isEmpty()) {
            ArrayList<TrackWatchDataModel> tracksList = null;
            ArrayList<TrackWatchDataModel> previousTracksList = null;
            boolean initial = true;
            for (int period : this.allPoints.keySet()) {
                tracksList = new ArrayList<TrackWatchDataModel>(this.allPoints.get(period));
                if (!initial) {
                    this.drawPauseLine(previousTracksList, tracksList, g2d);
                }
                previousTracksList = tracksList;
                ListIterator iterator = tracksList.listIterator();
                iterator.next();
                while (iterator.hasNext()) {
                    TrackWatchDataModel trackData1 = (TrackWatchDataModel)iterator.previous();
                    ImmutablePoint immutablePoint1 = trackData1.getGeoTrack();
                    Point2D.Double point1 = new Point2D.Double(immutablePoint1.getX(), immutablePoint1.getY());
                    double sX = point1.getX();
                    double sY = point1.getY();
                    if (iterator.previousIndex() == -1) {
                        this.drawCircle(g2d, 3, immutablePoint1.getCoordinate(), 2.0);
                    }
                    iterator.next();
                    TrackWatchDataModel trackData2 = (TrackWatchDataModel)iterator.next();
                    ImmutablePoint immutablePoint2 = trackData2.getGeoTrack();
                    Point2D.Double point2 = new Point2D.Double(immutablePoint2.getX(), immutablePoint2.getY());
                    double eX = point2.getX();
                    double eY = point2.getY();
                    g2d.setColor(Color.BLACK);
                    Path2D.Double path = new Path2D.Double();
                    path.moveTo(sX, sY);
                    path.lineTo(eX, eY);
                    g2d.draw(path);
                    this.drawArrow(g2d, sX, sY, eX, eY);
                    if (this.pausePoints.contains(immutablePoint2)) continue;
                    this.drawCircle(g2d, 3, immutablePoint2.getCoordinate(), 2.0);
                }
                if (initial) {
                    this.drawCircle(g2d, 1, ((TrackWatchDataModel)tracksList.get(0)).getGeoTrack().getCoordinate(), 4.0);
                }
                initial = false;
            }
            this.drawCircle(g2d, 2, ((TrackWatchDataModel)tracksList.get(tracksList.size() - 1)).getGeoTrack().getCoordinate(), 4.0);
            if (this.isExtraPauseTimeSignActive()) {
                this.drawAllExtraPauseTimeSigns(g2d, upp);
            }
        }
        if (this.isActive() && this.hover != null) {
            OnTopRendering onTopRendering = new OnTopRendering(){

                @Override
                public void paint() {
                    Rectangle2D.Double rectangleOfBox = new Rectangle2D.Double();
                    double left = TrackWatchTrackingsRenderer.this.hover.getGeoTrack().getX();
                    double top = TrackWatchTrackingsRenderer.this.hover.getGeoTrack().getY();
                    rectangleOfBox.height = upp * 17.0;
                    rectangleOfBox.width = upp * 65.0;
                    rectangleOfBox.x = left;
                    rectangleOfBox.y = top - rectangleOfBox.height;
                    g2d.setColor(Color.WHITE);
                    g2d.fill(rectangleOfBox);
                    g2d.setColor(Color.BLACK);
                    BasicStroke stroke = new BasicStroke((float)upp);
                    g2d.setStroke(stroke);
                    g2d.draw(rectangleOfBox);
                    TrackWatchTrackingsRenderer.this.drawInfoText(g2d, upp, left, top);
                }
            };
            ArrayList<OnTopRendering> aOnTops = new ArrayList<OnTopRendering>(1);
            aOnTops.add(onTopRendering);
            return aOnTops;
        }
        return Collections.emptyList();
    }

    private Collection<Tupel<Integer, List<ImmutablePoint>>> getExtraPauseTimeTrackPointsList() {
        HistoryAreaTourModel historyAreaTour;
        WageParameterModel parameter;
        ArrayList<Tupel<Integer, List<ImmutablePoint>>> result = new ArrayList<Tupel<Integer, List<ImmutablePoint>>>();
        if (!this.allPoints.isEmpty() && (parameter = (historyAreaTour = this.allPoints.values().iterator().next().getHistoryAreaTour()).getParameter()) != null && parameter.getTrackPointCount() != null && parameter.getTrackPauseDistanceInMeter() != null) {
            int trackPointsCount = parameter.getTrackPointCount();
            int distance = parameter.getTrackPauseDistanceInMeter();
            if (trackPointsCount > 1 && distance > -1) {
                int sequence = 0;
                for (Integer period : this.allPoints.keySet()) {
                    ArrayList<TrackWatchDataModel> listTrackings = new ArrayList<TrackWatchDataModel>(this.allPoints.get(period));
                    while (!listTrackings.isEmpty()) {
                        int i;
                        ListIterator tracks = listTrackings.listIterator();
                        int distanceBetweenPoints = 0;
                        HashSet<ImmutablePoint> trackPausePoints = new HashSet<ImmutablePoint>();
                        tracks.next();
                        boolean breakFlag = false;
                        for (i = 0; i < trackPointsCount - 1; ++i) {
                            if (tracks.hasNext()) {
                                TrackWatchDataModel track1 = (TrackWatchDataModel)tracks.previous();
                                tracks.next();
                                TrackWatchDataModel track2 = (TrackWatchDataModel)tracks.next();
                                if (track1.getGeoTrack() == null || track2.getGeoTrack() == null) continue;
                                if ((distanceBetweenPoints = (int)((double)distanceBetweenPoints + GeoUtils.getDistanceInMeter(track1.getGeoTrack(), track2.getGeoTrack()))) > distance) {
                                    listTrackings.remove(0);
                                    break;
                                }
                                trackPausePoints.add(track1.getGeoTrack());
                                trackPausePoints.add(track2.getGeoTrack());
                                continue;
                            }
                            breakFlag = true;
                            for (int j = 0; j <= i; ++j) {
                                if (listTrackings.isEmpty()) continue;
                                listTrackings.remove(0);
                            }
                            break;
                        }
                        if (distanceBetweenPoints > distance || breakFlag) continue;
                        ArrayList arrayPoints = new ArrayList(trackPausePoints);
                        result.add(new Tupel(sequence++, arrayPoints));
                        this.pausePoints.addAll(arrayPoints);
                        for (int j = 0; j < i; ++j) {
                            if (listTrackings.isEmpty()) continue;
                            listTrackings.remove(0);
                        }
                    }
                }
            }
        }
        return result;
    }

    private void drawAllExtraPauseTimeSigns(Graphics2D g2d, double upp) {
        String breakSymbol = ModelEnviroment.getProperties().getProperty("breakSymbol");
        BufferedImage breakSymbolImage = null;
        try {
            breakSymbolImage = ImageIO.read(TrackWatchTourTrackingDialog.class.getResourceAsStream(breakSymbol));
            for (Tupel<Integer, List<ImmutablePoint>> pauseTimeTupel : this.extraPauseTimePointsList) {
                List<ImmutablePoint> points = pauseTimeTupel.getElement2();
                ImmutablePoint averagePoint = GeoUtils.getAveragePointOfGivenPoints(points);
                if (breakSymbolImage == null) continue;
                AffineTransform transform = g2d.getTransform();
                double scaleX = transform.getScaleX();
                double scaleY = transform.getScaleY();
                g2d.scale(1.0 / scaleX, 1.0 / scaleY);
                int width = ((Image)breakSymbolImage).getWidth(null) / 2;
                int height = ((Image)breakSymbolImage).getHeight(null) / 2;
                double x = averagePoint.getX() * scaleX;
                double y = averagePoint.getY() * scaleY;
                g2d.drawImage((Image)breakSymbolImage, (int)Math.round(x - (double)width), (int)Math.round(y - (double)height), null);
                g2d.setTransform(transform);
            }
        }
        catch (Exception e) {
            LOGGER.error("break symbol not found: " + breakSymbol);
        }
    }

    private void drawArrow(Graphics2D g, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = Math.atan2(dy, dx);
        int len = (int)Math.sqrt(dx * dx + dy * dy) / 2;
        AffineTransform affineTransform = g.getTransform();
        AffineTransform at = AffineTransform.getTranslateInstance(x1, y1);
        at.concatenate(AffineTransform.getRotateInstance(angle));
        g.transform(at);
        g.drawLine(0, 0, len, 0);
        g.fillPolygon(new int[]{len, len - 4, len - 4, len}, new int[]{0, -4, 4, 0}, 4);
        g.setTransform(affineTransform);
    }

    private void drawInfoText(Graphics2D g2d, double upp, double left, double top) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        double marginTop = 15.0;
        String info = sdf.format(this.hover.getTrackTime());
        Point2D.Double topLeftPixel = this.navigatorPanel.getPixel(new Point2D.Double(left, top));
        Point2D.Double real = this.navigatorPanel.getReal(topLeftPixel.getX() + 5.0, topLeftPixel.getY() + marginTop);
        Coordinate c = this.navigatorPanel.getCoordinateFactory().createCoordinate(real.getX(), real.getY());
        AffineTransform affineTransform = g2d.getTransform();
        double scaleX = affineTransform.getScaleX() / 1.5;
        double scaleY = affineTransform.getScaleY() / 1.5;
        AffineTransform tranformForText = AffineTransform.getScaleInstance(1.0 / scaleX, 1.0 / scaleY);
        g2d.transform(tranformForText);
        double textX = c.getX() + upp;
        double textY = c.getY();
        Point2D.Double point = new Point2D.Double(textX, textY);
        Point2D.Double dst = new Point2D.Double();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform.getScaleInstance(scaleX, scaleY).transform(point, dst);
        Font font = new Font(DEFAULT_FONT_NAME, 0, 7);
        TextLayout textLayout = new TextLayout(info, font, g2d.getFontRenderContext());
        g2d.setColor(Color.BLACK);
        textLayout.draw(g2d, (float)(dst.getX() + 0.0 - 1.0), (float)(dst.getY() + 0.0 - 1.0));
        g2d.setTransform(affineTransform);
    }

    private void drawPauseLine(List<TrackWatchDataModel> previousTracksList, List<TrackWatchDataModel> nextTracksList, Graphics2D g2d) {
        TrackWatchDataModel trackData1 = previousTracksList.get(previousTracksList.size() - 1);
        ImmutablePoint immutablePoint1 = trackData1.getGeoTrack();
        Point2D.Double point1 = new Point2D.Double(immutablePoint1.getX(), immutablePoint1.getY());
        double sX = point1.getX();
        double sY = point1.getY();
        TrackWatchDataModel trackData2 = nextTracksList.get(0);
        ImmutablePoint immutablePoint2 = trackData2.getGeoTrack();
        Point2D.Double point2 = new Point2D.Double(immutablePoint2.getX(), immutablePoint2.getY());
        double eX = point2.getX();
        double eY = point2.getY();
        g2d.setColor(Color.YELLOW);
        Path2D.Double path = new Path2D.Double();
        path.moveTo(sX, sY);
        path.lineTo(eX, eY);
        g2d.draw(path);
        this.drawArrow(g2d, sX, sY, eX, eY);
    }

    private void drawCircle(Graphics2D g2d, int color, Coordinate c, double r) {
        if (color == 1) {
            g2d.setColor(Color.RED);
        } else if (color == 2) {
            g2d.setColor(Color.GREEN);
        } else if (color == 3) {
            g2d.setColor(Color.BLACK);
        }
        Ellipse2D.Double circle = new Ellipse2D.Double();
        circle.x = c.getX() - r;
        circle.y = c.getY() - r;
        circle.width = 2.0 * r;
        circle.height = 2.0 * r;
        g2d.fill(circle);
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public boolean isExtraPauseTimeSignActive() {
        return this.extraPauseTimeSignActive;
    }

    public void setExtraPauseTimeSignActive(boolean extraPauseTimeSignActive) {
        this.extraPauseTimeSignActive = extraPauseTimeSignActive;
        this.getNavigatorPanel().repaint(1L);
    }

    @Override
    public void turnedOn() {
        this.setActive(true);
        this.fireNavigatorRendererActivateEvent(new NavigatorRendererActivateEvent(this, true));
        this.getNavigatorPanel().repaint(1L);
    }

    @Override
    public void turnedOff() {
        this.setActive(false);
        this.fireNavigatorRendererActivateEvent(new NavigatorRendererActivateEvent(this, false));
        this.getNavigatorPanel().repaint(1L);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        if (this.navigatorRendererActiveListeners == null) {
            this.navigatorRendererActiveListeners = new LinkedList<NavigatorRendererActiveListener>();
        }
        this.navigatorRendererActiveListeners.add(navigatorPanelActiveListener);
    }

    @Override
    public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        if (this.navigatorRendererActiveListeners == null) {
            this.navigatorRendererActiveListeners = new LinkedList<NavigatorRendererActiveListener>();
        }
        this.navigatorRendererActiveListeners.remove(navigatorPanelActiveListener);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void close() {
    }

    public Multimap<Integer, TrackWatchDataModel> getAllPoints() {
        return this.allPoints;
    }

    public void setAllPoints(Multimap<Integer, TrackWatchDataModel> allPoints) {
        this.allPoints = allPoints;
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        this.navigatorPanel = navigatorPanel;
    }

    @Override
    public NavigatorPanel getNavigatorPanel() {
        return this.navigatorPanel;
    }

    public TrackWatchDataModel getHover() {
        return this.hover;
    }

    public void setHover(TrackWatchDataModel hover) {
        this.hover = hover;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    protected void mousePressed(int x, int y, int modifiers, MouseButton mouseButton) {
    }

    @Override
    protected void mouseDragged(int x, int y) {
    }

    @Override
    protected void mouseDragFinished(int x, int y, int modifiers) {
    }

    @Override
    protected void mouseClicked(int x, int y, int clickCount, int modifiers, MouseButton mouseButton) {
    }

    @Override
    protected Integer getTimerInterval() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mouseMoved(int x, int y) {
        if (this.isActive()) {
            Point2D.Double real = this.navigatorPanel.getReal(x, y);
            double upp = this.navigatorPanel.getUpp();
            double margin = 15.0 * Math.pow(upp, -0.2) * upp;
            CoordinateFactory factory = this.navigatorPanel.getCoordinateFactory();
            TrackWatchTrackingsRenderer trackWatchTrackingsRenderer = this;
            synchronized (trackWatchTrackingsRenderer) {
                this.hover = null;
                for (TrackWatchDataModel trackData : this.allPoints.values()) {
                    Coordinate c;
                    Ellipse2D.Double circle;
                    if (this.pausePoints.contains(trackData.getGeoTrack()) || !(circle = DefaultPointRenderer.getCircle(c = factory.createCoordinate(trackData.getGeoTrack().getCoordinate()), margin)).contains(real)) continue;
                    this.hover = trackData;
                    this.refreshRequired = true;
                    this.navigatorPanel.repaint(1L);
                    break;
                }
                if (this.refreshRequired && this.hover == null) {
                    this.navigatorPanel.repaint(1L);
                    this.refreshRequired = false;
                }
            }
        }
    }

    private void fireNavigatorRendererActivateEvent(NavigatorRendererActivateEvent navigatorPanelActivateEvent) {
        if (this.navigatorRendererActiveListeners != null) {
            for (NavigatorRendererActiveListener navigatorRendererActiveListener : this.navigatorRendererActiveListeners) {
                navigatorRendererActiveListener.valueChanged(navigatorPanelActivateEvent);
            }
        }
    }

    public List<NavigatorRendererActiveListener> getNavigatorRendererActiveListeners() {
        return this.navigatorRendererActiveListeners;
    }

    public void setNavigatorRendererActiveListeners(List<NavigatorRendererActiveListener> navigatorRendererActiveListeners) {
        this.navigatorRendererActiveListeners = navigatorRendererActiveListeners;
    }

    public boolean isRefreshRequired() {
        return this.refreshRequired;
    }

    public void setRefreshRequired(boolean refreshRequired) {
        this.refreshRequired = refreshRequired;
    }

    public HashSet<ImmutablePoint> getPausePoints() {
        return this.pausePoints;
    }

    public void setPausePoints(HashSet<ImmutablePoint> pausePoints) {
        this.pausePoints = pausePoints;
    }

    public Collection<Tupel<Integer, List<ImmutablePoint>>> getExtraPauseTimePointsList() {
        return this.extraPauseTimePointsList;
    }

    public void setExtraPauseTimePointsList(Collection<Tupel<Integer, List<ImmutablePoint>>> extraPauseTimePointsList) {
        this.extraPauseTimePointsList = extraPauseTimePointsList;
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }
}

