/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.wage.track;

import com.google.common.collect.Multimap;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.wage.HistoryAreaStopModel;
import de.datomino.peppergis.client.model.wage.TrackWatchDataModel;
import de.datomino.peppergis.client.wage.track.TrackWatchTracksMapPane;
import de.datomino.util.geo.ImmutableLineString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class TrackWatchTourTrackingDialog
extends JDialog {
    private static final long serialVersionUID = 7016189766279007451L;
    private ModelEnviroment modelEnviroment;
    private Multimap<Integer, TrackWatchDataModel> trackingPoints;
    private List<HistoryAreaStopModel> stops;
    private ImmutableLineString lineString;
    private JCheckBox activateRenderersCheckBox;
    private JCheckBox activateCalculateCheckBox;
    private JCheckBox activateExtraPauseTimeCheckBox;
    private TrackWatchTracksMapPane trackingsMapPanel;

    public TrackWatchTourTrackingDialog(Window parent, ModelEnviroment modelEnvironment, Multimap<Integer, TrackWatchDataModel> trackingImmutablePoints, List<HistoryAreaStopModel> stops, ImmutableLineString lineString) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.trackWatch.trackings.map", new Serializable[0]));
        this.modelEnviroment = modelEnvironment;
        this.trackingPoints = trackingImmutablePoints;
        this.stops = stops;
        this.lineString = lineString;
        this.buildLayout();
    }

    private void buildLayout() {
        try {
            this.setIconImage(ImageIO.read(TrackWatchTourTrackingDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.getContentPane().setLayout(new BorderLayout());
        JPanel activatePanel = new JPanel(new BorderLayout());
        JPanel checkBoxesPanel = new JPanel(new FlowLayout());
        this.activateRenderersCheckBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.show.tracks", new Serializable[0]));
        this.activateRenderersCheckBox.setSelected(true);
        checkBoxesPanel.add(this.activateRenderersCheckBox);
        this.activateCalculateCheckBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.activate.calculate", new Serializable[0]));
        this.activateCalculateCheckBox.setSelected(true);
        checkBoxesPanel.add(this.activateCalculateCheckBox);
        this.activateExtraPauseTimeCheckBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.activate.extraPauseTime", new Serializable[0]));
        this.activateExtraPauseTimeCheckBox.setSelected(true);
        checkBoxesPanel.add(this.activateExtraPauseTimeCheckBox);
        activatePanel.add((Component)checkBoxesPanel, "West");
        this.getContentPane().add((Component)activatePanel, "North");
        this.trackingsMapPanel = new TrackWatchTracksMapPane(this.modelEnviroment, this.trackingPoints, this.stops, this.lineString);
        this.trackingsMapPanel.getTrackWatchTrackingsRenderer().turnedOn();
        this.trackingsMapPanel.getEstimatedTourTrackingsRenderer().turnedOn();
        this.trackingsMapPanel.getTrackWatchTrackingsRenderer().setExtraPauseTimeSignActive(true);
        this.activateRenderersCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TrackWatchTourTrackingDialog.this.activateRenderersCheckBox.isSelected()) {
                    TrackWatchTourTrackingDialog.this.trackingsMapPanel.getTrackWatchTrackingsRenderer().turnedOn();
                    TrackWatchTourTrackingDialog.this.activateExtraPauseTimeCheckBox.setEnabled(true);
                } else {
                    TrackWatchTourTrackingDialog.this.trackingsMapPanel.getTrackWatchTrackingsRenderer().turnedOff();
                    TrackWatchTourTrackingDialog.this.activateExtraPauseTimeCheckBox.setEnabled(false);
                }
            }
        });
        this.activateCalculateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TrackWatchTourTrackingDialog.this.activateCalculateCheckBox.isSelected()) {
                    TrackWatchTourTrackingDialog.this.trackingsMapPanel.getEstimatedTourTrackingsRenderer().turnedOn();
                } else {
                    TrackWatchTourTrackingDialog.this.trackingsMapPanel.getEstimatedTourTrackingsRenderer().turnedOff();
                }
            }
        });
        this.activateExtraPauseTimeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TrackWatchTourTrackingDialog.this.activateExtraPauseTimeCheckBox.isSelected()) {
                    TrackWatchTourTrackingDialog.this.trackingsMapPanel.getTrackWatchTrackingsRenderer().setExtraPauseTimeSignActive(true);
                } else {
                    TrackWatchTourTrackingDialog.this.trackingsMapPanel.getTrackWatchTrackingsRenderer().setExtraPauseTimeSignActive(false);
                }
            }
        });
        this.getContentPane().add((Component)this.trackingsMapPanel, "Center");
    }

    public ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    public void setModelEnviroment(ModelEnviroment modelEnviroment) {
        this.modelEnviroment = modelEnviroment;
    }

    public Multimap<Integer, TrackWatchDataModel> getTrackingPoints() {
        return this.trackingPoints;
    }

    public void setTrackingPoints(Multimap<Integer, TrackWatchDataModel> trackingPoints) {
        this.trackingPoints = trackingPoints;
    }

    public JCheckBox getActivateRenderersCheckBox() {
        return this.activateRenderersCheckBox;
    }

    public void setActivateRenderersCheckBox(JCheckBox activateRenderersCheckBox) {
        this.activateRenderersCheckBox = activateRenderersCheckBox;
    }

    public TrackWatchTracksMapPane getTrackingsMapPanel() {
        return this.trackingsMapPanel;
    }

    public void setTrackingsMapPanel(TrackWatchTracksMapPane trackingsMapPanel) {
        this.trackingsMapPanel = trackingsMapPanel;
    }

    public List<HistoryAreaStopModel> getStops() {
        return this.stops;
    }

    public void setStops(List<HistoryAreaStopModel> stops) {
        this.stops = stops;
    }

    public ImmutableLineString getLineString() {
        return this.lineString;
    }

    public void setLineString(ImmutableLineString lineString) {
        this.lineString = lineString;
    }
}

