/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.wage.parameter.inclusionexclusion;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.model.wage.WageParcelInclusionExclusionModel;
import de.datomino.peppergis.client.model.wage.WageParcelInclusionExclusionModelImpl;
import de.datomino.peppergis.client.model.wage.WageParcelInclusionExclusionSetModel;
import de.datomino.peppergis.client.model.wage.WageParcelInclusionExclusionSetModelImpl;
import de.datomino.peppergis.client.wage.parameter.inclusionexclusion.PreferWageParameterInclusionExclusionTableEntry;
import de.datomino.peppergis.client.wage.parameter.inclusionexclusion.WageParameterInclusionExclusionTableEntry;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.ParcelBlockType;
import de.datomino.peppergis.type.WeekDay;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class WageParameterInclusionExclusionTableModel
implements TableModel {
    private List<ParcelAttributeValueDescriptorModel> descriptors;
    private Map<String, ParcelAttributeValueDescriptorModel> descriptorMap;
    private List<TableModelListener> listeners = new LinkedList<TableModelListener>();
    private WageParameterModel wageParameterModel;
    private boolean editable = true;

    public WageParameterInclusionExclusionTableModel(ModelEnviroment modelEnviroment) {
        Collection<ParcelAttributeValueDescriptorModel> descriptors = modelEnviroment.getAllCaller().getStreetNetCaller().fetchAllParcelAttributeValueDescriptors();
        this.descriptors = new ArrayList<ParcelAttributeValueDescriptorModel>();
        this.descriptorMap = new HashMap<String, ParcelAttributeValueDescriptorModel>();
        for (ParcelAttributeValueDescriptorModel attr : descriptors) {
            if (attr.getAttributeValueType() != AttributeValueType.BOOLEAN) continue;
            this.descriptors.add(attr);
            this.descriptorMap.put(attr.getKey(), attr);
        }
    }

    @Override
    public int getRowCount() {
        return 1 + this.descriptors.size() * 2;
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.attributes", new Serializable[0]);
            }
            case 1: {
                return "";
            }
            case 2: {
                return ModelEnviroment.getMessageResolver().resolveMessageForEnum(WeekDay.MONDAY);
            }
            case 3: {
                return ModelEnviroment.getMessageResolver().resolveMessageForEnum(WeekDay.TUESDAY);
            }
            case 4: {
                return ModelEnviroment.getMessageResolver().resolveMessageForEnum(WeekDay.WEDNESDAY);
            }
            case 5: {
                return ModelEnviroment.getMessageResolver().resolveMessageForEnum(WeekDay.THURSDAY);
            }
            case 6: {
                return ModelEnviroment.getMessageResolver().resolveMessageForEnum(WeekDay.FRIDAY);
            }
            case 7: {
                return ModelEnviroment.getMessageResolver().resolveMessageForEnum(WeekDay.SATURDAY);
            }
            case 8: {
                return ModelEnviroment.getMessageResolver().resolveMessageForEnum(WeekDay.SUNDAY);
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex <= 1) {
            return String.class;
        }
        return PreferWageParameterInclusionExclusionTableEntry.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        boolean isInclusion;
        boolean bl = isInclusion = (rowIndex - 1) % 2 == 0;
        if (columnIndex == 0) {
            if (rowIndex == 0) {
                return "";
            }
            if (isInclusion) {
                ParcelAttributeValueDescriptorModel desc = this.descriptors.get((rowIndex - 1) / 2);
                return desc.getName();
            }
            return "";
        }
        if (columnIndex == 1) {
            if (rowIndex == 0) {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.preferExclusion", new Serializable[0]);
            }
            if (isInclusion) {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.inclusion", new Serializable[0]);
            }
            return ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.block", new Serializable[0]);
        }
        if (this.wageParameterModel == null) {
            if (rowIndex == 0) {
                return new PreferWageParameterInclusionExclusionTableEntry(false);
            }
            return WageParameterInclusionExclusionTableEntry.INACTIVE;
        }
        int cIndex = columnIndex - 2;
        WeekDay weekDay = this.getWeekDayFromIndex(cIndex);
        WageParcelInclusionExclusionSetModel foundSet = null;
        for (WageParcelInclusionExclusionSetModel set : this.wageParameterModel.iterableWageParcelInclusionExclusionSet()) {
            if (set.getWeekDay() != weekDay) continue;
            foundSet = set;
            break;
        }
        if (foundSet == null) {
            if (rowIndex == 0) {
                return new PreferWageParameterInclusionExclusionTableEntry(false);
            }
            return WageParameterInclusionExclusionTableEntry.INACTIVE;
        }
        if (rowIndex == 0) {
            return new PreferWageParameterInclusionExclusionTableEntry(foundSet.getPreferExclusion());
        }
        ParcelAttributeValueDescriptorModel desc = this.descriptors.get((rowIndex - 1) / 2);
        WageParcelInclusionExclusionModel found = this.findWageInclusionExclusion(foundSet, desc, isInclusion);
        if (found == null) {
            return WageParameterInclusionExclusionTableEntry.INACTIVE;
        }
        return new WageParameterInclusionExclusionTableEntry(found.getValue());
    }

    private WageParcelInclusionExclusionModel findWageInclusionExclusion(WageParcelInclusionExclusionSetModel foundSet, ParcelAttributeValueDescriptorModel desc, boolean isInclusion) {
        WageParcelInclusionExclusionModel found = null;
        for (WageParcelInclusionExclusionModel inEx : foundSet.iterableWageParcelInclusionExclusions()) {
            if (!inEx.getDescriptorKey().equals(desc.getKey()) || (!isInclusion || inEx.getType() != ParcelBlockType.INCLUSION) && (isInclusion || inEx.getType() != ParcelBlockType.EXCLUSION)) continue;
            found = inEx;
            break;
        }
        return found;
    }

    private WeekDay getWeekDayFromIndex(int cIndex) {
        switch (cIndex) {
            case 0: {
                return WeekDay.MONDAY;
            }
            case 1: {
                return WeekDay.TUESDAY;
            }
            case 2: {
                return WeekDay.WEDNESDAY;
            }
            case 3: {
                return WeekDay.THURSDAY;
            }
            case 4: {
                return WeekDay.FRIDAY;
            }
            case 5: {
                return WeekDay.SATURDAY;
            }
            case 6: {
                return WeekDay.SUNDAY;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.wageParameterModel != null && columnIndex > 1) {
            int cIndex = columnIndex - 2;
            WeekDay weekDay = this.getWeekDayFromIndex(cIndex);
            WageParcelInclusionExclusionSetModel foundSet = null;
            for (WageParcelInclusionExclusionSetModel set : this.wageParameterModel.iterableWageParcelInclusionExclusionSet()) {
                if (set.getWeekDay() != weekDay) continue;
                foundSet = set;
                break;
            }
            if (foundSet == null) {
                foundSet = new WageParcelInclusionExclusionSetModelImpl();
                foundSet.setWageParameter(this.wageParameterModel);
                foundSet.setWeekDay(weekDay);
                foundSet.setPreferExclusion(false);
            }
            if (rowIndex == 0) {
                foundSet.setPreferExclusion(((PreferWageParameterInclusionExclusionTableEntry)aValue).isActive());
            } else {
                WageParameterInclusionExclusionTableEntry wageParameterInclusionExclusionTableEntry = (WageParameterInclusionExclusionTableEntry)aValue;
                boolean isInclusion = (rowIndex - 1) % 2 == 0;
                ParcelAttributeValueDescriptorModel desc = this.descriptors.get((rowIndex - 1) / 2);
                WageParcelInclusionExclusionModel found = this.findWageInclusionExclusion(foundSet, desc, isInclusion);
                if (wageParameterInclusionExclusionTableEntry.isActive()) {
                    if (found == null) {
                        found = new WageParcelInclusionExclusionModelImpl();
                        found.setWageParcelInclusionExclusionSet(foundSet);
                        found.setDescriptorKey(desc.getKey());
                    }
                    if (isInclusion) {
                        found.setType(ParcelBlockType.INCLUSION);
                    } else {
                        found.setType(ParcelBlockType.EXCLUSION);
                    }
                    found.setValue(wageParameterInclusionExclusionTableEntry.getValue());
                } else if (found != null) {
                    found.setWageParcelInclusionExclusionSet(null);
                    found.delete();
                }
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    protected void fireTableModelChanged(TableModelEvent e) {
        for (TableModelListener l : this.listeners) {
            l.tableChanged(e);
        }
    }

    public void setWageParameterInclusionExclusionSets(WageParameterModel wageParameterModel) {
        this.wageParameterModel = wageParameterModel;
        this.fireTableModelChanged(new TableModelEvent(this));
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public ParcelAttributeValueDescriptorModel getDescriptorForRow(int row) {
        int index = (row - 1) / 2;
        if (index >= 0) {
            return this.descriptors.get(index);
        }
        return null;
    }

    public WeekDay getWeekDayForCol(int col) {
        return this.getWeekDayFromIndex(col - 2);
    }

    public ParcelBlockType getParcelBlockTypeForRow(int row) {
        if (row > 0) {
            if ((row - 1) % 2 == 0) {
                return ParcelBlockType.INCLUSION;
            }
            return ParcelBlockType.EXCLUSION;
        }
        return null;
    }
}

