/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.wage;

import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.common.DialogDisposeAction;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.deliverer.AreaDelivererEmploymentDialog;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaStopModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourModel;
import de.datomino.peppergis.client.model.wage.HistoryAreaTourPdfModel;
import de.datomino.peppergis.client.model.wage.TrackWatchDataModel;
import de.datomino.peppergis.client.model.wage.WageDifferenceModel;
import de.datomino.peppergis.client.model.wage.WageParameterModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.PdfUtil;
import de.datomino.peppergis.client.util.wage.HistoryAreaTourModelWageResult;
import de.datomino.peppergis.client.util.wage.TrackWatchUtil;
import de.datomino.peppergis.client.util.wage.WageDeltaModelUtil;
import de.datomino.peppergis.client.wage.DifferenceDocumentListener;
import de.datomino.peppergis.client.wage.parameter.WageParameterPane;
import de.datomino.peppergis.client.wage.track.TrackWatchTourTrackingDialog;
import de.datomino.peppergis.type.DataSourceType;
import de.datomino.peppergis.type.Product;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.util.GeoUtils;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.time.TimeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.plaf.basic.BasicArrowButton;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Holder;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class HistoryAreaTourDialog
extends CommonDialog {
    private static final long serialVersionUID = 6790734126644297909L;
    private List<HistoryAreaTourModelWageResult> list;
    private HistoryAreaTourModelWageResult wageResult;
    private ModelEnviroment modelEnviroment;
    private boolean editable;
    private boolean differenceAllowed;

    public HistoryAreaTourDialog(List<HistoryAreaTourModelWageResult> list, ModelEnviroment modelEnviroment, boolean editable, Window parent) {
        super((Component)parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.route.deliveryroute", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.list = list;
        this.wageResult = list.get(0);
        this.modelEnviroment = modelEnviroment;
        this.editable = editable && ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER, UserRole.WAGE_ACTIVE);
        this.differenceAllowed = ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER, UserRole.WAGE_ACTIVE, UserRole.WAGE_DIFFERENCE);
        if (this.editable || this.differenceAllowed) {
            this.modelEnviroment.getUndoManager().startTransaction();
        }
        super.buildLayout();
        if (this.list.size() > 1) {
            this.add((Component)this.createControlPanel(), "First");
        }
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 3280449595070962158L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HistoryAreaTourDialog.this.editable || HistoryAreaTourDialog.this.differenceAllowed) {
                    String s = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.edit", new Serializable[0]) + " - " + HistoryAreaTourDialog.this.wageResult.getModel().getShortcut();
                    HistoryAreaTourDialog.this.doWageDeviationSettings();
                    HistoryAreaTourDialog.this.modelEnviroment.getUndoManager().finishTransaction(s);
                }
                HistoryAreaTourDialog.this.dispose();
            }
        };
    }

    private void doWageDeviationSettings() {
        HistoryAreaTourModel model = this.wageResult.getModel();
        WageDifferenceModel difference = model.getWageDifference();
        if (difference != null) {
            Integer time = WageDeltaModelUtil.getTimeForDifference(difference.getActualStartTime1(), difference.getActualEndTime1(), difference.getActualBreak1());
            difference.setTimeDeviation1(time);
            time = WageDeltaModelUtil.getTimeForDifference(difference.getActualStartTime2(), difference.getActualEndTime2(), difference.getActualBreak2());
            difference.setTimeDeviation2(time);
            time = WageDeltaModelUtil.getTimeForDifference(difference.getActualStartTime3(), difference.getActualEndTime3(), difference.getActualBreak3());
            difference.setTimeDeviation3(time);
        }
    }

    @Override
    protected Action getCancelAction() {
        return new DialogDisposeAction(this){
            private static final long serialVersionUID = 944191393010430177L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (HistoryAreaTourDialog.this.editable || HistoryAreaTourDialog.this.differenceAllowed) {
                    UndoManager undoManager = HistoryAreaTourDialog.this.modelEnviroment.getUndoManager();
                    undoManager.rollbackTransaction();
                }
                HistoryAreaTourDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JTabbedPane mainPane = new JTabbedPane();
        mainPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), new JScrollPane(this.createDefaultPane()));
        mainPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.offer.deliveryTimes", new Serializable[0]), new JScrollPane(this.createDeliveryTimePane()));
        mainPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.dailyVolumn", new Serializable[0]), new JScrollPane(this.createDeliveryPane()));
        mainPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.difference", new Serializable[0]), new JScrollPane(this.createDifferencePane()));
        mainPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.information", new Serializable[0]), new JScrollPane(this.createTrackWatchInfoPane()));
        return mainPane;
    }

    private Component createDeliveryTimePane() {
        JPanel timePane = new JPanel(new SpringLayout());
        boolean b = this.wageResult.getModel().getLength() == null;
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.receptionTime", new Serializable[0])));
        timePane.add(new JLabel(""));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscription", new Serializable[0])));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated((long)(this.wageResult.getReceptionSubscriptionTime() * 1000.0)), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.weeklyPaper", new Serializable[0])));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated((long)(this.wageResult.getReceptionWeeklyPaperTime() * 1000.0)), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.leaflet", new Serializable[0])));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated((long)(this.wageResult.getReceptionLeafletTime() * 1000.0)), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.mounting", new Serializable[0])));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated((long)(this.wageResult.getReceptionManualLeafletTime() * 1000.0)), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.letter", new Serializable[0])));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated((long)(this.wageResult.getReceptionLetterTime() * 1000.0)), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.sortLetter", new Serializable[0])));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated((long)(this.wageResult.getSortLetterTime() * 1000.0)), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.sum", new Serializable[0])));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated((long)(this.wageResult.getReceptionTimeSum() * 1000.0)), false));
        timePane.add(new JLabel("---------------------"));
        timePane.add(new JLabel(""));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.throw", new Serializable[0])));
        timePane.add(new JLabel(""));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscription", new Serializable[0])));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated((long)(this.wageResult.getThrowSubscriptionTime() * 1000.0)), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.weeklyPaper", new Serializable[0])));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated((long)(this.wageResult.getThrowWeeklyPaperTime() * 1000.0)), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.leaflet", new Serializable[0])));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated((long)(this.wageResult.getThrowLeafletTime() * 1000.0)), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.letter", new Serializable[0])));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated((long)(this.wageResult.getThrowLetterTime() * 1000.0)), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.reload", new Serializable[0])));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated((long)(this.wageResult.getReloadTime() * 1000.0)), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.sum", new Serializable[0])));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated((long)(this.wageResult.getThrowTimeSum() * 1000.0)), false));
        timePane.add(new JLabel("---------------------"));
        timePane.add(new JLabel(""));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.duration", new Serializable[0])));
        timePane.add(new JLabel(""));
        Integer duration = this.wageResult.getModel().getDuration();
        duration = duration == null ? 0 : duration;
        Integer durationFromPoi = this.wageResult.getModel().getDurationFromPoi();
        durationFromPoi = durationFromPoi == null ? 0 : durationFromPoi;
        Integer durationToPoi = this.wageResult.getModel().getDurationToPoi();
        durationToPoi = durationToPoi == null ? 0 : durationToPoi;
        Integer durationFromPickPoint = this.wageResult.getModel().getDurationFromPickPoint();
        durationFromPickPoint = durationFromPickPoint == null ? 0 : durationFromPickPoint;
        Integer durationToPickPoint = this.wageResult.getModel().getDurationToPickPoint();
        durationToPickPoint = durationToPickPoint == null ? 0 : durationToPickPoint;
        int durationInArea = duration - durationFromPoi - durationFromPickPoint - durationToPickPoint - durationToPoi;
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.area", new Serializable[]{""})));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated(durationInArea * 1000), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.p2a", new Serializable[]{""})));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated(durationFromPoi * 1000), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.a2p", new Serializable[]{""})));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated(durationToPoi * 1000), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.pp2a", new Serializable[]{""})));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated(durationFromPickPoint * 1000), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.a2pp", new Serializable[]{""})));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated(durationToPickPoint * 1000), false));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.sum", new Serializable[0])));
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationSeparated(duration * 1000), false));
        timePane.add(new JLabel("---------------------"));
        timePane.add(new JLabel(""));
        timePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.duration", new Serializable[]{""})));
        double timeSum = (double)duration.intValue() + this.wageResult.getThrowTimeSum() + this.wageResult.getReceptionTimeSum();
        timePane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDurationToHourMinSec((long)(timeSum * 1000.0)), false));
        SpringUtilities.makeCompactGrid(timePane, 26, 2, 5, 5, 5, 5);
        return ClientSwingUtil.createPanelForComponent(timePane, null, "North");
    }

    private Component createDifferencePane() {
        final WageDifferenceModel wageDifference = this.wageResult.getModel().getWageDifference();
        if (wageDifference == null) {
            return null;
        }
        Holder<WageDifferenceModel> object = new Holder<WageDifferenceModel>(wageDifference);
        JPanel differencePane = new JPanel(new SpringLayout());
        differencePane.add(new JLabel("IST " + ModelEnviroment.getMessageResolver().resolveMessage("gui.date.date", new Serializable[0]) + " 1"));
        differencePane.add(this.createTextField(ClientFormUtil.getDateString(wageDifference.getActualWageTime1(), FormUtil.DATEFORMAT), "ActualWageTime1", object, this.differenceAllowed));
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.timeDeviation", new Serializable[0]) + " 1"));
        Integer timeDeviationValue = wageDifference.getTimeDeviation1();
        JTextField difference1 = this.createTextField(timeDeviationValue == null ? "" : TimeUtil.formatDurationToHourMinSec(Math.abs((long)timeDeviationValue.intValue() * 1000L)), "TimeDeviation1", object, false);
        difference1.setForeground(timeDeviationValue == null || timeDeviationValue >= 0 ? Color.BLACK : Color.RED);
        differencePane.add(difference1);
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.actualStartTime", new Serializable[0]) + " 1"));
        JTextField actualStartTime1 = this.createTextField(ClientFormUtil.getDateString(wageDifference.getActualStartTime1(), FormUtil.TIMEFORMAT), "ActualStartTime1", object, this.differenceAllowed);
        differencePane.add(actualStartTime1);
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.actualEndTime", new Serializable[0]) + " 1"));
        JTextField actualEndTime1 = this.createTextField(ClientFormUtil.getDateString(wageDifference.getActualEndTime1(), FormUtil.TIMEFORMAT), "ActualEndTime1", object, this.differenceAllowed);
        differencePane.add(actualEndTime1);
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.break", new Serializable[0]) + " 1"));
        JTextField actualBreak1 = this.createTextField(ClientFormUtil.getNumberString(wageDifference.getActualBreak1()), "ActualBreak1", object, this.differenceAllowed);
        differencePane.add(actualBreak1);
        DifferenceDocumentListener differenceDocumentListener = new DifferenceDocumentListener(actualStartTime1, actualEndTime1, actualBreak1, difference1, FormUtil.TIMEFORMAT);
        actualStartTime1.getDocument().addDocumentListener(differenceDocumentListener);
        actualEndTime1.getDocument().addDocumentListener(differenceDocumentListener);
        actualBreak1.getDocument().addDocumentListener(differenceDocumentListener);
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.dataSource", new Serializable[0]) + " 1"));
        differencePane.add(new EnumComboBoxAdapter<DataSourceType>(DataSourceType.class, wageDifference.getDataSource1(), true, this.differenceAllowed){
            private static final long serialVersionUID = 2993356414216762802L;

            @Override
            protected void doAfterSelect(DataSourceType t) {
                wageDifference.setDataSource1(t);
            }
        });
        differencePane.add(new JLabel("IST " + ModelEnviroment.getMessageResolver().resolveMessage("gui.date.date", new Serializable[0]) + " 2"));
        differencePane.add(this.createTextField(ClientFormUtil.getDateString(wageDifference.getActualWageTime2(), FormUtil.DATEFORMAT), "ActualWageTime2", object, this.differenceAllowed));
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.timeDeviation", new Serializable[0]) + " 2"));
        timeDeviationValue = wageDifference.getTimeDeviation2();
        JTextField difference2 = this.createTextField(timeDeviationValue == null ? "" : TimeUtil.formatDurationToHourMinSec(Math.abs((long)timeDeviationValue.intValue() * 1000L)), "TimeDeviation2", object, false);
        difference2.setForeground(timeDeviationValue == null || timeDeviationValue >= 0 ? Color.BLACK : Color.RED);
        differencePane.add(difference2);
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.actualStartTime", new Serializable[0]) + " 2"));
        JTextField actualStartTime2 = this.createTextField(ClientFormUtil.getDateString(wageDifference.getActualStartTime2(), FormUtil.TIMEFORMAT), "ActualStartTime2", object, this.differenceAllowed);
        differencePane.add(actualStartTime2);
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.actualEndTime", new Serializable[0]) + " 2"));
        JTextField actualEndTime2 = this.createTextField(ClientFormUtil.getDateString(wageDifference.getActualEndTime2(), FormUtil.TIMEFORMAT), "ActualEndTime2", object, this.differenceAllowed);
        differencePane.add(actualEndTime2);
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.break", new Serializable[0]) + " 2"));
        JTextField actualBreak2 = this.createTextField(ClientFormUtil.getNumberString(wageDifference.getActualBreak2()), "ActualBreak2", object, this.differenceAllowed);
        differencePane.add(actualBreak2);
        differenceDocumentListener = new DifferenceDocumentListener(actualStartTime2, actualEndTime2, actualBreak2, difference2, FormUtil.TIMEFORMAT);
        actualStartTime2.getDocument().addDocumentListener(differenceDocumentListener);
        actualEndTime2.getDocument().addDocumentListener(differenceDocumentListener);
        actualBreak2.getDocument().addDocumentListener(differenceDocumentListener);
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.dataSource", new Serializable[0]) + " 2"));
        differencePane.add(new EnumComboBoxAdapter<DataSourceType>(DataSourceType.class, wageDifference.getDataSource2(), true, this.differenceAllowed){
            private static final long serialVersionUID = 2993356414216762802L;

            @Override
            protected void doAfterSelect(DataSourceType t) {
                wageDifference.setDataSource2(t);
            }
        });
        differencePane.add(new JLabel("IST " + ModelEnviroment.getMessageResolver().resolveMessage("gui.date.date", new Serializable[0]) + " 3"));
        differencePane.add(this.createTextField(ClientFormUtil.getDateString(wageDifference.getActualWageTime3(), FormUtil.DATEFORMAT), "ActualWageTime3", object, this.differenceAllowed));
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.timeDeviation", new Serializable[0]) + " 3"));
        timeDeviationValue = wageDifference.getTimeDeviation3();
        JTextField difference3 = this.createTextField(timeDeviationValue == null ? "" : TimeUtil.formatDurationToHourMinSec(Math.abs((long)timeDeviationValue.intValue() * 1000L)), "TimeDeviation3", object, false);
        difference3.setForeground(timeDeviationValue == null || timeDeviationValue >= 0 ? Color.BLACK : Color.RED);
        differencePane.add(difference3);
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.actualStartTime", new Serializable[0]) + " 3"));
        JTextField actualStartTime3 = this.createTextField(ClientFormUtil.getDateString(wageDifference.getActualStartTime3(), FormUtil.TIMEFORMAT), "ActualStartTime3", object, this.differenceAllowed);
        differencePane.add(actualStartTime3);
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.actualEndTime", new Serializable[0]) + " 3"));
        JTextField actualEndTime3 = this.createTextField(ClientFormUtil.getDateString(wageDifference.getActualEndTime3(), FormUtil.TIMEFORMAT), "ActualEndTime3", object, this.differenceAllowed);
        differencePane.add(actualEndTime3);
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.break", new Serializable[0]) + " 3"));
        JTextField actualBreak3 = this.createTextField(ClientFormUtil.getNumberString(wageDifference.getActualBreak3()), "ActualBreak3", object, this.differenceAllowed);
        differencePane.add(actualBreak3);
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.dataSource", new Serializable[0]) + " 3"));
        differencePane.add(new EnumComboBoxAdapter<DataSourceType>(DataSourceType.class, wageDifference.getDataSource3(), true, this.differenceAllowed){
            private static final long serialVersionUID = 2993356414216762802L;

            @Override
            protected void doAfterSelect(DataSourceType t) {
                wageDifference.setDataSource3(t);
            }
        });
        differenceDocumentListener = new DifferenceDocumentListener(actualStartTime3, actualEndTime3, actualBreak3, difference3, FormUtil.TIMEFORMAT);
        actualStartTime3.getDocument().addDocumentListener(differenceDocumentListener);
        actualEndTime3.getDocument().addDocumentListener(differenceDocumentListener);
        actualBreak3.getDocument().addDocumentListener(differenceDocumentListener);
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.explanation", new Serializable[0])));
        JTextArea explanation = ClientSwingUtil.createParameterTextArea(5, 20, wageDifference.getExplanation(), this.differenceAllowed, "Explanation", object, this);
        differencePane.add(explanation);
        differencePane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.comment", new Serializable[0])));
        JTextArea comment = ClientSwingUtil.createParameterTextArea(5, 20, wageDifference.getComment(), this.differenceAllowed, "Comment", object, this);
        differencePane.add(comment);
        SpringUtilities.makeCompactGrid(differencePane, 20, 2, 5, 5, 5, 5);
        return ClientSwingUtil.createPanelForComponent(differencePane, null, "North");
    }

    private JPanel createDeliveryPane() {
        JPanel delivereryPane = new JPanel(new SpringLayout());
        HistoryAreaTourModel historyAreaTour = this.wageResult.getModel();
        delivereryPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.subscriptionAmount", new Serializable[0])));
        delivereryPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getSubscriptionAmount()), false));
        delivereryPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.subscriptionPackageCount", new Serializable[0])));
        delivereryPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getSubscriptionPackageCount()), false));
        delivereryPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.subscriptionStopCount", new Serializable[0])));
        delivereryPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getSubscriptionStopCount()), false));
        delivereryPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.weeklyPaperAmount", new Serializable[0])));
        delivereryPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getWeeklyPaperAmount()), false));
        delivereryPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.weeklyPaperPackageCount", new Serializable[0])));
        delivereryPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getWeeklyPaperPackageCount()), false));
        delivereryPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.weeklyPaperStopCount", new Serializable[0])));
        delivereryPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getWeeklyPaperStopCount()), false));
        delivereryPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.directDeliveryLeafletAmount", new Serializable[0])));
        delivereryPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getDirectDeliveryLeafletAmount()), false));
        delivereryPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.manualLeafletAmount", new Serializable[0])));
        delivereryPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getManualLeafletAmount()), false));
        delivereryPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.leafletPackageCount", new Serializable[0])));
        delivereryPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getLeafletPackageCount()), false));
        delivereryPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.leafletStopCount", new Serializable[0]) + "-DV"));
        delivereryPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getDirectDeliveryStopCount()), false));
        delivereryPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.leafletStopCount", new Serializable[0]) + "-MB"));
        delivereryPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getManualLeafletStopCount()), false));
        delivereryPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.letterAmount", new Serializable[0])));
        delivereryPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getLetterAmount()), false));
        delivereryPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.letterStopCount", new Serializable[0])));
        delivereryPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getLetterStopCount()), false));
        final WageParameterModel parameter = historyAreaTour.getParameter();
        delivereryPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.parameter", new Serializable[0])));
        String parameterName = StringUtil.isBlank(parameter.getName()) ? "Parameter" : parameter.getName();
        delivereryPane.add(new JButton(new AbstractAction(parameterName){
            private static final long serialVersionUID = -8024700936842450043L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WageParameterPane wageParameterPane = new WageParameterPane(parameter, false, HistoryAreaTourDialog.this.modelEnviroment);
                JScrollPane scrollWageParameterPane = new JScrollPane(wageParameterPane);
                scrollWageParameterPane.setPreferredSize(new Dimension(700, 800));
                JOptionPane.showMessageDialog(HistoryAreaTourDialog.this, scrollWageParameterPane);
            }
        }));
        SpringUtilities.makeCompactGrid(delivereryPane, 14, 2, 5, 5, 5, 5);
        return ClientSwingUtil.createPanelForComponent(delivereryPane, null, "North");
    }

    private JPanel createDefaultPane() {
        final HistoryAreaTourModel historyAreaTour = this.wageResult.getModel();
        JPanel defaultPane = new JPanel(new SpringLayout());
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(historyAreaTour.getLayerName() + " - " + historyAreaTour.getShortcut(), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.date.date", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ClientFormUtil.dateToString(historyAreaTour.getDate(), FormUtil.DATEFORMAT), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(historyAreaTour.getDeliveryRound(), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.deliveryRound.products", new Serializable[0])));
        String productString = "";
        for (String s : StringUtil.unflatArrayString(historyAreaTour.getProducts())) {
            if (productString.length() != 0) {
                productString = productString + ", ";
            }
            productString = productString + ModelEnviroment.getMessageResolver().resolveMessageForEnum(Product.valueOf(s));
        }
        defaultPane.add(ClientSwingUtil.createTextField(productString, false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.start", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(historyAreaTour.getStartLocation(), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.end", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(historyAreaTour.getEndLocation(), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.stop", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(historyAreaTour.getPoiNumber(), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.startPickPoints", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(historyAreaTour.getFirstPickPoint(), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.endPickPoints", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(historyAreaTour.getLastPickPoint(), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.numberOfAreaStops", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getStopCount()), false));
        defaultPane.add(new JLabel("PDF"));
        defaultPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.show", new Serializable[0])){
            private static final long serialVersionUID = 4756482088994802646L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryAreaTourPdfModel pdf = historyAreaTour.getPdf();
                if (pdf == null || pdf.getData() == null) {
                    JOptionPane.showMessageDialog(HistoryAreaTourDialog.this, "Kein PDF", "", 2);
                } else {
                    try {
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(pdf.getData());
                        PdfUtil.showPdf("Peppergis - Lohn Delta", inputStream, ModelEnviroment.getProperties());
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(HistoryAreaTourDialog.this, "Fehlerhafte PDF-Darstellung", "", 0);
                    }
                }
            }
        }));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.length", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getLength()), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.streetLength", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getStreetLength()), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.parcelLength", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getParcelLength()), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.p2aLength", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getLengthFromPoi()), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.a2pLength", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getLengthToPoi()), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.pp2aLength", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getLengthFromPickPoint()), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.a2ppLength", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getLengthToPickPoint()), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.wage.areatour.reloadLength", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(this.wageResult.getReloadDistance()), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.parcellocation", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getParcelLocation()), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.difficultyLevel", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ClientFormUtil.getNumberString(historyAreaTour.getDifficultyLevel()), false));
        final AreaDelivererModel deliverer = historyAreaTour.getDeliverer();
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.areaDelivererNumber", new Serializable[0])));
        JButton delivererButton = new JButton(new AbstractAction(deliverer == null ? " " : deliverer.getDelivererNumber()){
            private static final long serialVersionUID = 3939534566896123265L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (deliverer != null) {
                    AreaDelivererEmploymentDialog.createAndShow(deliverer, HistoryAreaTourDialog.this.modelEnviroment, HistoryAreaTourDialog.this.editable, HistoryAreaTourDialog.this);
                }
            }
        });
        if (deliverer == null) {
            delivererButton.setEnabled(false);
        }
        defaultPane.add(delivererButton);
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.deliverer.vehicelTypeInArea", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ModelEnviroment.getMessageResolver().resolveMessageForEnum(historyAreaTour.getVehicelTypeInArea()), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.deliverer.vehicelTypeFromPoi", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ModelEnviroment.getMessageResolver().resolveMessageForEnum(historyAreaTour.getVehicelTypeFromPoi()), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.deliverer.vehicelTypeFromPickPoint", new Serializable[0])));
        defaultPane.add(ClientSwingUtil.createTextField(ModelEnviroment.getMessageResolver().resolveMessageForEnum(historyAreaTour.getVehicelTypeFromPickPoint()), false));
        WageDifferenceModel wageDifference = this.wageResult.getModel().getWageDifference();
        final AreaDelivererModel replacement = wageDifference == null ? null : wageDifference.getReplacementDeliverer();
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.replacement", new Serializable[0])));
        JButton replacementButton = new JButton(new AbstractAction(replacement == null ? " " : replacement.getDelivererNumber()){
            private static final long serialVersionUID = 3939534566896123265L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (replacement != null) {
                    AreaDelivererEmploymentDialog.createAndShow(replacement, HistoryAreaTourDialog.this.modelEnviroment, HistoryAreaTourDialog.this.editable, HistoryAreaTourDialog.this);
                }
            }
        });
        if (replacement == null) {
            replacementButton.setEnabled(false);
        }
        defaultPane.add(replacementButton);
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.replacement.vehicelTypeInArea", new Serializable[0])));
        RouteVehicleType vehicelTypeInArea = wageDifference == null ? null : wageDifference.getVehicelTypeInArea();
        defaultPane.add(ClientSwingUtil.createTextField(ModelEnviroment.getMessageResolver().resolveMessageForEnum(vehicelTypeInArea), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.replacement.vehicelTypeFromPoi", new Serializable[0])));
        RouteVehicleType vehicelTypeFromPoi = wageDifference == null ? null : wageDifference.getVehicelTypeFromPoi();
        defaultPane.add(ClientSwingUtil.createTextField(ModelEnviroment.getMessageResolver().resolveMessageForEnum(vehicelTypeFromPoi), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.wage.replacement.vehicelTypeFromPickPoint", new Serializable[0])));
        RouteVehicleType vehicelTypeFromPickPoint = wageDifference == null ? null : wageDifference.getVehicelTypeFromPickPoint();
        defaultPane.add(ClientSwingUtil.createTextField(ModelEnviroment.getMessageResolver().resolveMessageForEnum(vehicelTypeFromPickPoint), false));
        defaultPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.show.tracks", new Serializable[0])));
        defaultPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.show", new Serializable[0])){
            private static final long serialVersionUID = -6454842393449518228L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Multimap trackWatchPoints = null;
                List<HistoryAreaStopModel> estimatedTourStops = null;
                HistoryAreaTourModel history = HistoryAreaTourDialog.this.wageResult.getModel();
                if (history != null) {
                    trackWatchPoints = HistoryAreaTourDialog.this.getGeoTracksForTour(history);
                    estimatedTourStops = HistoryAreaTourDialog.this.getEstimatedTourStops(history);
                }
                Window parent = SwingUtils.findWindowParent(HistoryAreaTourDialog.this);
                ImmutableLineString lineString = history == null ? null : history.getLineString();
                TrackWatchTourTrackingDialog tourTracksDialog = new TrackWatchTourTrackingDialog(parent, HistoryAreaTourDialog.this.modelEnviroment, trackWatchPoints, estimatedTourStops, lineString);
                tourTracksDialog.pack();
                SwingUtils.center((Window)tourTracksDialog, parent);
                tourTracksDialog.setVisible(true);
            }
        }));
        SpringUtilities.makeCompactGrid(defaultPane, 30, 2, 5, 5, 5, 5);
        return ClientSwingUtil.createPanelForComponent(defaultPane, null, "North");
    }

    private JPanel createTrackWatchInfoPane() {
        JPanel trackwatchPane = new JPanel(new SpringLayout());
        HistoryAreaTourModel historyAreaTour = this.wageResult.getModel();
        Tupel<Multimap<Integer, TrackWatchDataModel>, Tripel<Date, Date, Long>> tupel = TrackWatchUtil.getTrackwatchSummary(historyAreaTour);
        Multimap<Integer, TrackWatchDataModel> tracksForPeriodMap = tupel.getElement1();
        long calculatedTime = historyAreaTour.getDuration() != null ? (long)historyAreaTour.getDuration().intValue() : 0L;
        long throwingTime = (long)this.wageResult.getThrowTimeSum();
        long preparationTime = (long)this.wageResult.getReceptionTimeSum();
        long totalCalculatedTrackTime = calculatedTime + throwingTime + preparationTime;
        trackwatchPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.totaltracktime.calculated", new Serializable[0])));
        trackwatchPane.add(this.createDurationTextField(totalCalculatedTrackTime * 1000L));
        trackwatchPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.trackingtime.calculated", new Serializable[0])));
        trackwatchPane.add(this.createDurationTextField(calculatedTime * 1000L));
        trackwatchPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.preparation.time", new Serializable[0])));
        trackwatchPane.add(this.createDurationTextField(preparationTime * 1000L));
        trackwatchPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.throwing.time", new Serializable[0])));
        trackwatchPane.add(this.createDurationTextField(throwingTime * 1000L));
        trackwatchPane.add((Component)new JSeparator(0), "Center");
        JSeparator sep = new JSeparator(0);
        sep.setVisible(false);
        trackwatchPane.add(sep);
        Tripel<Date, Date, Long> trackingInfo = tupel.getElement2();
        Date startTime = trackingInfo.getElement1();
        Date stopTime = trackingInfo.getElement2();
        long pauseTime = trackingInfo.getElement3();
        long trackingTime = stopTime.getTime() - startTime.getTime();
        long pausedTotalMinutes = historyAreaTour.getPausedMinutes() != null ? (long)historyAreaTour.getPausedMinutes().intValue() : 0L;
        long addedPauseTime = pausedTotalMinutes * 60L * 1000L - pauseTime;
        long totalTrackingTime = trackingTime - pauseTime - addedPauseTime;
        boolean b = this.wageResult.getModel().getLength() == null;
        trackwatchPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.tracking.totaltime", new Serializable[0])));
        trackwatchPane.add(this.createDurationTextField(totalTrackingTime));
        trackwatchPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.start.time", new Serializable[0])));
        trackwatchPane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDate(startTime, "HH:mm:ss"), false));
        trackwatchPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.stop.time", new Serializable[0])));
        trackwatchPane.add(ClientSwingUtil.createTextField(b ? null : TimeUtil.formatDate(stopTime, "HH:mm:ss"), false));
        trackwatchPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.tracking.time", new Serializable[0])));
        trackwatchPane.add(this.createDurationTextField(trackingTime));
        trackwatchPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.pause.time", new Serializable[0])));
        trackwatchPane.add(this.createDurationTextField(pauseTime));
        trackwatchPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.addedpause.time", new Serializable[0])));
        trackwatchPane.add(this.createDurationTextField(addedPauseTime));
        trackwatchPane.add((Component)new JSeparator(0), "Center");
        JSeparator separator = new JSeparator(0);
        separator.setVisible(false);
        trackwatchPane.add(separator);
        long extraPauseTime = this.calculateExtraPauseTime(tracksForPeriodMap, historyAreaTour);
        long overallTrackingTime = trackingTime - pauseTime - addedPauseTime - extraPauseTime + throwingTime + preparationTime;
        trackwatchPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.overall.tracktime", new Serializable[0])));
        trackwatchPane.add(this.createDurationTextField(overallTrackingTime));
        trackwatchPane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.trackwatch.extrapause.time", new Serializable[0])));
        trackwatchPane.add(this.createDurationTextField(extraPauseTime));
        SpringUtilities.makeCompactGrid(trackwatchPane, 14, 2, 5, 5, 10, 7);
        return ClientSwingUtil.createPanelForComponent(trackwatchPane, null, "North");
    }

    private JTextField createDurationTextField(long time) {
        long fTime = Math.abs(time);
        JTextField textField = ClientSwingUtil.createTextField(TimeUtil.formatDurationToHourMinSec(fTime), false);
        if (this.wageResult.getModel().getLength() == null) {
            textField.setText(null);
        } else if (time < 0L) {
            textField.setForeground(Color.RED);
        }
        return textField;
    }

    private long calculateExtraPauseTime(Multimap<Integer, TrackWatchDataModel> tracksForPeriodMap, HistoryAreaTourModel historyAreaTour) {
        long extraPauseTime = 0L;
        WageParameterModel parameter = historyAreaTour.getParameter();
        if (parameter != null && parameter.getTrackPointCount() != null && parameter.getTrackPauseDistanceInMeter() != null) {
            int trackPointsCount = parameter.getTrackPointCount();
            int distance = parameter.getTrackPauseDistanceInMeter();
            if (trackPointsCount > 1 && distance > -1) {
                for (Integer period : tracksForPeriodMap.keySet()) {
                    ArrayList<TrackWatchDataModel> listTrackings = new ArrayList<TrackWatchDataModel>(tracksForPeriodMap.get(period));
                    while (!listTrackings.isEmpty()) {
                        int i;
                        ListIterator tracks = listTrackings.listIterator();
                        int distanceBetweenPoints = 0;
                        int pauseBetweenPoints = 0;
                        tracks.next();
                        boolean breakFlag = false;
                        for (i = 0; i < trackPointsCount - 1; ++i) {
                            if (tracks.hasNext()) {
                                TrackWatchDataModel track1 = (TrackWatchDataModel)tracks.previous();
                                tracks.next();
                                TrackWatchDataModel track2 = (TrackWatchDataModel)tracks.next();
                                if (track1.getGeoTrack() == null || track2.getGeoTrack() == null) continue;
                                if ((distanceBetweenPoints = (int)((double)distanceBetweenPoints + GeoUtils.getDistanceInMeter(track1.getGeoTrack(), track2.getGeoTrack()))) > distance) {
                                    listTrackings.remove(0);
                                    break;
                                }
                                if (track2.getTrackTime() == null || track1.getTrackTime() == null) continue;
                                pauseBetweenPoints = (int)((long)pauseBetweenPoints + (track2.getTrackTime().getTime() - track1.getTrackTime().getTime()));
                                continue;
                            }
                            breakFlag = true;
                            for (int j = 0; j <= i; ++j) {
                                if (listTrackings.isEmpty()) continue;
                                listTrackings.remove(0);
                            }
                            break;
                        }
                        if (distanceBetweenPoints > distance || breakFlag) continue;
                        extraPauseTime += (long)pauseBetweenPoints;
                        for (int j = 0; j < i; ++j) {
                            if (listTrackings.isEmpty()) continue;
                            listTrackings.remove(0);
                        }
                    }
                }
            }
        }
        return extraPauseTime;
    }

    protected List<HistoryAreaStopModel> getEstimatedTourStops(HistoryAreaTourModel historyAreaTour) {
        if (historyAreaTour == null) {
            return Collections.emptyList();
        }
        return WageDeltaModelUtil.getEstimatedStopsDataForTour(historyAreaTour);
    }

    private Multimap<Integer, TrackWatchDataModel> getGeoTracksForTour(HistoryAreaTourModel historyAreaTour) {
        Comparator<TrackWatchDataModel> comparator = new Comparator<TrackWatchDataModel>(){

            @Override
            public int compare(TrackWatchDataModel o1, TrackWatchDataModel o2) {
                return o1.getTrackTime().compareTo(o2.getTrackTime());
            }
        };
        TreeMultimap<Integer, TrackWatchDataModel> geoPoints = TreeMultimap.create(Ordering.natural(), comparator);
        if (historyAreaTour == null) {
            return geoPoints;
        }
        List<TrackWatchDataModel> tracksList = WageDeltaModelUtil.getTrackWatchDataForTour(historyAreaTour);
        for (TrackWatchDataModel tracking : tracksList) {
            if (tracking.getGeoTrack() == null) continue;
            geoPoints.put(tracking.getEventPeriod(), tracking);
        }
        return geoPoints;
    }

    private JTextField createTextField(String text, String fieldName, Holder<?> object) {
        return this.createTextField(text, fieldName, object, this.editable);
    }

    private JTextField createTextField(String text, String fieldName, Holder<?> object, boolean editable) {
        return ClientSwingUtil.createParameterTextField(10, text, editable, fieldName, object, this);
    }

    private JPanel createControlPanel() {
        JPanel controlPanel = new JPanel(new FlowLayout());
        BasicArrowButton leftButton = new BasicArrowButton(7);
        leftButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        leftButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -8946496325538682806L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryAreaTourDialog.this.next(-1);
            }
        });
        controlPanel.add(leftButton);
        JLabel indexLabel = new JLabel(this.list.indexOf(this.wageResult) + 1 + "/" + this.list.size());
        controlPanel.add(indexLabel);
        BasicArrowButton rightButton = new BasicArrowButton(3);
        rightButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        rightButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -8946496325538682806L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryAreaTourDialog.this.next(1);
            }
        });
        controlPanel.add(rightButton);
        return controlPanel;
    }

    private void next(int step) {
        int currentIndex = this.list.indexOf(this.wageResult);
        if ((currentIndex += step) < 0) {
            currentIndex = this.list.size() - 1;
        } else if (currentIndex > this.list.size() - 1) {
            currentIndex = 0;
        }
        this.wageResult = this.list.get(currentIndex);
        this.getContentPane().removeAll();
        this.buildLayout();
        this.add((Component)this.createControlPanel(), "First");
        this.pack();
    }

    public static void createAndShow(List<HistoryAreaTourModelWageResult> list, ModelEnviroment modelEnviroment, Window parent) {
        boolean editable = ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER);
        HistoryAreaTourDialog dialog = new HistoryAreaTourDialog(list, modelEnviroment, editable, parent);
        dialog.pack();
        SwingUtils.center((Window)dialog, parent);
        dialog.setSize(dialog.getWidth(), dialog.getHeight() + 100);
        dialog.setVisible(true);
    }

    private static HistoryAreaTourModel refresh(HistoryAreaTourModel model, ModelEnviroment modelEnviroment) {
        modelEnviroment.getModelCache().refreshRek(model);
        return model;
    }

    private abstract class EnumComboBoxAdapter<T extends Enum<T>>
    extends EnumComboBox<T>
    implements ItemListener {
        private static final long serialVersionUID = 5253903619453380430L;
        private boolean editable;
        final /* synthetic */ HistoryAreaTourDialog this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public EnumComboBoxAdapter(Class<T> clazz, T t, boolean withEmpty, boolean editable) {
            this.this$0 = (HistoryAreaTourDialog)n;
            super(clazz, withEmpty);
            this.editable = editable;
            this.setSelectedValue(t);
            this.setEnabled(editable);
            this.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this.editable && e.getStateChange() == 1) {
                this.doAfterSelect(super.getSelectedValue());
            }
        }

        protected abstract void doAfterSelect(T var1);
    }
}

