/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.wage;

import de.datomino.peppergis.client.util.wage.WageDeltaModelUtil;
import de.datomino.util.time.TimeUtil;
import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DifferenceDocumentListener
implements DocumentListener {
    private JTextField startTime;
    private JTextField endTime;
    private JTextField difference;
    private JTextField pause;
    private String dateFormat;

    public DifferenceDocumentListener(JTextField startTime, JTextField endTime, JTextField pause, JTextField difference, String dateFormat) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.difference = difference;
        this.dateFormat = dateFormat;
        this.pause = pause;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setDifference();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setDifference();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setDifference();
    }

    private void setDifference() {
        try {
            long time = WageDeltaModelUtil.getTimeForDifference(this.startTime.getText(), this.endTime.getText(), this.pause.getText(), this.dateFormat);
            this.difference.setText(TimeUtil.formatDurationToHourMinSec(Math.abs(time)));
            this.difference.setForeground(time < 0L ? Color.RED : Color.BLACK);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

