/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util.model.location;

import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.util.model.location.AbstractLocationWrapper;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.international.country.Country;
import org.apache.commons.lang.math.NumberUtils;

public class ParcelLocationWrapper
extends AbstractLocationWrapper {
    private ParcelModel parcelModel;
    private StreetModel streetModel;

    public ParcelLocationWrapper(ParcelModel parcelModel) {
        this.parcelModel = parcelModel;
        this.streetModel = parcelModel.getStreet();
        super.setMotorSegment(parcelModel.getMotorSegment());
        super.setFootSegment(parcelModel.getFootSegment());
        super.setBikeSegment(parcelModel.getBikeSegment());
    }

    @Override
    public Long getId() {
        return this.parcelModel.getTempUUID();
    }

    @Override
    public String getInformation() {
        return null;
    }

    @Override
    public void setInformation(String information) {
    }

    @Override
    public Country getCountry() {
        return this.streetModel == null ? null : this.streetModel.getPostcodeDistrictRelation().getPostcode().getCountry();
    }

    @Override
    public void setCountry(Country country) {
        this.streetModel.getPostcodeDistrictRelation().getPostcode().setCountry(country);
    }

    @Override
    public String getCity() {
        DistrictModel districtModel = this.streetModel == null ? null : this.streetModel.getPostcodeDistrictRelation().getDistrict();
        return districtModel == null ? "" : districtModel.getCity().getName();
    }

    @Override
    public void setCity(String city) {
        DistrictModel districtModel = this.streetModel.getPostcodeDistrictRelation().getDistrict();
        districtModel.getCity().setName(city);
    }

    @Override
    public String getDistrict() {
        return this.streetModel == null ? null : this.streetModel.getPostcodeDistrictRelation().getDistrict().getName();
    }

    @Override
    public void setDistrict(String district) {
        this.streetModel.getPostcodeDistrictRelation().getDistrict().setName(district);
    }

    @Override
    public String getPostcode() {
        return this.streetModel == null ? null : this.streetModel.getPostcodeDistrictRelation().getPostcode().getName();
    }

    @Override
    public void setPostcode(String postcode) {
        this.streetModel.getPostcodeDistrictRelation().getPostcode().setName(postcode);
    }

    @Override
    public String getStreet() {
        return this.streetModel == null ? "" : this.streetModel.getName();
    }

    @Override
    public void setStreet(String street) {
        this.streetModel.setName(street);
    }

    @Override
    public Integer getHousenumber() {
        Integer number = null;
        if (NumberUtils.isDigits(this.parcelModel.getHouseNumber())) {
            number = Integer.valueOf(this.parcelModel.getHouseNumber());
        }
        return number;
    }

    @Override
    public void setHousenumber(Integer housenumber) {
        this.parcelModel.setHouseNumber(String.valueOf(housenumber));
    }

    @Override
    public String getHousenumberExtension() {
        return this.parcelModel.getHouseNumberExtension();
    }

    @Override
    public void setHousenumberExtension(String housenumberExtension) {
        this.parcelModel.setHouseNumberExtension(housenumberExtension);
    }

    @Override
    public ImmutablePoint getGeoLocation() {
        ImmutablePoint geom = this.parcelModel.getGeom();
        return GeoUtil.isNullPoint(geom) ? null : geom;
    }

    @Override
    public void setGeoLocation(ImmutablePoint geoLocation) {
        this.parcelModel.setGeom(geoLocation);
    }

    @Override
    public Double getParcelLocation() {
        for (ParcelAttributeValueModel value : this.parcelModel.iterableParcelAttributeValues()) {
            ParcelAttributeValueDescriptorModel descriptor = value.getParcelAttributeValueDescriptor();
            if (descriptor == null || !descriptor.getKey().equals("PARCEL-LOCATION")) continue;
            return value.getFloatValue();
        }
        return null;
    }

    @Override
    public void setParcelLocation(Double parcelLocation) {
        for (ParcelAttributeValueModel value : this.parcelModel.iterableParcelAttributeValues()) {
            ParcelAttributeValueDescriptorModel descriptor = value.getParcelAttributeValueDescriptor();
            if (descriptor == null || !descriptor.getKey().equals("PARCEL-LOCATION")) continue;
            value.setFloatValue(parcelLocation);
        }
    }

    public ParcelModel getParcel() {
        return this.parcelModel;
    }

    @Override
    public ImmutablePoint getRealGeoLocation() {
        return this.parcelModel.getGeom();
    }
}

