/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util.model.location;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.ExternalLocationModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.mobile.LocationCapturingModel;
import de.datomino.peppergis.client.util.model.location.ExternalLocationWrapper;
import de.datomino.peppergis.client.util.model.location.ImportedLocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationCapturingLocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.NullLocationWrapper;
import de.datomino.peppergis.client.util.model.location.ParcelLocationWrapper;
import de.datomino.util.international.country.Country;

public class LocationWrapperFactory {
    public static final LocationWrapperFactory INSTANCE;
    private Country defaultCountry;

    protected LocationWrapperFactory(Country defaultCountry) {
        this.defaultCountry = defaultCountry;
    }

    public LocationWrapper createLocationWrapper(ImportedLocationModel importedLocationModel) {
        return new ImportedLocationWrapper(importedLocationModel);
    }

    public LocationWrapper createLocationWrapper(ExternalLocationModel externalLocationModel) {
        return new ExternalLocationWrapper(externalLocationModel);
    }

    public LocationWrapper createLocationWrapper(ParcelModel parcelModel) {
        return new ParcelLocationWrapper(parcelModel);
    }

    public LocationWrapper createLocationWrapper(LocationCapturingModel locationCapturingModel) {
        return new LocationCapturingLocationWrapper(locationCapturingModel);
    }

    public LocationWrapper createLocationWrapper(LocationModel locationModel) {
        LocationWrapper locationWrapper;
        if (locationModel == null) {
            return null;
        }
        ImportedLocationModel importedLocationModel = locationModel.getImportedLocation();
        ExternalLocationModel externalLocationModel = locationModel.getExternalLocation();
        ParcelModel parcelModel = locationModel.getParcel();
        if (parcelModel != null) {
            locationWrapper = INSTANCE.createLocationWrapper(parcelModel);
            locationWrapper.setMotorSegment(parcelModel.getMotorSegment());
            locationWrapper.setFootSegment(parcelModel.getFootSegment());
            locationWrapper.setBikeSegment(parcelModel.getBikeSegment());
        } else if (importedLocationModel != null) {
            locationWrapper = INSTANCE.createLocationWrapper(importedLocationModel);
            locationWrapper.setMotorSegment(locationModel.getMotorSegment());
            locationWrapper.setFootSegment(locationModel.getFootSegment());
            locationWrapper.setBikeSegment(locationModel.getBikeSegment());
        } else if (externalLocationModel != null) {
            locationWrapper = INSTANCE.createLocationWrapper(externalLocationModel);
            locationWrapper.setMotorSegment(locationModel.getMotorSegment());
            locationWrapper.setFootSegment(locationModel.getFootSegment());
            locationWrapper.setBikeSegment(locationModel.getBikeSegment());
        } else {
            locationWrapper = INSTANCE.createNullLocationWrapper();
        }
        return locationWrapper;
    }

    public LocationWrapper createNullLocationWrapper() {
        return new NullLocationWrapper(this.defaultCountry);
    }

    static {
        ModelEnviroment modelEnviroment = new ModelEnviroment(null);
        Country country = modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry();
        INSTANCE = new LocationWrapperFactory(country);
        modelEnviroment.close();
    }
}

