/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util.model.location;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractLocationWrapper
implements LocationWrapper {
    private SegmentModel motorSegment;
    private SegmentModel footSegment;
    private SegmentModel bikeSegment;

    @Override
    public ImmutablePoint getAccessLocation(RouteVehicleType routeVehicleType) {
        SegmentModel segment = null;
        switch (routeVehicleType) {
            case MOTORCAR: {
                segment = this.motorSegment;
                break;
            }
            case BIKE: {
                segment = this.bikeSegment;
                break;
            }
            case FOOT: {
                segment = this.footSegment;
            }
        }
        if (segment == null) {
            return this.getGeoLocation();
        }
        Tupel<Double, ImmutablePoint> tupel = GeoUtil.getShortestPerpendicular(this.getGeoLocation(), segment.getGeom());
        return tupel.getElement2();
    }

    @Override
    public SegmentModel getMotorSegment() {
        return this.motorSegment;
    }

    @Override
    public void setMotorSegment(SegmentModel segment) {
        this.motorSegment = segment;
    }

    @Override
    public SegmentModel getFootSegment() {
        return this.footSegment;
    }

    @Override
    public void setFootSegment(SegmentModel segment) {
        this.footSegment = segment;
    }

    @Override
    public SegmentModel getBikeSegment() {
        return this.bikeSegment;
    }

    @Override
    public void setBikeSegment(SegmentModel bikeSegment) {
        this.bikeSegment = bikeSegment;
    }

    @Override
    public Double getParcelLocation() {
        return null;
    }

    @Override
    public void setParcelLocation(Double parcelLocation) {
    }

    @Override
    public boolean isAddressEqual(LocationWrapper locationWrapper) {
        return this.isAddressEqual(locationWrapper, true);
    }

    @Override
    public boolean isAddressEqual(LocationWrapper locationWrapper, boolean withCountry) {
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        if (withCountry) {
            equalsBuilder.append(this.getCountry(), locationWrapper.getCountry());
        }
        return equalsBuilder.append(this.getPostcode(), locationWrapper.getPostcode()).append(this.getCity(), locationWrapper.getCity()).append(this.getDistrict(), locationWrapper.getDistrict()).append(this.getStreet(), locationWrapper.getStreet()).append(this.getHousenumber(), locationWrapper.getHousenumber()).append(this.getHousenumberExtension(), locationWrapper.getHousenumberExtension()).isEquals();
    }

    @Override
    public boolean isCoordEqual(LocationWrapper locationWrapper) {
        return this.isCoordEqual(locationWrapper, 0.0);
    }

    @Override
    public boolean isCoordEqual(LocationWrapper locationWrapper, double toleranceInMeter) {
        ImmutablePoint geoLocation2;
        ImmutablePoint geoLocation = this.getGeoLocation();
        if (geoLocation == (geoLocation2 = locationWrapper.getGeoLocation())) {
            return true;
        }
        if (geoLocation == null || geoLocation2 == null) {
            return false;
        }
        double dist = GeoUtils.getDistanceInMeter(geoLocation.getCoordinate(), geoLocation2.getCoordinate());
        return dist < toleranceInMeter;
    }
}

