/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util.filter.poi;

import de.datomino.peppergis.client.model.base.PoiAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.PoiAttributeValueModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.PoiStaticChoiceAttributeValueModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.model.filter.PoiFilterModel;
import de.datomino.peppergis.client.util.filter.AbstractFilterChecker;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueModel;
import de.datomino.peppergis.client.util.wrapper.poi.attribute.PoiAttributeValueModelAttributeWrapper;
import de.datomino.peppergis.type.PoiType;
import de.datomino.peppergis.type.filter.ObjectFilter;
import java.util.ArrayList;
import java.util.Collection;
import org.ktde.util.StringUtil;

public class PoiFilterChecker
extends AbstractFilterChecker<PoiFilterModel, PoiModel, PoiAttributeValueModel, PoiStaticChoiceAttributeValueModel, PoiAttributeValueDescriptorModel> {
    public PoiFilterChecker(ObjectFilter<PoiFilterModel, AttributeValueFilterModel> modelObjectFilter) {
        super(modelObjectFilter);
    }

    @Override
    protected Collection<AttributeValueModel<PoiAttributeValueModel, PoiStaticChoiceAttributeValueModel, PoiAttributeValueDescriptorModel>> getAttributeValueModels(PoiModel model) {
        ArrayList<AttributeValueModel<PoiAttributeValueModel, PoiStaticChoiceAttributeValueModel, PoiAttributeValueDescriptorModel>> list = new ArrayList<AttributeValueModel<PoiAttributeValueModel, PoiStaticChoiceAttributeValueModel, PoiAttributeValueDescriptorModel>>(model.countPoiAttributeValues());
        for (PoiAttributeValueModel poiAttributeValueModel : model.iterablePoiAttributeValues()) {
            list.add(new PoiAttributeValueModelAttributeWrapper(poiAttributeValueModel));
        }
        return list;
    }

    @Override
    protected boolean satisfiesSpecial(PoiModel model, ObjectFilter<PoiFilterModel, AttributeValueFilterModel> modelObjectFilter) {
        String poiNumber;
        PoiFilterModel poiFilterModel = (PoiFilterModel)modelObjectFilter.getAttachedObject();
        String poiNumberPattern = poiFilterModel.getPoiNumber();
        if (!StringUtil.isBlank(poiNumberPattern) && !(poiNumber = StringUtil.nullToEmpty(model.getPoiNumber())).matches(poiNumberPattern.replace("*", ".*"))) {
            return false;
        }
        PoiType poiType = poiFilterModel.getPoiType();
        return poiType == null || poiType == model.getPoiType();
    }
}

