/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util.filter;

import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.client.model.filter.SimpleAttributeValueFilterModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueModel;
import de.datomino.peppergis.type.attribute.StaticChoiceValue;
import de.datomino.peppergis.type.filter.ObjectFilter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.lang.builder.EqualsBuilder;

public abstract class AbstractFilterChecker<T extends Model, W extends Model, A extends Model, B extends Model, C extends Model> {
    private ObjectFilter<T, AttributeValueFilterModel> modelObjectFilter;
    private static final Comparator<Date> DATE_COMPARATOR = ComparatorUtils.nullHighComparator(ComparatorUtils.naturalComparator());
    private static final Comparator<String> STRING_COMPARATOR = ComparatorUtils.nullHighComparator(ComparatorUtils.naturalComparator());
    private static final Comparator<Number> NUMBER_COMPARATOR = ComparatorUtils.nullHighComparator(new Comparator<Number>(){

        @Override
        public int compare(Number n1, Number n2) {
            if (n1 instanceof Double || n2 instanceof Double) {
                return Double.compare(n1.doubleValue(), n2.doubleValue());
            }
            return n1.intValue() - n2.intValue();
        }
    });

    public AbstractFilterChecker(ObjectFilter<T, AttributeValueFilterModel> modelObjectFilter) {
        this.modelObjectFilter = modelObjectFilter;
    }

    public boolean satisfiesFilter(W model) {
        boolean b = this.satisfiesSpecial(model, this.modelObjectFilter);
        if (b) {
            b = this.satisfiesAttributeFilter(model, this.modelObjectFilter.getAttributeValueFilter());
        }
        return b;
    }

    private boolean satisfiesAttributeFilter(W model, AttributeValueFilterModel attributeValueFilter) {
        Collection<AttributeValueModel<A, B, C>> attributeValueModels = this.getAttributeValueModels(model);
        HashMap<String, AttributeValueModel<A, B, C>> attributes = new HashMap<String, AttributeValueModel<A, B, C>>();
        for (AttributeValueModel<A, B, C> attributeValueModel : attributeValueModels) {
            attributes.put(attributeValueModel.getAttributeValueDescriptor().getKey(), attributeValueModel);
        }
        return attributeValueFilter == null || this.satisfiesAttributeFilterRek(attributes, attributeValueFilter);
    }

    private boolean satisfiesAttributeFilterRek(Map<String, AttributeValueModel<A, B, C>> attributes, AttributeValueFilterModel attributeValueFilter) {
        switch (attributeValueFilter.getAttributeValueFilterType()) {
            case AND: {
                for (AttributeValueFilterModel childAttributeValueFilterModel : attributeValueFilter.iterableChildAttributeValueFilters()) {
                    boolean b = this.satisfiesAttributeFilterRek(attributes, childAttributeValueFilterModel);
                    if (b) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (AttributeValueFilterModel childAttributeValueFilterModel : attributeValueFilter.iterableChildAttributeValueFilters()) {
                    boolean b = this.satisfiesAttributeFilterRek(attributes, childAttributeValueFilterModel);
                    if (!b) continue;
                    return true;
                }
                return false;
            }
            case NOT: {
                boolean b = this.satisfiesAttributeFilterRek(attributes, attributeValueFilter.getChildAttributeValueFilterAt(0));
                return !b;
            }
            case SIMPLE: {
                return this.satisfiesSimple(attributes, attributeValueFilter.getSimpleAttriubteValueFilter());
            }
        }
        throw new RuntimeException();
    }

    private boolean satisfiesSimple(Map<String, AttributeValueModel<A, B, C>> attributes, SimpleAttributeValueFilterModel simpleAttriubteValueFilter) {
        int d;
        AttributeValueModel<A, B, C> attributeValueModel = attributes.get(simpleAttriubteValueFilter.getKey());
        if (attributeValueModel == null) {
            return false;
        }
        String refValue = simpleAttriubteValueFilter.getRefKeyValue();
        boolean constant = refValue == null;
        AttributeValueModel<A, B, C> other = constant ? null : attributes.get(refValue);
        switch (attributeValueModel.getAttributeValueDescriptor().getAttributeValueType()) {
            case BOOLEAN: {
                Boolean valueBooleanValue;
                Boolean bl = valueBooleanValue = attributeValueModel == null ? null : attributeValueModel.getBooleanValue();
                Boolean filterBooleanValue = constant ? simpleAttriubteValueFilter.getBooleanValue() : (other == null ? null : other.getBooleanValue());
                switch (simpleAttriubteValueFilter.getRelation()) {
                    case EQUALS: {
                        return new EqualsBuilder().append(valueBooleanValue, filterBooleanValue).isEquals();
                    }
                }
                return false;
            }
            case DATE: {
                Date valueDate;
                Long long1 = attributeValueModel.getLongValue();
                Date date = attributeValueModel == null ? null : (valueDate = long1 == null ? null : new Date(long1));
                Long long2 = constant ? simpleAttriubteValueFilter.getLongValue() : (other == null ? null : other.getLongValue());
                Date filterDate = long2 == null ? null : new Date(long2);
                d = DATE_COMPARATOR.compare(valueDate, filterDate);
                break;
            }
            case INTEGER: {
                Integer valueInt;
                Integer n = valueInt = attributeValueModel == null ? null : attributeValueModel.getIntegerValue();
                Integer filterInt = constant ? simpleAttriubteValueFilter.getIntegerValue() : (other == null ? null : this.getNumberValue(other));
                d = NUMBER_COMPARATOR.compare(valueInt, filterInt);
                break;
            }
            case STATIC_CHOICE: {
                String filterStaticChoice;
                StaticChoiceValue staticChoiceValueModel;
                StaticChoiceValue staticChoiceValue = staticChoiceValueModel = attributeValueModel == null ? null : attributeValueModel.getStaticChoiceValue();
                if (constant) {
                    filterStaticChoice = simpleAttriubteValueFilter.getStaticChoiceValue();
                } else {
                    StaticChoiceValue otherStaticChoiceValue = other == null ? null : other.getStaticChoiceValue();
                    filterStaticChoice = otherStaticChoiceValue == null ? null : otherStaticChoiceValue.getValue();
                }
                switch (simpleAttriubteValueFilter.getRelation()) {
                    case EQUALS: {
                        return new EqualsBuilder().append(staticChoiceValueModel == null ? null : staticChoiceValueModel.getValue(), filterStaticChoice).isEquals();
                    }
                }
                return false;
            }
            case STRING: {
                String valueString;
                String string = valueString = attributeValueModel == null ? null : attributeValueModel.getStringValue();
                String filterString = constant ? simpleAttriubteValueFilter.getStringValue() : (other == null ? null : other.getStringValue());
                d = STRING_COMPARATOR.compare(valueString, filterString);
                break;
            }
            case TEXT: {
                String valueString;
                String string = valueString = attributeValueModel == null ? null : attributeValueModel.getTextValue();
                String filterString = constant ? simpleAttriubteValueFilter.getTextValue() : (other == null ? null : other.getTextValue());
                d = STRING_COMPARATOR.compare(valueString, filterString);
                break;
            }
            case FLOAT: {
                Double valueDouble;
                Double d2 = valueDouble = attributeValueModel == null ? null : attributeValueModel.getFloatValue();
                Double filterDouble = constant ? simpleAttriubteValueFilter.getFloatValue() : (other == null ? null : this.getNumberValue(other));
                d = NUMBER_COMPARATOR.compare(valueDouble, filterDouble);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        switch (simpleAttriubteValueFilter.getRelation()) {
            case EQUALS: {
                return d == 0;
            }
            case GE: {
                return d >= 0;
            }
            case GT: {
                return d > 0;
            }
            case LE: {
                return d <= 0;
            }
            case LT: {
                return d < 0;
            }
        }
        return false;
    }

    private Number getNumberValue(AttributeValueModel<A, B, C> other) {
        switch (other.getAttributeValueDescriptor().getAttributeValueType()) {
            case INTEGER: {
                return other.getIntegerValue();
            }
            case FLOAT: {
                return other.getFloatValue();
            }
        }
        return null;
    }

    protected abstract Collection<AttributeValueModel<A, B, C>> getAttributeValueModels(W var1);

    protected abstract boolean satisfiesSpecial(W var1, ObjectFilter<T, AttributeValueFilterModel> var2);
}

