/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util.attribute;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.type.attribute.AttributeValue;
import de.datomino.peppergis.type.attribute.AttributeValueDescriptor;
import de.datomino.peppergis.type.attribute.StaticChoiceValue;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.common.PrimitiveUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class AttributeHelper {
    public static List<Tupel<String, String>> getTupelsForPrint(Collection<? extends AttributeValueDescriptor<?, ?>> descriptors, Collection<? extends AttributeValue<?, ?, ?>> attributeValueModelAttributeWrappers) {
        ArrayList<Tupel<String, String>> list = new ArrayList<Tupel<String, String>>(descriptors.size());
        for (AttributeValueDescriptor<?, ?> descriptor : descriptors) {
            String key = descriptor.getKey();
            String value = "";
            for (AttributeValue<?, ?, ?> attributeValue : attributeValueModelAttributeWrappers) {
                if (!key.equals(attributeValue.getAttributeValueDescriptor().getKey())) continue;
                value = AttributeHelper.getTextRepresentationValue(attributeValue);
                break;
            }
            list.add(new Tupel<String, String>(StringEscapeUtils.escapeXml(descriptor.getName()), StringEscapeUtils.escapeXml(value)));
        }
        return list;
    }

    public static List<Tupel<String, String>> getTupelsForPrintFromMap(Map<Long, ? extends AttributeValue<?, ?, ?>> map, List<? extends AttributeValueDescriptor<?, ?>> descriptors) {
        ArrayList<Tupel<String, String>> list = new ArrayList<Tupel<String, String>>(descriptors.size());
        for (AttributeValueDescriptor<?, ?> descriptor : descriptors) {
            AttributeValue<?, ?, ?> attributeValue = map.get(descriptor.getId());
            String value = "";
            if (attributeValue != null) {
                value = StringUtil.nullToEmpty(AttributeHelper.getTextRepresentationValue(attributeValue));
            }
            list.add(new Tupel<String, String>(descriptor.getName(), value));
        }
        return list;
    }

    public static String getTextRepresentationValue(AttributeValue<?, ?, ?> attributeValue) {
        return AttributeHelper.getTextRepresentationValue(attributeValue, FormUtil.TIMEFORMAT);
    }

    public static String getTextRepresentationValue(AttributeValue<?, ?, ?> attributeValue, String dateFormat) {
        String value = null;
        switch (attributeValue.getAttributeValueDescriptor().getAttributeValueType()) {
            case BOOLEAN: {
                boolean bool = PrimitiveUtil.nullToFalse(attributeValue.getBooleanValue());
                value = ModelEnviroment.getMessageResolver().resolveMessage("messages.default." + (bool ? "yes" : "no"), new Serializable[0]);
                break;
            }
            case DATE: {
                Long timestamp = attributeValue.getLongValue();
                if (timestamp == null) {
                    value = "";
                    break;
                }
                Date date = new Date(timestamp);
                SimpleDateFormat f = dateFormat == null ? new SimpleDateFormat() : new SimpleDateFormat(dateFormat);
                value = f.format(date);
                break;
            }
            case INTEGER: {
                value = StringUtil.nullToEmpty(attributeValue.getIntegerValue());
                break;
            }
            case STATIC_CHOICE: {
                StaticChoiceValue<?, ?> staticChoiceValue = attributeValue.getStaticChoiceValue();
                if (staticChoiceValue == null) {
                    value = "";
                    break;
                }
                value = staticChoiceValue.getName() + " (" + staticChoiceValue.getValue() + ")";
                break;
            }
            case STRING: {
                value = StringUtil.nullToEmpty(attributeValue.getStringValue());
                break;
            }
            case TEXT: {
                value = StringUtil.nullToEmpty(attributeValue.getTextValue());
                break;
            }
            case FLOAT: {
                value = StringUtil.nullToEmpty(attributeValue.getFloatValue());
                break;
            }
        }
        return value;
    }

    public static String getStringRepresentationForMultiInteger(String string) {
        Tripel<Integer, Integer[], Integer[]> tripel = AttributeHelper.getValuesForMultiInteger(string);
        NameGenerator<Integer> nameGenerator = new NameGenerator<Integer>(){

            @Override
            public String getName(Integer t) {
                return t == null ? "" : t.toString();
            }
        };
        return StringUtil.implode(Arrays.asList((Object[])tripel.getElement2()), "/", nameGenerator) + " - " + StringUtil.implode(Arrays.asList((Object[])tripel.getElement3()), "/", nameGenerator);
    }

    public static Tripel<Integer, Integer[], Integer[]> getValuesForMultiInteger(String string) {
        String defs;
        Integer[] empty = new Integer[]{};
        if (string == null) {
            return new Tripel<Integer, Integer[], Integer[]>(0, empty, empty);
        }
        int index = string.indexOf(64);
        if (index < 0) {
            return new Tripel<Integer, Integer[], Integer[]>(0, empty, empty);
        }
        int count = Integer.parseInt(string.substring(0, index));
        String values = string.substring(index + 1);
        if ((index = values.indexOf(35)) < 0) {
            defs = values;
            values = "";
        } else {
            defs = values.substring(0, index);
            values = values.substring(index + 1);
        }
        String[] defArray = StringUtil.splitByChar(defs, '/');
        Integer[] defInteger = new Integer[count];
        for (int i = 0; i < Math.min(defArray.length, count); ++i) {
            try {
                defInteger[i] = Integer.valueOf(defArray[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String[] valueArray = StringUtil.splitByChar(values, '/');
        Integer[] valueInteger = new Integer[count];
        for (int i = 0; i < Math.min(valueArray.length, count); ++i) {
            try {
                valueInteger[i] = Integer.valueOf(valueArray[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Tripel<Integer, Integer[], Integer[]>(count, defInteger, valueInteger);
    }

    public static String getStringValueForMultiInteger(Tripel<Integer, Integer[], Integer[]> tripel) {
        StringBuilder sb = new StringBuilder(tripel.getElement1().toString()).append("@");
        NameGenerator<Integer> nameGenerator = new NameGenerator<Integer>(){

            @Override
            public String getName(Integer t) {
                return t == null ? "" : t.toString();
            }
        };
        sb.append(StringUtil.implode(Arrays.asList((Object[])tripel.getElement2()), "/", nameGenerator)).append("#").append(StringUtil.implode(Arrays.asList((Object[])tripel.getElement3()), "/", nameGenerator));
        return sb.toString();
    }
}

