/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.util.FormUtil;
import java.io.Serializable;
import org.ktde.util.StringUtil;

public class TourInfoObject {
    public String shortcut;
    public String displayname;
    public Integer distance;
    public Integer accessDistance;
    public Integer streetDistance;
    public Integer duration;
    public Integer accessDuration;
    public Integer streetDuration;
    public Integer sum;

    public TourInfoObject(String shortcut, String displayname) {
        this(shortcut, displayname, null, null, null);
    }

    public TourInfoObject(String shortcut, String displayname, Integer distance, Integer duration, Integer sum) {
        this(shortcut, displayname, distance, null, null, duration, null, null, sum);
    }

    public TourInfoObject(String shortcut, String displayname, Integer distance, Integer accessDistance, Integer streetDistance, Integer duration, Integer accessDuration, Integer streetDuration, Integer sum) {
        this.shortcut = shortcut;
        this.displayname = displayname;
        this.distance = distance;
        this.accessDistance = accessDistance;
        this.streetDistance = streetDistance;
        this.duration = duration;
        this.accessDuration = accessDuration;
        this.streetDuration = streetDuration;
        this.sum = sum;
    }

    public String getString() {
        return this.getString("%%%shortcut%%% - %%%displayname%%%\n%%%duration%%%\n%%%distance%%%\n%%%sum%%%");
    }

    public String getString(String pattern) {
        String distanceString;
        String durationString;
        String s = ModelEnviroment.getMessageResolver().resolveMessage("gui.area.areaObject", new Serializable[0]) + " - " + pattern;
        s = s.replaceAll("%%%shortcut%%%", StringUtil.getNotNull(this.shortcut));
        s = s.replaceAll("%%%displayname%%%", StringUtil.getNotNull(this.displayname));
        String string = durationString = this.duration == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.duration", new Serializable[]{FormUtil.getSecondTimeString(this.duration)});
        if (this.accessDuration != null && this.streetDuration != null) {
            durationString = durationString + "(Strasse: " + FormUtil.getSecondTimeString(this.streetDuration);
            durationString = durationString + "- Geb\u00e4ude: " + FormUtil.getSecondTimeString(this.accessDuration) + ")";
        }
        s = s.replaceAll("%%%duration%%%", durationString);
        String distanceDisplay = ClientFormUtil.getDistanceDisplay(this.distance, " " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.meter", new Serializable[0]));
        String string2 = distanceString = this.distance == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.distance", new Serializable[0]) + ": " + distanceDisplay;
        if (this.streetDistance != null && this.accessDistance != null) {
            distanceString = distanceString + " (" + ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.street", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(this.streetDistance, "");
            distanceString = distanceString + "- " + ModelEnviroment.getMessageResolver().resolveMessage("messages.parcels", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(this.accessDistance, "") + ")";
        }
        s = s.replaceAll("%%%distance%%%", distanceString);
        s = s.replaceAll("%%%sum%%%", this.sum == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.stopSum", new Serializable[0]) + ": " + this.sum);
        return s;
    }

    public String getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(String shortcut) {
        this.shortcut = shortcut;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    public Integer getAccessDistance() {
        return this.accessDistance;
    }

    public void setAccessDistance(Integer accessDistance) {
        this.accessDistance = accessDistance;
    }

    public Integer getStreetDistance() {
        return this.streetDistance;
    }

    public void setStreetDistance(Integer streetDistance) {
        this.streetDistance = streetDistance;
    }

    public Integer getAccessDuration() {
        return this.accessDuration;
    }

    public void setAccessDuration(Integer accessDuration) {
        this.accessDuration = accessDuration;
    }

    public Integer getStreetDuration() {
        return this.streetDuration;
    }

    public void setStreetDuration(Integer streetDuration) {
        this.streetDuration = streetDuration;
    }

    public Integer getSum() {
        return this.sum;
    }

    public void setSum(Integer sum) {
        this.sum = sum;
    }
}

