/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.client.auth.UserInformation;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueModel;
import de.datomino.peppergis.client.model.base.SubscriptionBreakTimeModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.base.SubscriptionSortOrderModel;
import de.datomino.peppergis.client.model.base.SubscriptionSortOrderModelImpl;
import de.datomino.peppergis.client.model.base.SubscriptionStaticChoiceAttributeValueModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.util.AreaTourModelUtil;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.client.util.wrapper.subscription.attribute.SubscriptionAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.print.PrintContentValue;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.print.TableCellEntity;
import de.datomino.peppergis.print.TableRowEntity;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.PrintContentKey;
import de.datomino.peppergis.type.SubscriptionStatus;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.NumericUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.Color;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class SubscriptionModelUtil {
    public static String getDisplayString(SubscriptionModel subscription) {
        String name;
        LocationModel location = subscription.getLocation();
        StringBuilder sb = new StringBuilder();
        String subscriptionNumber = subscription.getSubscriptionNumber();
        boolean blankSubscriptionNumber = StringUtil.isBlank(subscriptionNumber);
        if (!blankSubscriptionNumber) {
            sb.append(subscriptionNumber.trim());
        }
        if (!StringUtil.isBlank(name = subscription.getCustomer().getName())) {
            if (!blankSubscriptionNumber) {
                sb.append(", ");
            }
            sb.append(name.trim());
        }
        sb.append(": ").append(LocationModelUtil.getAddressString(location, true));
        return sb.toString();
    }

    public static String getDisplayStringStartingWithSubscriptionNumber(SubscriptionModel subscription) {
        LocationModel location = subscription.getLocation();
        String info = subscription.getSubscriptionNumber() + ": " + LocationModelUtil.getAddressString(location, true);
        return info;
    }

    public static void getPrintInformation(LegendObject<SubscriptionModel> legendObject, List<SubscriptionAttributeValueDescriptorModelAttributeWrapper> descriptorsForPrinting, Color color, PrinterInformation.LineGroupType group, TableRowEntity row, Map<PrintPropertyKey, Serializable> subscriptionProperties, boolean mixed) {
        SubscriptionModel subscription = legendObject.getM();
        LocationModel location = subscription.getLocation();
        LocationModelUtil.getPrintingInformation(location, color, group, row, subscriptionProperties);
        if (group == PrinterInformation.LineGroupType.NORMAL) {
            Integer distanceValue = legendObject.getStreetMileageMetersFromTourStart();
            Integer durationValue = legendObject.getEstimatedDurationSeconds();
            SubscriptionModelUtil.addAttributesForPrint(subscription, distanceValue, durationValue, descriptorsForPrinting, color, group, subscriptionProperties, row);
        }
    }

    public static void addAttributesForPrint(SubscriptionModel subscription, Integer distanceValue, Integer durationValue, List<SubscriptionAttributeValueDescriptorModelAttributeWrapper> descriptorsForPrinting, Color color, PrinterInformation.LineGroupType group, Map<PrintPropertyKey, Serializable> subscriptionProperties, TableRowEntity row) {
        PrintContentValue duration;
        PrintContentValue distance;
        ArrayList<TableCellEntity> shortAttributes = new ArrayList<TableCellEntity>();
        ArrayList<String> textAttributes = new ArrayList<String>();
        PrintContentValue customer = (PrintContentValue)subscriptionProperties.get(PrintContentKey.CUSTOMER);
        if (customer.isPrint()) {
            shortAttributes.add(customer.createCell(SubscriptionModelUtil.getPrintInfoFromCustomer(subscription), color));
        }
        if ((distance = (PrintContentValue)subscriptionProperties.get(PrintContentKey.DISTANCE_FROM_START)).isPrint()) {
            shortAttributes.add(distance.createCell(ClientFormUtil.getNumberString(distanceValue), color));
        }
        if ((duration = (PrintContentValue)subscriptionProperties.get(PrintContentKey.DURATION_FROM_START)).isPrint()) {
            shortAttributes.add(duration.createCell(ClientFormUtil.getNumberString(durationValue), color));
        }
        SubscriptionModelUtil.getInfoFromAttribute(subscription, descriptorsForPrinting, shortAttributes, textAttributes, color);
        switch (group) {
            case ADDRESS: 
            case STREET: {
                String mainInfo = "";
                for (TableCellEntity tableCellEntity : shortAttributes) {
                    if (!StringUtil.isBlank(mainInfo)) {
                        mainInfo = mainInfo + " - ";
                    }
                    mainInfo = mainInfo + tableCellEntity.getText();
                }
                row.getInfos().add(mainInfo);
                for (String string : textAttributes) {
                    row.getInfos().add(" - " + string);
                }
                break;
            }
            case NORMAL: {
                for (TableCellEntity tableCellEntity : shortAttributes) {
                    row.add(tableCellEntity);
                }
                row.getInfos().addAll(textAttributes);
            }
        }
    }

    private static void getInfoFromAttribute(SubscriptionModel subscription, List<SubscriptionAttributeValueDescriptorModelAttributeWrapper> descriptorsForPrinting, List<TableCellEntity> shortAttributes, List<String> textAttributes, Color color) {
        for (SubscriptionAttributeValueDescriptorModelAttributeWrapper descriptorWrapper : descriptorsForPrinting) {
            if (descriptorWrapper == null || descriptorWrapper.getAttachedObject() == null) continue;
            boolean isFand = false;
            if (descriptorWrapper.getAttributeValueType() == AttributeValueType.TEXT) {
                isFand = true;
            }
            Iterator<SubscriptionAttributeValueModel> iter = subscription.iterateSubscriptionAttributeValues();
            while (iter.hasNext()) {
                SubscriptionAttributeValueModel attribute = iter.next();
                if (attribute == null || !descriptorWrapper.getAttachedObject().equals(attribute.getSubscriptionAttributeValueDescriptor())) continue;
                isFand = true;
                String value = SubscriptionModelUtil.getValue(attribute, true);
                if (descriptorWrapper.getAttributeValueType() == AttributeValueType.TEXT) {
                    if (attribute.getTextValue() == null || attribute.getTextValue().equals("")) break;
                    if (textAttributes == null) {
                        textAttributes = new LinkedList<String>();
                    }
                    textAttributes.add(descriptorWrapper.getKey() + ": " + value);
                    break;
                }
                Integer printLength = attribute.getSubscriptionAttributeValueDescriptor().getPrintLength();
                if (printLength != null) {
                    value = ClientFormUtil.getStringWithLength(value, printLength);
                }
                shortAttributes.add(new TableCellEntity(descriptorWrapper.getPrintLength(), value, color, descriptorWrapper.getPrintSortOrder()));
                break;
            }
            if (isFand) continue;
            shortAttributes.add(new TableCellEntity(descriptorWrapper.getPrintLength(), "", color, descriptorWrapper.getPrintSortOrder()));
        }
    }

    private static String getPrintInfoFromCustomer(SubscriptionModel subscription) {
        String info = null;
        CustomerModel customer = subscription.getCustomer();
        if (customer == null) {
            info = "";
        } else {
            boolean b = customer.getCompany() != null && customer.getCompany() != false;
            String clientName = b ? customer.getCompanyName() : customer.getFirstName() + " " + customer.getLastName();
            String company = b ? "(" + ModelEnviroment.getMessageResolver().resolveMessage("messages.cutomer.isCompany", new Serializable[0]) + ")" : "";
            info = clientName + company;
        }
        return info;
    }

    private static String getValue(SubscriptionAttributeValueModel attributeValue, boolean trim) {
        SubscriptionAttributeValueDescriptorModel subscriptionAttributeValueDescriptor = attributeValue.getSubscriptionAttributeValueDescriptor();
        String value = null;
        Boolean booleanValue = attributeValue.getBooleanValue();
        switch (subscriptionAttributeValueDescriptor.getAttributeValueType()) {
            case BOOLEAN: {
                if (booleanValue != null && booleanValue.booleanValue()) {
                    value = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.yes", new Serializable[0]);
                    break;
                }
                value = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.no", new Serializable[0]);
                break;
            }
            case DATE: {
                Long longValue = attributeValue.getLongValue();
                if (longValue == null) break;
                Date date = new Date(longValue);
                value = new SimpleDateFormat("yyyy-MM-dd").format(date);
                break;
            }
            case FLOAT: {
                Double doubleValue = attributeValue.getFloatValue();
                if (doubleValue == null) break;
                value = doubleValue.toString();
                break;
            }
            case IMAGE: {
                break;
            }
            case INTEGER: {
                Integer intValue = attributeValue.getIntegerValue();
                if (intValue == null) break;
                value = intValue.toString();
                break;
            }
            case MULTIPLE_LIST_CHOICE: {
                break;
            }
            case PDF_DOWN: {
                break;
            }
            case STATIC_CHOICE: {
                SubscriptionStaticChoiceAttributeValueModel staticChoiceValue = attributeValue.getStaticChoiceValue();
                if (staticChoiceValue == null) break;
                value = staticChoiceValue.getName();
                break;
            }
            case STRING: {
                value = attributeValue.getStringValue();
                break;
            }
            case TEXT: {
                value = attributeValue.getTextValue();
            }
        }
        return value == null ? null : (trim ? value.trim() : value);
    }

    public static List<String> getInfoBoxString(SubscriptionModel subscription) {
        ArrayList<String> infoBox = new ArrayList<String>();
        LocationModel location = subscription.getLocation();
        infoBox.add(FormUtil.getStringDisplay(subscription.getCustomer().getName()));
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        infoBox.add(LocationModelUtil.getStreetString(locationWrapper));
        infoBox.add(LocationModelUtil.getCityString(locationWrapper));
        AreaObjectModel areaObject = subscription.getAreaObject();
        infoBox.add(areaObject == null ? "N/A" : areaObject.getShortcut());
        return infoBox;
    }

    public static ImmutablePoint getGeom(SubscriptionModel subscription) {
        LocationModel location = subscription.getLocation();
        if (location == null) {
            return null;
        }
        return LocationModelUtil.getGeom(location);
    }

    public static boolean checkGeomOfSubscription(SubscriptionModel subscription) {
        ImmutablePoint geom = SubscriptionModelUtil.getGeom(subscription);
        return !GeoUtil.isNullPoint(geom);
    }

    public static ImmutablePoint getAccessGeom(SubscriptionModel subscription, RouteVehicleType routeVehicleType, ModelEnviroment modelEnviroment) {
        LocationModel location = subscription.getLocation();
        return LocationModelUtil.getAccessGeom(location, routeVehicleType, modelEnviroment);
    }

    public static double getAccessDistance(SubscriptionModel subscription, RouteVehicleType routeVehicleType, ModelEnviroment modelEnviroment) {
        ImmutablePoint geom = SubscriptionModelUtil.getGeom(subscription);
        ImmutablePoint accessGeom = SubscriptionModelUtil.getAccessGeom(subscription, routeVehicleType, modelEnviroment);
        if (geom != null && accessGeom != null) {
            return GeoUtils.getDistanceInMeter(geom.getCoordinate(), accessGeom.getCoordinate());
        }
        return 0.0;
    }

    public static void deleteSubscription(SubscriptionModel subscription, ModelEnviroment modelEnviroment) {
        if (subscription != null) {
            ModelCache modelCache = modelEnviroment.getModelCache();
            for (SubscriptionSortOrderModel order : subscription.iterableSortOrders()) {
                modelCache.evictModel(order);
                order.delete();
            }
            for (SubscriptionAttributeValueModel value : subscription.iterableSubscriptionAttributeValues()) {
                modelCache.evictModel(value);
                value.delete();
            }
            for (SubscriptionBreakTimeModel breakTime : subscription.iterableBreakTimes()) {
                modelCache.evictModel(breakTime);
                breakTime.delete();
            }
            HashSet<AreaTourModel> toDeletes = new HashSet<AreaTourModel>();
            Collection<AreaStopModel> areaStopModels = modelEnviroment.getAllCaller().getTourCaller().fetchAreaStop(null, subscription, null, null);
            for (AreaStopModel areaStopModel : areaStopModels) {
                toDeletes.add(areaStopModel.getAreaTourPart().getAreaTour());
            }
            AreaTourModelUtil.deleteAreaTours(toDeletes, modelEnviroment);
            subscription.delete();
        }
    }

    public static boolean isActiveForDate(SubscriptionModel model, Date date) {
        return SubscriptionModelUtil.isActive(model) && SubscriptionModelUtil.isDaySelected(model, date) && !SubscriptionModelUtil.isInBreakTime(model, date) && SubscriptionModelUtil.isInTimeRange(model, date);
    }

    public static boolean isActive(SubscriptionModel model) {
        return model.getStatus().equals((Object)SubscriptionStatus.ACTIVE);
    }

    private static boolean isDaySelected(SubscriptionModel model, Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayOfWeek = cal.get(7);
        return SubscriptionModelUtil.isDaySelected(model, dayOfWeek);
    }

    public static boolean isCurrentDaySelected(SubscriptionModel model) {
        int dayOfWeek = Calendar.getInstance().get(7);
        return SubscriptionModelUtil.isDaySelected(model, dayOfWeek);
    }

    private static boolean isDaySelected(SubscriptionModel model, int dayOfWeek) {
        switch (dayOfWeek) {
            case 2: {
                Boolean monday = model.getMonday();
                if (monday == null || monday.booleanValue()) break;
                return false;
            }
            case 3: {
                Boolean tuesday = model.getTuesday();
                if (tuesday == null || tuesday.booleanValue()) break;
                return false;
            }
            case 4: {
                Boolean wednesday = model.getWednesday();
                if (wednesday == null || wednesday.booleanValue()) break;
                return false;
            }
            case 5: {
                Boolean thursday = model.getThursday();
                if (thursday == null || thursday.booleanValue()) break;
                return false;
            }
            case 6: {
                Boolean friday = model.getFriday();
                if (friday == null || friday.booleanValue()) break;
                return false;
            }
            case 7: {
                Boolean saturday = model.getSaturday();
                if (saturday == null || saturday.booleanValue()) break;
                return false;
            }
            case 1: {
                Boolean sunday = model.getSunday();
                if (sunday == null || sunday.booleanValue()) break;
                return false;
            }
        }
        return true;
    }

    public static boolean isCurrentDateInTimeRange(SubscriptionModel model) {
        Date now = new Date();
        return SubscriptionModelUtil.isInTimeRange(model, now);
    }

    private static boolean isInTimeRange(SubscriptionModel model, Date date) {
        Date startDate = model.getStartDate();
        Date endDate = model.getEndDate();
        return !(startDate != null && !startDate.before(date) || endDate != null && !endDate.after(date));
    }

    public static boolean isCurrentDateInBreakTime(SubscriptionModel model) {
        Date now = Calendar.getInstance().getTime();
        return SubscriptionModelUtil.isInBreakTime(model, now);
    }

    private static boolean isInBreakTime(SubscriptionModel model, Date date) {
        for (SubscriptionBreakTimeModel breakTime : model.iterableBreakTimes()) {
            Date bStartDate = breakTime.getStartDate();
            Date bEndDate = breakTime.getEndDate();
            if (!bStartDate.before(date) || !bEndDate.after(date)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubscriptionModifiable(SubscriptionModel subscription) {
        UserInformation userInformation = ModelEnviroment.getUserInformation();
        boolean b = userInformation.hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER);
        if (b) {
            return b;
        }
        AreaLayerModel areaLayer = subscription.getAreaLayer();
        if (areaLayer == null) {
            return false;
        }
        Set<Long> layerIds = userInformation.getAttachedIdsForUserRole(UserRole.AREA_EDITOR);
        return layerIds.contains(areaLayer.getId());
    }

    public static Tupel<List<SubscriptionModel>, List<SubscriptionModel>> partSubscriptionsWithGeom(List<SubscriptionModel> subscriptions) {
        ArrayList<SubscriptionModel> subscriptionsWithGeom = new ArrayList<SubscriptionModel>();
        ArrayList<SubscriptionModel> subscriptionsWithNullGeom = new ArrayList<SubscriptionModel>();
        for (SubscriptionModel subscription : subscriptions) {
            ImmutablePoint point = SubscriptionModelUtil.getGeom(subscription);
            if (GeoUtil.isNullPoint(point)) {
                subscriptionsWithNullGeom.add(subscription);
                continue;
            }
            subscriptionsWithGeom.add(subscription);
        }
        return new Tupel<List<SubscriptionModel>, List<SubscriptionModel>>(subscriptionsWithGeom, subscriptionsWithNullGeom);
    }

    public static Map<ParcelModel, List<SubscriptionModel>> findSubscriptionsWithParcel(List<SubscriptionModel> subscriptions, List<ParcelModel> parcels) {
        HashMap<ParcelModel, List<SubscriptionModel>> subscriptionsWithParcel = new HashMap<ParcelModel, List<SubscriptionModel>>();
        block0: for (SubscriptionModel subscription : subscriptions) {
            for (ParcelModel parcel : parcels) {
                if (!ParcelModelUtil.isSameLocation(parcel, subscription)) continue;
                ArrayList<SubscriptionModel> value = (ArrayList<SubscriptionModel>)subscriptionsWithParcel.get(parcel);
                if (value == null) {
                    value = new ArrayList<SubscriptionModel>();
                    subscriptionsWithParcel.put(parcel, value);
                }
                value.add(subscription);
                continue block0;
            }
        }
        return subscriptionsWithParcel;
    }

    public static Map<ParcelModel, Set<SubscriptionModel>> findParcelMap(Collection<SubscriptionModel> subscriptions) {
        HashMap<ParcelModel, Set<SubscriptionModel>> map = new HashMap<ParcelModel, Set<SubscriptionModel>>();
        if (subscriptions != null) {
            for (SubscriptionModel subscription : subscriptions) {
                ParcelModel parcel = subscription.getLocation().getParcel();
                if (parcel == null) continue;
                HashSet<SubscriptionModel> value = (HashSet<SubscriptionModel>)map.get(parcel);
                if (value == null) {
                    value = new HashSet<SubscriptionModel>();
                    map.put(parcel, value);
                }
                value.add(subscription);
            }
        }
        return map;
    }

    public static Integer getSortOrder(SubscriptionModel subscription, RouteVehicleType vehicle, DeliveryRoundModel round) {
        SubscriptionSortOrderModel found = subscription == null ? null : SubscriptionModelUtil.findSortOrder(subscription, vehicle, round);
        return found == null ? null : found.getValue();
    }

    public static void setSortOrder(SubscriptionModel subscription, Integer sortOrder, RouteVehicleType vehicle, DeliveryRoundModel round) {
        SubscriptionSortOrderModel found = SubscriptionModelUtil.findSortOrder(subscription, vehicle, round);
        if (found == null) {
            found = new SubscriptionSortOrderModelImpl();
            found.setSubscription(subscription);
            found.setVehicle(vehicle);
            found.setDeliveryRound(round);
        }
        if (found.getValue() == null || NumericUtil.getIntegerValue(sortOrder) != NumericUtil.getIntegerValue(found.getValue())) {
            found.setValue(sortOrder);
        }
    }

    private static SubscriptionSortOrderModel findSortOrder(SubscriptionModel subscription, RouteVehicleType vehicle, DeliveryRoundModel round) {
        SubscriptionSortOrderModel found = null;
        if (vehicle == null || round == null) {
            return found;
        }
        for (SubscriptionSortOrderModel sortOrder : subscription.iterableSortOrders()) {
            if (vehicle != sortOrder.getVehicle() || !round.equals(sortOrder.getDeliveryRound())) continue;
            found = sortOrder;
            break;
        }
        return found;
    }
}

