/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import java.util.Comparator;
import org.ktde.util.datatypes.Tripel;

public class StreetNameComparator<O, M>
implements Comparator<O> {
    @Override
    public int compare(O o1, O o2) {
        M m1 = this.getM(o1);
        M m2 = this.getM(o2);
        if (m1 == null) {
            return 1;
        }
        if (m2 == null) {
            return -1;
        }
        Tripel<String, Integer, String> tripel1 = this.getAddressTripel(m1);
        Tripel<String, Integer, String> tripel2 = this.getAddressTripel(m2);
        if (tripel1.getElement1().equalsIgnoreCase(tripel2.getElement1())) {
            if (tripel1.getElement2().equals(tripel2.getElement2())) {
                return tripel1.getElement3().compareToIgnoreCase(tripel2.getElement3());
            }
            return tripel1.getElement2().compareTo(tripel2.getElement2());
        }
        return tripel1.getElement1().compareToIgnoreCase(tripel2.getElement1());
    }

    private Tripel<String, Integer, String> getAddressTripel(M m) {
        Tripel<String, Integer, String> tripel = new Tripel<String, Integer, String>("", 0, "");
        if (m instanceof StopModel) {
            tripel = LocationModelUtil.getAddressTripel(((StopModel)m).getLocation());
        } else if (m instanceof SubscriptionModel) {
            tripel = LocationModelUtil.getAddressTripel(((SubscriptionModel)m).getLocation());
        } else if (m instanceof ParcelModel) {
            tripel = ParcelModelUtil.getAddressTripel((ParcelModel)m);
        } else if (m instanceof LocationModel) {
            tripel = LocationModelUtil.getAddressTripel((LocationModel)m);
        } else if (m instanceof PoiModel) {
            tripel = LocationModelUtil.getAddressTripel(((PoiModel)m).getLocation());
        } else if (m instanceof LetterModel) {
            tripel = LocationModelUtil.getAddressTripel(((LetterModel)m).getLocation());
        }
        if (tripel.getElement1() == null) {
            tripel.setElement1("");
        }
        if (tripel.getElement2() == null) {
            tripel.setElement2(0);
        }
        if (tripel.getElement3() == null) {
            tripel.setElement3("");
        }
        return tripel;
    }

    protected M getM(O o) {
        return (M)o;
    }
}

