/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.ServiceTicketModel;
import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModelImpl;
import de.datomino.peppergis.client.model.tour.ServiceValueModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.StopModelImpl;
import de.datomino.peppergis.client.model.tour.TimeWindowModel;
import de.datomino.peppergis.client.model.tour.TimeWindowModelImpl;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.ServiceModelUtil;
import de.datomino.peppergis.client.util.StreetNameComparator;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.client.util.attribute.AttributeHelper;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.print.PrintContentValue;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.print.TableRowEntity;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.MobileGpsStatus;
import de.datomino.peppergis.type.PrintContentKey;
import de.datomino.peppergis.type.ServiceStatusType;
import de.datomino.peppergis.type.StopStatus;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.NumericUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import de.datomino.util.time.TimeUtil;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.lang.time.DateUtils;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;
import org.ktde.util.StringUtil;
import org.ktde.util.application.DynamicAttributedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopModelUtil {
    public static final String WEIGHT_KEY = "WEIGHT";
    public static final String UNLOADING_WEIGHT_KEY;
    public static final String LOADING_WEIGHT_KEY;
    private static final Logger LOGGER;

    public static String getDisplayString(StopModel stopModel) {
        if (stopModel == null) {
            return "";
        }
        String string = StopModelUtil.getStopDisplay(stopModel, false) + " - ";
        string = string + LocationModelUtil.getAddressString(stopModel.getLocation());
        return string;
    }

    public static TimeWindowModel getCurrentTimeWindow(StopModel stopModel) {
        Date timeOfArrival = stopModel.getActualTimeOfArrival();
        if (timeOfArrival != null) {
            for (TimeWindowModel timeWindowModel : stopModel.iterableTimeWindows()) {
                if (!TimeUtil.isInInterval(timeOfArrival, timeWindowModel.getStartTime(), timeWindowModel.getEndTime())) continue;
                return timeWindowModel;
            }
        }
        return null;
    }

    public static TimeWindowModel getNearbyTimeWindow(StopModel stop, Date date) {
        TimeWindowModel nearby = null;
        long nearbyStart = Long.MIN_VALUE;
        long nearbyEnd = Long.MIN_VALUE;
        long time = date.getTime();
        for (TimeWindowModel timeWindow : stop.iterableTimeWindows()) {
            long e;
            Date startTime = timeWindow.getStartTime();
            Date endTime = timeWindow.getEndTime();
            long s = startTime == null ? Long.MIN_VALUE : startTime.getTime();
            long l = e = endTime == null ? Long.MIN_VALUE : endTime.getTime();
            if (time >= s && time <= e) {
                nearbyStart = s;
                nearbyEnd = e;
                nearby = timeWindow;
                break;
            }
            if (time < s) {
                if (time <= nearbyEnd && nearbyStart - time <= nearbyStart - s) continue;
                nearbyStart = s;
                nearbyEnd = e;
                nearby = timeWindow;
                continue;
            }
            if (nearbyStart != Long.MIN_VALUE || nearbyEnd != Long.MIN_VALUE) continue;
            nearbyStart = s;
            nearbyEnd = e;
            nearby = timeWindow;
        }
        return nearby;
    }

    public static String getShortInformation(StopModel stop) {
        String info = StopModelUtil.getDisplayString(stop);
        info = info + " (" + ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.estimatedTime", new Serializable[0]) + ": " + ClientFormUtil.dateToString(stop.getEstimatedTimeOfArrival());
        info = info + ", " + ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.durationOnLocation", new Serializable[0]) + ": " + FormUtil.getSecondTimeString(stop.getEstimatedDurationSeconds());
        info = info + ", " + ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.streetMileage", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(stop.getStreetMileageMetersFromTourStart(), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.meter", new Serializable[0]));
        return info + ")";
    }

    public static String getAllInformation(StopModel stop) {
        String string = ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.estimatedTime", new Serializable[0]) + ": " + ClientFormUtil.dateToString(stop.getEstimatedTimeOfArrival());
        string = string + "\n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.durationOnLocation", new Serializable[0]) + ": " + FormUtil.getSecondTimeString(stop.getEstimatedDurationSeconds());
        string = string + "\n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.streetMileage", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(stop.getStreetMileageMetersFromTourStart(), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.meter", new Serializable[0])) + "\n";
        string = string + "\n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.actualTime", new Serializable[0]) + ": " + ClientFormUtil.dateToString(stop.getActualTimeOfArrival());
        string = string + "\n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.actualDuration", new Serializable[0]) + ": " + FormUtil.getSecondTimeString(stop.getActualDurationSeconds()) + "\n";
        string = string + "\n" + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]) + ":\n" + FormUtil.getStringDisplay(stop.getInformation()) + "\n";
        string = string + "\n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.infoForPark", new Serializable[0]) + ":\n" + FormUtil.getStringDisplay(stop.getParkingInformation()) + "\n";
        string = string + "\n" + ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.infoForDeliverer", new Serializable[0]) + ":\n" + FormUtil.getStringDisplay(stop.getDelivererInformation());
        return string;
    }

    public static String getStopDisplay(StopModel stop, boolean company) {
        String display = null;
        try {
            String property = ModelEnviroment.getProperties().getProperty("stopName");
            display = property != null && property.equals("clientName") ? StopModelUtil.getCustomers(stop) : stop.getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (display == null && stop.getPoi() != null) {
            display = ModelEnviroment.getMessageResolver().resolveMessage("messages.poi", new Serializable[0]);
        }
        if (company) {
            display = display + " " + StopModelUtil.getCompanyNames(stop);
        }
        return StringUtil.getNotNull(display);
    }

    private static String getCustomers(StopModel stop) {
        HashSet<String> customers = new HashSet<String>();
        Iterator<ServiceTicketStopRelationModel> iter = stop.iterateServiceStopRelations();
        while (iter.hasNext()) {
            customers.add(ServiceModelUtil.getCustomerDisplay(iter.next()));
        }
        String s = "";
        for (String customer : customers) {
            s = StringUtil.isEmpty(s) ? customer : s + ", " + customer;
        }
        return s;
    }

    public static String timeWindowToString(TimeWindowModel timeWindow) {
        if (timeWindow == null) {
            return "";
        }
        return ClientFormUtil.dateToString(timeWindow.getStartTime()) + " - " + ClientFormUtil.dateToString(timeWindow.getEndTime());
    }

    public static void updateActualTimeOfStop(StopModel stop, long deviation) {
        Date actualTime;
        if (stop != null && (actualTime = stop.getActualTimeOfArrival()) != null) {
            stop.setActualTimeOfArrival(DateUtils.addMilliseconds(actualTime, (int)deviation));
        }
    }

    public static void updateEstimatedTimeOfStop(StopModel stop, long deviation) {
        Date estimatedTime;
        if (stop != null && (estimatedTime = stop.getEstimatedTimeOfArrival()) != null) {
            long newTime = estimatedTime.getTime() + deviation;
            stop.setEstimatedTimeOfArrival(new Date(newTime));
        }
    }

    public static List<String> getAllStatus(StopModel stop) {
        ArrayList<String> allStatus = new ArrayList<String>();
        if (stop == null) {
            return allStatus;
        }
        Iterator<ServiceTicketStopRelationModel> relIter = stop.iterateServiceStopRelations();
        while (relIter.hasNext()) {
            ServiceTicketStopRelationModel relation = relIter.next();
            Iterator<ServiceValueDescriptorModel> descriptorIter = relation.getServiceTicket().getService().iterateServiceValueDescriptors();
            while (descriptorIter.hasNext()) {
                ServiceValueDescriptorModel descriptor = descriptorIter.next();
                if (!descriptor.getKey().equals("STATUS")) continue;
                ServiceValueModel serviceValue = ServiceModelUtil.getServiceValueModel(relation, descriptor);
                allStatus.add(ServiceModelUtil.getServiceValue(serviceValue));
            }
        }
        return allStatus;
    }

    public static ImmutablePoint getGeom(StopModel stop) {
        if (stop == null) {
            return null;
        }
        LocationModel location = stop.getLocation();
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        return locationWrapper.getGeoLocation();
    }

    public static ServiceStatusType getSummarizedServiceStatusType(StopModel stop) {
        ServiceStatusType serviceStatusType = ServiceStatusType.ALL_DONE;
        block4: for (ServiceTicketStopRelationModel serviceTicketStopRelationModel : stop.iterableServiceStopRelations()) {
            ServiceStatusType subServiceStatusType = ServiceModelUtil.calculateServiceStatus(serviceTicketStopRelationModel);
            if (subServiceStatusType == null) continue;
            switch (subServiceStatusType) {
                case NOT_DONE: {
                    serviceStatusType = ServiceStatusType.NOT_DONE;
                    break block4;
                }
                case PARTIALLY_DONE: {
                    serviceStatusType = ServiceStatusType.PARTIALLY_DONE;
                }
                default: {
                    continue block4;
                }
            }
        }
        return serviceStatusType;
    }

    public static MobileGpsStatus getSummarizedMobileGpsStatus(StopModel stop) {
        MobileGpsStatus result = MobileGpsStatus.DONE;
        block4: for (ServiceTicketStopRelationModel serviceTicketStopRelationModel : stop.iterableServiceStopRelations()) {
            MobileGpsStatus mobileGpsStatus = serviceTicketStopRelationModel.getGpsStatus();
            if (mobileGpsStatus == null) {
                mobileGpsStatus = MobileGpsStatus.NONE;
            }
            switch (mobileGpsStatus) {
                case NONE: {
                    result = MobileGpsStatus.NONE;
                    break block4;
                }
                case OK: {
                    result = MobileGpsStatus.OK;
                }
                default: {
                    continue block4;
                }
            }
        }
        return result;
    }

    public static void sortStopsWithStreet(List<StopModel> stops) {
        Collections.sort(stops, new StreetNameComparator());
    }

    public static String getStopInfos(StopModel stop) {
        String info = "";
        if ((info = info + (stop.getDelivererInformation() == null ? "" : ", " + stop.getDelivererInformation())).startsWith(", ")) {
            info = info.substring(2);
        }
        return info;
    }

    public static String getCompanyNames(StopModel stop) {
        HashSet<String> companys = new HashSet<String>();
        Iterator<ServiceTicketStopRelationModel> iter = stop.iterateServiceStopRelations();
        while (iter.hasNext()) {
            companys.add(ServiceModelUtil.getCompanyName(iter.next()));
        }
        String companyNames = "";
        for (String company : companys) {
            companyNames = companyNames + (StringUtil.isBlank(companyNames) ? "" : ", ") + company;
        }
        return companyNames;
    }

    public static void getPrintingInformation(StopModel stop, Color color, TableRowEntity row, Map<PrintPropertyKey, Serializable> tourProperties) {
        LocationModelUtil.getPrintingInformation(stop.getLocation(), color, PrinterInformation.LineGroupType.NORMAL, row, tourProperties);
        ((PrintContentValue)tourProperties.get(PrintContentKey.NAME)).addCell(stop.getName(), color, row);
        ((PrintContentValue)tourProperties.get(PrintContentKey.CUSTOMER)).addCell(StopModelUtil.getCustomers(stop), color, row);
        ((PrintContentValue)tourProperties.get(PrintContentKey.COMPANY)).addCell(StopModelUtil.getCompanyNames(stop), color, row);
        ((PrintContentValue)tourProperties.get(PrintContentKey.ESTIMATED_TIME)).addCell(ClientFormUtil.dateToString(stop.getEstimatedTimeOfArrival(), FormUtil.CLOCKFORMAT), color, row);
        ((PrintContentValue)tourProperties.get(PrintContentKey.ACTUAL_TIME)).addCell(ClientFormUtil.dateToString(stop.getActualTimeOfArrival(), FormUtil.CLOCKFORMAT), color, row);
        List<String> informations = row.getInfos();
        if (((PrintContentValue)tourProperties.get(PrintContentKey.INFO)).isPrint() && stop.getInformation() != null) {
            informations.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]) + ": " + stop.getInformation());
        }
        if (((PrintContentValue)tourProperties.get(PrintContentKey.INFO_DELIVERER)).isPrint() && stop.getDelivererInformation() != null) {
            informations.add(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.delivererInformation", new Serializable[0]) + ": " + stop.getDelivererInformation());
        }
        if (((PrintContentValue)tourProperties.get(PrintContentKey.INFO_PARKING)).isPrint() && stop.getParkingInformation() != null) {
            informations.add(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.parkingInformation", new Serializable[0]) + ": " + stop.getParkingInformation());
        }
    }

    public static String getWeightString(StopModel stop) {
        if (TourModelUtil.tour_weight_active) {
            Double weight = StopModelUtil.getAttributeSum(stop, WEIGHT_KEY);
            return ClientFormUtil.getNumberString(weight == null ? 0.0 : weight) + " " + TourModelUtil.tour_weight_unity;
        }
        return "";
    }

    public static Double getAttributeSum(StopModel stop, String key) {
        Double weight = null;
        for (ServiceTicketStopRelationModel relation : stop.iterableServiceStopRelations()) {
            for (ServiceValueModel serviceValue : relation.iterableServiceValues()) {
                ServiceValueDescriptorModel serviceValueDescriptor = serviceValue.getServiceValueDescriptor();
                if (!serviceValueDescriptor.getKey().equals(key)) continue;
                switch (serviceValueDescriptor.getServiceValueType()) {
                    case STRING: {
                        String value = serviceValue.getStringValue();
                        if (StringUtil.isBlank(value)) {
                            weight = 0.0;
                            break;
                        }
                        try {
                            weight = Double.parseDouble(value);
                        }
                        catch (Exception e) {
                            NumberFormat formatter = NumberFormat.getNumberInstance(Locale.GERMANY);
                            try {
                                weight = formatter.parse(value).doubleValue();
                            }
                            catch (Exception e1) {
                                LOGGER.error("service value is invalid - " + value + "(" + serviceValue.getId() + ")");
                            }
                        }
                        break;
                    }
                    case INTEGER: {
                        weight = serviceValue.getIntegerValue() == null ? null : Double.valueOf(serviceValue.getIntegerValue().doubleValue());
                        break;
                    }
                    case FLOAT: {
                        weight = serviceValue.getFloatValue();
                        break;
                    }
                }
            }
        }
        return weight;
    }

    public static Object getServiceValue(StopModel stop, String key, AttributeValueType valueType) {
        Object value = null;
        for (ServiceTicketStopRelationModel relation : stop.iterableServiceStopRelations()) {
            for (ServiceValueModel serviceValue : relation.iterableServiceValues()) {
                ServiceValueDescriptorModel serviceValueDescriptor = serviceValue.getServiceValueDescriptor();
                if (!serviceValueDescriptor.getKey().equals(key) || serviceValueDescriptor.getServiceValueType() != valueType) continue;
                switch (valueType) {
                    case STRING: {
                        value = serviceValue.getStringValue();
                        break;
                    }
                    case INTEGER: {
                        value = serviceValue.getIntegerValue();
                        break;
                    }
                    case BOOLEAN: {
                        value = serviceValue.getBooleanValue();
                        break;
                    }
                    case DATE: {
                        Long longValue = serviceValue.getLongValue();
                        value = longValue == null ? null : new Date(longValue);
                        break;
                    }
                    case FLOAT: {
                        value = serviceValue.getFloatValue();
                        break;
                    }
                    case IMAGE: {
                        byte[] imageValue = serviceValue.getImageValue();
                        try {
                            value = imageValue == null ? null : ImageIO.read(new ByteArrayInputStream(imageValue));
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    case PDF_DOWN: {
                        byte[] pdfValue = serviceValue.getPdfValue();
                        value = pdfValue;
                        break;
                    }
                    case MULTIPLE_LIST_CHOICE: {
                        value = serviceValue.getMultipleListChoiceValues();
                        break;
                    }
                    case MULTI_INTEGER: {
                        value = AttributeHelper.getStringRepresentationForMultiInteger(serviceValue.getStringValue());
                        break;
                    }
                    case STATIC_CHOICE: {
                        value = serviceValue.getStaticChoiceValue();
                        break;
                    }
                    case TEXT: {
                        value = serviceValue.getTextValue();
                        break;
                    }
                }
            }
        }
        return value;
    }

    public static ImmutablePoint getAccessGeom(StopModel stop, ModelEnviroment modelEnviroment) {
        RouteVehicleType type = stop.getTourPart().getRouteVehicleType();
        ImmutablePoint accessGeom = LocationModelUtil.getAccessGeom(stop.getLocation(), type, modelEnviroment);
        if (accessGeom == null) {
            accessGeom = StopModelUtil.getGeom(stop);
        }
        return accessGeom;
    }

    public static double getAccessDistance(StopModel stop, RouteVehicleType routeVehicleType, ModelEnviroment modelEnviroment) {
        ImmutablePoint geom = StopModelUtil.getGeom(stop);
        ImmutablePoint accessGeom = LocationModelUtil.getAccessGeom(stop.getLocation(), routeVehicleType, modelEnviroment);
        if (geom != null && accessGeom != null) {
            return GeoUtils.getDistanceInMeter(geom.getCoordinate(), accessGeom.getCoordinate());
        }
        return 0.0;
    }

    public static void deleteStop(StopModel stop, ModelEnviroment modelEnviroment) {
        if (stop != null) {
            ModelCache modelCache = modelEnviroment.getModelCache();
            for (ServiceTicketStopRelationModel rel : stop.iterableServiceStopRelations()) {
                ServiceTicketModel serviceTicket = rel.getServiceTicket();
                serviceTicket.removeAServiceTicketStopRelation(rel);
                for (ServiceValueModel value : rel.iterableServiceValues()) {
                    modelCache.evictModel(value);
                    value.delete();
                }
                modelCache.evictModel(rel);
                rel.delete();
            }
            for (TimeWindowModel timeWindow : stop.iterableTimeWindows()) {
                modelCache.evictModel(timeWindow);
                timeWindow.delete();
            }
            modelCache.evictModel(stop);
            stop.delete();
        }
    }

    public static Color getColorOfStatus(final StopModel stop, final Map<StopModel, Color> stopColorCache) {
        Color color = PeppergisConstants.SERVICE_NONE_COLOR;
        if (stopColorCache == null || stop == null || stop.getEstimatedTimeOfArrival() == null || stop.getEstimatedTimeOfArrival().after(new Date())) {
            return color;
        }
        color = stopColorCache.get(stop);
        if (color == null) {
            ValueChangeListener listener = new ValueChangeListener(){

                @Override
                public void valueChanged(ValueChangeEvent e) {
                    stop.removeValueChangeListener(this);
                    for (ServiceTicketStopRelationModel serviceTicketStopRelationModel : stop.iterableServiceStopRelations()) {
                        serviceTicketStopRelationModel.removeValueChangeListener(this);
                        for (ServiceValueModel serviceValueModel : serviceTicketStopRelationModel.iterableServiceValues()) {
                            serviceValueModel.removeValueChangeListener(this);
                        }
                    }
                    stopColorCache.remove(stop);
                }
            };
            stop.addValueChangeListener(listener);
            for (ServiceTicketStopRelationModel serviceTicketStopRelationModel : stop.iterableServiceStopRelations()) {
                serviceTicketStopRelationModel.addValueChangeListener(listener);
                for (ServiceValueModel serviceValueModel : serviceTicketStopRelationModel.iterableServiceValues()) {
                    serviceValueModel.addValueChangeListener(listener);
                }
            }
        } else {
            return color;
        }
        ServiceStatusType serviceStatusType = StopModelUtil.getSummarizedServiceStatusType(stop);
        block0 : switch (serviceStatusType) {
            case ALL_DONE: {
                color = PeppergisConstants.SERVICE_ALL_DONE_COLOR;
                break;
            }
            case PARTIALLY_DONE: {
                color = PeppergisConstants.SERVICE_PARTIALLY_DONE_COLOR;
                break;
            }
            case NOT_DONE: {
                color = PeppergisConstants.SERVICE_NOT_DONE_COLOR;
                MobileGpsStatus mobileGpsStatus = StopModelUtil.getSummarizedMobileGpsStatus(stop);
                switch (mobileGpsStatus) {
                    case DONE: {
                        color = PeppergisConstants.SERVICE_ALL_DONE_COLOR;
                        break block0;
                    }
                    case NONE: {
                        color = PeppergisConstants.SERVICE_NOT_DONE_COLOR;
                        break block0;
                    }
                    case OK: {
                        color = PeppergisConstants.SERVICE_CURRENT_COLOR;
                    }
                }
            }
        }
        return color;
    }

    private static boolean isBreakTimeWindows(StopModel stop) {
        Date estimatedTimeOfArrival = stop.getEstimatedTimeOfArrival();
        if (stop.getPoi() != null || estimatedTimeOfArrival == null) {
            return false;
        }
        Integer duration = stop.getEstimatedDurationSeconds();
        if (duration == null) {
            duration = 0;
        }
        Date leaveTime = DateUtils.addSeconds(estimatedTimeOfArrival, duration);
        return StopModelUtil.isBreakTimeWindows(stop.iterateTimeWindows(), estimatedTimeOfArrival, leaveTime);
    }

    private static boolean isBreakTimeWindows(Iterator<TimeWindowModel> iterateTimeWindows, Date arrivalTime, Date leaveTime) {
        if (iterateTimeWindows == null || !iterateTimeWindows.hasNext() || arrivalTime == null) {
            return false;
        }
        while (iterateTimeWindows.hasNext()) {
            TimeWindowModel timeWindow = iterateTimeWindows.next();
            if (timeWindow == null || !TimeUtil.isBetween(arrivalTime, timeWindow.getStartTime(), timeWindow.getEndTime())) continue;
            return false;
        }
        return true;
    }

    public static boolean hasBadTimeWindow(StopModel stop) {
        boolean b = false;
        if (stop != null) {
            boolean bl = b = stop.getEstimatedTimeOfArrival() == null && stop.getStopStatus() != null && stop.getStopStatus() == StopStatus.BAD_TIME_WINDOW;
            if (!b) {
                b = StopModelUtil.isBreakTimeWindows(stop);
            }
        }
        return b;
    }

    public static StopModel cloneStop(StopModel stop) {
        if (stop == null) {
            return null;
        }
        StopModelImpl clone = new StopModelImpl();
        clone.setActualDurationSeconds(stop.getActualDurationSeconds());
        clone.setActualTimeOfArrival(stop.getActualTimeOfArrival());
        clone.setBranch(stop.getBranch());
        clone.setDelivererInformation(stop.getDelivererInformation());
        clone.setEstimatedDurationSeconds(stop.getEstimatedDurationSeconds());
        clone.setEstimatedTimeOfArrival(stop.getEstimatedTimeOfArrival());
        clone.setExportedByJob(stop.getExportedByJob());
        clone.setImportOrder(stop.getImportOrder());
        clone.setInformation(stop.getInformation());
        clone.setLocation(stop.getLocation());
        clone.setName(stop.getName());
        clone.setParkingInformation(stop.getParkingInformation());
        clone.setPoi(stop.getPoi());
        clone.setSortOrder(stop.getSortOrder());
        clone.setStopStatus(stop.getStopStatus());
        clone.setStreetMileageMetersFromTourStart(stop.getStreetMileageMetersFromTourStart());
        for (ServiceTicketStopRelationModel rel : stop.iterableServiceStopRelations()) {
            ServiceTicketStopRelationModelImpl cloneRel = new ServiceTicketStopRelationModelImpl();
            cloneRel.setServiceTicket(rel.getServiceTicket());
            cloneRel.setStop(clone);
        }
        for (TimeWindowModel tw : stop.iterableTimeWindows()) {
            TimeWindowModelImpl cloneTw = new TimeWindowModelImpl();
            cloneTw.setEndTime(tw.getEndTime());
            cloneTw.setStartTime(tw.getStartTime());
            cloneTw.setStop(clone);
        }
        return clone;
    }

    public static Set<MobileGpsStatus> getGpsStatuses(StopModel stop) {
        HashSet<MobileGpsStatus> statuses = new HashSet<MobileGpsStatus>();
        for (ServiceTicketStopRelationModel rel : stop.iterableServiceStopRelations()) {
            MobileGpsStatus s = rel.getGpsStatus();
            if (s == null) continue;
            statuses.add(s);
        }
        return statuses;
    }

    public static boolean inHomeZone(StopModel stop, ImmutablePoint point) {
        Integer maxPerimeter = null;
        for (ServiceTicketStopRelationModel rel : stop.iterableServiceStopRelations()) {
            ServiceTicketModel ticket = rel.getServiceTicket();
            Integer perimeter = ticket.getAutoServicePerimeter();
            if (perimeter == null) {
                perimeter = ticket.getService().getAutoServicePerimeter();
            }
            if (perimeter == null) continue;
            if (maxPerimeter == null) {
                maxPerimeter = perimeter;
                continue;
            }
            maxPerimeter = Math.max(maxPerimeter, NumericUtil.getIntegerValue(perimeter));
        }
        if (maxPerimeter == null) {
            try {
                maxPerimeter = Integer.parseInt(ModelEnviroment.getProperties().getProperty("service.homezone.maxPerimeter", "50"));
            }
            catch (Exception e) {
                maxPerimeter = 50;
            }
        }
        double distance = GeoUtils.getDistanceInMeter(StopModelUtil.getGeom(stop), point);
        return Double.compare(maxPerimeter.intValue(), distance) > 0;
    }

    static {
        DynamicAttributedProperties properties = ModelEnviroment.getProperties();
        String loadingWeightKey = properties.getProperty("tour.rendering.weight.loading");
        if (StringUtil.isBlank(loadingWeightKey)) {
            loadingWeightKey = "LOADING_WEIGHT";
        }
        LOADING_WEIGHT_KEY = loadingWeightKey;
        String unloadingWeightKey = properties.getProperty("tour.rendering.weight.unloading");
        if (StringUtil.isBlank(unloadingWeightKey)) {
            unloadingWeightKey = "UNLOADING_WEIGHT";
        }
        UNLOADING_WEIGHT_KEY = unloadingWeightKey;
        LOGGER = LoggerFactory.getLogger(StopModelUtil.class);
    }

    public static enum StopTimeTyp {
        ACTUAL,
        ESTIMATED;

    }
}

