/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiAttributeValueModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.PoiModelImpl;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.print.TableCellEntity;
import de.datomino.peppergis.print.TableRowEntity;
import de.datomino.peppergis.type.PoiType;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.ktde.util.StringUtil;

public class PoiModelUtil {
    public static String getName(PoiModel poi) {
        if (poi == null) {
            return "";
        }
        return poi.getName();
    }

    public static String getShortInformation(PoiModel poi) {
        String info = PoiModelUtil.getName(poi);
        LocationModel location = poi.getLocation();
        info = info + ", " + LocationModelUtil.getAddressString(location);
        info = info + (poi.getInformation() == null ? "" : ", Lagezusatz: " + poi.getInformation());
        return info;
    }

    public static PoiModel createUnloadingPoi(PoiModel poi) {
        PoiModelImpl unloadingPoi = null;
        if (poi != null) {
            unloadingPoi = new PoiModelImpl();
            unloadingPoi.setPoiType(PoiType.PICK_POINT);
            unloadingPoi.setImage(poi.getImage());
            unloadingPoi.setInformation(poi.getInformation());
            unloadingPoi.setLocation(poi.getLocation());
            unloadingPoi.setName(poi.getName());
            unloadingPoi.setPoiNumber(poi.getPoiNumber());
        }
        return unloadingPoi;
    }

    public static void getPrintingInformation(PoiModel poi, Color color, PrinterInformation.LineGroupType group, TableRowEntity row, Map<PrintPropertyKey, Serializable> properties, boolean mixed) {
        row.getInfos().add(PoiModelUtil.getName(poi));
        LocationModelUtil.getPrintingInformation(poi.getLocation(), color, group, row, properties);
        String location = "";
        for (TableCellEntity l : row) {
            if (!StringUtil.isBlank(location)) {
                location = location + " ";
            }
            if (StringUtil.isBlank(l.getText())) continue;
            location = location + l.getText();
        }
        row.getInfos().add(location);
        if (!StringUtil.isBlank(poi.getInformation())) {
            row.getInfos().add(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.delivererInformation", new Serializable[0]) + ": " + poi.getInformation());
        }
    }

    public static double getAccessDistance(PoiModel poi, RouteVehicleType routeVehicleType, ModelEnviroment modelEnviroment) {
        LocationModel location = poi.getLocation();
        ImmutablePoint geom = LocationModelUtil.getGeom(location);
        ImmutablePoint accessGeom = LocationModelUtil.getAccessGeom(location, routeVehicleType, modelEnviroment);
        if (geom != null && accessGeom != null) {
            return GeoUtils.getDistanceInMeter(geom.getCoordinate(), accessGeom.getCoordinate());
        }
        return 0.0;
    }

    public static boolean deletePoi(PoiModel poi, ModelEnviroment modelEnviroment, boolean force) {
        if (poi.getId() != null) {
            boolean poiAttached = modelEnviroment.getAllCaller().getBaseCaller().isPoiAttachedToAnyObject(poi);
            if (poiAttached && !force) {
                return false;
            }
            for (PoiAttributeValueModel poiAttributeValueModel : poi.iterablePoiAttributeValues()) {
                poiAttributeValueModel.delete();
            }
            ArrayList<AreaObjectModel> areas = new ArrayList<AreaObjectModel>(poi.countAreaObjects());
            for (AreaObjectModel areaObjectModel : poi.iterableAreaObjects()) {
                areas.add(areaObjectModel);
            }
            for (AreaObjectModel areaObjectModel : areas) {
                areaObjectModel.setPoi(null);
            }
            areas = new ArrayList(poi.countFirstThrowAreaObjects());
            for (AreaObjectModel areaObjectModel : poi.iterableFirstThrowAreaObjects()) {
                areas.add(areaObjectModel);
            }
            for (AreaObjectModel areaObjectModel : areas) {
                areaObjectModel.setFirstPickPoint(null);
            }
            areas = new ArrayList(poi.countLastThrowAreaObjects());
            for (AreaObjectModel areaObjectModel : poi.iterableLastThrowAreaObjects()) {
                areas.add(areaObjectModel);
            }
            for (AreaObjectModel areaObjectModel : areas) {
                areaObjectModel.setLastPickPoint(null);
            }
            ArrayList<DelivererModel> arrayList = new ArrayList<DelivererModel>(poi.countDeliverers());
            for (DelivererModel deliverer : poi.iterableDeliverers()) {
                arrayList.add(deliverer);
            }
            for (DelivererModel deliverer : arrayList) {
                deliverer.setPoi(null);
            }
            ArrayList<StopModel> arrayList2 = new ArrayList<StopModel>(poi.countStops());
            for (StopModel stop : poi.iterableStops()) {
                arrayList2.add(stop);
            }
            for (StopModel stop : arrayList2) {
                stop.setPoi(null);
            }
            poi.delete();
        } else {
            Collection<PoiModel> unsavedPoi = modelEnviroment.getUndoManager().getChangedObjects(PoiModel.class);
            unsavedPoi.remove(poi);
            modelEnviroment.getModelCache().evictModel(poi);
        }
        return true;
    }
}

