/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.client.geometric.GeoClientHelper;
import de.datomino.peppergis.client.gui.location.GeomEditorResult;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.BlockDescriptor;
import de.datomino.peppergis.client.manager.filter.ObjectFilterEntity;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModelImpl;
import de.datomino.peppergis.client.model.area.ParcelSortOrderModel;
import de.datomino.peppergis.client.model.area.ParcelSortOrderModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.CityAliasModel;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictAliasModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.map.StreetAliasModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.print.DefaultPrintingInformation;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.SegmentModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.client.util.wrapper.parcel.attribute.ParcelAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.dto.location.SimpleAddressDto;
import de.datomino.peppergis.print.PrintContentValue;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.print.TableCellEntity;
import de.datomino.peppergis.print.TableRowEntity;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.ImportParcelStatus;
import de.datomino.peppergis.type.ParcelBlockType;
import de.datomino.peppergis.type.ParcelSortOrderType;
import de.datomino.peppergis.type.PrintContentKey;
import de.datomino.peppergis.type.SegmentStatus;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.NumericUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class ParcelModelUtil {
    public static String getDisplayString(ParcelModel parcel) {
        return ModelEnviroment.getMessageResolver().resolveMessage("gui.parcel.parcel", new Serializable[0]) + ": " + ParcelModelUtil.getAddress(parcel);
    }

    public static Tripel<String, Integer, String> getAddressTripel(ParcelModel parcel) {
        String streetName = ParcelModelUtil.getStreetName(parcel);
        Integer hnr = 0;
        try {
            hnr = Integer.parseInt(parcel.getHouseNumber().trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String ext = parcel.getHouseNumberExtension() == null ? "" : parcel.getHouseNumberExtension();
        return new Tripel<String, Integer, String>(streetName, hnr, ext);
    }

    public static String getAddress(ParcelModel parcel) {
        PostcodeDistrictRelationModel postcodeDistrictRelation;
        String streetName = ParcelModelUtil.getStreetName(parcel);
        CityModel city = null;
        DistrictModel district = null;
        PostcodeModel postcode = null;
        StreetModel street = parcel.getStreet();
        if (street != null && (postcodeDistrictRelation = street.getPostcodeDistrictRelation()) != null) {
            district = postcodeDistrictRelation.getDistrict();
            postcode = postcodeDistrictRelation.getPostcode();
            if (district != null) {
                city = district.getCity();
            }
        }
        String postcodeName = postcode == null ? null : FormUtil.getStringDisplay(postcode.getName());
        String cityName = city == null ? null : FormUtil.getStringDisplay(city.getName());
        return FormUtil.getAddressString(cityName, postcodeName, streetName, parcel.getHouseNumber(), parcel.getHouseNumberExtension());
    }

    public static boolean isSameLocation(ParcelModel parcel, SubscriptionModel subscription) {
        return ParcelModelUtil.isSameLocation(parcel, subscription.getLocation());
    }

    public static boolean isSameLocation(ParcelModel parcel, LocationModel location) {
        boolean sameAddress;
        boolean same;
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        boolean bl = same = parcel.equals(location.getParcel()) || GeoUtils.areSamedPoints(parcel.getGeom(), locationWrapper.getGeoLocation(), (Double)1.0);
        if (same || parcel.getStreet() == null || locationWrapper == null) {
            return same;
        }
        boolean bl2 = sameAddress = parcel.getHouseNumber() == null ? false : parcel.getHouseNumber().equals(String.valueOf(locationWrapper.getHousenumber()));
        if (parcel.getHouseNumberExtension() == null && locationWrapper.getHousenumberExtension() != null) {
            sameAddress = false;
        } else if (parcel.getHouseNumberExtension() != null) {
            sameAddress = sameAddress && parcel.getHouseNumberExtension().equals(locationWrapper.getHousenumberExtension());
        }
        String name = parcel.getStreet().getName();
        sameAddress = sameAddress && name != null && name.equals(locationWrapper.getStreet());
        return same || sameAddress;
    }

    public static List<ParcelModel> findParcelsWithoutSubscription(List<ParcelModel> parcels, List<SubscriptionModel> subscriptions) {
        ArrayList<ParcelModel> parcelsWithouSub = new ArrayList<ParcelModel>();
        for (ParcelModel parcel : parcels) {
            if (ParcelModelUtil.parcelWithSubscription(parcel, subscriptions)) continue;
            parcelsWithouSub.add(parcel);
        }
        return parcelsWithouSub;
    }

    public static boolean parcelWithSubscription(ParcelModel parcel, Collection<SubscriptionModel> subscriptions) {
        if (subscriptions == null || subscriptions.isEmpty()) {
            return false;
        }
        boolean exist = false;
        for (SubscriptionModel subscription : subscriptions) {
            if (!ParcelModelUtil.isSameLocation(parcel, subscription)) continue;
            exist = true;
            break;
        }
        return exist;
    }

    public static SimpleAddressDto convertParcelToSimpleAddress(ParcelModel parcel, String internalId) {
        PostcodeDistrictRelationModel postcodeDistrictRelation;
        SimpleAddressDto simpleAddressDto = new SimpleAddressDto();
        simpleAddressDto.setHousenumber(StringUtil.nullToEmpty(parcel.getHouseNumber()));
        simpleAddressDto.setHousenumberExtension(StringUtil.nullToEmpty(parcel.getHouseNumberExtension()));
        StreetModel street = parcel.getStreet();
        CityModel city = null;
        DistrictModel district = null;
        PostcodeModel postcode = null;
        if (street != null && (postcodeDistrictRelation = street.getPostcodeDistrictRelation()) != null) {
            district = postcodeDistrictRelation.getDistrict();
            postcode = postcodeDistrictRelation.getPostcode();
            if (district != null) {
                city = district.getCity();
            }
        }
        simpleAddressDto.setStreet(street == null ? "" : StringUtil.nullToEmpty(street.getName()));
        simpleAddressDto.setDistrict(district == null ? "" : StringUtil.nullToEmpty(district.getName()));
        simpleAddressDto.setCity(city == null ? "" : StringUtil.nullToEmpty(city.getName()));
        simpleAddressDto.setPostcode(postcode == null ? "" : StringUtil.nullToEmpty(postcode.getName()));
        simpleAddressDto.setCountry(postcode == null ? null : postcode.getCountry());
        simpleAddressDto.setLocation(ImmutablePointDto.create(parcel.getGeom()));
        simpleAddressDto.setInternalId(internalId);
        return simpleAddressDto;
    }

    public static boolean checkGeomOfParcel(ParcelModel parcel) {
        boolean valid = true;
        ImmutablePoint nullPoint = ImmutableGeoObjectFactory.createImmutablePoint(Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0));
        if (parcel == null || parcel.getGeom() == null || ((ImmutablePoint)parcel.getGeom().getTransformed(Wgs84Factory.INSTANCE)).equals(nullPoint)) {
            valid = false;
        }
        return valid;
    }

    public static void removeOldRelationsOfParcel(ParcelModel parcel) {
        Iterator<AreaObjectParcelRelModel> rels = parcel.iterateAreaObjectParcelRel();
        while (rels.hasNext()) {
            AreaObjectParcelRelModel rel = rels.next();
            parcel.removeAAreaObjectParcelRel(rel);
            AreaObjectModel area = rel.getAreaObject();
            area.removeAAreaObjectParcelRel(rel);
            rel.delete();
            rels = area.iterateAreaObjectParcelRel();
        }
    }

    public static String getStreetName(ParcelModel parcel) {
        StreetModel street = parcel.getStreet();
        String streetName = street == null ? null : FormUtil.getStringDisplay(street.getName());
        return streetName;
    }

    public static SegmentModel getRouteSegment(ParcelModel parcel, RouteVehicleType routeVehicleType) {
        SegmentModel segment = null;
        if (routeVehicleType != null && parcel != null) {
            switch (routeVehicleType) {
                case FOOT: {
                    segment = parcel.getFootSegment();
                    break;
                }
                case BIKE: {
                    segment = parcel.getBikeSegment();
                    break;
                }
                case MOTORCAR: {
                    segment = parcel.getMotorSegment();
                    break;
                }
            }
        }
        return segment;
    }

    public static void getPrintingInformation(LegendObject<ParcelModel> legendObject, List<ParcelAttributeValueDescriptorModelAttributeWrapper> descriptorsForPrinting, Color color, PrinterInformation.LineGroupType group, TableRowEntity row, Map<PrintPropertyKey, Serializable> parcelProperties, boolean mixed) {
        PostcodeDistrictRelationModel postcodeDistrictRelation;
        ParcelModel parcel = legendObject.getM();
        CityModel city = null;
        DistrictModel district = null;
        PostcodeModel postcode = null;
        StreetModel street = parcel.getStreet();
        if (street != null && (postcodeDistrictRelation = street.getPostcodeDistrictRelation()) != null) {
            district = postcodeDistrictRelation.getDistrict();
            postcode = postcodeDistrictRelation.getPostcode();
            if (district != null) {
                city = district.getCity();
            }
        }
        String countryString = postcode == null || postcode.getCountry() == null ? null : postcode.getCountry().getVehicleSign();
        String cityString = city == null ? "" : FormUtil.getStringDisplay(city.getName());
        String districtString = district == null ? "" : FormUtil.getStringDisplay(district.getName());
        String postcodeString = postcode == null ? "" : FormUtil.getStringDisplay(postcode.getName());
        String streetName = StringUtil.getNotNull(ParcelModelUtil.getStreetName(parcel));
        String hausNumberString = parcel.getHouseNumber() == null ? "" : parcel.getHouseNumber();
        String hausNumberExString = parcel.getHouseNumberExtension() == null ? "" : parcel.getHouseNumberExtension();
        DefaultPrintingInformation.addAddressRow(countryString, cityString, districtString, postcodeString, streetName, hausNumberString, hausNumberExString, parcelProperties, row, color, group);
        if (group == PrinterInformation.LineGroupType.NORMAL) {
            Integer distanceValue = legendObject.getStreetMileageMetersFromTourStart();
            Integer durationValue = legendObject.getEstimatedDurationSeconds();
            ParcelModelUtil.addAttributesForPrint(parcel, distanceValue, durationValue, descriptorsForPrinting, color, group, mixed, parcelProperties, row);
        }
    }

    public static void addAttributesForPrint(ParcelModel parcel, Integer distanceValue, Integer durationValue, List<ParcelAttributeValueDescriptorModelAttributeWrapper> descriptorsForPrinting, Color color, PrinterInformation.LineGroupType group, boolean mixed, Map<PrintPropertyKey, Serializable> parcelProperties, TableRowEntity row) {
        PrintContentValue duration;
        PrintContentValue distance;
        PrintContentValue customer;
        ArrayList<TableCellEntity> shortAttributes = new ArrayList<TableCellEntity>();
        ArrayList<String> textAttributes = new ArrayList<String>();
        if (mixed && (customer = (PrintContentValue)parcelProperties.get(PrintContentKey.CUSTOMER)).isPrint()) {
            shortAttributes.add(customer.createCell("", color));
        }
        if ((distance = (PrintContentValue)parcelProperties.get(PrintContentKey.DISTANCE_FROM_START)).isPrint()) {
            shortAttributes.add(distance.createCell(ClientFormUtil.getNumberString(distanceValue), color));
        }
        if ((duration = (PrintContentValue)parcelProperties.get(PrintContentKey.DURATION_FROM_START)).isPrint()) {
            shortAttributes.add(duration.createCell(ClientFormUtil.getNumberString(durationValue), color));
        }
        for (ParcelAttributeValueDescriptorModelAttributeWrapper descriptor : descriptorsForPrinting) {
            if (descriptor == null || descriptor.getAttachedObject() == null) continue;
            boolean isFound = false;
            Iterator<ParcelAttributeValueModel> iter = parcel.iterateParcelAttributeValues();
            while (iter.hasNext()) {
                ParcelAttributeValueModel attribute = iter.next();
                if (attribute == null || !descriptor.getAttachedObject().equals(attribute.getParcelAttributeValueDescriptor())) continue;
                isFound = true;
                String value = ParcelModelUtil.getValue(attribute, true);
                if (descriptor.getAttributeValueType() == AttributeValueType.TEXT) {
                    if (attribute.getTextValue() == null || attribute.getTextValue().equals("")) break;
                    textAttributes.add(descriptor.getKey() + ": " + value);
                    break;
                }
                Integer printLength = attribute.getParcelAttributeValueDescriptor().getPrintLength();
                if (printLength != null) {
                    value = ClientFormUtil.getStringWithLength(value, printLength);
                }
                row.add(new TableCellEntity(descriptor.getPrintLength(), value, color, descriptor.getPrintSortOrder()));
                break;
            }
            if (isFound) continue;
            row.add(new TableCellEntity(descriptor.getPrintLength(), "", color, descriptor.getPrintSortOrder()));
        }
        switch (group) {
            case ADDRESS: 
            case STREET: {
                String mainInfo = "";
                for (TableCellEntity s : shortAttributes) {
                    if (!StringUtil.isBlank(mainInfo)) {
                        mainInfo = mainInfo + " - ";
                    }
                    mainInfo = mainInfo + s.getText();
                }
                row.getInfos().add(mainInfo);
                for (String s : textAttributes) {
                    row.getInfos().add(" - " + s);
                }
                break;
            }
            case NORMAL: {
                for (TableCellEntity cell : shortAttributes) {
                    row.add(cell);
                }
                row.getInfos().addAll(textAttributes);
            }
        }
    }

    private static String getValue(ParcelAttributeValueModel attributeValue, boolean trim) {
        String value = attributeValue.getStringValue();
        if (attributeValue.getTextValue() != null) {
            value = attributeValue.getTextValue();
        } else if (attributeValue.getIntegerValue() != null) {
            value = String.valueOf(attributeValue.getIntegerValue());
        } else if (attributeValue.getBooleanValue() != null) {
            value = attributeValue.getBooleanValue().booleanValue() ? ModelEnviroment.getMessageResolver().resolveMessage("messages.default.yes", new Serializable[0]) : ModelEnviroment.getMessageResolver().resolveMessage("messages.default.no", new Serializable[0]);
        } else if (attributeValue.getLongValue() != null) {
            value = String.valueOf(attributeValue.getLongValue());
        } else if (attributeValue.getStaticChoiceValue() != null) {
            value = attributeValue.getStaticChoiceValue().getValue();
        }
        return value == null ? null : (trim ? value.trim() : value);
    }

    public static ImmutablePoint getAccessGeom(ParcelModel parcel, RouteVehicleType routeVehicleType) {
        SegmentModel segment = ParcelModelUtil.getRouteSegment(parcel, routeVehicleType);
        if (segment != null) {
            Tupel<Double, ImmutablePoint> tupel = GeoUtil.getShortestPerpendicular(parcel.getGeom(), segment.getGeom());
            return tupel.getElement2();
        }
        return null;
    }

    public static double getAccessDistance(ParcelModel parcel, RouteVehicleType routeVehicleType) {
        ImmutablePoint accessGeom = ParcelModelUtil.getAccessGeom(parcel, routeVehicleType);
        if (parcel.getGeom() != null && accessGeom != null) {
            return GeoUtils.getDistanceInMeter(parcel.getGeom().getCoordinate(), accessGeom.getCoordinate());
        }
        return 0.0;
    }

    public static String getDistrictName(ParcelModel parcel) {
        PostcodeDistrictRelationModel postcodeDistrictRelation;
        String districtName = "";
        StreetModel street = parcel.getStreet();
        if (street != null && (postcodeDistrictRelation = street.getPostcodeDistrictRelation()) != null) {
            DistrictModel district = postcodeDistrictRelation.getDistrict();
            districtName = district == null ? "" : district.getName();
        }
        return districtName;
    }

    public static String getPostcodeName(ParcelModel parcel) {
        PostcodeDistrictRelationModel postcodeDistrictRelation;
        PostcodeModel postcode = null;
        StreetModel street = parcel.getStreet();
        if (street != null && (postcodeDistrictRelation = street.getPostcodeDistrictRelation()) != null) {
            postcode = postcodeDistrictRelation.getPostcode();
        }
        return postcode == null ? null : FormUtil.getStringDisplay(postcode.getName());
    }

    public static Tupel<List<ParcelModel>, List<ParcelModel>> partParcelsWithGeom(List<ParcelModel> parcels) {
        ArrayList<ParcelModel> parcelsWithGeom = new ArrayList<ParcelModel>();
        ArrayList<ParcelModel> parcelsWithNullGeom = new ArrayList<ParcelModel>();
        for (ParcelModel parcel : parcels) {
            if (GeoUtil.isNullPoint(parcel.getGeom())) {
                parcelsWithNullGeom.add(parcel);
                continue;
            }
            parcelsWithGeom.add(parcel);
        }
        return new Tupel<List<ParcelModel>, List<ParcelModel>>(parcelsWithGeom, parcelsWithNullGeom);
    }

    public static boolean isAllowed(ParcelModel parcel, ObjectFilterEntity parcelFilterEntity) {
        return ParcelModelUtil.isAllowed(parcel, parcelFilterEntity.getBlockDescriptors(), parcelFilterEntity.isPreferExclusion());
    }

    public static boolean isAllowed(ParcelModel parcel, Collection<BlockDescriptor> blockDescriptors, boolean exclusionFirst) {
        boolean exclusion = false;
        boolean inclusion = false;
        for (BlockDescriptor blockDescriptor : blockDescriptors) {
            Boolean bValue = null;
            for (ParcelAttributeValueModel value : parcel.iterableParcelAttributeValues()) {
                ParcelAttributeValueDescriptorModel parcelAttributeValueDescriptorModel = blockDescriptor.getParcelAttributeValueDescriptorModel();
                if (parcelAttributeValueDescriptorModel.getAttributeValueType() != AttributeValueType.BOOLEAN || !parcelAttributeValueDescriptorModel.equals(value.getParcelAttributeValueDescriptor())) continue;
                bValue = value.getBooleanValue();
                break;
            }
            ParcelBlockType parcelBlockType = blockDescriptor.getParcelBlockType();
            boolean matches = new EqualsBuilder().append(bValue, blockDescriptor.getValue()).isEquals();
            switch (parcelBlockType) {
                case INCLUSION: {
                    inclusion |= matches;
                    break;
                }
                case EXCLUSION: {
                    exclusion |= matches;
                }
            }
            if (!inclusion || !exclusion) continue;
            break;
        }
        if (exclusion && inclusion) {
            return !exclusionFirst;
        }
        if (!exclusion && !inclusion) {
            return exclusionFirst;
        }
        return !exclusion && inclusion;
    }

    public static void setGeomResult(ParcelModel parcel, GeomEditorResult result, GeoClientHelper geoClientHelper) {
        boolean coordinateChanged;
        if (parcel == null) {
            return;
        }
        geoClientHelper.setNewSegment(true);
        Coordinate oldCoordinate = parcel.getGeom() == null ? null : parcel.getGeom().getCoordinate();
        boolean bl = coordinateChanged = !GeoUtil.areSamedPoints(oldCoordinate, result.getCoordinate(), (Double)0.0);
        if (coordinateChanged) {
            ImmutablePoint newPoint = ImmutableGeoObjectFactory.createImmutablePoint(result.getCoordinate());
            parcel.setGeom(newPoint);
            boolean bl2 = coordinateChanged = !GeoUtil.isNullPoint(newPoint);
        }
        if (result.isMotorSegmentUpdate()) {
            parcel.setMotorSegment(result.getMotorSegment());
            parcel.setManualMotorSegmentUpdate(result.isMotorSegmentUpdate());
        } else if ((parcel.getManualMotorSegmentUpdate() == null || !parcel.getManualMotorSegmentUpdate().booleanValue()) && coordinateChanged) {
            geoClientHelper.getAccessGeomForParcel(parcel, RouteVehicleType.MOTORCAR);
        }
        if (result.isFootSegmentUpdate()) {
            parcel.setFootSegment(result.getFootSegment());
            parcel.setManualFootSegmentUpdate(result.isFootSegmentUpdate());
        } else if ((parcel.getManualFootSegmentUpdate() == null || !parcel.getManualFootSegmentUpdate().booleanValue()) && coordinateChanged) {
            geoClientHelper.getAccessGeomForParcel(parcel, RouteVehicleType.FOOT);
        }
        if (result.isBikeSegmentUpdate()) {
            parcel.setBikeSegment(result.getBikeSegment());
            parcel.setManualBikeSegmentUpdate(result.isBikeSegmentUpdate());
        } else if ((parcel.getManualBikeSegmentUpdate() == null || !parcel.getManualBikeSegmentUpdate().booleanValue()) && coordinateChanged) {
            geoClientHelper.getAccessGeomForParcel(parcel, RouteVehicleType.BIKE);
        }
        geoClientHelper.setNewSegment(false);
    }

    public static Integer getSortOrder(ParcelModel parcel, AreaObjectModel areaObject, RouteVehicleType vehicle, DeliveryRoundModel round, ParcelSortOrderType type) {
        AreaObjectParcelRelModel rel = ParcelModelUtil.findRelation(parcel, areaObject);
        ParcelSortOrderModel found = rel == null ? null : ParcelModelUtil.findParcelSortOrder(rel, vehicle, round, type);
        return found == null ? null : found.getValue();
    }

    public static void setSortOrder(ParcelModel parcel, AreaObjectModel areaObject, Integer sortOrder, RouteVehicleType vehicle, DeliveryRoundModel round, ParcelSortOrderType type) {
        ParcelSortOrderModel found;
        AreaObjectParcelRelModel rel = ParcelModelUtil.findRelation(parcel, areaObject);
        if (rel == null) {
            rel = new AreaObjectParcelRelModelImpl();
            rel.setAreaObject(areaObject);
            rel.setParcel(parcel);
        }
        if ((found = ParcelModelUtil.findParcelSortOrder(rel, vehicle, round, type)) == null) {
            found = new ParcelSortOrderModelImpl();
            found.setAreaObjectParcelRel(rel);
            found.setVehicle(vehicle);
            found.setDeliveryRound(type == ParcelSortOrderType.MANUAL ? round : null);
            found.setType(type);
        }
        if (found.getValue() == null || NumericUtil.getIntegerValue(sortOrder) != NumericUtil.getIntegerValue(found.getValue())) {
            found.setValue(sortOrder);
        }
    }

    private static AreaObjectParcelRelModel findRelation(ParcelModel parcel, AreaObjectModel areaObject) {
        AreaObjectParcelRelModel found = null;
        if (parcel != null && areaObject != null) {
            for (AreaObjectParcelRelModel rel : parcel.iterableAreaObjectParcelRel()) {
                if (!rel.getAreaObject().equals(areaObject)) continue;
                found = rel;
                break;
            }
        }
        return found;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ParcelSortOrderModel findParcelSortOrder(AreaObjectParcelRelModel rel, RouteVehicleType vehicle, DeliveryRoundModel round, ParcelSortOrderType type) {
        ParcelSortOrderModel found = null;
        if (vehicle == null) return found;
        if (type == ParcelSortOrderType.MANUAL && round == null) {
            return found;
        }
        Iterator<ParcelSortOrderModel> iterator = rel.iterableSortOrders().iterator();
        while (iterator.hasNext()) {
            ParcelSortOrderModel sortOrder = iterator.next();
            if (type != sortOrder.getType() || vehicle != sortOrder.getVehicle()) continue;
            switch (type) {
                case MANUAL: {
                    if (!round.equals(sortOrder.getDeliveryRound())) break;
                    return sortOrder;
                }
                case OPTIMAL_ALL: {
                    return sortOrder;
                }
            }
        }
        return found;
    }

    public static SegmentStatus getSegmentStatus(ParcelModel parcel) {
        SegmentModel motor = parcel.getMotorSegment();
        SegmentModel foot = parcel.getFootSegment();
        SegmentModel bike = parcel.getBikeSegment();
        return SegmentModelUtil.getBadestStatus(motor, foot, bike);
    }

    public static boolean isEqualToAtLeastOneAlias(ParcelModel parcel, LocationWrapper locationWrapper) {
        return ParcelModelUtil.isEqualToAtLeastOneAlias(parcel, locationWrapper, true);
    }

    public static boolean isEqualToAtLeastOneAlias(ParcelModel parcel, LocationWrapper locationWrapper, boolean withCountry) {
        StreetModel streetModel = parcel.getStreet();
        PostcodeDistrictRelationModel postcodeDistrictRelationModel = streetModel.getPostcodeDistrictRelation();
        PostcodeModel postcodeModel = postcodeDistrictRelationModel.getPostcode();
        DistrictModel districtModel = postcodeDistrictRelationModel.getDistrict();
        CityModel cityModel = districtModel.getCity();
        if (withCountry && postcodeModel.getCountry() != locationWrapper.getCountry()) {
            return false;
        }
        if (!new EqualsBuilder().append(parcel.getHouseNumber(), StringUtil.nullToFallback(locationWrapper.getHousenumber(), null)).append(parcel.getHouseNumberExtension(), locationWrapper.getHousenumberExtension()).append(postcodeModel.getName(), locationWrapper.getPostcode()).isEquals()) {
            return false;
        }
        boolean found = false;
        String lStreet = locationWrapper.getStreet();
        for (StreetAliasModel streetAliasModel : streetModel.iterableAlias()) {
            if (!new EqualsBuilder().append(streetAliasModel.getName(), lStreet).isEquals()) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        found = false;
        String lCity = locationWrapper.getCity();
        for (CityAliasModel cityAlias : cityModel.iterableAlias()) {
            if (!new EqualsBuilder().append(cityAlias.getName(), lCity).isEquals()) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        found = false;
        String string = locationWrapper.getDistrict();
        for (DistrictAliasModel districtAlias : districtModel.iterableAlias()) {
            if (!new EqualsBuilder().append(districtAlias.getName(), string).isEquals()) continue;
            found = true;
            break;
        }
        return found;
    }

    public static Color getColorOfParcel(ParcelModel parcel, Collection<SubscriptionModel> subscriptions, RouteVehicleType vehicleType, Color defaultColor) {
        boolean badSegment = false;
        if (vehicleType != null) {
            SegmentStatus segmentStatus;
            SegmentModel routeSegment = ParcelModelUtil.getRouteSegment(parcel, vehicleType);
            SegmentStatus segmentStatus2 = segmentStatus = routeSegment == null ? null : routeSegment.getSegmentStatus();
            badSegment = routeSegment == null ? true : (segmentStatus == null ? false : segmentStatus.isBad(vehicleType));
        }
        ImportParcelStatus status = parcel.getImportStatus();
        if (parcel.getStreet() == null || GeoUtil.isNullPoint(parcel.getGeom()) || badSegment) {
            defaultColor = Color.RED;
        } else if (status != null && (status == ImportParcelStatus.NOTCHECKED || status == ImportParcelStatus.NOTCHANGED)) {
            defaultColor = Color.RED;
        } else if (ParcelModelUtil.parcelWithSubscription(parcel, subscriptions)) {
            defaultColor = new Color(50, 150, 255, 200);
        }
        return defaultColor;
    }

    public static Double getParcelLocation(ParcelModel parcel) {
        if (parcel != null) {
            for (ParcelAttributeValueModel value : parcel.iterableParcelAttributeValues()) {
                ParcelAttributeValueDescriptorModel descriptor = value.getParcelAttributeValueDescriptor();
                if (descriptor == null || !descriptor.getKey().equals("PARCEL-LOCATION")) continue;
                return value.getFloatValue();
            }
        }
        return null;
    }
}

