/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.client.geometric.GeoClientHelper;
import de.datomino.peppergis.client.gui.location.GeomEditorResult;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.print.DefaultPrintingInformation;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.SegmentModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.print.TableRowEntity;
import de.datomino.peppergis.type.SegmentStatus;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.io.Serializable;
import java.util.Map;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class LocationModelUtil {
    public static String getAddressForPrint(LocationModel location) {
        if (location == null) {
            return "";
        }
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        String streetString = LocationModelUtil.getStreetString(locationWrapper);
        String postCodeAndCityString = LocationModelUtil.getCityString(locationWrapper);
        return streetString + "/n" + postCodeAndCityString;
    }

    public static String getAddressString(LocationModel location) {
        return LocationModelUtil.getAddressString(location, true);
    }

    public static String getAddressString(LocationModel location, boolean withCity) {
        String s = "";
        if (location == null) {
            s = "";
        } else {
            LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
            s = FormUtil.getAddressStringForLegend(locationWrapper.getStreet(), locationWrapper.getHousenumber(), locationWrapper.getHousenumberExtension());
            if (withCity) {
                s = s + ", " + LocationModelUtil.getCityString(locationWrapper);
            }
        }
        return s;
    }

    public static String getAddressShortString(LocationModel location) {
        if (location == null) {
            return "";
        }
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        return LocationModelUtil.getAddressShortString(locationWrapper);
    }

    private static String getAddressShortString(LocationWrapper locationWrapper) {
        if (locationWrapper == null) {
            return "";
        }
        String housenumber = ClientFormUtil.getNumberString(locationWrapper.getHousenumber());
        String housenumberExtension = FormUtil.getStringDisplay(locationWrapper.getHousenumberExtension());
        String street = "";
        String city = "";
        try {
            street = FormUtil.getStringDisplay(locationWrapper.getStreet()) + "/";
            city = FormUtil.getStringDisplay(locationWrapper.getCity()) + "/";
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return city + street + housenumber + housenumberExtension;
    }

    public static String getStreetString(LocationWrapper locationWrapper) {
        if (locationWrapper == null) {
            return "";
        }
        String housenumber = ClientFormUtil.getNumberString(locationWrapper.getHousenumber());
        String housenumberExtension = FormUtil.getStringDisplay(locationWrapper.getHousenumberExtension());
        String street = locationWrapper == null ? "" : FormUtil.getStringDisplay(locationWrapper.getStreet());
        return street + " " + housenumber + housenumberExtension;
    }

    public static Tripel<String, Integer, String> getAddressTripel(LocationModel location) {
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        if (locationWrapper == null) {
            return new Tripel<String, Integer, String>("", 0, "");
        }
        String streetName = FormUtil.getStringDisplay(locationWrapper.getStreet());
        Integer hnr = locationWrapper.getHousenumber();
        String ext = FormUtil.getStringDisplay(locationWrapper.getHousenumberExtension());
        return new Tripel<String, Integer, String>(streetName, hnr, ext);
    }

    public static String getCityString(LocationWrapper locationWrapper) {
        if (locationWrapper == null) {
            return "";
        }
        return FormUtil.getCityString(locationWrapper.getCity(), locationWrapper.getPostcode());
    }

    public static ImmutablePoint getGeom(LocationModel location) {
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        return locationWrapper.getGeoLocation();
    }

    public static ImmutablePoint getAccessGeom(LocationModel location, RouteVehicleType routeVehicleType, ModelEnviroment modelEnviroment) {
        SegmentModel segment = LocationModelUtil.getRouteSegment(location, routeVehicleType, modelEnviroment);
        if (segment != null) {
            Tupel<Double, ImmutablePoint> tupel = GeoUtil.getShortestPerpendicular(LocationModelUtil.getGeom(location), segment.getGeom());
            return tupel.getElement2();
        }
        return null;
    }

    public static SegmentModel getRouteSegment(LocationModel location, RouteVehicleType routeVehicleType) {
        if (routeVehicleType == null) {
            return null;
        }
        SegmentModel segment = null;
        switch (routeVehicleType) {
            case BIKE: {
                segment = location == null ? null : location.getBikeSegment();
                break;
            }
            case FOOT: {
                segment = location == null ? null : location.getFootSegment();
                break;
            }
            default: {
                segment = location == null ? null : location.getMotorSegment();
            }
        }
        return segment;
    }

    public static SegmentModel getRouteSegment(LocationModel location, RouteVehicleType routeVehicleType, ModelEnviroment modelEnviroment) {
        if (location == null) {
            return null;
        }
        if (routeVehicleType == null) {
            routeVehicleType = RouteVehicleType.MOTORCAR;
        }
        modelEnviroment.getUndoManager().startTransaction();
        boolean update = false;
        SegmentModel segment = ParcelModelUtil.getRouteSegment(location.getParcel(), routeVehicleType);
        switch (routeVehicleType) {
            case MOTORCAR: {
                if (!(segment == null || location.getMotorSegment() != null && segment.equals(location.getMotorSegment()))) {
                    location.setMotorSegment(segment);
                    update = true;
                    break;
                }
                if (segment != null) break;
                segment = location.getMotorSegment();
                break;
            }
            case BIKE: {
                if (!(segment == null || location.getBikeSegment() != null && segment.equals(location.getBikeSegment()))) {
                    location.setBikeSegment(segment);
                    update = true;
                    break;
                }
                if (segment != null) break;
                segment = location.getBikeSegment();
                break;
            }
            case FOOT: {
                if (!(segment == null || location.getFootSegment() != null && segment.equals(location.getFootSegment()))) {
                    location.setFootSegment(segment);
                    update = true;
                    break;
                }
                if (segment != null) break;
                segment = location.getFootSegment();
            }
        }
        if (update) {
            modelEnviroment.getUndoManager().finishTransaction("");
            modelEnviroment.getUndoManager().startTransaction();
        }
        return segment;
    }

    public static void getPrintingInformation(LocationModel location, Color color, PrinterInformation.LineGroupType group, TableRowEntity row, Map<PrintPropertyKey, Serializable> properties) {
        LocationWrapper w = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        if (w == null) {
            DefaultPrintingInformation.addAddressRow("", "", "", "", "", "", "", properties, row, color, group);
        } else {
            String countryString = w.getCountry() == null ? "" : w.getCountry().getVehicleSign();
            DefaultPrintingInformation.addAddressRow(countryString, w.getCity(), w.getDistrict(), w.getPostcode(), w.getStreet(), ClientFormUtil.getNumberString(w.getHousenumber()), w.getHousenumberExtension(), properties, row, color, group);
        }
    }

    public static boolean changedAddress(ImportedLocationModel importedLocation, LogisticLocationDto<Long> locationDto) {
        return LocationModelUtil.changedAddress(LocationWrapperFactory.INSTANCE.createLocationWrapper(importedLocation), locationDto);
    }

    public static boolean changedAddress(LocationWrapper wrapper, LogisticLocationDto<Long> locationDto) {
        boolean b = wrapper.getCountry() == null ? true : wrapper.getCountry().equals(locationDto.getCountry());
        b &= StringUtil.getNotNull(wrapper.getPostcode()).equals(StringUtil.getNotNull(locationDto.getPostcode()));
        b &= StringUtil.getNotNull(wrapper.getCity()).equals(StringUtil.getNotNull(locationDto.getCity()));
        b &= StringUtil.getNotNull(wrapper.getDistrict()).equals(StringUtil.getNotNull(locationDto.getDistrict()));
        b &= StringUtil.getNotNull(wrapper.getStreet()).equals(StringUtil.getNotNull(locationDto.getStreet()));
        String number = wrapper.getHousenumber() == null ? "" : String.valueOf(wrapper.getHousenumber());
        b &= StringUtil.getNotNull(number).equals(StringUtil.getNotNull(locationDto.getHousenumber()));
        return !(b &= StringUtil.getNotNull(wrapper.getHousenumberExtension()).equals(StringUtil.getNotNull(locationDto.getExtension())));
    }

    public static void setGeomResult(LocationModel location, GeomEditorResult result, GeoClientHelper geoClientHelper) {
        if (location == null) {
            return;
        }
        ImmutablePoint newPoint = ImmutableGeoObjectFactory.createImmutablePoint(result.getCoordinate());
        LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        wrapper.setGeoLocation(newPoint);
        location.setMotorSegment(result.getMotorSegment());
        location.setFootSegment(result.getFootSegment());
        location.setBikeSegment(result.getBikeSegment());
        ParcelModelUtil.setGeomResult(location.getParcel(), result, geoClientHelper);
    }

    public static SegmentStatus getSegmentStatus(LocationModel location) {
        SegmentModel motor = location.getMotorSegment();
        SegmentModel foot = location.getFootSegment();
        SegmentModel bike = location.getBikeSegment();
        return SegmentModelUtil.getBadestStatus(motor, foot, bike);
    }

    public static boolean areSamedAddress(LocationModel l1, LocationModel l2) {
        String s1 = LocationModelUtil.getAddressString(l1).toLowerCase();
        String s2 = LocationModelUtil.getAddressString(l2).toLowerCase();
        return s1.equals(s2);
    }

    public static LocationModel getLocationModel(Model model) {
        LocationModel location = null;
        if (model instanceof SubscriptionModel) {
            location = ((SubscriptionModel)model).getLocation();
        } else if (model instanceof LetterModel) {
            location = ((LetterModel)model).getLocation();
        } else if (model instanceof PoiModel) {
            location = ((PoiModel)model).getLocation();
        } else if (model instanceof StopModel) {
            location = ((StopModel)model).getLocation();
        }
        return location;
    }
}

