/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.pdf.printer.PrinterInformation;
import de.datomino.peppergis.client.auth.UserInformation;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.base.LetterAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.LetterAttributeValueModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LetterSortOrderModel;
import de.datomino.peppergis.client.model.base.LetterSortOrderModelImpl;
import de.datomino.peppergis.client.model.base.LetterStaticChoiceAttributeValueModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.AreaStopModel;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.client.util.AreaTourModelUtil;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.attribute.AttributeHelper;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.client.util.wrapper.letter.attribute.LetterAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.print.PrintContentValue;
import de.datomino.peppergis.print.PrintPropertyKey;
import de.datomino.peppergis.print.TableCellEntity;
import de.datomino.peppergis.print.TableRowEntity;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.PrintContentKey;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.NumericUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;

public final class LetterModelUtil {
    private LetterModelUtil() {
    }

    public static boolean isLetterModifiable(LetterModel letter) {
        UserInformation userInformation = ModelEnviroment.getUserInformation();
        boolean b = userInformation.hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER);
        if (b) {
            return b;
        }
        AreaLayerModel areaLayer = letter.getAreaLayer();
        if (areaLayer == null) {
            return false;
        }
        Set<Long> layerIds = userInformation.getAttachedIdsForUserRole(UserRole.AREA_EDITOR);
        return layerIds.contains(areaLayer.getId());
    }

    public static List<String> getInfoBoxString(LetterModel letter) {
        return Arrays.asList(letter.getLetterNumber(), LetterModelUtil.getName(letter));
    }

    public static ImmutablePoint getGeom(LetterModel letter) {
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(letter.getLocation());
        return locationWrapper.getGeoLocation();
    }

    public static boolean checkGeomOfLetter(LetterModel letter) {
        boolean valid = true;
        ImmutablePoint nullPoint = ImmutableGeoObjectFactory.createImmutablePoint(Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0));
        ImmutablePoint geom = LetterModelUtil.getGeom(letter);
        if (geom == null) {
            valid = false;
        } else if (geom == null || ((ImmutablePoint)geom.getTransformed(Wgs84Factory.INSTANCE)).equals(nullPoint)) {
            valid = false;
        }
        return valid;
    }

    public static String getDisplayString(LetterModel letter) {
        LocationModel location = letter.getLocation();
        StringBuilder sb = new StringBuilder(letter.getLetterNumber()).append(": ");
        String name = LetterModelUtil.getName(letter);
        sb.append(name);
        sb.append(", ").append(LocationModelUtil.getAddressString(location, true));
        return sb.toString();
    }

    private static String getName(LetterModel letter) {
        boolean natural;
        String companyName = letter.getCompanyName();
        String lastName = letter.getLastName();
        String firstName = letter.getFirstName();
        boolean company = !StringUtil.isBlank(companyName);
        boolean bl = natural = !StringUtil.isBlank(lastName) || !StringUtil.isBlank(firstName);
        String name = company && natural ? companyName.trim() + " (" + (StringUtil.nullToEmpty(firstName.trim()) + " " + StringUtil.nullToEmpty(lastName).trim()).trim() + ")" : (company ? companyName.trim() : (natural ? (StringUtil.nullToEmpty(firstName) + " " + StringUtil.nullToEmpty(lastName)).trim() : ""));
        return name;
    }

    public static void getPrintInformation(LegendObject<LetterModel> legendObject, List<LetterAttributeValueDescriptorModelAttributeWrapper> letterDescriptors, Color color, PrinterInformation.LineGroupType lineGroupType, TableRowEntity row, Map<PrintPropertyKey, Serializable> letterProperties, boolean mixed) {
        LetterModel letter = legendObject.getM();
        LocationModel location = letter.getLocation();
        LocationModelUtil.getPrintingInformation(location, color, lineGroupType, row, letterProperties);
        if (lineGroupType == PrinterInformation.LineGroupType.NORMAL) {
            Integer distanceValue = legendObject.getStreetMileageMetersFromTourStart();
            Integer durationValue = legendObject.getEstimatedDurationSeconds();
            LetterModelUtil.addAttributesForPrint(letter, distanceValue, durationValue, letterDescriptors, color, lineGroupType, letterProperties, row);
        }
    }

    public static void addAttributesForPrint(LetterModel letter, Integer distanceValue, Integer durationValue, List<LetterAttributeValueDescriptorModelAttributeWrapper> letterDescriptors, Color color, PrinterInformation.LineGroupType lineGroupType, Map<PrintPropertyKey, Serializable> letterProperties, TableRowEntity row) {
        PrintContentValue duration;
        PrintContentValue distance;
        ArrayList<TableCellEntity> shortAttributes = new ArrayList<TableCellEntity>();
        ArrayList<String> textAttributes = new ArrayList<String>();
        PrintContentValue customer = (PrintContentValue)letterProperties.get(PrintContentKey.CUSTOMER);
        if (customer.isPrint()) {
            shortAttributes.add(customer.createCell(LetterModelUtil.getPrintInfoFromCustomer(letter), color));
        }
        if ((distance = (PrintContentValue)letterProperties.get(PrintContentKey.DISTANCE_FROM_START)).isPrint()) {
            shortAttributes.add(distance.createCell(ClientFormUtil.getNumberString(distanceValue), color));
        }
        if ((duration = (PrintContentValue)letterProperties.get(PrintContentKey.DURATION_FROM_START)).isPrint()) {
            shortAttributes.add(duration.createCell(ClientFormUtil.getNumberString(durationValue), color));
        }
        LetterModelUtil.getInfoFromAttribute(letter, letterDescriptors, shortAttributes, textAttributes, color);
        switch (lineGroupType) {
            case ADDRESS: 
            case STREET: {
                String mainInfo = "";
                for (TableCellEntity tableCellEntity : shortAttributes) {
                    if (!StringUtil.isBlank(mainInfo)) {
                        mainInfo = mainInfo + " - ";
                    }
                    mainInfo = mainInfo + tableCellEntity.getText();
                }
                row.getInfos().add(mainInfo);
                for (String string : textAttributes) {
                    row.getInfos().add(" - " + string);
                }
                break;
            }
            case NORMAL: {
                for (TableCellEntity tableCellEntity : shortAttributes) {
                    row.add(tableCellEntity);
                }
                row.getInfos().addAll(textAttributes);
            }
        }
    }

    private static void getInfoFromAttribute(LetterModel letter, List<LetterAttributeValueDescriptorModelAttributeWrapper> descriptorsForPrinting, List<TableCellEntity> shortAttributes, List<String> textAttributes, Color color) {
        for (LetterAttributeValueDescriptorModelAttributeWrapper descriptorWrapper : descriptorsForPrinting) {
            if (descriptorWrapper == null || descriptorWrapper.getAttachedObject() == null) continue;
            boolean isFand = false;
            if (descriptorWrapper.getAttributeValueType() == AttributeValueType.TEXT) {
                isFand = true;
            }
            Iterator<LetterAttributeValueModel> iter = letter.iterateLetterAttributeValues();
            while (iter.hasNext()) {
                LetterAttributeValueModel attribute = iter.next();
                if (attribute == null || !descriptorWrapper.getAttachedObject().equals(attribute.getLetterAttributeValueDescriptor())) continue;
                isFand = true;
                String value = LetterModelUtil.getValue(attribute, true);
                if (descriptorWrapper.getAttributeValueType() == AttributeValueType.TEXT) {
                    if (attribute.getTextValue() == null || attribute.getTextValue().equals("")) break;
                    if (textAttributes == null) {
                        textAttributes = new LinkedList<String>();
                    }
                    textAttributes.add(descriptorWrapper.getKey() + ": " + value);
                    break;
                }
                Integer printLength = attribute.getLetterAttributeValueDescriptor().getPrintLength();
                if (printLength != null) {
                    value = FormUtil.getStringWithLength(value, printLength);
                }
                shortAttributes.add(new TableCellEntity(descriptorWrapper.getPrintLength(), value, color, descriptorWrapper.getPrintSortOrder()));
                break;
            }
            if (isFand) continue;
            shortAttributes.add(new TableCellEntity(descriptorWrapper.getPrintLength(), "", color, descriptorWrapper.getPrintSortOrder()));
        }
    }

    private static String getValue(LetterAttributeValueModel attributeValue, boolean trim) {
        LetterAttributeValueDescriptorModel letterAttributeValueDescriptor = attributeValue.getLetterAttributeValueDescriptor();
        String value = null;
        Boolean booleanValue = attributeValue.getBooleanValue();
        switch (letterAttributeValueDescriptor.getAttributeValueType()) {
            case BOOLEAN: {
                if (booleanValue != null && booleanValue.booleanValue()) {
                    value = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.yes", new Serializable[0]);
                    break;
                }
                value = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.no", new Serializable[0]);
                break;
            }
            case DATE: {
                Long longValue = attributeValue.getLongValue();
                if (longValue == null) break;
                Date date = new Date(longValue);
                value = new SimpleDateFormat("yyyy-MM-dd").format(date);
                break;
            }
            case FLOAT: {
                Double doubleValue = attributeValue.getFloatValue();
                if (doubleValue == null) break;
                value = doubleValue.toString();
                break;
            }
            case IMAGE: {
                break;
            }
            case INTEGER: {
                Integer intValue = attributeValue.getIntegerValue();
                if (intValue == null) break;
                value = intValue.toString();
                break;
            }
            case MULTIPLE_LIST_CHOICE: {
                break;
            }
            case MULTI_INTEGER: {
                value = AttributeHelper.getStringRepresentationForMultiInteger(attributeValue.getStringValue());
                break;
            }
            case PDF_DOWN: {
                break;
            }
            case STATIC_CHOICE: {
                LetterStaticChoiceAttributeValueModel staticChoiceValue = attributeValue.getStaticChoiceValue();
                if (staticChoiceValue == null) break;
                value = staticChoiceValue.getName();
                break;
            }
            case STRING: {
                value = attributeValue.getStringValue();
                break;
            }
            case TEXT: {
                value = attributeValue.getTextValue();
            }
        }
        return value == null ? null : (trim ? value.trim() : value);
    }

    private static String getPrintInfoFromCustomer(LetterModel letter) {
        return LetterModelUtil.getName(letter);
    }

    public static void deleteLetter(LetterModel letter, ModelEnviroment modelEnvironment) {
        if (letter != null) {
            ModelCache modelCache = modelEnvironment.getModelCache();
            for (LetterSortOrderModel order : letter.iterableSortOrders()) {
                modelCache.evictModel(order);
                order.delete();
            }
            for (LetterAttributeValueModel value : letter.iterableLetterAttributeValues()) {
                modelCache.evictModel(value);
                value.delete();
            }
            HashSet<AreaTourModel> toDeletes = new HashSet<AreaTourModel>();
            Collection<AreaStopModel> areaStopModels = modelEnvironment.getAllCaller().getTourCaller().fetchAreaStop(null, null, null, letter);
            for (AreaStopModel areaStopModel : areaStopModels) {
                toDeletes.add(areaStopModel.getAreaTourPart().getAreaTour());
            }
            AreaTourModelUtil.deleteAreaTours(toDeletes, modelEnvironment);
            letter.delete();
        }
    }

    public static Map<ParcelModel, Set<LetterModel>> findParcelMap(List<LetterModel> letters) {
        HashMap<ParcelModel, Set<LetterModel>> map = new HashMap<ParcelModel, Set<LetterModel>>();
        if (letters != null) {
            for (LetterModel letter : letters) {
                ParcelModel parcel = letter.getLocation().getParcel();
                if (parcel == null) continue;
                HashSet<LetterModel> value = (HashSet<LetterModel>)map.get(parcel);
                if (value == null) {
                    value = new HashSet<LetterModel>();
                    map.put(parcel, value);
                }
                value.add(letter);
            }
        }
        return map;
    }

    public static Integer getSortOrder(LetterModel letter, RouteVehicleType vehicle, DeliveryRoundModel round) {
        LetterSortOrderModel found = letter == null ? null : LetterModelUtil.findSortOrder(letter, vehicle, round);
        return found == null ? null : found.getValue();
    }

    public static void setSortOrder(LetterModel letter, Integer sortOrder, RouteVehicleType vehicle, DeliveryRoundModel round) {
        LetterSortOrderModel found = LetterModelUtil.findSortOrder(letter, vehicle, round);
        if (found == null) {
            found = new LetterSortOrderModelImpl();
            found.setLetter(letter);
            found.setVehicle(vehicle);
            found.setDeliveryRound(round);
        }
        if (found.getValue() == null || NumericUtil.getIntegerValue(sortOrder) != NumericUtil.getIntegerValue(found.getValue())) {
            found.setValue(sortOrder);
        }
    }

    private static LetterSortOrderModel findSortOrder(LetterModel letter, RouteVehicleType vehicle, DeliveryRoundModel round) {
        LetterSortOrderModel found = null;
        if (vehicle == null || round == null) {
            return found;
        }
        for (LetterSortOrderModel sortOrder : letter.iterableSortOrders()) {
            if (vehicle != sortOrder.getVehicle() || !round.equals(sortOrder.getDeliveryRound())) continue;
            found = sortOrder;
            break;
        }
        return found;
    }
}

