/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.peppergis.client.model.tour.DeliveryProductModel;
import de.datomino.peppergis.client.model.tour.DeliveryRoundModel;
import de.datomino.peppergis.type.areatourtype.AreaObjectType;

public final class DeliveryRoundModelUtil {
    public static AreaObjectType getAreaObjectTypeForDeliveryRound(DeliveryRoundModel deliveryRound) {
        boolean parcel = false;
        boolean letter = false;
        boolean subscription = false;
        for (DeliveryProductModel product : deliveryRound.iterableDeliveryProducts()) {
            switch (product.getProduct()) {
                case LEAFLET: 
                case WEEKLY_PAPER: {
                    parcel = true;
                    break;
                }
                case LETTER: {
                    letter = true;
                    break;
                }
                case SUBSCRIPTION: {
                    subscription = true;
                }
            }
        }
        if (!(parcel || letter || subscription)) {
            return null;
        }
        if (parcel && !letter && !subscription) {
            return AreaObjectType.PARCEL;
        }
        if (!parcel && letter && !subscription) {
            return AreaObjectType.LETTER;
        }
        if (!parcel && !letter && subscription) {
            return AreaObjectType.SUBSCRIPTION;
        }
        if (parcel && letter && !subscription) {
            return AreaObjectType.PARCEL_WITH_LETTER;
        }
        if (parcel && !letter && subscription) {
            return AreaObjectType.PARCEL_SUBSCRIPTION;
        }
        if (!parcel && letter && subscription) {
            return AreaObjectType.SUBSCRIPTION_WITH_LETTER;
        }
        if (parcel && letter && subscription) {
            return AreaObjectType.PARCEL_SUBSCRIPTION_LETTER;
        }
        throw new RuntimeException("can never reach this line of code");
    }
}

