/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.AreaDelivererEmploymentModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererFactorModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererMaxSalaryModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererNightSurchargeModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererRewardModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererStatusTimeWindowModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererStatusTimeWindowModelImpl;
import de.datomino.peppergis.client.model.tour.AreaDelivererSurchargeModel;
import de.datomino.peppergis.client.model.tour.DelivererEmploymentModel;
import de.datomino.peppergis.client.model.tour.DelivererFactorModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererStatusTimeWindowModel;
import de.datomino.peppergis.client.model.tour.DelivererStatusTimeWindowModelImpl;
import de.datomino.peppergis.type.DelivererStatus;
import de.datomino.peppergis.util.TimeComparator;
import de.datomino.util.NumericUtil;
import de.datomino.util.time.TimeUtil;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class DelivererModelUtil {
    public static String getDisplayString(DelivererModel deliverer) {
        if (deliverer == null) {
            return "";
        }
        String number = deliverer.getDelivererNumber();
        String name = deliverer.getName();
        String branch = deliverer.getBranch() == null ? "" : " (" + deliverer.getBranch().getName() + ")";
        return number + " - " + name + branch;
    }

    public static String getDisplayString(AreaDelivererModel deliverer) {
        if (deliverer == null) {
            return "";
        }
        String number = deliverer.getDelivererNumber();
        String name = deliverer.getName();
        String branch = deliverer.getBranch() == null ? "" : " (" + deliverer.getBranch().getName() + ")";
        return number + " - " + name + branch;
    }

    public static String getDisplayForPlanTable(DelivererModel deliverer, boolean withVehicle, String prefix) {
        if (deliverer == null) {
            return "";
        }
        String displayContent = StringUtil.getNotNull(prefix) + "\n" + deliverer.getDelivererNumber() + " - " + deliverer.getName();
        if (withVehicle) {
            String vehicle;
            String string = vehicle = deliverer.getVehicle() == null ? null : deliverer.getVehicle().getName();
            if (vehicle != null) {
                displayContent = displayContent + "\n" + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.wagon", new Serializable[0]) + ": " + vehicle + "\n";
            }
        }
        return displayContent;
    }

    public static String getDisplayForPlanTable(AreaDelivererModel deliverer, boolean withVehicle, String prefix) {
        if (deliverer == null) {
            return "";
        }
        String displayContent = StringUtil.getNotNull(prefix) + "\n" + deliverer.getDelivererNumber() + " - " + deliverer.getName();
        if (withVehicle) {
            String vehicle;
            String string = vehicle = deliverer.getVehicle() == null ? null : deliverer.getVehicle().getName();
            if (vehicle != null) {
                displayContent = displayContent + "\n" + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.wagon", new Serializable[0]) + ": " + vehicle + "\n";
            }
        }
        return displayContent;
    }

    private static String getContent(DelivererModel deliverer, String key) {
        if (key != null) {
            if (key.equals("NAME")) {
                return deliverer.getName();
            }
            if (key.equals("NUMBER")) {
                return deliverer.getDelivererNumber();
            }
        }
        return "";
    }

    public static Double getCurrentFactor(DelivererModel deliverer) {
        Double d = null;
        List<DelivererFactorModel> factors = DelivererModelUtil.getSortedDelivererFactors(deliverer);
        if (!factors.isEmpty()) {
            d = factors.get(0).getFactor();
        }
        return d;
    }

    public static List<DelivererFactorModel> getSortedDelivererFactors(DelivererModel deliverer) {
        DelivererEmploymentModel employment;
        DelivererEmploymentModel delivererEmploymentModel = employment = deliverer == null ? null : deliverer.getEmployment();
        if (employment == null) {
            return Collections.emptyList();
        }
        ArrayList<DelivererFactorModel> list = new ArrayList<DelivererFactorModel>(employment.countFactors());
        for (DelivererFactorModel factor : employment.iterableFactors()) {
            list.add(factor);
        }
        Collections.sort(list, new TimeComparator<DelivererFactorModel>(false){

            @Override
            protected Date getTime(DelivererFactorModel o) {
                return o.getLastModifiedDate();
            }
        });
        return list;
    }

    public static Double getCurrentFactor(AreaDelivererModel deliverer) {
        Double d = null;
        List<AreaDelivererFactorModel> factors = DelivererModelUtil.getSortedDelivererFactors(deliverer);
        if (!factors.isEmpty()) {
            d = factors.get(0).getFactor();
        }
        return d;
    }

    public static List<AreaDelivererFactorModel> getSortedDelivererFactors(AreaDelivererModel deliverer) {
        AreaDelivererEmploymentModel employment;
        AreaDelivererEmploymentModel areaDelivererEmploymentModel = employment = deliverer == null ? null : deliverer.getEmployment();
        if (employment == null) {
            return Collections.emptyList();
        }
        ArrayList<AreaDelivererFactorModel> list = new ArrayList<AreaDelivererFactorModel>(employment.countFactors());
        for (AreaDelivererFactorModel factor : employment.iterableFactors()) {
            list.add(factor);
        }
        Collections.sort(list, new TimeComparator<AreaDelivererFactorModel>(false){

            @Override
            protected Date getTime(AreaDelivererFactorModel o) {
                return o.getLastModifiedDate();
            }
        });
        return list;
    }

    public static Tupel<Date, Date> getAbsentTupel(DelivererModel deliverer, Tupel<Date, Date> timewindow) {
        Date absentFrom = null;
        Date absentTill = null;
        if (deliverer != null) {
            for (DelivererStatusTimeWindowModel m : deliverer.iterableStatusTimeWindows()) {
                if (m.getStatus() == null) continue;
                Tupel<Date, Date> cover = TimeUtil.findCover(timewindow, new Tupel<Date, Date>(m.getStartTime(), m.getEndTime()));
                if (absentFrom == null) {
                    absentFrom = cover.getElement1();
                } else if (cover.getElement1() != null && cover.getElement1().before(absentFrom)) {
                    absentFrom = cover.getElement1();
                }
                if (absentTill == null) {
                    absentTill = cover.getElement2();
                    continue;
                }
                if (cover.getElement2() == null || !cover.getElement2().after(absentTill)) continue;
                absentTill = cover.getElement2();
            }
        }
        return new Tupel<Object, Object>(absentFrom, absentTill);
    }

    public static DelivererStatus getStatus(DelivererModel deliverer, Date date) {
        DelivererStatus status = null;
        for (DelivererStatusTimeWindowModel statusTimeWindows : deliverer.iterableStatusTimeWindows()) {
            Date endTime;
            Date startTime = statusTimeWindows.getStartTime();
            if (startTime != null && startTime.after(date) || (endTime = statusTimeWindows.getEndTime()) != null && endTime.before(date)) continue;
            status = statusTimeWindows.getStatus();
            break;
        }
        return status == null ? DelivererStatus.VACANT : status;
    }

    public static DelivererStatus getStatus(AreaDelivererModel deliverer, Date date) {
        DelivererStatus status = null;
        for (AreaDelivererStatusTimeWindowModel statusTimeWindows : deliverer.iterableStatusTimeWindows()) {
            Date endTime;
            Date startTime = statusTimeWindows.getStartTime();
            if (startTime != null && startTime.after(date) || (endTime = statusTimeWindows.getEndTime()) != null && endTime.before(date)) continue;
            status = statusTimeWindows.getStatus();
            break;
        }
        return status == null ? DelivererStatus.VACANT : status;
    }

    public static boolean setDelivererDeleted(DelivererModel deliverer) {
        return DelivererModelUtil.setDelivererDeleted(deliverer, new Date());
    }

    public static boolean setDelivererDeleted(DelivererModel deliverer, Date date) {
        boolean existingTimeWindowsAfterDeletionDate = false;
        for (DelivererStatusTimeWindowModel timeWindow : deliverer.iterableStatusTimeWindows()) {
            if (timeWindow.getEndTime() == null || !timeWindow.getEndTime().after(date)) continue;
            if (timeWindow.getStartTime() != null && timeWindow.getStartTime().after(date)) {
                deliverer.removeStatusTimeWindow(timeWindow);
                timeWindow.delete();
            } else {
                timeWindow.setEndTime(date);
            }
            existingTimeWindowsAfterDeletionDate = true;
        }
        DelivererStatusTimeWindowModelImpl delTimeWindow = new DelivererStatusTimeWindowModelImpl();
        delTimeWindow.setStartTime(date);
        delTimeWindow.setEndTime(TimeUtil.getFarFarFuture());
        delTimeWindow.setStatus(DelivererStatus.DELETED);
        deliverer.addStatusTimeWindow(delTimeWindow);
        return existingTimeWindowsAfterDeletionDate;
    }

    public static boolean setDelivererDeleted(AreaDelivererModel deliverer) {
        return DelivererModelUtil.setDelivererDeleted(deliverer, new Date());
    }

    public static boolean setDelivererDeleted(AreaDelivererModel deliverer, Date date) {
        boolean existingTimeWindowsAfterDeletionDate = false;
        for (AreaDelivererStatusTimeWindowModel timeWindow : deliverer.iterableStatusTimeWindows()) {
            if (timeWindow.getEndTime() == null || !timeWindow.getEndTime().after(date)) continue;
            if (timeWindow.getStartTime() != null && timeWindow.getStartTime().after(date)) {
                deliverer.removeStatusTimeWindow(timeWindow);
                timeWindow.delete();
            } else {
                timeWindow.setEndTime(date);
            }
            existingTimeWindowsAfterDeletionDate = true;
        }
        AreaDelivererStatusTimeWindowModelImpl delTimeWindow = new AreaDelivererStatusTimeWindowModelImpl();
        delTimeWindow.setStartTime(date);
        delTimeWindow.setEndTime(TimeUtil.getFarFarFuture());
        delTimeWindow.setStatus(DelivererStatus.DELETED);
        deliverer.addStatusTimeWindow(delTimeWindow);
        return existingTimeWindowsAfterDeletionDate;
    }

    public static int resolveTimeIntervalConflicts(Component parent, DelivererModel deliverer, DelivererStatusTimeWindowModel newTimeWindow, DefaultListModel<DelivererStatusTimeWindowModel> dlm) {
        int NO_CHOICE_MADE = 2;
        int choice = 2;
        LinkedList<DelivererStatusTimeWindowModel> toBeRemoved = new LinkedList<DelivererStatusTimeWindowModel>();
        LinkedList<DelivererStatusTimeWindowModelImpl> toBeAdded = new LinkedList<DelivererStatusTimeWindowModelImpl>();
        for (DelivererStatusTimeWindowModel delivererStatusTimeWindowModel : deliverer.iterableStatusTimeWindows()) {
            if (!TimeUtil.covers(new Tupel<Date, Date>(delivererStatusTimeWindowModel.getStartTime(), delivererStatusTimeWindowModel.getEndTime()), new Tupel<Date, Date>(newTimeWindow.getStartTime(), newTimeWindow.getEndTime()))) continue;
            if (choice == 2) {
                choice = JOptionPane.showConfirmDialog(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.timeWindow.resolveConflict", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.timeWindow.conflict", new Serializable[0]), 0, 2);
            }
            if (choice != 0) break;
            boolean oldEndTimeAfterNewOne = delivererStatusTimeWindowModel.getEndTime().after(newTimeWindow.getEndTime());
            if (delivererStatusTimeWindowModel.getStartTime().before(newTimeWindow.getStartTime())) {
                if (oldEndTimeAfterNewOne) {
                    DelivererStatusTimeWindowModelImpl existingTimeWindowFragment = new DelivererStatusTimeWindowModelImpl();
                    existingTimeWindowFragment.setStartTime(TimeUtil.add(newTimeWindow.getEndTime(), 14, 1));
                    existingTimeWindowFragment.setEndTime(delivererStatusTimeWindowModel.getEndTime());
                    existingTimeWindowFragment.setStatus(delivererStatusTimeWindowModel.getStatus());
                    toBeAdded.add(existingTimeWindowFragment);
                }
                delivererStatusTimeWindowModel.setEndTime(TimeUtil.add(newTimeWindow.getStartTime(), 14, -1));
            } else if (oldEndTimeAfterNewOne) {
                delivererStatusTimeWindowModel.setStartTime(TimeUtil.add(newTimeWindow.getEndTime(), 14, 1));
            } else {
                toBeRemoved.add(delivererStatusTimeWindowModel);
            }
            if (delivererStatusTimeWindowModel.getStartTime().before(delivererStatusTimeWindowModel.getEndTime())) continue;
            toBeRemoved.add(delivererStatusTimeWindowModel);
        }
        for (DelivererStatusTimeWindowModel delivererStatusTimeWindowModel : toBeRemoved) {
            deliverer.removeStatusTimeWindow(delivererStatusTimeWindowModel);
            dlm.removeElement(delivererStatusTimeWindowModel);
            delivererStatusTimeWindowModel.delete();
        }
        for (DelivererStatusTimeWindowModel delivererStatusTimeWindowModel : toBeAdded) {
            delivererStatusTimeWindowModel.setDeliverer(deliverer);
            dlm.addElement(delivererStatusTimeWindowModel);
        }
        return choice;
    }

    public static int resolveTimeIntervalConflicts(Component parent, AreaDelivererModel deliverer, AreaDelivererStatusTimeWindowModel newTimeWindow, DefaultListModel<AreaDelivererStatusTimeWindowModel> dlm) {
        int NO_CHOICE_MADE = 2;
        int choice = 2;
        LinkedList<AreaDelivererStatusTimeWindowModel> toBeRemoved = new LinkedList<AreaDelivererStatusTimeWindowModel>();
        LinkedList<AreaDelivererStatusTimeWindowModelImpl> toBeAdded = new LinkedList<AreaDelivererStatusTimeWindowModelImpl>();
        for (AreaDelivererStatusTimeWindowModel areaDelivererStatusTimeWindowModel : deliverer.iterableStatusTimeWindows()) {
            if (!TimeUtil.covers(new Tupel<Date, Date>(areaDelivererStatusTimeWindowModel.getStartTime(), areaDelivererStatusTimeWindowModel.getEndTime()), new Tupel<Date, Date>(newTimeWindow.getStartTime(), newTimeWindow.getEndTime()))) continue;
            if (choice == 2) {
                choice = JOptionPane.showConfirmDialog(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.timeWindow.resolveConflict", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.timeWindow.conflict", new Serializable[0]), 0, 2);
            }
            if (choice != 0) break;
            boolean oldEndTimeAfterNewOne = areaDelivererStatusTimeWindowModel.getEndTime().after(newTimeWindow.getEndTime());
            if (areaDelivererStatusTimeWindowModel.getStartTime().before(newTimeWindow.getStartTime())) {
                if (oldEndTimeAfterNewOne) {
                    AreaDelivererStatusTimeWindowModelImpl existingTimeWindowFragment = new AreaDelivererStatusTimeWindowModelImpl();
                    existingTimeWindowFragment.setStartTime(TimeUtil.add(newTimeWindow.getEndTime(), 14, 1));
                    existingTimeWindowFragment.setEndTime(areaDelivererStatusTimeWindowModel.getEndTime());
                    existingTimeWindowFragment.setStatus(areaDelivererStatusTimeWindowModel.getStatus());
                    toBeAdded.add(existingTimeWindowFragment);
                }
                areaDelivererStatusTimeWindowModel.setEndTime(TimeUtil.add(newTimeWindow.getStartTime(), 14, -1));
            } else if (oldEndTimeAfterNewOne) {
                areaDelivererStatusTimeWindowModel.setStartTime(TimeUtil.add(newTimeWindow.getEndTime(), 14, 1));
            } else {
                toBeRemoved.add(areaDelivererStatusTimeWindowModel);
            }
            if (areaDelivererStatusTimeWindowModel.getStartTime().before(areaDelivererStatusTimeWindowModel.getEndTime())) continue;
            toBeRemoved.add(areaDelivererStatusTimeWindowModel);
        }
        for (AreaDelivererStatusTimeWindowModel areaDelivererStatusTimeWindowModel : toBeRemoved) {
            deliverer.removeStatusTimeWindow(areaDelivererStatusTimeWindowModel);
            dlm.removeElement(areaDelivererStatusTimeWindowModel);
            areaDelivererStatusTimeWindowModel.delete();
        }
        for (AreaDelivererStatusTimeWindowModel areaDelivererStatusTimeWindowModel : toBeAdded) {
            areaDelivererStatusTimeWindowModel.setDeliverer(deliverer);
            dlm.addElement(areaDelivererStatusTimeWindowModel);
        }
        return choice;
    }

    public static boolean isDelivererTourMappingValid(DelivererModel deliverer, Collection<Date> dates) {
        for (Date date : dates) {
            if (DelivererModelUtil.isDelivererActive(deliverer, date)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDelivererActive(DelivererModel deliverer, Date date) {
        DelivererStatus status = DelivererModelUtil.getStatus(deliverer, date);
        return DelivererModelUtil.isDelivererStatusActive(status);
    }

    public static boolean isDelivererActive(AreaDelivererModel deliverer, Date date) {
        DelivererStatus status = DelivererModelUtil.getStatus(deliverer, date);
        return DelivererModelUtil.isDelivererStatusActive(status);
    }

    public static boolean isDelivererStatusActive(DelivererStatus status) {
        return status == DelivererStatus.VACANT || status == DelivererStatus.OCCUPIED;
    }

    public static Color determineColor(AreaDelivererModel deliverer, Date date) {
        Color c = Color.DARK_GRAY;
        if (deliverer != null && date != null) {
            c = Color.GREEN.darker().darker().darker();
            block8: for (AreaDelivererStatusTimeWindowModel status : deliverer.iterableStatusTimeWindows()) {
                if (!TimeUtil.isBetween(date, status.getStartTime(), status.getEndTime())) continue;
                switch (status.getStatus()) {
                    case VACANT: {
                        break block8;
                    }
                    case RETRAINING: {
                        c = Color.BLUE;
                        break block8;
                    }
                    case VACATION: {
                        c = Color.MAGENTA.darker();
                        break block8;
                    }
                    case ILLNESS: {
                        c = Color.RED;
                        break block8;
                    }
                    case DELETED: {
                        c = Color.GRAY;
                        break block8;
                    }
                    case OCCUPIED: {
                        c = Color.BLACK;
                        break block8;
                    }
                    default: {
                        continue block8;
                    }
                }
            }
        }
        return c;
    }

    public static Color determineColor(DelivererModel deliverer, Date date) {
        Color c = Color.DARK_GRAY;
        if (deliverer != null && date != null) {
            c = Color.GREEN.darker().darker().darker();
            block8: for (DelivererStatusTimeWindowModel status : deliverer.iterableStatusTimeWindows()) {
                if (!TimeUtil.isBetween(date, status.getStartTime(), status.getEndTime())) continue;
                switch (status.getStatus()) {
                    case VACANT: {
                        break block8;
                    }
                    case RETRAINING: {
                        c = Color.BLUE;
                        break block8;
                    }
                    case VACATION: {
                        c = Color.MAGENTA.darker();
                        break block8;
                    }
                    case ILLNESS: {
                        c = Color.RED;
                        break block8;
                    }
                    case DELETED: {
                        c = Color.GRAY;
                        break block8;
                    }
                    case OCCUPIED: {
                        c = Color.BLACK;
                        break block8;
                    }
                    default: {
                        continue block8;
                    }
                }
            }
        }
        return c;
    }

    public static Double getMaxSalary(AreaDelivererModel deliverer, Date date) {
        AreaDelivererMaxSalaryModel found = null;
        long dateL = date.getTime();
        long minD = Long.MAX_VALUE;
        for (AreaDelivererMaxSalaryModel m : deliverer.iterableMaxSalary()) {
            Date startTime = m.getStartTime();
            long l = startTime == null ? Long.MIN_VALUE : startTime.getTime();
            long d = dateL - l;
            if (d < 0L || d >= minD) continue;
            minD = d;
            found = m;
        }
        return found == null ? null : found.getValue();
    }

    public static AreaDelivererRewardModel getReward(AreaDelivererModel deliverer, Date date) {
        AreaDelivererRewardModel found = null;
        long dateL = date.getTime();
        long minD = Long.MAX_VALUE;
        for (AreaDelivererRewardModel m : deliverer.iterableReward()) {
            Date startTime;
            long l;
            long d;
            if (NumericUtil.getDoubleValue(m.getHourReward()) == 0.0 || (d = dateL - (l = (startTime = m.getStartTime()) == null ? Long.MIN_VALUE : startTime.getTime())) < 0L || d >= minD) continue;
            minD = d;
            found = m;
        }
        return found;
    }

    public static Double getSurcharge(AreaDelivererModel deliverer, Date date) {
        AreaDelivererSurchargeModel found = null;
        long dateL = date.getTime();
        long minD = Long.MAX_VALUE;
        for (AreaDelivererSurchargeModel m : deliverer.iterableSurcharge()) {
            Date startTime = m.getStartTime();
            long l = startTime == null ? Long.MIN_VALUE : startTime.getTime();
            long d = dateL - l;
            if (d < 0L || d >= minD) continue;
            minD = d;
            found = m;
        }
        return found == null ? null : found.getValue();
    }

    public static Double getNightSurcharge(AreaDelivererModel deliverer, Date date) {
        AreaDelivererNightSurchargeModel found = null;
        long dateL = date.getTime();
        long minD = Long.MAX_VALUE;
        for (AreaDelivererNightSurchargeModel m : deliverer.iterableNightSurcharge()) {
            Date startTime = m.getStartTime();
            long l = startTime == null ? Long.MIN_VALUE : startTime.getTime();
            long d = dateL - l;
            if (d < 0L || d >= minD) continue;
            minD = d;
            found = m;
        }
        return found == null ? null : found.getValue();
    }

    public static String checkRewards(AreaDelivererModel deliverer) {
        String errorKey = DelivererModelUtil.checkRewards(deliverer.iterableReward());
        errorKey = errorKey != null ? errorKey : DelivererModelUtil.checkMaxSalaries(deliverer.iterableMaxSalary());
        errorKey = errorKey != null ? errorKey : DelivererModelUtil.checkSurcharges(deliverer.iterableSurcharge());
        errorKey = errorKey != null ? errorKey : DelivererModelUtil.checkNightSurcharges(deliverer.iterableNightSurcharge());
        return errorKey;
    }

    public static String checkRewards(Iterable<AreaDelivererRewardModel> rs) {
        String errorKey = null;
        block0: for (AreaDelivererRewardModel r1 : rs) {
            if (r1.getHourReward() == null) {
                errorKey = "gui.areaDeliverer.reward.noHourReward";
                break;
            }
            for (AreaDelivererRewardModel r2 : rs) {
                if (r1.equals(r2) || !TimeUtil.isSameDay(r1.getStartTime(), r2.getStartTime())) continue;
                errorKey = "gui.areaDeliverer.reward.timeConflict";
                break block0;
            }
        }
        return errorKey;
    }

    private static String checkMaxSalaries(Iterable<AreaDelivererMaxSalaryModel> ms) {
        String errorKey = null;
        block0: for (AreaDelivererMaxSalaryModel m1 : ms) {
            if (m1.getValue() == null) {
                errorKey = "gui.areaDeliverer.maxSalary.noHourReward";
                break;
            }
            for (AreaDelivererMaxSalaryModel m2 : ms) {
                if (m1.equals(m2) || !TimeUtil.isSameDay(m1.getStartTime(), m2.getStartTime())) continue;
                errorKey = "gui.areaDeliverer.maxSalary.timeConflict";
                break block0;
            }
        }
        return errorKey;
    }

    private static String checkSurcharges(Iterable<AreaDelivererSurchargeModel> ss) {
        String errorKey = null;
        block0: for (AreaDelivererSurchargeModel s1 : ss) {
            if (s1.getValue() == null) {
                s1.setValue(0.0);
            }
            for (AreaDelivererSurchargeModel s2 : ss) {
                if (s1.equals(s2) || !TimeUtil.isSameDay(s1.getStartTime(), s2.getStartTime())) continue;
                errorKey = "gui.areaDeliverer.surcharge.timeConflict";
                break block0;
            }
        }
        return errorKey;
    }

    private static String checkNightSurcharges(Iterable<AreaDelivererNightSurchargeModel> ns) {
        String errorKey = null;
        block0: for (AreaDelivererNightSurchargeModel n1 : ns) {
            if (n1.getValue() == null) {
                n1.setValue(0.0);
            }
            for (AreaDelivererNightSurchargeModel n2 : ns) {
                if (n1.equals(n2) || !TimeUtil.isSameDay(n1.getStartTime(), n2.getStartTime())) continue;
                errorKey = "gui.areaDeliverer.nightSurcharge.timeConflict";
                break block0;
            }
        }
        return errorKey;
    }
}

