/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.util.FormUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ClientFormUtil
extends FormUtil {
    public static Date stringToDate(String string) {
        return ClientFormUtil.stringToDate(string, TIMEFORMAT);
    }

    public static Date stringToDate(String string, String format) {
        try {
            return new SimpleDateFormat(format == null ? TIMEFORMAT : format).parse(string);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String dateToString(Date date) {
        return ClientFormUtil.dateToString(date, TIMEFORMAT);
    }

    public static String dateToString(Date date, String format) {
        return FormUtil.dateToString(date, format, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.noA", new Serializable[0]));
    }

    public static String getDistanceDisplay(Integer distance, String unit) {
        if (distance == null) {
            return "keine";
        }
        return ModelEnviroment.getMessageResolver().getNumberFormat().format(distance) + (unit == null ? "" : " " + unit);
    }

    public static String getNumberString(Number number) {
        if (number == null) {
            return "";
        }
        return String.valueOf(ModelEnviroment.getMessageResolver().getNumberFormat().format(number));
    }

    public static Number getNumber(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        return ModelEnviroment.getMessageResolver().getNumberFormat().parse(string);
    }

    public static String getDateString(Date date, String format) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static String getBooleanString(Boolean b) {
        String s = " ";
        if (b != null) {
            String messageKey = "messages.default." + (b != false ? "yes" : "no");
            s = ModelEnviroment.getMessageResolver().resolveMessage(messageKey, new Serializable[0]);
        }
        return s;
    }
}

