/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.util.FormUtil;
import java.io.Serializable;
import java.util.Date;
import org.ktde.util.StringUtil;

public class AreaTourInfoObject {
    private String shortcut;
    private String displayname;
    private Integer distance;
    private Integer accessDistance;
    private Integer streetDistance;
    private Integer duration;
    private Integer accessDuration;
    private Integer streetDuration;
    private Integer sum;
    private Integer parcelSum;
    private AreaObjectModel areaObject;

    public AreaTourInfoObject(AreaObjectModel areaObject) {
        this(areaObject, null, null, null, null);
    }

    public AreaTourInfoObject(AreaObjectModel areaObject, Integer distance, Integer duration, Integer sum, Integer parcelSum) {
        this(areaObject.getShortcut(), areaObject.getDisplayname(), distance, duration, sum, parcelSum);
        this.areaObject = areaObject;
    }

    public AreaTourInfoObject(String shortcut, String displayname) {
        this(shortcut, displayname, null, null, null, null);
    }

    public AreaTourInfoObject(String shortcut, String displayname, Integer distance, Integer duration, Integer sum, Integer parcelSum) {
        this(shortcut, displayname, distance, null, null, duration, null, null, sum, parcelSum);
    }

    public AreaTourInfoObject(String shortcut, String displayname, Integer distance, Integer accessDistance, Integer streetDistance, Integer duration, Integer accessDuration, Integer streetDuration, Integer sum, Integer parcelSum) {
        this.shortcut = shortcut;
        this.displayname = displayname;
        this.distance = distance;
        this.accessDistance = accessDistance;
        this.streetDistance = streetDistance;
        this.duration = duration;
        this.accessDuration = accessDuration;
        this.streetDuration = streetDuration;
        this.sum = sum;
        this.parcelSum = parcelSum;
    }

    public String getString() {
        return this.getString("%%%shortcut%%% - %%%displayname%%%\n%%%duration%%%\n%%%distance%%%\n%%%sum%%%\n%%%printDate%%%\n");
    }

    public String getString(String pattern) {
        String totalDistanceString;
        String durationString;
        if (pattern == null) {
            return this.getString();
        }
        if (this.displayname == null) {
            return this.shortcut;
        }
        String string = ModelEnviroment.getMessageResolver().resolveMessage("gui.area.areaObject", new Serializable[0]) + " - " + pattern;
        string = string.replaceAll("%%%shortcut%%%", StringUtil.getNotNull(this.shortcut));
        string = string.replaceAll("%%%displayname%%%", StringUtil.getNotNull(this.displayname));
        String string2 = durationString = this.duration == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.areatour.duration", new Serializable[]{FormUtil.getSecondTimeString(this.duration)});
        if (this.accessDuration != null && this.streetDuration != null) {
            durationString = durationString + "(Strasse: " + FormUtil.getSecondTimeString(this.streetDuration);
            durationString = durationString + "- Geb\u00e4ude: " + FormUtil.getSecondTimeString(this.accessDuration) + ")";
        }
        string = string.replaceAll("%%%duration%%%", durationString);
        String distanceDisplay = ClientFormUtil.getDistanceDisplay(this.distance, " " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.meter", new Serializable[0]));
        String wholeDistanceString = totalDistanceString = this.distance == null ? "" : ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.distance", new Serializable[0]) + ": " + distanceDisplay;
        String streetDistanceString = "";
        String parcelDistanceString = "";
        if (this.streetDistance != null) {
            streetDistanceString = ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.street", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(this.streetDistance, "");
        }
        if (this.accessDistance != null) {
            parcelDistanceString = ModelEnviroment.getMessageResolver().resolveMessage("messages.parcels", new Serializable[0]) + ": " + ClientFormUtil.getDistanceDisplay(this.accessDistance, "");
        }
        if (this.streetDistance != null && this.accessDistance != null) {
            totalDistanceString = totalDistanceString + " (" + streetDistanceString;
            totalDistanceString = totalDistanceString + "- " + parcelDistanceString + ")";
        }
        string = string.replaceAll("%%%distance%%%", totalDistanceString);
        string = string.replaceAll("%%%whole_distance%%%", wholeDistanceString);
        string = string.replaceAll("%%%street_distance%%%", streetDistanceString);
        string = string.replaceAll("%%%parcel_distance%%%", parcelDistanceString);
        String sumString = this.parcelSum == null ? "" : "Anzahl der Orte: " + this.parcelSum;
        sumString = sumString + (this.sum == null ? "" : "\nAnzahl der Stopps: " + this.sum);
        string = string.replaceAll("%%%sum%%%", sumString);
        string = string.replaceAll("%%%printDate%%%", ClientFormUtil.dateToString(new Date(), FormUtil.DATEFORMAT));
        String[] ss = string.split("\n");
        string = ss[0];
        for (int i = 1; i < ss.length; ++i) {
            if (StringUtil.isBlank(ss[i]) || ss[i].contains("%%%")) continue;
            string = string + "\n" + ss[i];
        }
        return string;
    }

    public String getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(String shortcut) {
        this.shortcut = shortcut;
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public void setDisplayname(String displayname) {
        this.displayname = displayname;
    }

    public Integer getAccessDistance() {
        return this.accessDistance;
    }

    public void setAccessDistance(Integer accessDistance) {
        this.accessDistance = accessDistance;
    }

    public Integer getStreetDistance() {
        return this.streetDistance;
    }

    public void setStreetDistance(Integer streetDistance) {
        this.streetDistance = streetDistance;
    }

    public Integer getAccessDuration() {
        return this.accessDuration;
    }

    public void setAccessDuration(Integer accessDuration) {
        this.accessDuration = accessDuration;
    }

    public Integer getStreetDuration() {
        return this.streetDuration;
    }

    public void setStreetDuration(Integer streetDuration) {
        this.streetDuration = streetDuration;
    }

    public Integer getSum() {
        return this.sum;
    }

    public void setSum(Integer sum) {
        this.sum = sum;
    }

    public AreaObjectModel getAreaObject() {
        return this.areaObject;
    }
}

