/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.util.LocationObject;
import de.datomino.util.geo.ImmutablePoint;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.ktde.model.ValueChangeEvent;
import org.ktde.model.ValueChangeListener;

public abstract class AbstractLocationObject<T extends Model>
implements LocationObject<T> {
    private T model;
    private List<ValueChangeListener> listeners = new LinkedList<ValueChangeListener>();

    public AbstractLocationObject(T model) {
        this.model = model;
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        this.model.addValueChangeListener(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeValueChangeListener(ValueChangeListener listener) {
        this.model.removeValueChangeListener(listener);
        this.listeners.remove(listener);
    }

    @Override
    public T getModel() {
        return this.model;
    }

    protected void fireValueChanged(ValueChangeEvent e) {
        for (ValueChangeListener valueChangeListener : this.listeners) {
            valueChangeListener.valueChanged(e);
        }
    }

    @Override
    public int compareTo(LocationObject<T> o) {
        return this.getModel().getId().compareTo(o.getModel().getId());
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractLocationObject) {
            AbstractLocationObject other = (AbstractLocationObject)obj;
            return new EqualsBuilder().append(this.getModel(), other.getModel()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getModel()).toHashCode();
    }

    @Override
    public abstract ImmutablePoint getImmutablePoint();

    public abstract ImmutablePoint getImmutablePointFromModel();
}

