/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.util;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDocumentListener
implements DocumentListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDocumentListener.class);
    protected String errorMessage = null;

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update();
    }

    private void update() {
        this.handleChange();
        if (this.errorMessage != null) {
            this.rollback();
            this.errorMessage = null;
        }
    }

    protected void rollback() {
        LOGGER.error(this.errorMessage);
    }

    protected abstract void handleChange();
}

