/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.swing.tool.area.aggregate;

import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.attribute.AttributeDescriptorComboBox;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModelImpl;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaLayerModelImpl;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueDescriptorModelImpl;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModelImpl;
import de.datomino.peppergis.client.util.wrapper.area.attribute.AreaAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.client.util.wrapper.parcel.attribute.ParcelAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.client.util.wrapper.subscription.attribute.SubscriptionAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.type.AggregateType;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.ktde.util.datatypes.Tupel;

public class AggregateAreaAttributeValuePane
extends JPanel {
    private static final long serialVersionUID = -5812803559904802281L;
    private AreaLayerComboBox areaLayerComboBox;
    private EnumComboBox<AggregateType> aggregateType;
    private AttributeDescriptorComboBox<AreaAttributeValueDescriptorModel> targetDescriptors;
    private EnumComboBox<SourceType> sourceType;
    private AttributeDescriptorComboBox<Model> sourceDescriptors;
    private ModelEnviroment modelEnviroment;

    public AggregateAreaAttributeValuePane(ModelEnviroment modelEnviroment) {
        super(new SpringLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
    }

    private void buildLayout() {
        this.areaLayerComboBox = new AreaLayerComboBox(this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values()), false);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0])));
        this.add(this.areaLayerComboBox);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.aggregateAreaAttributeValue.targetDescriptor", new Serializable[0])));
        Collection<AreaAttributeValueDescriptorModel> allAreaAttributeValueDescriptors = this.modelEnviroment.getAllCaller().getAreaCaller().fetchAllAreaAttributeValueDescriptors();
        LinkedList<AreaAttributeValueDescriptorModelAttributeWrapper> list = new LinkedList<AreaAttributeValueDescriptorModelAttributeWrapper>();
        for (AreaAttributeValueDescriptorModel areaAttributeValueDescriptorModel : allAreaAttributeValueDescriptors) {
            AttributeValueType attributeValueType = areaAttributeValueDescriptorModel.getAttributeValueType();
            if (attributeValueType != AttributeValueType.INTEGER && attributeValueType != AttributeValueType.FLOAT) continue;
            list.add(new AreaAttributeValueDescriptorModelAttributeWrapper(areaAttributeValueDescriptorModel));
        }
        this.targetDescriptors = new AttributeDescriptorComboBox(list);
        this.add(this.targetDescriptors);
        this.sourceType = new EnumComboBox<SourceType>(SourceType.class, false);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(SourceType.class.getName(), new Serializable[0])));
        this.add(this.sourceType);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.aggregateAreaAttributeValue.sourceDescriptor", new Serializable[0])));
        Set emptySet = Collections.emptySet();
        this.sourceDescriptors = new AttributeDescriptorComboBox(emptySet);
        this.add(this.sourceDescriptors);
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(AggregateType.class.getName(), new Serializable[0])));
        this.aggregateType = new EnumComboBox<AggregateType>(AggregateType.class, false);
        this.add(this.aggregateType);
        SpringUtilities.makeCompactGrid(this, 5, 2, 5, 5, 2, 2);
        this.sourceType.addActionListener(new SourceTypeListener());
        this.setDescriptors();
    }

    private void setDescriptors() {
        SourceType selectedSourceType = this.sourceType.getSelectedValue();
        switch (selectedSourceType) {
            case AREA: {
                Collection<AreaAttributeValueDescriptorModel> allAreaAttributeValueDescriptors = this.modelEnviroment.getAllCaller().getAreaCaller().fetchAllAreaAttributeValueDescriptors();
                LinkedList<AreaAttributeValueDescriptorModelAttributeWrapper> numberAreaAttributeValueDescriptors = new LinkedList<AreaAttributeValueDescriptorModelAttributeWrapper>();
                for (AreaAttributeValueDescriptorModel areaAttributeValueDescriptorModel : allAreaAttributeValueDescriptors) {
                    AttributeValueType attributeValueType = areaAttributeValueDescriptorModel.getAttributeValueType();
                    if (attributeValueType != AttributeValueType.INTEGER && attributeValueType != AttributeValueType.FLOAT) continue;
                    numberAreaAttributeValueDescriptors.add(new AreaAttributeValueDescriptorModelAttributeWrapper(areaAttributeValueDescriptorModel));
                }
                this.sourceDescriptors.setValues(numberAreaAttributeValueDescriptors);
                break;
            }
            case PARCEL: {
                Collection<ParcelAttributeValueDescriptorModel> allParcelAttributeValueDescriptors = this.modelEnviroment.getAllCaller().getStreetNetCaller().fetchAllParcelAttributeValueDescriptors();
                LinkedList<ParcelAttributeValueDescriptorModelAttributeWrapper> numberParcelAttributeValueDescriptors = new LinkedList<ParcelAttributeValueDescriptorModelAttributeWrapper>();
                for (ParcelAttributeValueDescriptorModel parcelAttributeValueDescriptorModel : allParcelAttributeValueDescriptors) {
                    AttributeValueType attributeValueType = parcelAttributeValueDescriptorModel.getAttributeValueType();
                    if (attributeValueType != AttributeValueType.INTEGER && attributeValueType != AttributeValueType.FLOAT) continue;
                    numberParcelAttributeValueDescriptors.add(new ParcelAttributeValueDescriptorModelAttributeWrapper(parcelAttributeValueDescriptorModel));
                }
                this.sourceDescriptors.setValues(numberParcelAttributeValueDescriptors);
                break;
            }
            case SUBSCRIPTION: {
                Collection<SubscriptionAttributeValueDescriptorModel> allSubscriptionAttributeValueDescriptors = this.modelEnviroment.getAllCaller().getSubscriptionCaller().getAllSubscriptionAttributeValueDescriptors();
                LinkedList<SubscriptionAttributeValueDescriptorModelAttributeWrapper> numberSubscriptionAttributeValueDescriptors = new LinkedList<SubscriptionAttributeValueDescriptorModelAttributeWrapper>();
                for (SubscriptionAttributeValueDescriptorModel subscriptionAttributeValueDescriptorModel : allSubscriptionAttributeValueDescriptors) {
                    AttributeValueType attributeValueType = subscriptionAttributeValueDescriptorModel.getAttributeValueType();
                    if (attributeValueType != AttributeValueType.INTEGER && attributeValueType != AttributeValueType.FLOAT) continue;
                    numberSubscriptionAttributeValueDescriptors.add(new SubscriptionAttributeValueDescriptorModelAttributeWrapper(subscriptionAttributeValueDescriptorModel));
                }
                this.sourceDescriptors.setValues(numberSubscriptionAttributeValueDescriptors);
            }
        }
    }

    boolean checkInput() {
        AreaLayerModel layer = (AreaLayerModel)this.areaLayerComboBox.getSelectedItem();
        if (layer == null) {
            JOptionPane.showMessageDialog(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver().resolveMessage("messages.error.noLayerSelected", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.error", new Serializable[0]), 0);
            return false;
        }
        Model descriptor = this.targetDescriptors.getSelectedDescriptor();
        if (descriptor == null) {
            JOptionPane.showMessageDialog(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.aggregateAreaAttributeValue.error.noTargetDescriptorSelected", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.error", new Serializable[0]), 0);
            return false;
        }
        descriptor = this.sourceDescriptors.getSelectedDescriptor();
        if (descriptor == null) {
            JOptionPane.showMessageDialog(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.aggregateAreaAttributeValue.error.noSourceDescriptorSelected", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.error", new Serializable[0]), 0);
            return false;
        }
        return true;
    }

    void aggregate() {
        SourceType selectedSourceType = this.sourceType.getSelectedValue();
        switch (selectedSourceType) {
            case AREA: {
                AbstractAsynchronousDialog<Serializable> asyncDialog1 = new AbstractAsynchronousDialog<Serializable>(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.aggregateAreaAttributeValue", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.aggregateAreaAttributeValue", new Serializable[0]), 1, this.modelEnviroment){
                    private static final long serialVersionUID = 5074200100962181596L;

                    @Override
                    protected String startAsynchronous() {
                        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().aggregateSubAreaAttributeValues(((AreaLayerModelImpl)AggregateAreaAttributeValuePane.this.areaLayerComboBox.getSelectedItem()).createDto(), ((AreaAttributeValueDescriptorModelImpl)AggregateAreaAttributeValuePane.this.targetDescriptors.getSelectedDescriptor()).createDto(), ((AreaAttributeValueDescriptorModelImpl)AggregateAreaAttributeValuePane.this.sourceDescriptors.getSelectedDescriptor()).createDto(), (AggregateType)((Object)AggregateAreaAttributeValuePane.this.aggregateType.getSelectedValue()));
                    }

                    @Override
                    protected AsynchronousDto<Serializable> getAsynchronousDto(String token) {
                        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().getAggregateSubAreaAttributeValuesResult(token);
                    }
                };
                try {
                    Tupel resultDto1 = asyncDialog1.run();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case PARCEL: {
                AbstractAsynchronousDialog<Serializable> asyncDialog2 = new AbstractAsynchronousDialog<Serializable>(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.aggregateAreaAttributeValue", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.aggregateAreaAttributeValue", new Serializable[0]), 1, this.modelEnviroment){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected String startAsynchronous() {
                        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().aggregateParcelAttributeValues(((AreaLayerModelImpl)AggregateAreaAttributeValuePane.this.areaLayerComboBox.getSelectedItem()).createDto(), ((AreaAttributeValueDescriptorModelImpl)AggregateAreaAttributeValuePane.this.targetDescriptors.getSelectedDescriptor()).createDto(), ((ParcelAttributeValueDescriptorModelImpl)AggregateAreaAttributeValuePane.this.sourceDescriptors.getSelectedDescriptor()).createDto(), (AggregateType)((Object)AggregateAreaAttributeValuePane.this.aggregateType.getSelectedValue()));
                    }

                    @Override
                    protected AsynchronousDto<Serializable> getAsynchronousDto(String token) {
                        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().getAggregateParcelAttributeValuesResult(token);
                    }
                };
                try {
                    Tupel resultDto2 = asyncDialog2.run();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case SUBSCRIPTION: {
                AbstractAsynchronousDialog<Serializable> asyncDialog3 = new AbstractAsynchronousDialog<Serializable>(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.aggregateAreaAttributeValue", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.aggregateAreaAttributeValue", new Serializable[0]), 1, this.modelEnviroment){
                    private static final long serialVersionUID = -3976994215024349155L;

                    @Override
                    protected String startAsynchronous() {
                        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().aggregateSubscriptionAttributeValues(((AreaLayerModelImpl)AggregateAreaAttributeValuePane.this.areaLayerComboBox.getSelectedItem()).createDto(), ((AreaAttributeValueDescriptorModelImpl)AggregateAreaAttributeValuePane.this.targetDescriptors.getSelectedDescriptor()).createDto(), ((SubscriptionAttributeValueDescriptorModelImpl)AggregateAreaAttributeValuePane.this.sourceDescriptors.getSelectedDescriptor()).createDto(), (AggregateType)((Object)AggregateAreaAttributeValuePane.this.aggregateType.getSelectedValue()));
                    }

                    @Override
                    protected AsynchronousDto<Serializable> getAsynchronousDto(String token) {
                        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().getAggregateSubscriptionAttributeValuesResult(token);
                    }
                };
                try {
                    Tupel resultDto3 = asyncDialog3.run();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private class SourceTypeListener
    implements ActionListener {
        private SourceTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AggregateAreaAttributeValuePane.this.setDescriptors();
        }
    }

    private static enum SourceType {
        SUBSCRIPTION,
        PARCEL,
        AREA;

    }
}

