/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.swing.baselayer;

import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.swing.AbstractPepperGisInternalFrame;
import de.datomino.peppergis.client.swing.PepperGisDesktopApplication;
import de.datomino.peppergis.client.swing.action.AbstractWindowOpenerAction;
import de.datomino.peppergis.client.swing.baselayer.BaseLayerEditorInternalFrame;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.license.LicenseType;
import de.datomino.peppergis.simplebasearea.gui.AreaObjectChooserPane;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class OpenBaseLayerEditorAction
extends AbstractWindowOpenerAction {
    private static final long serialVersionUID = 1L;

    public OpenBaseLayerEditorAction(PepperGisDesktopApplication application) {
        super(application, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areaEditor", new Serializable[0]), null);
    }

    @Override
    protected String getWindowId(ModelEnviroment modelEnviroment) {
        AreaLayerModel choosen;
        int selectedIndex;
        AreaObjectGenInfoDiscriminator[] mDiscriminators;
        AreaCaller areaCaller = modelEnviroment.getAllCaller().getAreaCaller();
        boolean micro = areaCaller.isMicroCellAllowed();
        boolean macro = areaCaller.isMacroCellAllowed();
        AreaObjectGenInfoDiscriminator[] discriminators = new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT, AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND, AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_UNMODIFYABLE};
        if (micro) {
            mDiscriminators = new AreaObjectGenInfoDiscriminator[discriminators.length + 2];
            System.arraycopy(discriminators, 0, mDiscriminators, 0, discriminators.length);
            mDiscriminators[discriminators.length] = AreaObjectGenInfoDiscriminator.AREA_OBJECT_MICRO_CELL;
            mDiscriminators[discriminators.length + 1] = AreaObjectGenInfoDiscriminator.AREA_OBJECT_MACRO_CELL;
            discriminators = mDiscriminators;
        }
        if (macro) {
            mDiscriminators = new AreaObjectGenInfoDiscriminator[discriminators.length + 1];
            System.arraycopy(discriminators, 0, mDiscriminators, 0, discriminators.length);
            mDiscriminators[discriminators.length] = AreaObjectGenInfoDiscriminator.AREA_OBJECT_MACRO_CELL;
            discriminators = mDiscriminators;
        }
        ArrayList<AreaLayerModel> layers = new ArrayList<AreaLayerModel>(areaCaller.getAreaLayersForType(discriminators));
        ListIterator layerIter = layers.listIterator();
        Vector<String> layernames = new Vector<String>();
        while (layerIter.hasNext()) {
            AreaLayerModel curLayer = (AreaLayerModel)layerIter.next();
            layernames.add(curLayer.getDisplayname());
        }
        JComboBox chooseEditLayerCombo = new JComboBox(layernames);
        if (JOptionPane.showConfirmDialog(this.getApplication(), chooseEditLayerCombo, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.chooseEditLayer", new Serializable[0]), 2) == 0 && (selectedIndex = chooseEditLayerCombo.getSelectedIndex()) >= 0 && (choosen = (AreaLayerModel)layers.get(selectedIndex)) != null) {
            int counter = 0;
            String id = "baselayer_" + choosen.getId() + "_" + counter;
            while (this.getApplication().getWindow(id) != null) {
                id = "baselayer_" + choosen.getId() + "_" + ++counter;
            }
            return id;
        }
        return null;
    }

    @Override
    protected AbstractPepperGisInternalFrame createWindow(String windowId, ModelEnviroment modelEnviroment) throws Exception {
        Long id = Long.parseLong(windowId.substring(10, windowId.lastIndexOf(95)));
        AreaLayerModel layer = modelEnviroment.getAllCaller().getAreaCaller().getAreaLayer(id);
        Long[] sourceLayerIds = new Long[]{};
        boolean isAreaGen = layer.getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT;
        AreaObjectChooserPane areaObjectChooserPane = new AreaObjectChooserPane(layer, modelEnviroment, isAreaGen);
        String key = isAreaGen ? "messages.area.preselectAreas.order" : "messages.area.preselectAreas";
        int d = JOptionPane.showConfirmDialog(this.getApplication(), areaObjectChooserPane, ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[0]), 2);
        if (d == 0) {
            if (isAreaGen) {
                Collection<AreaLayerDto> layers = modelEnviroment.getGeoServerStub().getAreaBi().getAreaLayersForType(new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND, AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_UNMODIFYABLE});
                sourceLayerIds = new Long[layers.size()];
                int i = 0;
                for (AreaLayerDto areaLayerFullDto : layers) {
                    sourceLayerIds[i++] = areaLayerFullDto.getId();
                }
            }
            boolean markAreas = false;
            boolean centerAreas = areaObjectChooserPane.isCenterAreas();
            ModelEnviroment.getProperties().setDynamicProperty("area.select.center", Boolean.toString(centerAreas));
            return new BaseLayerEditorInternalFrame(this.getApplication(), id, areaObjectChooserPane.getNotSelectedAreaObjects(), centerAreas, markAreas, areaObjectChooserPane.getTitleAddon(), sourceLayerIds);
        }
        return null;
    }

    @Override
    protected LicenseType getLicenseType() {
        return LicenseType.AREA;
    }
}

