/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.swing.baselayer;

import de.datomino.peppergis.client.event.ApplicationMessage;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.swing.AbstractEditorInternalFrame;
import de.datomino.peppergis.client.swing.PepperGisDesktopApplication;
import de.datomino.peppergis.license.LicenseType;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.gui.menu.BaseLayerEditorPanelMenuBar;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.UserRole;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.JToolBar;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Holder;

public class BaseLayerEditorInternalFrame
extends AbstractEditorInternalFrame<ConstructorArgs, BaseLayerEditorPanel> {
    private static final long serialVersionUID = 5949310542605651236L;
    private static Holder<Integer> windowCount = new Holder<Integer>(0);
    private BaseLayerEditorPanelMenuBar baseLayerEditorPanelMenuBar;

    public BaseLayerEditorInternalFrame(PepperGisDesktopApplication application, Long layerId, Set<Long> areaObjectsNotToShow, boolean centerShowingAreas, boolean selectShowingAreas, String titleAddOn, Long ... sourceIds) throws IOException {
        super(application, new ConstructorArgs(layerId, sourceIds, areaObjectsNotToShow, centerShowingAreas, selectShowingAreas, titleAddOn), "BaseLayer Editor", true, true, true);
    }

    @Override
    protected void extendToolBar(JToolBar toolBar) {
        ((BaseLayerEditorPanel)this.panel).extendToolBar(toolBar);
    }

    @Override
    protected BaseLayerEditorPanel createEditorPanel(ConstructorArgs constructorArgs) {
        BaseLayerEditorPanel baseLayerEditorPanel = new BaseLayerEditorPanel(constructorArgs.layerId, (Set<Long>)constructorArgs.areaObjectIdsNotToShow, constructorArgs.centerShowingAreas, constructorArgs.selectShowingAreas, this, constructorArgs.sourceIds);
        List<AreaLayerModel> layerList = Arrays.asList(baseLayerEditorPanel.getEditBaseLayer());
        String title = ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areaEditor", new Serializable[0]) + " - " + StringUtil.implode(layerList, ", ", new NameGenerator<AreaLayerModel>(){

            @Override
            public String getName(AreaLayerModel t) {
                return StringUtil.nullToEmpty(t.getDisplayname());
            }
        });
        String titleAddOn = constructorArgs.titleAddOn;
        if (titleAddOn != null) {
            title = title + " - " + titleAddOn;
        }
        this.setTitle(title);
        this.addInternalFrameListener(baseLayerEditorPanel);
        return baseLayerEditorPanel;
    }

    @Override
    protected BaseLayerEditorPanelMenuBar createMenuBar() {
        this.baseLayerEditorPanelMenuBar = ((BaseLayerEditorPanel)this.panel).getMenuBar();
        return this.baseLayerEditorPanelMenuBar;
    }

    @Override
    public void consumeApplicationMessage(ApplicationMessage<?> message) {
        super.consumeApplicationMessage(message);
        ((BaseLayerEditorPanel)this.getEditorPanel()).consumeApplicationMessage(message);
    }

    @Override
    protected boolean isSaveActionAllowed() {
        return ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_EDITOR, UserRole.DISPONENT_SUPER);
    }

    @Override
    public boolean close() {
        BaseLayerEditorPanel editorPanel = (BaseLayerEditorPanel)this.getEditorPanel();
        boolean close = false;
        close = editorPanel.getFreyHandler() == null || editorPanel.getEditBaseLayer().getDiscriminator() != AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? super.close() : true;
        if (close) {
            editorPanel.close();
        }
        return close;
    }

    @Override
    public LicenseType getLicenseType() {
        return LicenseType.AREA;
    }

    public static class ConstructorArgs {
        private Long layerId;
        private Long[] sourceIds;
        private Set<Long> areaObjectIdsNotToShow;
        private boolean centerShowingAreas;
        private boolean selectShowingAreas;
        private String titleAddOn;

        public ConstructorArgs(Long layerId, Long[] sourceIds, Set<Long> areaObjectIdsNotToShow, boolean centerShowingAreas, boolean selectShowingAreas, String titleAddOn) {
            this.layerId = layerId;
            this.sourceIds = sourceIds;
            this.areaObjectIdsNotToShow = areaObjectIdsNotToShow;
            this.centerShowingAreas = centerShowingAreas;
            this.selectShowingAreas = selectShowingAreas;
            this.titleAddOn = titleAddOn;
        }
    }
}

