/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.swing.action;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.swing.AbstractPepperGisInternalFrame;
import de.datomino.peppergis.client.swing.PepperGisDesktopApplication;
import de.datomino.peppergis.client.swing.action.AbstractPepperGisAction;
import de.datomino.peppergis.exception.InsufficiantLicenseException;
import de.datomino.peppergis.license.LicenseType;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWindowOpenerAction
extends AbstractPepperGisAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWindowOpenerAction.class);
    private static final long serialVersionUID = 1L;

    public AbstractWindowOpenerAction(PepperGisDesktopApplication application, String title, Icon icon) {
        super(application, title, icon);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ModelEnviroment modelEnviroment = this.createModelEnviroment();
        if (!this.checkForLicense(modelEnviroment)) {
            return;
        }
        String windowId = this.getWindowId(modelEnviroment);
        if (windowId == null) {
            return;
        }
        if (this.getApplication().hasWindow(windowId)) {
            this.getApplication().focusWindow(windowId);
        } else {
            try {
                AbstractPepperGisInternalFrame window = this.createWindow(windowId, modelEnviroment);
                if (window != null) {
                    this.getApplication().addWindow(windowId, window);
                    try {
                        window.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
                this.getApplication().showMessage(e);
            }
        }
    }

    private boolean checkForLicense(ModelEnviroment modelEnviroment) {
        LicenseType licenseType = this.getLicenseType();
        if (licenseType != null) {
            if (modelEnviroment.getUserInformation().isSuperUser()) {
                return true;
            }
            Collection windows = this.getApplication().getAllWindows().values();
            boolean found = false;
            for (AbstractPepperGisInternalFrame window : windows) {
                if (licenseType != window.getLicenseType()) continue;
                found = true;
                break;
            }
            if (!found) {
                try {
                    modelEnviroment.getAllCaller().getUserCaller().loginModule(licenseType);
                }
                catch (InsufficiantLicenseException ex) {
                    String messageKey = "";
                    switch (licenseType) {
                        case AREA: {
                            messageKey = "messages.license.insufficentLicense.area";
                            break;
                        }
                        case TOUR: {
                            messageKey = "messages.license.insufficentLicense.tour";
                            break;
                        }
                        case TOUR2: {
                            messageKey = "messages.license.insufficentLicense.tour2";
                            break;
                        }
                        case AREA2: {
                            messageKey = "messages.license.insufficentLicense.area2";
                            break;
                        }
                        case WAGE: {
                            messageKey = "messages.license.insufficentLicense.wage";
                            break;
                        }
                    }
                    JOptionPane.showMessageDialog(this.getApplication(), ModelEnviroment.getMessageResolver().resolveMessage(messageKey, Integer.valueOf(ex.getMaxLicenseCount())), ModelEnviroment.getMessageResolver().resolveMessage("messages.error", new Serializable[0]), 2);
                    return false;
                }
            }
        }
        return true;
    }

    protected abstract String getWindowId(ModelEnviroment var1);

    protected ModelEnviroment createModelEnviroment() {
        ModelEnviroment modelEnviroment = new ModelEnviroment(this.getApplication());
        return modelEnviroment;
    }

    protected abstract AbstractPepperGisInternalFrame createWindow(String var1, ModelEnviroment var2) throws Exception;

    protected abstract LicenseType getLicenseType();
}

