/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.swing;

import de.datomino.peppergis.client.auth.UserInformation;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.swing.PepperGisDesktopApplication;
import de.datomino.peppergis.client.swing.action.PeppergisExitAction;
import de.datomino.peppergis.client.swing.areamanager.AreaManagerAction;
import de.datomino.peppergis.client.swing.baselayer.OpenBaseLayerEditorAction;
import de.datomino.peppergis.client.swing.data.DataManagerAction;
import de.datomino.peppergis.client.swing.tourmanager.TourManagerAction;
import de.datomino.peppergis.client.swing.wage.OpenWageAction;
import de.datomino.peppergis.type.ComponentType;
import de.datomino.peppergis.type.UserRole;
import javax.swing.Action;
import javax.swing.JToolBar;
import org.ktde.util.MultitonManager;

public class PepperGisDesktopApplicationActions
extends MultitonManager<Integer, Action> {
    public static final int EXIT_ACTION = 1;
    public static final int BASELAYER_ACTION = 2;
    public static final int AREAMANAGER_ACTION = 3;
    public static final int TOURMANAGER_ACTION = 4;
    public static final int WAGE_ACTION = 5;
    public static final int DATA_ACTION = 6;
    private PepperGisDesktopApplication pepperGisClient;

    @Override
    protected Action createInstance(Integer action) {
        switch (action) {
            case 1: {
                return new PeppergisExitAction(this.pepperGisClient);
            }
            case 2: {
                return new OpenBaseLayerEditorAction(this.pepperGisClient);
            }
            case 4: {
                return new TourManagerAction(this.pepperGisClient);
            }
            case 3: {
                return new AreaManagerAction(this.pepperGisClient);
            }
            case 5: {
                return new OpenWageAction(this.pepperGisClient);
            }
            case 6: {
                return new DataManagerAction(this.pepperGisClient, this.pepperGisClient.createImportMenu(), this.pepperGisClient.createExportMenu());
            }
        }
        return null;
    }

    public void setApplication(PepperGisDesktopApplication pepperGisClient) {
        this.pepperGisClient = pepperGisClient;
    }

    public JToolBar createToolbar() {
        boolean property;
        Action toolBarAction;
        JToolBar toolBar = new JToolBar(0);
        UserInformation userInformation = ModelEnviroment.getUserInformation();
        ModelEnviroment modelEnv = new ModelEnviroment(this.pepperGisClient);
        if (userInformation.hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_EDITOR, UserRole.AREA_VIEWER, UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER)) {
            toolBar.add((Action)this.getInstance(2));
        }
        if (userInformation.hasAtLeastOneRole(UserRole.DELIVERER_PASSIVE, UserRole.DELIVERER_ACTIVE, UserRole.DISPONENT_SUPER, UserRole.DISPONENT_LOCAL_PASSIVE, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.ADMIN)) {
            toolBarAction = (Action)this.getInstance(4);
            property = modelEnv.getAllCaller().getUserCaller().isComponentEnabled(ComponentType.TOUR_MANAGER);
            toolBarAction.setEnabled(property);
            toolBar.add(toolBarAction);
        }
        if (userInformation.hasAtLeastOneRole(UserRole.ADMIN, UserRole.AREA_EDITOR, UserRole.AREA_VIEWER, UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER, UserRole.PERSONAL_PLANNER)) {
            toolBarAction = (Action)this.getInstance(3);
            property = modelEnv.getAllCaller().getUserCaller().isComponentEnabled(ComponentType.AREA_MANAGER);
            toolBarAction.setEnabled(property);
            toolBar.add(toolBarAction);
        }
        if (userInformation.hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER, UserRole.WAGE_ACTIVE, UserRole.WAGE_PASSIVE, UserRole.WAGE_DIFFERENCE)) {
            toolBarAction = (Action)this.getInstance(5);
            property = modelEnv.getAllCaller().getUserCaller().isComponentEnabled(ComponentType.WAGE_TOOL);
            toolBarAction.setEnabled(property);
            toolBar.add(toolBarAction);
        }
        if (userInformation.hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER, UserRole.AREA_ADMIN, UserRole.POST_WORK)) {
            toolBarAction = (Action)this.getInstance(6);
            toolBar.add(toolBarAction);
        }
        return toolBar;
    }
}

