/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.print;

import de.datomino.pdf.engine.Format;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import java.awt.Component;
import java.io.Serializable;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class FormatComboBox
extends JComboBox {
    private static final long serialVersionUID = 7849283449161739439L;
    private boolean showType = true;

    public FormatComboBox() {
        this(Format.DinRow.values(), 0, 10, true, true);
    }

    public FormatComboBox(Format.DinRow[] allowedDinRows, int minClass, int maxClass, boolean portrait, boolean landscape) {
        this(FormatComboBox.createFormats(allowedDinRows, minClass, maxClass, portrait, landscape));
    }

    public FormatComboBox(Collection<Format> formats) {
        super(new DefaultComboBoxModel<Format>(new Vector<Format>(formats)));
        final ListCellRenderer renderer = this.getRenderer();
        this.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object v = value;
                if (value instanceof Format) {
                    Format format = (Format)value;
                    v = FormatComboBox.this.showType ? ModelEnviroment.getMessageResolver().resolveMessage("messages.print.formatWithType", new Serializable[]{format.getDinRow().name(), Integer.valueOf(format.getClazz()), format.getType()}) : ModelEnviroment.getMessageResolver().resolveMessage("messages.print.format", new Serializable[]{format.getDinRow().name(), Integer.valueOf(format.getClazz())});
                }
                return renderer.getListCellRendererComponent(list, v, index, isSelected, cellHasFocus);
            }
        });
    }

    private static Collection<Format> createFormats(Format.DinRow[] allowedDinRows, int minClass, int maxClass, boolean portrait, boolean landscape) {
        TreeSet<Format> set = new TreeSet<Format>();
        for (Format.DinRow dinRow : allowedDinRows) {
            for (int i = minClass; i <= maxClass; ++i) {
                if (portrait) {
                    set.add(new Format(dinRow, Format.Type.PORTRAIT, i));
                }
                if (!landscape) continue;
                set.add(new Format(dinRow, Format.Type.LANDSCAPE, i));
            }
        }
        return set;
    }

    public void setShowType(boolean showType) {
        this.showType = showType;
    }

    public Format getSelectedFormat() {
        Object selected = this.getSelectedItem();
        if (selected instanceof Format) {
            return (Format)selected;
        }
        return null;
    }

    public void setSelectedFormat(Format format) {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Object element = this.getModel().getElementAt(i);
            if (!format.equals(element)) continue;
            this.setSelectedIndex(i);
            break;
        }
    }
}

