/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.client.model.wage;

import de.datomino.peppergis.client.communication.CommonCaller;
import de.datomino.peppergis.client.model.AbstractModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaLayerModelImpl;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.wage.SpecialWageHolidayModel;
import de.datomino.peppergis.client.model.wage.SpecialWageHolidayModelImpl;
import de.datomino.peppergis.client.model.wage.WageHolidaySetModel;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.area.AreaObjectDto;
import de.datomino.peppergis.dto.wage.SpecialWageHolidayDto;
import de.datomino.peppergis.dto.wage.WageHolidaySetFullDto;
import de.datomino.peppergis.dto.wage.WageHolidaySetProxyDto;
import de.datomino.peppergis.exception.StaleStateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.conversions.ImmutableIterator;
import org.ktde.util.conversions.IteratorIterable;

public class WageHolidaySetModelImpl
extends AbstractModel<WageHolidaySetFullDto, WageHolidaySetProxyDto>
implements WageHolidaySetModel {
    private String name;
    private Set<AreaObjectModel> areaObjects = null;
    private Set<AreaLayerModel> areaLayers = null;
    private Boolean newYear;
    private Boolean threeHolyKings;
    private Boolean goodFriday;
    private Boolean easterMonday;
    private Boolean laborDay;
    private Boolean ascensionDay;
    private Boolean whitMonday;
    private Boolean corpusChristi;
    private Boolean assumptionDay;
    private Boolean germanUnityDay;
    private Boolean reformationDay;
    private Boolean allSaintsDay;
    private Boolean penanceDay;
    private Boolean firstChristmasDay;
    private Boolean secondChristmasDay;
    private Boolean peacePartyDay;
    private Boolean monday;
    private Boolean tuesday;
    private Boolean wednesday;
    private Boolean thursday;
    private Boolean friday;
    private Boolean saturday;
    private Boolean sunday;
    private Set<SpecialWageHolidayModel> specialWageHolidays = null;

    public WageHolidaySetModelImpl() {
        ChangeSet.startChange(this, null);
        ChangeSet.finishChange();
    }

    public WageHolidaySetModelImpl(Long id, CommonCaller commonCaller) {
        super(id, commonCaller);
    }

    @Override
    public String getName() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName(name, true);
    }

    private void setName(String name, boolean setDirty) {
        String oldName = this.getName();
        if (new EqualsBuilder().append(oldName, name).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.NAME.getPropertyName());
        }
        this.name = name;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.NAME, name, oldName);
    }

    @Override
    public int countAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        return this.areaObjects.size();
    }

    @Override
    public Iterator<AreaObjectModel> iterateAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        return new ImmutableIterator<AreaObjectModel>(this.areaObjects);
    }

    @Override
    public Iterable<AreaObjectModel> iterableAreaObjects() {
        return new IteratorIterable<AreaObjectModel>(this.iterateAreaObjects());
    }

    @Override
    public void addAreaObject(AreaObjectModel areaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        if (this.areaObjects.contains(areaObject)) {
            return;
        }
        this.areaObjects.add(areaObject);
        this.fireValueChanged(WageHolidaySetModelEnum.AREA_OBJECTS, areaObject, null);
        if (areaObject != null) {
            areaObject.setWageHolidaySet(this);
        }
    }

    @Override
    public void removeAreaObject(AreaObjectModel areaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        if (!this.areaObjects.contains(areaObject)) {
            return;
        }
        this.areaObjects.remove(areaObject);
        this.fireValueChanged(WageHolidaySetModelEnum.AREA_OBJECTS, areaObject, null);
        if (areaObject != null) {
            areaObject.setWageHolidaySet(null);
        }
    }

    @Override
    public void clearAreaObjects() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        ArrayList<AreaObjectModel> oldAreaObjects = new ArrayList<AreaObjectModel>(this.areaObjects);
        this.areaObjects.clear();
        this.fireValueChanged(WageHolidaySetModelEnum.AREA_OBJECTS, null, null);
        for (AreaObjectModel oldAreaObject : oldAreaObjects) {
            if (oldAreaObject == null) continue;
            oldAreaObject.setWageHolidaySet(null);
        }
    }

    @Override
    public boolean isAreaObjectsEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        return this.areaObjects.isEmpty();
    }

    @Override
    public boolean containsAreaObject(AreaObjectModel areaObject) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaObjects == null) {
            this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            if (this.getId() != null) {
                Collection areaObjectsCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.AREA_OBJECTS.getPropertyName());
                this.areaObjects.addAll(areaObjectsCollection);
            }
        }
        return this.areaObjects.contains(areaObject);
    }

    @Override
    public boolean isAreaObjectsInitialized() {
        return this.areaObjects != null;
    }

    @Override
    public int countAreaLayers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaLayers == null) {
            this.areaLayers = new LinkedHashSet<AreaLayerModel>();
            if (this.getId() != null) {
                Collection areaLayersCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.AREA_LAYERS.getPropertyName());
                this.areaLayers.addAll(areaLayersCollection);
            }
        }
        return this.areaLayers.size();
    }

    @Override
    public Iterator<AreaLayerModel> iterateAreaLayers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaLayers == null) {
            this.areaLayers = new LinkedHashSet<AreaLayerModel>();
            if (this.getId() != null) {
                Collection areaLayersCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.AREA_LAYERS.getPropertyName());
                this.areaLayers.addAll(areaLayersCollection);
            }
        }
        return new ImmutableIterator<AreaLayerModel>(this.areaLayers);
    }

    @Override
    public Iterable<AreaLayerModel> iterableAreaLayers() {
        return new IteratorIterable<AreaLayerModel>(this.iterateAreaLayers());
    }

    @Override
    public void addAreaLayer(AreaLayerModel areaLayer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaLayers == null) {
            this.areaLayers = new LinkedHashSet<AreaLayerModel>();
            if (this.getId() != null) {
                Collection areaLayersCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.AREA_LAYERS.getPropertyName());
                this.areaLayers.addAll(areaLayersCollection);
            }
        }
        if (this.areaLayers.contains(areaLayer)) {
            return;
        }
        this.areaLayers.add(areaLayer);
        this.fireValueChanged(WageHolidaySetModelEnum.AREA_LAYERS, areaLayer, null);
        if (areaLayer != null) {
            areaLayer.setWageHolidaySet(this);
        }
    }

    @Override
    public void removeAreaLayer(AreaLayerModel areaLayer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaLayers == null) {
            this.areaLayers = new LinkedHashSet<AreaLayerModel>();
            if (this.getId() != null) {
                Collection areaLayersCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.AREA_LAYERS.getPropertyName());
                this.areaLayers.addAll(areaLayersCollection);
            }
        }
        if (!this.areaLayers.contains(areaLayer)) {
            return;
        }
        this.areaLayers.remove(areaLayer);
        this.fireValueChanged(WageHolidaySetModelEnum.AREA_LAYERS, areaLayer, null);
        if (areaLayer != null) {
            areaLayer.setWageHolidaySet(null);
        }
    }

    @Override
    public void clearAreaLayers() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaLayers == null) {
            this.areaLayers = new LinkedHashSet<AreaLayerModel>();
            if (this.getId() != null) {
                Collection areaLayersCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.AREA_LAYERS.getPropertyName());
                this.areaLayers.addAll(areaLayersCollection);
            }
        }
        ArrayList<AreaLayerModel> oldAreaLayers = new ArrayList<AreaLayerModel>(this.areaLayers);
        this.areaLayers.clear();
        this.fireValueChanged(WageHolidaySetModelEnum.AREA_LAYERS, null, null);
        for (AreaLayerModel oldAreaLayer : oldAreaLayers) {
            if (oldAreaLayer == null) continue;
            oldAreaLayer.setWageHolidaySet(null);
        }
    }

    @Override
    public boolean isAreaLayersEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaLayers == null) {
            this.areaLayers = new LinkedHashSet<AreaLayerModel>();
            if (this.getId() != null) {
                Collection areaLayersCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.AREA_LAYERS.getPropertyName());
                this.areaLayers.addAll(areaLayersCollection);
            }
        }
        return this.areaLayers.isEmpty();
    }

    @Override
    public boolean containsAreaLayer(AreaLayerModel areaLayer) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.areaLayers == null) {
            this.areaLayers = new LinkedHashSet<AreaLayerModel>();
            if (this.getId() != null) {
                Collection areaLayersCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.AREA_LAYERS.getPropertyName());
                this.areaLayers.addAll(areaLayersCollection);
            }
        }
        return this.areaLayers.contains(areaLayer);
    }

    @Override
    public boolean isAreaLayersInitialized() {
        return this.areaLayers != null;
    }

    @Override
    public Boolean getNewYear() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.newYear;
    }

    @Override
    public void setNewYear(Boolean newYear) {
        this.setNewYear(newYear, true);
    }

    private void setNewYear(Boolean newYear, boolean setDirty) {
        Boolean oldNewYear = this.getNewYear();
        if (new EqualsBuilder().append(oldNewYear, newYear).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.NEW_YEAR.getPropertyName());
        }
        this.newYear = newYear;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.NEW_YEAR, newYear, oldNewYear);
    }

    @Override
    public Boolean getThreeHolyKings() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.threeHolyKings;
    }

    @Override
    public void setThreeHolyKings(Boolean threeHolyKings) {
        this.setThreeHolyKings(threeHolyKings, true);
    }

    private void setThreeHolyKings(Boolean threeHolyKings, boolean setDirty) {
        Boolean oldThreeHolyKings = this.getThreeHolyKings();
        if (new EqualsBuilder().append(oldThreeHolyKings, threeHolyKings).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.THREE_HOLY_KINGS.getPropertyName());
        }
        this.threeHolyKings = threeHolyKings;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.THREE_HOLY_KINGS, threeHolyKings, oldThreeHolyKings);
    }

    @Override
    public Boolean getGoodFriday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.goodFriday;
    }

    @Override
    public void setGoodFriday(Boolean goodFriday) {
        this.setGoodFriday(goodFriday, true);
    }

    private void setGoodFriday(Boolean goodFriday, boolean setDirty) {
        Boolean oldGoodFriday = this.getGoodFriday();
        if (new EqualsBuilder().append(oldGoodFriday, goodFriday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.GOOD_FRIDAY.getPropertyName());
        }
        this.goodFriday = goodFriday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.GOOD_FRIDAY, goodFriday, oldGoodFriday);
    }

    @Override
    public Boolean getEasterMonday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.easterMonday;
    }

    @Override
    public void setEasterMonday(Boolean easterMonday) {
        this.setEasterMonday(easterMonday, true);
    }

    private void setEasterMonday(Boolean easterMonday, boolean setDirty) {
        Boolean oldEasterMonday = this.getEasterMonday();
        if (new EqualsBuilder().append(oldEasterMonday, easterMonday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.EASTER_MONDAY.getPropertyName());
        }
        this.easterMonday = easterMonday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.EASTER_MONDAY, easterMonday, oldEasterMonday);
    }

    @Override
    public Boolean getLaborDay() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.laborDay;
    }

    @Override
    public void setLaborDay(Boolean laborDay) {
        this.setLaborDay(laborDay, true);
    }

    private void setLaborDay(Boolean laborDay, boolean setDirty) {
        Boolean oldLaborDay = this.getLaborDay();
        if (new EqualsBuilder().append(oldLaborDay, laborDay).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.LABOR_DAY.getPropertyName());
        }
        this.laborDay = laborDay;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.LABOR_DAY, laborDay, oldLaborDay);
    }

    @Override
    public Boolean getAscensionDay() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.ascensionDay;
    }

    @Override
    public void setAscensionDay(Boolean ascensionDay) {
        this.setAscensionDay(ascensionDay, true);
    }

    private void setAscensionDay(Boolean ascensionDay, boolean setDirty) {
        Boolean oldAscensionDay = this.getAscensionDay();
        if (new EqualsBuilder().append(oldAscensionDay, ascensionDay).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.ASCENSION_DAY.getPropertyName());
        }
        this.ascensionDay = ascensionDay;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.ASCENSION_DAY, ascensionDay, oldAscensionDay);
    }

    @Override
    public Boolean getWhitMonday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.whitMonday;
    }

    @Override
    public void setWhitMonday(Boolean whitMonday) {
        this.setWhitMonday(whitMonday, true);
    }

    private void setWhitMonday(Boolean whitMonday, boolean setDirty) {
        Boolean oldWhitMonday = this.getWhitMonday();
        if (new EqualsBuilder().append(oldWhitMonday, whitMonday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.WHIT_MONDAY.getPropertyName());
        }
        this.whitMonday = whitMonday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.WHIT_MONDAY, whitMonday, oldWhitMonday);
    }

    @Override
    public Boolean getCorpusChristi() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.corpusChristi;
    }

    @Override
    public void setCorpusChristi(Boolean corpusChristi) {
        this.setCorpusChristi(corpusChristi, true);
    }

    private void setCorpusChristi(Boolean corpusChristi, boolean setDirty) {
        Boolean oldCorpusChristi = this.getCorpusChristi();
        if (new EqualsBuilder().append(oldCorpusChristi, corpusChristi).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.CORPUS_CHRISTI.getPropertyName());
        }
        this.corpusChristi = corpusChristi;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.CORPUS_CHRISTI, corpusChristi, oldCorpusChristi);
    }

    @Override
    public Boolean getAssumptionDay() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.assumptionDay;
    }

    @Override
    public void setAssumptionDay(Boolean assumptionDay) {
        this.setAssumptionDay(assumptionDay, true);
    }

    private void setAssumptionDay(Boolean assumptionDay, boolean setDirty) {
        Boolean oldAssumptionDay = this.getAssumptionDay();
        if (new EqualsBuilder().append(oldAssumptionDay, assumptionDay).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.ASSUMPTION_DAY.getPropertyName());
        }
        this.assumptionDay = assumptionDay;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.ASSUMPTION_DAY, assumptionDay, oldAssumptionDay);
    }

    @Override
    public Boolean getGermanUnityDay() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.germanUnityDay;
    }

    @Override
    public void setGermanUnityDay(Boolean germanUnityDay) {
        this.setGermanUnityDay(germanUnityDay, true);
    }

    private void setGermanUnityDay(Boolean germanUnityDay, boolean setDirty) {
        Boolean oldGermanUnityDay = this.getGermanUnityDay();
        if (new EqualsBuilder().append(oldGermanUnityDay, germanUnityDay).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.GERMAN_UNITY_DAY.getPropertyName());
        }
        this.germanUnityDay = germanUnityDay;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.GERMAN_UNITY_DAY, germanUnityDay, oldGermanUnityDay);
    }

    @Override
    public Boolean getReformationDay() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.reformationDay;
    }

    @Override
    public void setReformationDay(Boolean reformationDay) {
        this.setReformationDay(reformationDay, true);
    }

    private void setReformationDay(Boolean reformationDay, boolean setDirty) {
        Boolean oldReformationDay = this.getReformationDay();
        if (new EqualsBuilder().append(oldReformationDay, reformationDay).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.REFORMATION_DAY.getPropertyName());
        }
        this.reformationDay = reformationDay;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.REFORMATION_DAY, reformationDay, oldReformationDay);
    }

    @Override
    public Boolean getAllSaintsDay() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.allSaintsDay;
    }

    @Override
    public void setAllSaintsDay(Boolean allSaintsDay) {
        this.setAllSaintsDay(allSaintsDay, true);
    }

    private void setAllSaintsDay(Boolean allSaintsDay, boolean setDirty) {
        Boolean oldAllSaintsDay = this.getAllSaintsDay();
        if (new EqualsBuilder().append(oldAllSaintsDay, allSaintsDay).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.ALL_SAINTS_DAY.getPropertyName());
        }
        this.allSaintsDay = allSaintsDay;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.ALL_SAINTS_DAY, allSaintsDay, oldAllSaintsDay);
    }

    @Override
    public Boolean getPenanceDay() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.penanceDay;
    }

    @Override
    public void setPenanceDay(Boolean penanceDay) {
        this.setPenanceDay(penanceDay, true);
    }

    private void setPenanceDay(Boolean penanceDay, boolean setDirty) {
        Boolean oldPenanceDay = this.getPenanceDay();
        if (new EqualsBuilder().append(oldPenanceDay, penanceDay).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.PENANCE_DAY.getPropertyName());
        }
        this.penanceDay = penanceDay;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.PENANCE_DAY, penanceDay, oldPenanceDay);
    }

    @Override
    public Boolean getFirstChristmasDay() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.firstChristmasDay;
    }

    @Override
    public void setFirstChristmasDay(Boolean firstChristmasDay) {
        this.setFirstChristmasDay(firstChristmasDay, true);
    }

    private void setFirstChristmasDay(Boolean firstChristmasDay, boolean setDirty) {
        Boolean oldFirstChristmasDay = this.getFirstChristmasDay();
        if (new EqualsBuilder().append(oldFirstChristmasDay, firstChristmasDay).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.FIRST_CHRISTMAS_DAY.getPropertyName());
        }
        this.firstChristmasDay = firstChristmasDay;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.FIRST_CHRISTMAS_DAY, firstChristmasDay, oldFirstChristmasDay);
    }

    @Override
    public Boolean getSecondChristmasDay() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.secondChristmasDay;
    }

    @Override
    public void setSecondChristmasDay(Boolean secondChristmasDay) {
        this.setSecondChristmasDay(secondChristmasDay, true);
    }

    private void setSecondChristmasDay(Boolean secondChristmasDay, boolean setDirty) {
        Boolean oldSecondChristmasDay = this.getSecondChristmasDay();
        if (new EqualsBuilder().append(oldSecondChristmasDay, secondChristmasDay).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.SECOND_CHRISTMAS_DAY.getPropertyName());
        }
        this.secondChristmasDay = secondChristmasDay;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.SECOND_CHRISTMAS_DAY, secondChristmasDay, oldSecondChristmasDay);
    }

    @Override
    public Boolean getPeacePartyDay() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.peacePartyDay;
    }

    @Override
    public void setPeacePartyDay(Boolean peacePartyDay) {
        this.setPeacePartyDay(peacePartyDay, true);
    }

    private void setPeacePartyDay(Boolean peacePartyDay, boolean setDirty) {
        Boolean oldPeacePartyDay = this.getPeacePartyDay();
        if (new EqualsBuilder().append(oldPeacePartyDay, peacePartyDay).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.PEACE_PARTY_DAY.getPropertyName());
        }
        this.peacePartyDay = peacePartyDay;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.PEACE_PARTY_DAY, peacePartyDay, oldPeacePartyDay);
    }

    @Override
    public Boolean getMonday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.monday;
    }

    @Override
    public void setMonday(Boolean monday) {
        this.setMonday(monday, true);
    }

    private void setMonday(Boolean monday, boolean setDirty) {
        Boolean oldMonday = this.getMonday();
        if (new EqualsBuilder().append(oldMonday, monday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.MONDAY.getPropertyName());
        }
        this.monday = monday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.MONDAY, monday, oldMonday);
    }

    @Override
    public Boolean getTuesday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.tuesday;
    }

    @Override
    public void setTuesday(Boolean tuesday) {
        this.setTuesday(tuesday, true);
    }

    private void setTuesday(Boolean tuesday, boolean setDirty) {
        Boolean oldTuesday = this.getTuesday();
        if (new EqualsBuilder().append(oldTuesday, tuesday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.TUESDAY.getPropertyName());
        }
        this.tuesday = tuesday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.TUESDAY, tuesday, oldTuesday);
    }

    @Override
    public Boolean getWednesday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.wednesday;
    }

    @Override
    public void setWednesday(Boolean wednesday) {
        this.setWednesday(wednesday, true);
    }

    private void setWednesday(Boolean wednesday, boolean setDirty) {
        Boolean oldWednesday = this.getWednesday();
        if (new EqualsBuilder().append(oldWednesday, wednesday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.WEDNESDAY.getPropertyName());
        }
        this.wednesday = wednesday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.WEDNESDAY, wednesday, oldWednesday);
    }

    @Override
    public Boolean getThursday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.thursday;
    }

    @Override
    public void setThursday(Boolean thursday) {
        this.setThursday(thursday, true);
    }

    private void setThursday(Boolean thursday, boolean setDirty) {
        Boolean oldThursday = this.getThursday();
        if (new EqualsBuilder().append(oldThursday, thursday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.THURSDAY.getPropertyName());
        }
        this.thursday = thursday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.THURSDAY, thursday, oldThursday);
    }

    @Override
    public Boolean getFriday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.friday;
    }

    @Override
    public void setFriday(Boolean friday) {
        this.setFriday(friday, true);
    }

    private void setFriday(Boolean friday, boolean setDirty) {
        Boolean oldFriday = this.getFriday();
        if (new EqualsBuilder().append(oldFriday, friday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.FRIDAY.getPropertyName());
        }
        this.friday = friday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.FRIDAY, friday, oldFriday);
    }

    @Override
    public Boolean getSaturday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.saturday;
    }

    @Override
    public void setSaturday(Boolean saturday) {
        this.setSaturday(saturday, true);
    }

    private void setSaturday(Boolean saturday, boolean setDirty) {
        Boolean oldSaturday = this.getSaturday();
        if (new EqualsBuilder().append(oldSaturday, saturday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.SATURDAY.getPropertyName());
        }
        this.saturday = saturday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.SATURDAY, saturday, oldSaturday);
    }

    @Override
    public Boolean getSunday() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        return this.sunday;
    }

    @Override
    public void setSunday(Boolean sunday) {
        this.setSunday(sunday, true);
    }

    private void setSunday(Boolean sunday, boolean setDirty) {
        Boolean oldSunday = this.getSunday();
        if (new EqualsBuilder().append(oldSunday, sunday).isEquals()) {
            return;
        }
        if (setDirty) {
            this.setDirty(true);
            ChangeSet.startChange(this, WageHolidaySetModelEnum.SUNDAY.getPropertyName());
        }
        this.sunday = sunday;
        if (setDirty) {
            ChangeSet.finishChange();
        }
        this.fireValueChanged(WageHolidaySetModelEnum.SUNDAY, sunday, oldSunday);
    }

    @Override
    public int countSpecialWageHolidays() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.specialWageHolidays == null) {
            this.specialWageHolidays = new LinkedHashSet<SpecialWageHolidayModel>();
            if (this.getId() != null) {
                Collection specialWageHolidaysCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.SPECIAL_WAGE_HOLIDAYS.getPropertyName());
                this.specialWageHolidays.addAll(specialWageHolidaysCollection);
            }
        }
        return this.specialWageHolidays.size();
    }

    @Override
    public Iterator<SpecialWageHolidayModel> iterateSpecialWageHolidays() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.specialWageHolidays == null) {
            this.specialWageHolidays = new LinkedHashSet<SpecialWageHolidayModel>();
            if (this.getId() != null) {
                Collection specialWageHolidaysCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.SPECIAL_WAGE_HOLIDAYS.getPropertyName());
                this.specialWageHolidays.addAll(specialWageHolidaysCollection);
            }
        }
        return new ImmutableIterator<SpecialWageHolidayModel>(this.specialWageHolidays);
    }

    @Override
    public Iterable<SpecialWageHolidayModel> iterableSpecialWageHolidays() {
        return new IteratorIterable<SpecialWageHolidayModel>(this.iterateSpecialWageHolidays());
    }

    @Override
    public void addSpecialWageHoliday(SpecialWageHolidayModel specialWageHoliday) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.specialWageHolidays == null) {
            this.specialWageHolidays = new LinkedHashSet<SpecialWageHolidayModel>();
            if (this.getId() != null) {
                Collection specialWageHolidaysCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.SPECIAL_WAGE_HOLIDAYS.getPropertyName());
                this.specialWageHolidays.addAll(specialWageHolidaysCollection);
            }
        }
        if (this.specialWageHolidays.contains(specialWageHoliday)) {
            return;
        }
        this.specialWageHolidays.add(specialWageHoliday);
        this.fireValueChanged(WageHolidaySetModelEnum.SPECIAL_WAGE_HOLIDAYS, specialWageHoliday, null);
        if (specialWageHoliday != null) {
            specialWageHoliday.setWageHolidaySet(this);
        }
    }

    @Override
    public void removeSpecialWageHoliday(SpecialWageHolidayModel specialWageHoliday) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.specialWageHolidays == null) {
            this.specialWageHolidays = new LinkedHashSet<SpecialWageHolidayModel>();
            if (this.getId() != null) {
                Collection specialWageHolidaysCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.SPECIAL_WAGE_HOLIDAYS.getPropertyName());
                this.specialWageHolidays.addAll(specialWageHolidaysCollection);
            }
        }
        if (!this.specialWageHolidays.contains(specialWageHoliday)) {
            return;
        }
        this.specialWageHolidays.remove(specialWageHoliday);
        this.fireValueChanged(WageHolidaySetModelEnum.SPECIAL_WAGE_HOLIDAYS, specialWageHoliday, null);
        if (specialWageHoliday != null) {
            specialWageHoliday.setWageHolidaySet(null);
        }
    }

    @Override
    public void clearSpecialWageHolidays() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.specialWageHolidays == null) {
            this.specialWageHolidays = new LinkedHashSet<SpecialWageHolidayModel>();
            if (this.getId() != null) {
                Collection specialWageHolidaysCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.SPECIAL_WAGE_HOLIDAYS.getPropertyName());
                this.specialWageHolidays.addAll(specialWageHolidaysCollection);
            }
        }
        ArrayList<SpecialWageHolidayModel> oldSpecialWageHolidays = new ArrayList<SpecialWageHolidayModel>(this.specialWageHolidays);
        this.specialWageHolidays.clear();
        this.fireValueChanged(WageHolidaySetModelEnum.SPECIAL_WAGE_HOLIDAYS, null, null);
        for (SpecialWageHolidayModel oldSpecialWageHoliday : oldSpecialWageHolidays) {
            if (oldSpecialWageHoliday == null) continue;
            oldSpecialWageHoliday.setWageHolidaySet(null);
        }
    }

    @Override
    public boolean isSpecialWageHolidaysEmpty() {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.specialWageHolidays == null) {
            this.specialWageHolidays = new LinkedHashSet<SpecialWageHolidayModel>();
            if (this.getId() != null) {
                Collection specialWageHolidaysCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.SPECIAL_WAGE_HOLIDAYS.getPropertyName());
                this.specialWageHolidays.addAll(specialWageHolidaysCollection);
            }
        }
        return this.specialWageHolidays.isEmpty();
    }

    @Override
    public boolean containsSpecialWageHoliday(SpecialWageHolidayModel specialWageHoliday) {
        if (this.isProxy()) {
            this.commonCaller.fetchModel(this);
        }
        if (this.specialWageHolidays == null) {
            this.specialWageHolidays = new LinkedHashSet<SpecialWageHolidayModel>();
            if (this.getId() != null) {
                Collection specialWageHolidaysCollection = this.commonCaller.fetchChildren(this, WageHolidaySetModelEnum.SPECIAL_WAGE_HOLIDAYS.getPropertyName());
                this.specialWageHolidays.addAll(specialWageHolidaysCollection);
            }
        }
        return this.specialWageHolidays.contains(specialWageHoliday);
    }

    @Override
    public boolean isSpecialWageHolidaysInitialized() {
        return this.specialWageHolidays != null;
    }

    @Override
    public void setProxy(boolean proxy) {
        super.setProxy(proxy);
        if (proxy) {
            this.areaObjects = null;
            this.areaLayers = null;
            this.specialWageHolidays = null;
        }
    }

    @Override
    protected void updateByDto(WageHolidaySetFullDto wageHolidaySetDto) {
        AreaLayerDto[] areaLayers;
        this.name = wageHolidaySetDto.getName();
        AreaObjectDto[] areaObjects = wageHolidaySetDto.getAreaObjects();
        if (areaObjects != null) {
            if (this.areaObjects == null) {
                this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            } else {
                this.areaObjects.clear();
            }
        }
        if ((areaLayers = wageHolidaySetDto.getAreaLayers()) != null) {
            if (this.areaLayers == null) {
                this.areaLayers = new LinkedHashSet<AreaLayerModel>();
            } else {
                this.areaLayers.clear();
            }
        }
        this.newYear = wageHolidaySetDto.getNewYear();
        this.threeHolyKings = wageHolidaySetDto.getThreeHolyKings();
        this.goodFriday = wageHolidaySetDto.getGoodFriday();
        this.easterMonday = wageHolidaySetDto.getEasterMonday();
        this.laborDay = wageHolidaySetDto.getLaborDay();
        this.ascensionDay = wageHolidaySetDto.getAscensionDay();
        this.whitMonday = wageHolidaySetDto.getWhitMonday();
        this.corpusChristi = wageHolidaySetDto.getCorpusChristi();
        this.assumptionDay = wageHolidaySetDto.getAssumptionDay();
        this.germanUnityDay = wageHolidaySetDto.getGermanUnityDay();
        this.reformationDay = wageHolidaySetDto.getReformationDay();
        this.allSaintsDay = wageHolidaySetDto.getAllSaintsDay();
        this.penanceDay = wageHolidaySetDto.getPenanceDay();
        this.firstChristmasDay = wageHolidaySetDto.getFirstChristmasDay();
        this.secondChristmasDay = wageHolidaySetDto.getSecondChristmasDay();
        this.peacePartyDay = wageHolidaySetDto.getPeacePartyDay();
        this.monday = wageHolidaySetDto.getMonday();
        this.tuesday = wageHolidaySetDto.getTuesday();
        this.wednesday = wageHolidaySetDto.getWednesday();
        this.thursday = wageHolidaySetDto.getThursday();
        this.friday = wageHolidaySetDto.getFriday();
        this.saturday = wageHolidaySetDto.getSaturday();
        this.sunday = wageHolidaySetDto.getSunday();
        SpecialWageHolidayDto[] specialWageHolidays = wageHolidaySetDto.getSpecialWageHolidays();
        if (specialWageHolidays != null) {
            if (this.specialWageHolidays == null) {
                this.specialWageHolidays = new LinkedHashSet<SpecialWageHolidayModel>();
            } else {
                this.specialWageHolidays.clear();
            }
        }
    }

    @Override
    protected void updateMasterRelationsByDto(WageHolidaySetFullDto wageHolidaySetDto) {
        SpecialWageHolidayDto[] specialWageHolidays;
        AreaLayerDto[] areaLayers;
        AreaObjectDto[] areaObjects = wageHolidaySetDto.getAreaObjects();
        if (areaObjects != null) {
            if (this.areaObjects == null) {
                this.areaObjects = new LinkedHashSet<AreaObjectModel>();
            } else {
                this.areaObjects.clear();
            }
            for (AreaObjectDto areaObjectDto : areaObjects) {
                AreaObjectModel areaObjectModel = (AreaObjectModel)this.getModelCache().getModel(areaObjectDto);
                this.areaObjects.add(areaObjectModel);
            }
        } else {
            this.areaObjects = null;
        }
        if ((areaLayers = wageHolidaySetDto.getAreaLayers()) != null) {
            if (this.areaLayers == null) {
                this.areaLayers = new LinkedHashSet<AreaLayerModel>();
            } else {
                this.areaLayers.clear();
            }
            for (AreaLayerDto areaLayerDto : areaLayers) {
                AreaLayerModel areaLayerModel = (AreaLayerModel)this.getModelCache().getModel(areaLayerDto);
                this.areaLayers.add(areaLayerModel);
            }
        } else {
            this.areaLayers = null;
        }
        if ((specialWageHolidays = wageHolidaySetDto.getSpecialWageHolidays()) != null) {
            if (this.specialWageHolidays == null) {
                this.specialWageHolidays = new LinkedHashSet<SpecialWageHolidayModel>();
            } else {
                this.specialWageHolidays.clear();
            }
            for (SpecialWageHolidayDto specialWageHolidayDto : specialWageHolidays) {
                SpecialWageHolidayModel specialWageHolidayModel = (SpecialWageHolidayModel)this.getModelCache().getModel(specialWageHolidayDto);
                this.specialWageHolidays.add(specialWageHolidayModel);
            }
        } else {
            this.specialWageHolidays = null;
        }
    }

    @Override
    protected void checkStaleByDto(WageHolidaySetFullDto wageHolidaySetDto) throws StaleStateException {
        SpecialWageHolidayDto[] specialWageHolidayDtos;
        AreaLayerDto[] areaLayerDtos;
        AreaObjectDto[] areaObjectDtos = wageHolidaySetDto.getAreaObjects();
        if (areaObjectDtos != null) {
            for (AreaObjectDto areaObjectDto : areaObjectDtos) {
                AreaObjectModelImpl areaObjectModel = (AreaObjectModelImpl)this.getModelCache().getModel(AreaObjectModel.class, areaObjectDto.getId());
                if (areaObjectModel == null) continue;
                areaObjectModel.checkStaleState(areaObjectDto);
            }
        }
        if ((areaLayerDtos = wageHolidaySetDto.getAreaLayers()) != null) {
            for (AreaLayerDto areaLayerDto : areaLayerDtos) {
                AreaLayerModelImpl areaLayerModel = (AreaLayerModelImpl)this.getModelCache().getModel(AreaLayerModel.class, areaLayerDto.getId());
                if (areaLayerModel == null) continue;
                areaLayerModel.checkStaleState(areaLayerDto);
            }
        }
        if ((specialWageHolidayDtos = wageHolidaySetDto.getSpecialWageHolidays()) != null) {
            for (SpecialWageHolidayDto specialWageHolidayDto : specialWageHolidayDtos) {
                SpecialWageHolidayModelImpl specialWageHolidayModel = (SpecialWageHolidayModelImpl)this.getModelCache().getModel(SpecialWageHolidayModel.class, specialWageHolidayDto.getId());
                if (specialWageHolidayModel == null) continue;
                specialWageHolidayModel.checkStaleState(specialWageHolidayDto);
            }
        }
    }

    @Override
    public WageHolidaySetFullDto createDto() {
        Long id = this.getId();
        WageHolidaySetFullDto wageHolidaySetDto = id == null ? new WageHolidaySetFullDto(this.getTempUUID()) : new WageHolidaySetFullDto(id, this.getVersion());
        wageHolidaySetDto.setName(this.getName());
        wageHolidaySetDto.setNewYear(this.getNewYear());
        wageHolidaySetDto.setThreeHolyKings(this.getThreeHolyKings());
        wageHolidaySetDto.setGoodFriday(this.getGoodFriday());
        wageHolidaySetDto.setEasterMonday(this.getEasterMonday());
        wageHolidaySetDto.setLaborDay(this.getLaborDay());
        wageHolidaySetDto.setAscensionDay(this.getAscensionDay());
        wageHolidaySetDto.setWhitMonday(this.getWhitMonday());
        wageHolidaySetDto.setCorpusChristi(this.getCorpusChristi());
        wageHolidaySetDto.setAssumptionDay(this.getAssumptionDay());
        wageHolidaySetDto.setGermanUnityDay(this.getGermanUnityDay());
        wageHolidaySetDto.setReformationDay(this.getReformationDay());
        wageHolidaySetDto.setAllSaintsDay(this.getAllSaintsDay());
        wageHolidaySetDto.setPenanceDay(this.getPenanceDay());
        wageHolidaySetDto.setFirstChristmasDay(this.getFirstChristmasDay());
        wageHolidaySetDto.setSecondChristmasDay(this.getSecondChristmasDay());
        wageHolidaySetDto.setPeacePartyDay(this.getPeacePartyDay());
        wageHolidaySetDto.setMonday(this.getMonday());
        wageHolidaySetDto.setTuesday(this.getTuesday());
        wageHolidaySetDto.setWednesday(this.getWednesday());
        wageHolidaySetDto.setThursday(this.getThursday());
        wageHolidaySetDto.setFriday(this.getFriday());
        wageHolidaySetDto.setSaturday(this.getSaturday());
        wageHolidaySetDto.setSunday(this.getSunday());
        return wageHolidaySetDto;
    }

    @Override
    public WageHolidaySetProxyDto createProxy() {
        Long id = this.getId();
        WageHolidaySetProxyDto wageHolidaySetDto = id == null ? new WageHolidaySetProxyDto(this.getTempUUID()) : new WageHolidaySetProxyDto(id, this.getVersion());
        return wageHolidaySetDto;
    }

    public static enum WageHolidaySetModelEnum {
        NAME("name"),
        AREA_OBJECTS("areaObjects"),
        AREA_LAYERS("areaLayers"),
        NEW_YEAR("newYear"),
        THREE_HOLY_KINGS("threeHolyKings"),
        GOOD_FRIDAY("goodFriday"),
        EASTER_MONDAY("easterMonday"),
        LABOR_DAY("laborDay"),
        ASCENSION_DAY("ascensionDay"),
        WHIT_MONDAY("whitMonday"),
        CORPUS_CHRISTI("corpusChristi"),
        ASSUMPTION_DAY("assumptionDay"),
        GERMAN_UNITY_DAY("germanUnityDay"),
        REFORMATION_DAY("reformationDay"),
        ALL_SAINTS_DAY("allSaintsDay"),
        PENANCE_DAY("penanceDay"),
        FIRST_CHRISTMAS_DAY("firstChristmasDay"),
        SECOND_CHRISTMAS_DAY("secondChristmasDay"),
        PEACE_PARTY_DAY("peacePartyDay"),
        MONDAY("monday"),
        TUESDAY("tuesday"),
        WEDNESDAY("wednesday"),
        THURSDAY("thursday"),
        FRIDAY("friday"),
        SATURDAY("saturday"),
        SUNDAY("sunday"),
        SPECIAL_WAGE_HOLIDAYS("specialWageHolidays");

        private String propertyName;

        private WageHolidaySetModelEnum(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

